/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.flt.control_surface.values.ManuallyMappedRangedValueTarget;
import java.util.ArrayList;
import java.util.List;

class MultiManuallyMappedRangedValueTarget
extends ManuallyMappedRangedValueTarget
implements QIj {
    private final List mManualMappings;
    private final OIA mEventSource = new OIA(false);

    public MultiManuallyMappedRangedValueTarget(List list) {
        assert (bRL.UB2(list != null));
        assert (bRL.UB2(list.size() >= 2));
        this.mManualMappings = new ArrayList(list);
    }

    @Override
    public void connected() {
        super.connected();
        for (AOT aOT2 : this.mManualMappings) {
            aOT2.oHp(this);
        }
    }

    @Override
    public void disconnected() {
        super.disconnected();
        for (AOT aOT2 : this.mManualMappings) {
            aOT2.UB2(this);
        }
    }

    public int getManualMappingCount() {
        return this.mManualMappings.size();
    }

    public AOT getManualMappingAt(int n2) {
        return (AOT)this.mManualMappings.get(n2);
    }

    @Override
    public String getName() {
        return "*Multi*";
    }

    @Override
    public RGg getValueChangedEventSource() {
        return this.mEventSource;
    }

    @Override
    public double getCurrentValue() {
        double d2 = 1.0;
        for (AOT aOT2 : this.mManualMappings) {
            double d3 = aOT2.UB2();
            d2 = Math.min(d2, d3);
        }
        return d2;
    }

    @Override
    public boolean isSettable() {
        return true;
    }

    @Override
    public void setCurrentValue(double d2) {
        assert (bRL.UB2(d2 >= 0.0 && d2 <= 1.0));
        for (AOT aOT2 : this.mManualMappings) {
            aOT2.OSp(d2);
        }
    }

    @Override
    public void incrementNormalized(double d2) {
        for (AOT aOT2 : this.mManualMappings) {
            aOT2.ZAb(d2);
        }
    }

    @Override
    public double valueToNormalizedValue(double d2) {
        return d2;
    }

    @Override
    public double normalizedValueToValue(double d2) {
        return d2;
    }

    public qQ createTruncatableStringForValue(double d2) {
        assert (bRL.UB2(d2 >= 0.0 && d2 <= 1.0));
        int n2 = (int)Math.round(d2 * 100.0);
        return new PBh(n2);
    }

    @Override
    public qQ createTruncatableStringForCurrentValue() {
        return this.createTruncatableStringForValue(this.getCurrentValue());
    }

    @Override
    public qQ createTruncatableStringForCurrentModulatedValue() {
        return this.createTruncatableStringForCurrentValue();
    }

    @Override
    public void eventOccurred(Object object) {
        this.mEventSource.setBoolValue(!this.mEventSource.getBoolValue());
    }

    @Override
    public boolean isContinuous() {
        return true;
    }
}

