/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.controller.api.Setting;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.EnumValueProxy;
import com.bitwig.ramona.core.Oac;

public class EnumSetting
extends EnumValueProxy
implements Setting {
    private final String mCategory;
    private final String mLabel;
    private VD2 mIsEnabled;
    private VD2 mIsVisible;
    private boolean mIsEnabledByDefault = true;
    private boolean mIsVisibleByDefault = true;
    private Oac mSetting;

    public EnumSetting(ControlSurfaceObject controlSurfaceObject, String string, String string2, String[] stringArray, String string3) {
        super(controlSurfaceObject, stringArray, string3);
        if (string == null || string.isEmpty()) {
            throw new QWx("Error: label for setting can't be empty.");
        }
        if (stringArray.length == 0) {
            throw new QWx("Enum settings should needs to have at least some options: Setting " + string + " in category: " + string2);
        }
        if (stringArray.length < 2) {
            this.getControlSurface().UB2("Enum settings should have at least two options: Setting " + string + " in category: " + string2);
        }
        this.mLabel = string;
        this.mCategory = string2;
    }

    @Override
    protected boolean shouldBeInterestedByDefault() {
        return true;
    }

    public void connectToSetting(oJ oJ2) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(oJ2 != null));
        assert (this.ZAb(this.mSetting == null));
        this.mSetting = oJ2;
        this.setTarget(oJ2.tGb());
        this.connectEnableAndVisibleValues(oJ2.oc(), oJ2.QkE());
    }

    public void disconnectFromSetting(oJ oJ2) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(oJ2 != null));
        assert (this.ZAb(this.mSetting == oJ2));
        this.disconnectEnableAndVisibleValues(oJ2.oc(), oJ2.QkE());
        this.setTarget(null);
        this.mSetting = null;
    }

    public void connectToSetting(PMF pMF) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.ZAb(this.mSetting == null));
        assert (this.UB2(pMF != null));
        this.mSetting = pMF;
        this.setTarget(pMF.Ivg());
        this.connectEnableAndVisibleValues(pMF.tGb(), pMF.Fqp());
    }

    public void disconnectFromSetting(PMF pMF) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(pMF != null));
        assert (this.ZAb(this.mSetting == pMF));
        this.disconnectEnableAndVisibleValues(pMF.tGb(), pMF.Fqp());
        this.setTarget(null);
        this.mSetting = null;
    }

    private void connectEnableAndVisibleValues(VD2 vD2, VD2 vD22) {
        this.mIsEnabled = vD2;
        this.mIsVisible = vD22;
    }

    private void disconnectEnableAndVisibleValues(VD2 vD2, VD2 vD22) {
        this.mIsEnabled = null;
        this.mIsVisible = null;
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    public String getCategory() {
        return this.mCategory;
    }

    @Override
    public void enable() {
        this.setIsEnabled(true);
    }

    @Override
    public void disable() {
        this.setIsEnabled(false);
    }

    @Override
    public void show() {
        this.setIsShown(true);
    }

    @Override
    public void hide() {
        this.setIsShown(false);
    }

    public void setIsEnabled(boolean bl2) {
        this.exec(() -> this.doSetIsEnabled(bl2));
    }

    private void doSetIsEnabled(boolean bl2) {
        assert (this.UB2(this.isDocumentThread()));
        if (this.mIsEnabled != null) {
            this.mIsEnabled.setBoolValue(bl2);
        } else {
            this.mIsEnabledByDefault = bl2;
        }
    }

    public void setIsShown(boolean bl2) {
        this.exec(() -> this.doSetIsShown(bl2));
    }

    private void doSetIsShown(boolean bl2) {
        assert (this.UB2(this.isDocumentThread()));
        if (this.mIsVisible != null) {
            this.mIsVisible.setBoolValue(bl2);
        } else {
            this.mIsVisibleByDefault = bl2;
        }
    }

    public boolean isEnabledByDefault() {
        return this.mIsEnabledByDefault;
    }

    public boolean isVisibleByDefault() {
        return this.mIsVisibleByDefault;
    }

    public Oac getSetting() {
        return this.mSetting;
    }
}

