/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.DoubleValueChangedCallback;
import com.bitwig.extension.controller.api.DoubleValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ValueProxy;
import java.util.Objects;

public class DoubleValueProxy
extends ValueProxy
implements DoubleValue,
xOW {
    private double mValue;
    private final double mDefaultValue;

    public DoubleValueProxy(ControlSurfaceObject controlSurfaceObject, double d2) {
        super(controlSurfaceObject);
        this.mValue = d2;
        this.mDefaultValue = d2;
    }

    public DoubleValueProxy(ControlSurfaceObject controlSurfaceObject) {
        this(controlSurfaceObject, 0.0);
    }

    @Override
    public Class getTargetType() {
        return Lym.class;
    }

    @Override
    public double get() {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mValue;
    }

    public double getControlSurfaceValue() {
        assert (this.UB2(this.isControlSurfaceThread()));
        assert (this.UB2(this.isInterested()));
        return this.mValue;
    }

    public void addValueObserver(DoubleValueChangedCallback doubleValueChangedCallback) {
        this.doAddValueObserver(doubleValueChangedCallback);
    }

    protected void sendDefaultValue(DoubleValueChangedCallback doubleValueChangedCallback) {
        doubleValueChangedCallback.valueChanged(this.mDefaultValue);
    }

    protected void disconnectFromTarget(Lym lym) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(lym != null));
        lym.removeListener(this);
        this.queueNotifyObservers(this.mDefaultValue);
    }

    protected void connectToTarget(Lym lym) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(lym != null));
        assert (this.UB2(this.isInterested()));
        assert (this.UB2(this.isActiveOnDocumentThread()));
        lym.addListener(this);
        this.queueNotifyObservers(lym.getDoubleValue());
    }

    public double getDefaultValue() {
        return this.mDefaultValue;
    }

    public void eventOccurred(FNz fNz) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(this.getTarget() != null));
        assert (this.UB2(this.isInterested()));
        assert (this.UB2(Objects.equals(fNz.Ivg(), this.getTarget())));
        double d2 = ((Lym)this.getTarget()).getDoubleValue();
        this.queueNotifyObservers(d2);
    }

    private void queueNotifyObservers(double d2) {
        assert (this.UB2(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(d2));
    }

    private void notifyObservers(double d2) {
        assert (this.UB2(this.isControlSurfaceThread()));
        assert (this.UB2(this.isInterested()));
        if (d2 != this.mValue) {
            this.mValue = d2;
            if (this.mObservers != null) {
                for (DoubleValueChangedCallback doubleValueChangedCallback : this.mObservers) {
                    doubleValueChangedCallback.valueChanged(d2);
                }
            }
        }
    }
}

