/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.StringValueChangedCallback;
import com.bitwig.extension.controller.api.StringValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ComputedValue;
import com.bitwig.flt.control_surface.values.ControlSurfaceStringValueChangedCallback;

public class ComputedStringValue
extends ComputedValue
implements StringValue {
    private qQ mValue;
    private qQ mDocumentValue;
    private final qQ mDefaultValue;

    public ComputedStringValue(ControlSurfaceObject controlSurfaceObject, qQ qQ2) {
        super(controlSurfaceObject);
        assert (this.UB2(qQ2 != null));
        this.mValue = qQ2;
        this.mDocumentValue = qQ2;
        this.mDefaultValue = qQ2;
    }

    public ComputedStringValue(ControlSurfaceObject controlSurfaceObject) {
        this(controlSurfaceObject, qQ.EMPTY);
    }

    @Override
    public String get() {
        this.checkCanGet();
        return this.mValue.get();
    }

    @Override
    public String getLimited(int n2) {
        this.atLeast(n2, 1, "maxLength");
        this.checkCanGet();
        return this.mValue.getLimited(n2);
    }

    public String getValue() {
        assert (this.UB2(this.isDocumentThread()));
        return this.mDocumentValue.get();
    }

    public void setValue(qQ qQ2) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(qQ2 != null));
        if (!qQ2.equals(this.mDocumentValue)) {
            this.mDocumentValue = qQ2;
            if (this.isInterested()) {
                this.queueNotifyObservers(qQ2);
            }
        }
    }

    public final void setValue(String string) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(string != null));
        this.setValue(this.createControlSurfaceStringValue(string));
    }

    public void unassign() {
        assert (this.UB2(this.isDocumentThread()));
        this.setValue(this.mDefaultValue);
    }

    public void addValueObserver(StringValueChangedCallback stringValueChangedCallback) {
        this.doAddValueObserver(qQ2 -> stringValueChangedCallback.valueChanged(qQ2.get()));
    }

    public void addValueObserver(int n2, String string, StringValueChangedCallback stringValueChangedCallback) {
        this.doAddValueObserver(qQ2 -> {
            if (qQ2 == this.mDefaultValue) {
                stringValueChangedCallback.valueChanged(string);
            } else {
                stringValueChangedCallback.valueChanged(qQ2.getLimited(n2));
            }
        });
    }

    protected void sendInitialValue(ControlSurfaceStringValueChangedCallback controlSurfaceStringValueChangedCallback) {
        controlSurfaceStringValueChangedCallback.valueChanged(this.mValue);
    }

    private void queueNotifyObservers(qQ qQ2) {
        assert (this.UB2(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(qQ2));
    }

    private void notifyObservers(qQ qQ2) {
        assert (this.UB2(this.isControlSurfaceThread()));
        assert (this.UB2(this.isInterested()));
        if (!qQ2.equals(this.mValue)) {
            this.mValue = qQ2;
            if (this.mObservers != null) {
                for (ControlSurfaceStringValueChangedCallback controlSurfaceStringValueChangedCallback : this.mObservers) {
                    controlSurfaceStringValueChangedCallback.valueChanged(qQ2);
                }
            }
        }
    }

    protected qQ createControlSurfaceStringValue(String string) {
        assert (this.UB2(this.isDocumentThread() || this.isInitializingDriver()));
        assert (this.UB2(string != null));
        if (string.isEmpty()) {
            return qQ.EMPTY;
        }
        return new xmn(string);
    }

    protected qQ getControlSurfaceString() {
        assert (this.UB2(this.isControlSurfaceThread()));
        assert (this.UB2(this.mValue != null));
        return this.mValue;
    }
}

