/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.ObjectValueChangedCallback;
import com.bitwig.extension.controller.api.StringArrayValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ComputedValue;
import java.util.Arrays;

public class ComputedStringArrayValue
extends ComputedValue
implements StringArrayValue {
    private String[] mValue = new String[0];
    private String[] mDocumentValue = this.mValue;

    public ComputedStringArrayValue(ControlSurfaceObject controlSurfaceObject) {
        super(controlSurfaceObject);
    }

    @Override
    public String[] get() {
        this.checkCanGet();
        return this.mValue;
    }

    public void addValueObserver(ObjectValueChangedCallback objectValueChangedCallback) {
        this.doAddValueObserver(objectValueChangedCallback);
    }

    protected void sendInitialValue(ObjectValueChangedCallback objectValueChangedCallback) {
        objectValueChangedCallback.valueChanged(this.mValue);
    }

    public String[] geValue() {
        assert (this.UB2(this.isDocumentThread()));
        return this.mDocumentValue;
    }

    public void setValue(String[] stringArray) {
        assert (this.UB2(this.isDocumentThread()));
        if (Arrays.equals(stringArray, this.mDocumentValue)) {
            return;
        }
        this.mDocumentValue = stringArray;
        if (this.isInterested()) {
            this.queueNotifyObservers(stringArray);
        }
    }

    private void queueNotifyObservers(String[] stringArray) {
        assert (this.UB2(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(stringArray));
    }

    private void notifyObservers(String[] stringArray) {
        assert (this.UB2(this.isControlSurfaceThread()));
        assert (this.UB2(this.isInterested()));
        if (!Arrays.equals(stringArray, this.mValue)) {
            this.mValue = stringArray;
            if (this.mObservers != null) {
                for (ObjectValueChangedCallback objectValueChangedCallback : this.mObservers) {
                    objectValueChangedCallback.valueChanged(stringArray);
                }
            }
        }
    }
}

