/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ComputedValue;
import com.bitwig.flt.control_surface.values.UnassignedValueObserver;
import java.util.ArrayList;
import java.util.List;

public class ComputedIntegerValue
extends ComputedValue
implements IntegerValue {
    private int mValue;
    private int mDocumentValue;
    private final int mDefaultValue;
    private List mUnassignedObservers;

    public ComputedIntegerValue(ControlSurfaceObject controlSurfaceObject, int n2) {
        super(controlSurfaceObject);
        this.mDefaultValue = n2;
        this.mValue = n2;
        this.mDocumentValue = n2;
    }

    @Override
    public int get() {
        this.checkCanGet();
        return this.mValue;
    }

    public int getControlSurfaceValue() {
        assert (this.UB2(this.isInterested()));
        assert (this.UB2(this.isControlSurfaceThread()));
        return this.mValue;
    }

    public int getValue() {
        assert (this.UB2(this.isDocumentThread()));
        return this.mDocumentValue;
    }

    public void setIntegerValue(int n2) {
        this.setIntegerValue(n2, true);
    }

    public void unassigned() {
        this.setIntegerValue(this.mDefaultValue, false);
    }

    private void setIntegerValue(int n2, boolean bl2) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(!bl2 ? n2 == this.mDefaultValue : true));
        if (n2 != this.mDocumentValue) {
            this.mDocumentValue = n2;
            if (this.isInterested()) {
                this.queueNotifyObservers(n2, bl2);
            }
        } else if (!bl2 && this.mUnassignedObservers != null) {
            this.queueNotifyObservers(n2, false);
        }
    }

    public void addValueObserver(IntegerValueChangedCallback integerValueChangedCallback) {
        this.doAddValueObserver(integerValueChangedCallback);
    }

    @Override
    public void addValueObserver(IntegerValueChangedCallback integerValueChangedCallback, int n2) {
        if (n2 == this.mDefaultValue) {
            this.addValueObserver(integerValueChangedCallback);
        } else {
            this.checkIsInitializingDriver();
            this.notNull(integerValueChangedCallback, "callback");
            this.doMarkInterested();
            if (this.mUnassignedObservers == null) {
                this.mUnassignedObservers = new ArrayList(2);
            }
            this.mUnassignedObservers.add(new UnassignedValueObserver(integerValueChangedCallback, n2));
        }
    }

    protected void sendInitialValue(IntegerValueChangedCallback integerValueChangedCallback) {
        integerValueChangedCallback.valueChanged(this.mValue);
    }

    private void queueNotifyObservers(int n2, boolean bl2) {
        assert (this.UB2(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(n2, bl2));
    }

    private void notifyObservers(int n2, boolean bl2) {
        assert (this.UB2(this.isControlSurfaceThread()));
        assert (this.UB2(this.isInterested()));
        assert (this.UB2(!bl2 ? n2 == this.mDefaultValue : true));
        if (n2 != this.mValue) {
            this.mValue = n2;
            if (this.mObservers != null) {
                for (Object object : this.mObservers) {
                    object.valueChanged(n2);
                }
            }
            if (bl2 && this.mUnassignedObservers != null) {
                for (Object object : this.mUnassignedObservers) {
                    ((UnassignedValueObserver)object).mCallback.valueChanged(n2);
                }
            }
        }
        if (!bl2 && this.mUnassignedObservers != null) {
            for (Object object : this.mUnassignedObservers) {
                ((UnassignedValueObserver)object).mCallback.valueChanged(((UnassignedValueObserver)object).mUnassignedValue);
            }
        }
    }
}

