/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ComputedValue;

public class ComputedBooleanValue
extends ComputedValue
implements BooleanValue {
    private final boolean mDefaultValue;
    private boolean mValue;
    private final OIA mDocumentValue;
    private final boolean mCanBeReduced;

    public ComputedBooleanValue(ControlSurfaceObject controlSurfaceObject, boolean bl2, boolean bl3) {
        super(controlSurfaceObject);
        this.mDefaultValue = bl2;
        this.mValue = bl2;
        this.mDocumentValue = new OIA(bl2);
        this.mCanBeReduced = bl3;
    }

    public ComputedBooleanValue(ControlSurfaceObject controlSurfaceObject, boolean bl2) {
        this(controlSurfaceObject, bl2, true);
    }

    public ComputedBooleanValue(ControlSurfaceObject controlSurfaceObject) {
        this(controlSurfaceObject, false);
    }

    @Override
    public boolean get() {
        this.checkCanGet();
        return this.mValue;
    }

    public boolean getValueOnControlSurfaceThread() {
        assert (this.UB2(this.isControlSurfaceThread()));
        return this.mValue;
    }

    public boolean getBoolValue() {
        assert (this.UB2(this.isDocumentThread()));
        return this.mDocumentValue.getBoolValue();
    }

    public void setBoolValue(boolean bl2) {
        assert (this.UB2(this.isDocumentThread()));
        if (bl2 != this.mDocumentValue.getBoolValue()) {
            this.mDocumentValue.setBoolValue(bl2);
            if (this.isInterested()) {
                this.queueNotifyObservers(bl2);
            }
        }
    }

    public VD2 getDocumentValue() {
        return this.mDocumentValue;
    }

    public void unassigned() {
        assert (this.UB2(this.isDocumentThread()));
        this.setBoolValue(this.mDefaultValue);
    }

    public void addValueObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.doAddValueObserver(booleanValueChangedCallback);
    }

    protected void sendInitialValue(BooleanValueChangedCallback booleanValueChangedCallback) {
        booleanValueChangedCallback.valueChanged(this.mValue);
    }

    private void queueNotifyObservers(boolean bl2) {
        assert (this.UB2(this.isDocumentThread()));
        if (this.mCanBeReduced) {
            this.queueCallback(this, () -> this.notifyObservers(bl2));
        } else {
            this.queueCallback(() -> this.notifyObservers(bl2));
        }
    }

    private void notifyObservers(boolean bl2) {
        assert (this.UB2(this.isControlSurfaceThread()));
        assert (this.UB2(this.isInterested()));
        if (bl2 != this.mValue) {
            this.mValue = bl2;
            if (this.mObservers != null) {
                for (BooleanValueChangedCallback booleanValueChangedCallback : this.mObservers) {
                    booleanValueChangedCallback.valueChanged(bl2);
                }
            }
        }
    }
}

