/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.api.Color;
import com.bitwig.extension.controller.api.Setting;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.SettableColorValueProxy;
import com.bitwig.flt.prefs.Ovf;
import com.bitwig.ramona.core.Oac;

public class ColorSetting
extends SettableColorValueProxy
implements Setting {
    private final String mLabel;
    private final String mCategory;
    private VD2 mIsEnabled;
    private VD2 mIsVisible;
    private boolean mIsEnabledByDefault = true;
    private boolean mIsVisibleByDefault = true;
    private Oac mSetting;

    public ColorSetting(ControlSurfaceObject controlSurfaceObject, String string, String string2, Color color) {
        super(controlSurfaceObject, (float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)color.getAlpha());
        this.mLabel = string;
        this.mCategory = string2;
    }

    @Override
    protected boolean shouldBeInterestedByDefault() {
        return true;
    }

    public void connectToSetting(B1Y b1Y) {
        assert (this.Ivg(this.isDocumentThread()));
        assert (this.Ivg(b1Y != null));
        assert (this.Ivg(this.mSetting == null));
        this.mSetting = b1Y;
        this.setTarget(b1Y.Ivg());
        this.connectEnableAndVisibleValues(b1Y.tGb(), b1Y.Fqp());
    }

    public void disconnectFromSetting(B1Y b1Y) {
        assert (this.Ivg(this.isDocumentThread()));
        assert (this.Ivg(b1Y != null));
        assert (this.Ivg(this.mSetting == b1Y));
        this.disconnectEnableAndVisibleValues(b1Y.tGb(), b1Y.Fqp());
        this.clearTarget();
        this.mSetting = null;
    }

    public void connectToSetting(oH oH2) {
        assert (this.Ivg(this.isDocumentThread()));
        assert (this.Ivg(oH2 != null));
        assert (this.Ivg(this.mSetting == null));
        this.mSetting = oH2;
        this.setTarget(oH2.tGb());
        this.connectEnableAndVisibleValues(oH2.oc(), oH2.QkE());
    }

    public void disconnectFromSetting(Ovf ovf) {
        assert (this.Ivg(this.isDocumentThread()));
        assert (this.Ivg(ovf != null));
        assert (this.Ivg(this.mSetting == ovf));
        this.disconnectEnableAndVisibleValues(ovf.oc(), ovf.QkE());
        this.clearTarget();
        this.mSetting = null;
    }

    private void connectEnableAndVisibleValues(VD2 vD2, VD2 vD22) {
        this.mIsEnabled = vD2;
        this.mIsVisible = vD22;
    }

    private void disconnectEnableAndVisibleValues(VD2 vD2, VD2 vD22) {
        this.mIsEnabled = null;
        this.mIsVisible = null;
    }

    @Override
    public String getCategory() {
        return this.mCategory;
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    public void enable() {
        this.setIsEnabled(true);
    }

    @Override
    public void disable() {
        this.setIsEnabled(false);
    }

    @Override
    public void show() {
        this.setIsShown(true);
    }

    @Override
    public void hide() {
        this.setIsShown(false);
    }

    public void setIsEnabled(boolean bl2) {
        this.exec(() -> this.doSetIsEnabled(bl2));
    }

    private void doSetIsEnabled(boolean bl2) {
        assert (this.Ivg(this.isDocumentThread()));
        if (this.mIsEnabled != null) {
            this.mIsEnabled.setBoolValue(bl2);
        } else {
            this.mIsEnabledByDefault = bl2;
        }
    }

    public void setIsShown(boolean bl2) {
        this.exec(() -> this.doSetIsShown(bl2));
    }

    private void doSetIsShown(boolean bl2) {
        assert (this.UB2(this.isDocumentThread()));
        if (this.mIsVisible != null) {
            this.mIsVisible.setBoolValue(bl2);
        } else {
            this.mIsVisibleByDefault = bl2;
        }
    }

    public boolean isEnabledByDefault() {
        return this.mIsEnabledByDefault;
    }

    public boolean isVisibleByDefault() {
        return this.mIsVisibleByDefault;
    }

    public Oac getSetting() {
        return this.mSetting;
    }
}

