/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.DoubleValueChangedCallback;
import com.bitwig.extension.callback.StringValueChangedCallback;
import com.bitwig.extension.controller.api.BeatTimeFormatter;
import com.bitwig.extension.controller.api.RelativeHardwarControlBindable;
import com.bitwig.extension.controller.api.RelativeHardwareControl;
import com.bitwig.extension.controller.api.RelativeHardwareControlBinding;
import com.bitwig.extension.controller.api.SettableBeatTimeValue;
import com.bitwig.flt.control_surface.proxy.BitwigStudioHost;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.SettableDoubleValueProxy;

public abstract class BeatTimeProxy
extends SettableDoubleValueProxy
implements SettableBeatTimeValue,
ycO {
    protected BeatTimeProxy(ControlSurfaceObject controlSurfaceObject) {
        super(controlSurfaceObject);
    }

    public abstract boolean isBeatTimeAbsolute();

    @Override
    public RelativeHardwareControlBinding addBindingWithSensitivity(RelativeHardwareControl relativeHardwareControl, double d2) {
        return new K2q((v)relativeHardwareControl, this, d2);
    }

    @Override
    public RelativeHardwarControlBindable beatStepper() {
        return rOd.Ivg(() -> this.doInc(1.0), () -> this.doInc(-1.0));
    }

    @Override
    public void addRawValueObserver(DoubleValueChangedCallback doubleValueChangedCallback) {
        this.deprecated(1, 2, "Use addValueObserver instead");
        this.addValueObserver(doubleValueChangedCallback);
    }

    @Override
    public String getFormatted() {
        assert (this.UB2(this.isControlSurfaceThread()));
        BeatTimeFormatter beatTimeFormatter = this.getHost().defaultBeatTimeFormatter();
        assert (this.UB2(beatTimeFormatter != null));
        double d2 = this.get();
        return this.getFormattedValue(d2, beatTimeFormatter);
    }

    @Override
    public String getFormatted(BeatTimeFormatter beatTimeFormatter) {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.notNull(beatTimeFormatter, "formatter");
        double d2 = this.get();
        return this.getFormattedValue(d2, beatTimeFormatter);
    }

    private String getFormattedValue(double d2, BeatTimeFormatter beatTimeFormatter) {
        BitwigStudioHost bitwigStudioHost = this.getHost();
        int n2 = bitwigStudioHost.getTimeSignatureNumerator().getControlSurfaceValue();
        int n3 = bitwigStudioHost.getTimeSignatureDenominator().getControlSurfaceValue();
        int n4 = bitwigStudioHost.getTimeSignatureTickRate().getControlSurfaceValue();
        String string = beatTimeFormatter.formatBeatTime(d2, this.isBeatTimeAbsolute(), n2, n3, n4);
        return string;
    }

    @Override
    public void addTimeObserver(String string, int n2, int n3, int n4, int n5, StringValueChangedCallback stringValueChangedCallback) {
        this.deprecated(1, 2, "Use getFormatted() instead");
        this.checkIsInitializingDriver();
        this.notNull(stringValueChangedCallback, "callback");
        this.doMarkInterested();
        MTp mTp = new MTp(string, n2, n4, n3, n5);
        this.doAddValueObserver(d2 -> {
            String string = this.getFormattedValue(d2, mTp);
            stringValueChangedCallback.valueChanged(string);
        });
    }
}

