/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.DoubleValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.controller.api.DoubleValue;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.SettableRangedValue;
import com.bitwig.extension.controller.api.StringArrayValue;
import com.bitwig.extension.controller.api.StringValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.AbstractRangedValueProxy$IntegerScaledValueObserver;
import com.bitwig.flt.control_surface.values.ComputedDoubleValue;
import com.bitwig.flt.control_surface.values.ComputedIntegerValue;
import com.bitwig.flt.control_surface.values.ComputedStringArrayValue;
import com.bitwig.flt.control_surface.values.ComputedStringValue;
import com.bitwig.flt.control_surface.values.RangedValueTarget;
import com.bitwig.flt.control_surface.values.TakeOverUtilities;
import com.bitwig.flt.control_surface.values.ValueProxy;
import com.bitwig.flt.prefs.jjB;
import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleConsumer;

public abstract class AbstractRangedValueProxy
extends ValueProxy
implements QIj,
SettableRangedValue {
    private double mRawValue;
    private double mNormalizedValue;
    private List mRawValueCallbacks;
    private List mIntegerScaledValueObservers;
    protected final ComputedStringValue mDisplayedValue = this.createDisplayedValue();
    private boolean mHasBeenCaught;
    private boolean mIsSettingValue;
    private double mLastSetNormalizedValue = -1.0;
    private RGg mValueChangedEventSource;
    private double mLastSetControllerValue = -1.0;
    private DoubleConsumer mNormalizedValueChangedListener;
    private ComputedDoubleValue mNormalizedValueOrigin;
    private ComputedIntegerValue mDiscreteValueCount;
    private ComputedStringArrayValue mDiscreteValueNames = null;

    protected AbstractRangedValueProxy(ControlSurfaceObject controlSurfaceObject, double d2, double d3) {
        super(controlSurfaceObject);
        this.mRawValue = d2;
        this.mNormalizedValue = d3;
        this.mNormalizedValueOrigin = new ComputedDoubleValue((ControlSurfaceObject)this, 0.0);
        this.mDiscreteValueCount = new ComputedIntegerValue((ControlSurfaceObject)this, 0);
        this.mDiscreteValueNames = new ComputedStringArrayValue(this);
    }

    @Override
    public double getRaw() {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mRawValue;
    }

    @Override
    public double get() {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mNormalizedValue;
    }

    @Override
    public DoubleValue getOrigin() {
        this.newSince(19);
        assert (this.onT(this.isControlSurfaceThread()));
        return this.mNormalizedValueOrigin;
    }

    @Override
    public IntegerValue discreteValueCount() {
        this.newSince(20);
        assert (this.onT(this.isControlSurfaceThread()));
        return this.mDiscreteValueCount;
    }

    @Override
    public StringArrayValue discreteValueNames() {
        assert (this.Ivg(this.isControlSurfaceThread()));
        this.newSince(23);
        return this.mDiscreteValueNames;
    }

    @Override
    public StringValue displayedValue() {
        this.newSince(2);
        return this.mDisplayedValue;
    }

    public ComputedStringValue getDisplayedValue() {
        return this.mDisplayedValue;
    }

    public void addValueObserver(DoubleValueChangedCallback doubleValueChangedCallback) {
        this.doAddValueObserver(doubleValueChangedCallback);
    }

    @Override
    protected boolean wantsToSendInitialDefaultValue() {
        return false;
    }

    protected void sendDefaultValue(DoubleValueChangedCallback doubleValueChangedCallback) {
        assert (this.UB2(false));
        assert (this.UB2(this.isControlSurfaceThread()));
    }

    @Override
    public void addValueObserver(int n2, IntegerValueChangedCallback integerValueChangedCallback) {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.checkIsInitializingDriver();
        if (n2 <= 1) {
            throw new QWx("Range must be > 1");
        }
        this.doMarkInterested();
        if (this.mIntegerScaledValueObservers == null) {
            this.mIntegerScaledValueObservers = new ArrayList(2);
        }
        this.mIntegerScaledValueObservers.add(new AbstractRangedValueProxy$IntegerScaledValueObserver(n2, integerValueChangedCallback));
    }

    @Override
    public final void set(Number number, Number number2) {
        double d2;
        assert (this.UB2(this.isControlSurfaceThread()));
        if (number == null || number2 == null) {
            throw new QWx("Cannot provide null for value or resolution");
        }
        double d3 = number.doubleValue();
        if (d3 > (d2 = number2.doubleValue()) - 1.0) {
            this.getControlSurface().UB2("Value must be <= range - 1. Setting value to range - 1");
        }
        if (d3 < 0.0) {
            this.getControlSurface().UB2("Value must be >= 0. Setting value to 0");
        }
        d3 = Syh.OSp(d3, 0.0, d2 - 1.0);
        assert (this.UB2(number != null));
        assert (this.UB2(number2 != null));
        double d4 = d2 >= 2.0 ? 1.0 / (d2 - 1.0) : 1.0;
        double d5 = d3 * d4;
        assert (this.UB2(d5 >= 0.0 && d5 <= 1.0));
        this.setNormalizedValue(d5, this.shouldSetImmediately());
    }

    @Override
    public final void set(double d2) {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.inRange(d2, 0.0, 1.0, "value");
        this.setNormalizedValue(d2, this.shouldSetImmediately());
    }

    void updateHasBeenCaughtFromCurrentDistance() {
        assert (this.UB2(this.isDocumentThread()));
        if (this.getTarget() != null) {
            this.mHasBeenCaught = this.mLastSetControllerValue == -1.0 ? false : TakeOverUtilities.isValueCloseEnoughForTakeOver(this.mLastSetControllerValue, this.getCurrentValue());
        }
    }

    private boolean shouldSetImmediately() {
        vmU vmU2 = this.getControlSurface();
        if (vmU2.zvj().rr()) {
            return !vmU2.Kyj().dJJ();
        }
        return false;
    }

    @Override
    public void setImmediately(double d2) {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.newSince(4);
        this.inRange(d2, 0.0, 1.0, "value");
        this.setNormalizedValue(d2, true);
    }

    private void setNormalizedValue(double d2, boolean bl2) {
        assert (this.UB2(this.isControlSurfaceThread()));
        assert (this.UB2(d2 >= 0.0 && d2 <= 1.0));
        this.postEvent(new hJl(this, d2, bl2, this.getTouchId()));
    }

    protected int getTouchId() {
        assert (this.UB2(this.isControlSurfaceThread()));
        return 0;
    }

    public void doSetNormalizedValueWithTakeOver(double d2, jjB jjB2, dAT dAT2) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(d2 >= 0.0 && d2 <= 1.0));
        assert (this.UB2(jjB2 != null));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable()) {
            boolean bl2;
            boolean bl3 = this.mLastSetControllerValue != -1.0;
            double d3 = d2 - this.mLastSetControllerValue;
            this.mLastSetControllerValue = d2;
            boolean bl4 = bl2 = !rangedValueTarget.isContinuous();
            if (this.mHasBeenCaught || jjB2 == jjB.Ivg || bl2) {
                this.doSetNormalizedValueImmediately(d2);
            } else if (jjB2 == jjB.oHp) {
                assert (this.oHp(!this.mHasBeenCaught));
                double d4 = ((RangedValueTarget)this.getTarget()).getCurrentNormalizedValue();
                if (TakeOverUtilities.isValueCloseEnoughForTakeOver(d2, d4)) {
                    this.doSetNormalizedValueImmediately(d2);
                    return;
                }
                if (bl3) {
                    boolean bl5 = d3 > 0.0;
                    double d5 = bl5 ? 1.0 : 0.0;
                    double d6 = d2 - d5;
                    double d7 = d4 - d5;
                    if (Math.abs(d6) > 0.01) {
                        double d8 = d7 / d6;
                        this.doIncNormalized(d3 * d8);
                    }
                }
                if (rangedValueTarget.shouldShowPopupNotifications()) {
                    this.doShowVisualizations();
                }
            } else {
                assert (this.UB2(!this.mHasBeenCaught));
                assert (this.UB2(jjB2 != jjB.Ivg));
                double d9 = ((RangedValueTarget)this.getTarget()).getCurrentNormalizedValue();
                boolean bl6 = false;
                if (this.mLastSetNormalizedValue != -1.0) {
                    double d10 = dAT2 != null ? dAT2.onT(0) : d2;
                    bl6 = TakeOverUtilities.shouldBeCaughtByMovement(this.mLastSetNormalizedValue, d10, d9, jjB2);
                }
                if (!bl6 && dAT2 != null) {
                    for (int i2 = 0; !bl6 && i2 < dAT2.size() - 1; ++i2) {
                        double d11 = dAT2.onT(i2);
                        double d12 = dAT2.onT(i2 + 1);
                        bl6 = TakeOverUtilities.shouldBeCaughtByMovement(d11, d12, d9, jjB2);
                    }
                    if (!bl6) {
                        double d14 = dAT2.onT(dAT2.size() - 1);
                        bl6 = TakeOverUtilities.shouldBeCaughtByMovement(d14, d2, d9, jjB2);
                    }
                }
                if (!bl6 && dAT2 == null) {
                    bl6 = TakeOverUtilities.isValueCloseEnoughForTakeOver(d2, d9);
                }
                if (bl6) {
                    this.doSetNormalizedValueImmediately(d2);
                } else if (rangedValueTarget.shouldShowPopupNotifications()) {
                    this.doShowVisualizations();
                }
            }
        }
    }

    public void doSetNormalizedValueImmediately(double d2) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(d2 >= 0.0 && d2 <= 1.0));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable()) {
            double d3 = this.normalizedValueToValue(d2);
            this.setCurrentValue(d3);
            this.mLastSetNormalizedValue = d2;
            this.mLastSetControllerValue = d2;
            this.mHasBeenCaught = true;
        }
    }

    @Override
    protected void targetChanged() {
        super.targetChanged();
        this.updateHasBeenCaughtFromCurrentDistance();
        this.mLastSetNormalizedValue = -1.0;
    }

    @Override
    public final void inc(Number number, Number number2) {
        assert (this.UB2(this.isControlSurfaceThread()));
        if (number == null) {
            throw new QWx("increment cannot be null");
        }
        if (number2 == null) {
            throw new QWx("range cannot be null");
        }
        if (number2.doubleValue() <= 1.0) {
            throw new QWx("range must be > 1");
        }
        double d2 = number.doubleValue() / (number2.doubleValue() - 1.0);
        this.incNormalized(d2);
    }

    @Override
    public void inc(double d2) {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.inRange(d2, -1.0, 1.0, "increment");
        this.newSince(2);
        this.incNormalized(d2);
    }

    public void incNormalized(double d2) {
        assert (this.UB2(this.isControlSurfaceThread()));
        assert (this.UB2(d2 >= -1.0 && d2 <= 1.0));
        this.postEvent(new hJl(this, d2, this.getTouchId()));
    }

    public boolean isMappable() {
        return false;
    }

    @Override
    public void addRawValueObserver(DoubleValueChangedCallback doubleValueChangedCallback) {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.notNull(doubleValueChangedCallback, "callback");
        this.checkIsInitializingDriver();
        this.doMarkInterested();
        if (this.mRawValueCallbacks == null) {
            this.mRawValueCallbacks = new ArrayList(2);
        }
        this.mRawValueCallbacks.add(doubleValueChangedCallback);
    }

    @Override
    public void setRaw(double d2) {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.exec(() -> this.doSetRaw(d2));
    }

    private void doSetRaw(double d2) {
        assert (this.UB2(this.isDocumentThread()));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable()) {
            this.setCurrentValue(this.validateRawValue(d2));
        }
    }

    @Override
    public void incRaw(double d2) {
        this.exec(() -> this.doIncRaw(d2));
    }

    private void doIncRaw(double d2) {
        assert (this.UB2(this.isDocumentThread()));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable()) {
            this.setCurrentValue(this.validateRawValue(this.getCurrentValue() + d2));
        }
    }

    protected double validateRawValue(double d2) {
        return d2;
    }

    protected void connectToTargetAlways(RangedValueTarget rangedValueTarget) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(rangedValueTarget != null));
        assert (this.UB2(this.mValueChangedEventSource == null));
        super.connectToTargetAlways(rangedValueTarget);
        this.mValueChangedEventSource = rangedValueTarget.getValueChangedEventSource();
        if (this.mValueChangedEventSource != null) {
            this.mValueChangedEventSource.addListener(this);
        }
        this.updateHasBeenCaughtFromCurrentDistance();
    }

    public void connectToTarget(RangedValueTarget rangedValueTarget) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(rangedValueTarget != null));
        assert (this.UB2(this.isInterested()));
        assert (this.UB2(this.isActiveOnDocumentThread()));
        rangedValueTarget.connected();
        this.mNormalizedValueOrigin.setDoubleValue(rangedValueTarget.normalizedValueOrigin());
        this.mDiscreteValueCount.setIntegerValue(rangedValueTarget.discreteValueCount());
        this.mDiscreteValueNames.setValue(rangedValueTarget.discreteValueNames());
        this.targetValueChanged();
    }

    protected void disconnectFromTargetAlways(RangedValueTarget rangedValueTarget) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(rangedValueTarget != null));
        super.disconnectFromTargetAlways(rangedValueTarget);
        if (this.mValueChangedEventSource != null) {
            this.mValueChangedEventSource.removeListener(this);
            this.mValueChangedEventSource = null;
        }
        this.mNormalizedValueOrigin.unassigned();
        this.mDiscreteValueCount.unassigned();
        this.mDiscreteValueNames.setValue(new String[0]);
        this.updateHasBeenCaughtFromCurrentDistance();
    }

    public void disconnectFromTarget(RangedValueTarget rangedValueTarget) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(rangedValueTarget != null));
        rangedValueTarget.disconnected();
        this.queueNotifyObservers(0.0, 0.0);
        if (this.mDisplayedValue.isInterested()) {
            this.mDisplayedValue.unassign();
        }
    }

    @Override
    public void eventOccurred(Object object) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(this.getTarget() != null));
        this.targetValueChanged();
        if (!this.mIsSettingValue) {
            this.updateHasBeenCaughtFromCurrentDistance();
        }
    }

    private void targetValueChanged() {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(this.getTarget() != null));
        double d2 = this.getCurrentValue();
        double d3 = this.valueToNormalizedValue(d2);
        if (this.isInterested()) {
            this.queueNotifyObserversRaw(d2, d3);
        }
        if (this.mDisplayedValue.isInterested()) {
            qQ qQ2 = this.createTruncatableStringForCurrentValue();
            assert (this.UB2(qQ2 != null));
            this.mDisplayedValue.setValue(qQ2);
        }
        if (this.mNormalizedValueChangedListener != null) {
            this.mNormalizedValueChangedListener.accept(d3);
        }
    }

    protected ComputedStringValue createDisplayedValue() {
        return new ComputedStringValue(this);
    }

    protected qQ createTruncatableStringForCurrentValue() {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(this.getTarget() != null));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget == null) {
            return qQ.EMPTY;
        }
        return rangedValueTarget.createTruncatableStringForCurrentValue();
    }

    protected double getCurrentValue() {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(this.getTarget() != null));
        return ((RangedValueTarget)this.getTarget()).getCurrentValue();
    }

    protected void setCurrentValue(double d2) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(this.getTarget() != null));
        assert (this.UB2(((RangedValueTarget)this.getTarget()).isSettable()));
        assert (this.UB2(!this.mIsSettingValue));
        this.beginSettingValue();
        ((RangedValueTarget)this.getTarget()).setCurrentValue(d2);
        this.endSettingValue();
    }

    protected double valueToNormalizedValue(double d2) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(this.getTarget() != null));
        return ((RangedValueTarget)this.getTarget()).valueToNormalizedValue(d2);
    }

    protected double normalizedValueToValue(double d2) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(this.getTarget() != null));
        return ((RangedValueTarget)this.getTarget()).normalizedValueToValue(d2);
    }

    public void doIncNormalized(double d2) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(!this.mIsSettingValue));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable()) {
            this.beginSettingValue();
            rangedValueTarget.incrementNormalized(d2);
            this.endSettingValue();
        }
    }

    private void beginSettingValue() {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(!this.mIsSettingValue));
        this.mIsSettingValue = true;
    }

    private void endSettingValue() {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(this.mIsSettingValue));
        assert (this.UB2(this.getTarget() != null));
        assert (this.UB2(((RangedValueTarget)this.getTarget()).isSettable()));
        this.mIsSettingValue = false;
        if (((RangedValueTarget)this.getTarget()).shouldShowPopupNotifications()) {
            this.doShowVisualizations();
        }
    }

    public void showVisualizations() {
        assert (this.UB2(this.isDocumentThread()));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable() && rangedValueTarget.shouldShowPopupNotifications()) {
            this.doShowVisualizations();
        }
    }

    private void doShowVisualizations() {
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(rangedValueTarget != null));
        assert (this.UB2(rangedValueTarget.isSettable()));
        assert (this.UB2(rangedValueTarget.shouldShowPopupNotifications()));
        this.getControlSurface().Ivg(this);
    }

    private final void queueNotifyObserversRaw(double d2, double d3) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(this.isInterested()));
        this.queueNotifyObservers(d2, d3);
    }

    private void queueNotifyObservers(double d2, double d3) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(d3 >= 0.0 && d3 <= 1.0));
        assert (this.UB2(this.isInterested()));
        this.queueCallback(this, () -> this.notifyObservers(d2, d3));
    }

    private void notifyObservers(double d2, double d3) {
        assert (this.UB2(this.isControlSurfaceThread()));
        assert (this.UB2(this.isInterested()));
        assert (this.UB2(d3 >= 0.0 && d3 <= 1.0));
        double d4 = this.mRawValue;
        double d5 = this.mNormalizedValue;
        this.mRawValue = d2;
        this.mNormalizedValue = d3;
        if (d3 != d5) {
            if (this.mObservers != null) {
                for (Object object : this.mObservers) {
                    object.valueChanged(d3);
                }
            }
            if (this.mIntegerScaledValueObservers != null) {
                for (Object object : this.mIntegerScaledValueObservers) {
                    IntegerValueChangedCallback integerValueChangedCallback = ((AbstractRangedValueProxy$IntegerScaledValueObserver)object).mCallback;
                    int n2 = ((AbstractRangedValueProxy$IntegerScaledValueObserver)object).mRange;
                    int n3 = Syh.Ivg(Math.round((float)d3 * (float)n2 - 0.5f), 0, n2 - 1);
                    integerValueChangedCallback.valueChanged(n3);
                }
            }
        }
        if (d2 != d4 && this.mRawValueCallbacks != null) {
            for (Object object : this.mRawValueCallbacks) {
                object.valueChanged(d2);
            }
        }
    }

    public void doTouch(boolean bl2) {
        assert (this.UB2(this.isDocumentThread()));
    }

    public boolean hasBeenCaught() {
        assert (this.oHp(this.isDocumentThread()));
        return this.mHasBeenCaught;
    }

    public double getLastSetControllerValue() {
        return this.mLastSetControllerValue;
    }

    public void setControllerTakeOverState(double d2, boolean bl2) {
        assert (this.UB2(this.isDocumentThread()));
        this.mLastSetControllerValue = d2;
        this.mHasBeenCaught = bl2;
    }

    public void setNormalizedValueChangedListener(DoubleConsumer doubleConsumer) {
        assert (this.UB2(this.isInitializingDriver()));
        assert (this.UB2(doubleConsumer != null));
        assert (this.UB2(this.mNormalizedValueChangedListener == null));
        this.mNormalizedValueChangedListener = doubleConsumer;
    }

    public String getLabel() {
        return "";
    }
}

