/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.UsbInterfaceMatcher;
import com.bitwig.extension.controller.api.UsbInterface;
import com.bitwig.extension.controller.api.UsbPipe;
import com.bitwig.flt.control_surface.proxy.UsbBulkInputPipeImpl;
import com.bitwig.flt.control_surface.proxy.UsbBulkOutputPipeImpl;
import com.bitwig.flt.control_surface.proxy.UsbDeviceImpl;
import com.bitwig.flt.control_surface.proxy.UsbInterruptInputPipeImpl;
import com.bitwig.flt.control_surface.proxy.UsbInterruptOutputPipeImpl;
import com.bitwig.flt.control_surface.proxy.UsbPipeImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UsbInterfaceImpl
implements UsbInterface {
    private final UsbDeviceImpl mDevice;
    private ckV mClaimedInterface;
    private final viL mMatchResult;
    private final List mPipes;

    UsbInterfaceImpl(UsbDeviceImpl usbDeviceImpl, viL viL2) {
        this.mDevice = usbDeviceImpl;
        this.mMatchResult = viL2;
        this.mPipes = new ArrayList(viL2.oHp().size());
        for (aXc aXc2 : viL2.oHp()) {
            UsbPipeImpl usbPipeImpl = UsbInterfaceImpl.createUsbPipe(usbDeviceImpl, aXc2);
            this.mPipes.add(usbPipeImpl);
        }
    }

    private static UsbPipeImpl createUsbPipe(UsbDeviceImpl usbDeviceImpl, aXc aXc2) {
        clc clc2 = aXc2.Ivg().Ivg();
        boolean bl2 = aXc2.Ivg().OSp();
        switch (clc2) {
            case oHp: {
                return bl2 ? new UsbBulkOutputPipeImpl(usbDeviceImpl, aXc2) : new UsbBulkInputPipeImpl(usbDeviceImpl, aXc2);
            }
            case UB2: {
                return bl2 ? new UsbInterruptOutputPipeImpl(usbDeviceImpl, aXc2) : new UsbInterruptInputPipeImpl(usbDeviceImpl, aXc2);
            }
        }
        throw new IllegalStateException("Unknown matcher transfer type " + String.valueOf((Object)clc2));
    }

    @Override
    public UsbInterfaceMatcher interfaceMatcher() {
        return this.mMatchResult.OSp();
    }

    @Override
    public List pipes() {
        return Collections.unmodifiableList(this.mPipes);
    }

    @Override
    public UsbPipe pipe(int n2) {
        return (UsbPipe)this.mPipes.get(n2);
    }

    @Override
    public int pipeCount() {
        return this.mPipes.size();
    }

    void claim() {
        this.mClaimedInterface = this.mDevice.getDeviceHandle().OSp(this.mMatchResult.Ivg().oHp);
    }

    void release() {
        if (this.mClaimedInterface != null) {
            this.mClaimedInterface.Ivg();
            this.mClaimedInterface = null;
        }
    }
}

