/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.callback.IndexedStringValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.callback.StringValueChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.CursorDevice;
import com.bitwig.extension.controller.api.CursorRemoteControlsPage;
import com.bitwig.extension.controller.api.Device;
import com.bitwig.extension.controller.api.HardwareActionBindable;
import com.bitwig.extension.controller.api.InsertionPoint;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.NoteInput;
import com.bitwig.extension.controller.api.SettableBooleanValue;
import com.bitwig.extension.controller.api.SettableEnumValue;
import com.bitwig.extension.controller.api.SourceSelector;
import com.bitwig.extension.controller.api.StringValue;
import com.bitwig.extension.controller.api.Track;
import com.bitwig.extension.controller.api.TrackBank;
import com.bitwig.flt.control_surface.proxy.AbstractChannelProxy;
import com.bitwig.flt.control_surface.proxy.AbstractTrackBankProxy;
import com.bitwig.flt.control_surface.proxy.BankItemWithPosition;
import com.bitwig.flt.control_surface.proxy.ChannelBankProxy;
import com.bitwig.flt.control_surface.proxy.ClipLauncherSlotBankProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentObjectProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceProxy;
import com.bitwig.flt.control_surface.proxy.CursorDeviceProxy;
import com.bitwig.flt.control_surface.proxy.DeviceCursorRemoteControlsPageProxy;
import com.bitwig.flt.control_surface.proxy.DirectNoteInput;
import com.bitwig.flt.control_surface.proxy.DocumentAction;
import com.bitwig.flt.control_surface.proxy.EffectTrackBankProxy;
import com.bitwig.flt.control_surface.proxy.IndependentDeviceCursorRemoteControlsPageProxy;
import com.bitwig.flt.control_surface.proxy.MainDeviceCursorRemoteControlsPageProxy;
import com.bitwig.flt.control_surface.proxy.MainTrackBankProxy;
import com.bitwig.flt.control_surface.proxy.MasterTrackProxy;
import com.bitwig.flt.control_surface.proxy.SiblingTrackBankProxy;
import com.bitwig.flt.control_surface.proxy.SourceSelectorProxy;
import com.bitwig.flt.control_surface.proxy.TrackBankProxy;
import com.bitwig.flt.control_surface.proxy.TrackProxy$PitchNamesObserver;
import com.bitwig.flt.control_surface.proxy.TracksBankTarget;
import com.bitwig.flt.control_surface.values.BooleanValueProxy;
import com.bitwig.flt.control_surface.values.ComputedBooleanValue;
import com.bitwig.flt.control_surface.values.ComputedIntegerValue;
import com.bitwig.flt.control_surface.values.ComputedStringValue;
import com.bitwig.flt.control_surface.values.EnumValueAtomProxy;
import com.bitwig.flt.control_surface.values.SettableBooleanValueProxy;
import com.bitwig.flt.control_surface.values.SettableEnumAttributeProxy;
import com.bitwig.flt.document.core.iface.PhH;
import com.bitwig.flt.document.core.iface.mgC;
import com.bitwig.flt.document.core.iface.yWu;
import java.util.ArrayList;
import java.util.List;

public class TrackProxy
extends AbstractChannelProxy
implements Track,
BankItemWithPosition {
    private static final int DEFAULT_MIDI_CHANNEL = 0;
    private static final String DEFAULT_CURSOR_DEVICE_ID = "DeviceSelection";
    private final xOW mTrackTypeListener = fNz -> this.updateTrackTypeString(this.getChannel());
    private final int mSlotCount;
    private final ComputedStringValue mTrackType;
    protected final SettableBooleanValueProxy mCanHoldNoteData;
    protected final SettableBooleanValueProxy mCanHoldAudioData;
    private final SettableBooleanValueProxy mArm;
    private final SettableEnumAttributeProxy mMonitorModeProxy;
    private final BooleanValueProxy mIsMonitoring;
    private final EnumValueAtomProxy mCrossFadeMode;
    private final BooleanValueProxy mIsMatrixStopped;
    private final BooleanValueProxy mIsMatrixQueuedForStop;
    private final SourceSelectorProxy mSourceSelector;
    private ClipLauncherSlotBankProxy mSlotBank;
    private final ComputedIntegerValue mPosition;
    private TracksBankTarget mBankTargetToUseForPosition;
    private boolean mHasScheduledUpdateToPositionWhenNotInBank;
    private final List mCursorDevices = new ArrayList(3);
    private CursorDeviceProxy mPrimaryDevice;
    private final ComputedBooleanValue mIsGroupValue;
    private final SettableBooleanValueProxy mIsGroupExpandedValue;
    private final SettableBooleanValueProxy mIsPreFader;
    private final psG mAfterTrackInsertionPoint = new psG(this);
    private final PfE mBeforeTrackInsertionPoint = new PfE(this);
    private final List mParentTrackProxies = new ArrayList(1);
    private final List mDirectNoteInputs = new ArrayList();
    private final SettableBooleanValueProxy mLegacyMonitorProxy = new SettableBooleanValueProxy((ControlSurfaceObject)this, false);
    private final SettableBooleanValueProxy mLegacyAutomonitorProxy = new SettableBooleanValueProxy((ControlSurfaceObject)this, false);
    private final SettableEnumAttributeProxy mLaunchQuantizationHelper = new SettableEnumAttributeProxy((ControlSurfaceObject)this, JmM.Ivg);
    private final SettableEnumAttributeProxy mLaunchModeHelper = new SettableEnumAttributeProxy((ControlSurfaceObject)this, fkQ.OSp);
    private MainDeviceCursorRemoteControlsPageProxy mMainRemoteControlsSection;
    private List mIndependentRemoteControlsSections;

    public TrackProxy(ControlSurfaceObject controlSurfaceObject, String string, int n2, int n3, int n4) {
        super(controlSurfaceObject, string, n2, n3);
        this.mTrackType = new ComputedStringValue(this);
        this.mPosition = new ComputedIntegerValue((ControlSurfaceObject)this, -1);
        this.mArm = new SettableBooleanValueProxy(this);
        this.mMonitorModeProxy = new SettableEnumAttributeProxy((ControlSurfaceObject)this, GhH.OSp);
        this.mIsMonitoring = new BooleanValueProxy(this);
        this.mIsPreFader = new SettableBooleanValueProxy(this);
        this.mCrossFadeMode = new EnumValueAtomProxy((ControlSurfaceObject)this, uKA.OSp);
        this.mIsMatrixStopped = new BooleanValueProxy(this);
        this.mIsMatrixQueuedForStop = new BooleanValueProxy(this);
        this.mCanHoldNoteData = new SettableBooleanValueProxy(this);
        this.mCanHoldAudioData = new SettableBooleanValueProxy(this);
        this.mSourceSelector = new SourceSelectorProxy((ControlSurfaceObject)this, this.getKey() + "/SourceSelector");
        this.mIsGroupValue = new ComputedBooleanValue((ControlSurfaceObject)this, false);
        this.mIsGroupExpandedValue = new SettableBooleanValueProxy(this);
        this.addChild(this.mArm);
        this.addChild(this.mIsMatrixStopped);
        this.addChild(this.mIsMatrixQueuedForStop);
        this.addChild(this.mCanHoldNoteData);
        this.addChild(this.mCanHoldAudioData);
        this.addChild(this.mSourceSelector);
        this.mSlotCount = n4;
        if (n4 > 0) {
            this.mSlotBank = new ClipLauncherSlotBankProxy((ControlSurfaceObject)this, n4);
            this.addChild(this.mSlotBank);
        }
    }

    @Override
    public ComputedIntegerValue getBankItemPosition() {
        return this.mPosition;
    }

    @Override
    public Class getTargetType() {
        return PhH.class;
    }

    protected mgC getDocumentFromTarget(PhH phH) {
        return phH.tNn();
    }

    protected MPl getEditorChannelSelection(PhH phH) {
        mgC mgC2 = phH.tNn();
        if (mgC2 != null) {
            return mgC2.uKS().lXt();
        }
        return null;
    }

    @Override
    protected String getAutomaticNotificationPrefix() {
        return "Track";
    }

    @Override
    public IntegerValue position() {
        this.newSince(2);
        return this.mPosition;
    }

    @Override
    public void addPositionObserver(IntegerValueChangedCallback integerValueChangedCallback) {
        this.deprecated(1, 2, "Use position() instead");
        this.mPosition.addValueObserver(integerValueChangedCallback);
    }

    @Override
    public ClipLauncherSlotBankProxy getClipLauncher() {
        this.deprecated(1, 2);
        return this.getClipLauncherSlots();
    }

    @Override
    public ClipLauncherSlotBankProxy getClipLauncherSlots() {
        return this.mSlotBank;
    }

    public int getSlotCount() {
        return this.mSlotCount;
    }

    @Override
    public ClipLauncherSlotBankProxy clipLauncherSlotBank() {
        return this.mSlotBank;
    }

    @Override
    public SettableBooleanValue getArm() {
        this.deprecated(1, 5, "Use arm() instead");
        return this.mArm;
    }

    @Override
    public SettableBooleanValue arm() {
        this.newSince(5);
        return this.mArm;
    }

    @Override
    public SettableBooleanValue getMonitor() {
        this.deprecated(1, 5, "Use monitor() instead");
        return this.mLegacyMonitorProxy;
    }

    @Override
    public SettableBooleanValue monitor() {
        this.deprecated(5, 14, "Use isMonitoring or monitorMode instead");
        return this.mLegacyMonitorProxy;
    }

    @Override
    public SettableBooleanValue getAutoMonitor() {
        this.deprecated(1, 14, "Use monitorMode instead");
        return this.mLegacyAutomonitorProxy;
    }

    @Override
    public SettableBooleanValue autoMonitor() {
        this.deprecated(5, 14, "Use monitorMode instead");
        return this.mLegacyAutomonitorProxy;
    }

    @Override
    public SettableEnumValue monitorMode() {
        this.newSince(14);
        return this.mMonitorModeProxy;
    }

    @Override
    public BooleanValue isMonitoring() {
        this.newSince(14);
        return this.mIsMonitoring;
    }

    @Override
    public SettableEnumValue getCrossFadeMode() {
        this.deprecated(1, 5, "Use crossFadeMode() instead");
        return this.mCrossFadeMode;
    }

    @Override
    public SettableEnumValue crossFadeMode() {
        this.newSince(5);
        return this.mCrossFadeMode;
    }

    @Override
    public BooleanValue isStopped() {
        this.newSince(2);
        return this.mIsMatrixStopped;
    }

    @Override
    public BooleanValue getIsMatrixStopped() {
        this.deprecated(1, 2, "Use isStopped() instead");
        return this.mIsMatrixStopped;
    }

    @Override
    public BooleanValue isQueuedForStop() {
        this.newSince(2);
        return this.mIsMatrixQueuedForStop;
    }

    @Override
    public BooleanValue getIsMatrixQueuedForStop() {
        this.deprecated(1, 2, "Use isQueuedForStop() instead");
        return this.mIsMatrixQueuedForStop;
    }

    @Override
    public SourceSelector getSourceSelector() {
        this.deprecated(1, 5, "Use sourceSelector() instead");
        return this.mSourceSelector;
    }

    @Override
    public SourceSelector sourceSelector() {
        this.newSince(5);
        return this.mSourceSelector;
    }

    @Override
    public void stop() {
        this.exec(() -> this.doStop(false));
    }

    @Override
    public void stopAlt() {
        this.newSince(18);
        this.exec(() -> this.doStop(true));
    }

    private void doStop(boolean bl2) {
        PhH phH = this.getChannel();
        if (phH != null) {
            phH.Ivg(JmM.Ivg, bl2);
        }
    }

    @Override
    public HardwareActionBindable stopAction() {
        this.newSince(10);
        return new DocumentAction((ControlSurfaceObject)this, () -> this.doStop(false));
    }

    @Override
    public HardwareActionBindable stopAltAction() {
        this.newSince(18);
        return new DocumentAction((ControlSurfaceObject)this, () -> this.doStop(true));
    }

    @Override
    public void returnToArrangement() {
        this.exec(() -> {
            PhH phH = this.getChannel();
            if (phH != null) {
                phH.huX();
            }
        });
    }

    @Override
    public void playNote(int n2, int n3) {
        if (n2 >= 0 && n2 < 128 && n3 >= 0 && n3 < 128) {
            this.exec(() -> {
                if (this.getChannel() instanceof UKr) {
                    UKr uKr2 = (UKr)this.getTarget();
                    uKr2.dYG().Ivg(0, n2, JVh.Ivg(n3), 0.5f, 100L);
                }
            });
        }
    }

    @Override
    public void startNote(int n2, int n3) {
        if (n2 >= 0 && n2 < 128 && n3 >= 0 && n3 < 128) {
            this.exec(() -> {
                if (this.getTarget() instanceof UKr) {
                    UKr uKr2 = (UKr)this.getTarget();
                    uKr2.dYG().Ivg(0, n2, JVh.Ivg(n3));
                }
            });
        }
    }

    @Override
    public void stopNote(int n2, int n3) {
        if (n2 >= 0 && n2 < 128 && n3 >= 0 && n3 < 128) {
            this.exec(() -> {
                if (this.getTarget() instanceof UKr) {
                    UKr uKr2 = (UKr)this.getTarget();
                    uKr2.dYG().OSp(0, n2, JVh.Ivg(n3));
                }
            });
        }
    }

    @Override
    public void sendMidi(int n2, int n3, int n4) {
        if (n2 < 0 || n2 > 127 || n3 < 0 || n3 > 127 || n4 < 0 || n4 > 127) {
            this.exec(() -> {
                if (!(this.getTarget() instanceof UKr)) {
                    return;
                }
                UKr uKr2 = (UKr)this.getTarget();
                uKr2.dYG().Ivg(n2, n3, n4);
            });
        }
    }

    @Override
    public CursorDevice createCursorDevice() {
        this.checkIsInitializingDriver();
        return this.createCursorDevice(DEFAULT_CURSOR_DEVICE_ID, this.getNumSends());
    }

    @Deprecated
    public CursorDevice createEditorDeviceSelection(boolean bl2) {
        return this.createCursorDevice();
    }

    protected void connectToTarget(PhH phH) {
        Object object2;
        super.connectToTarget(phH);
        UKr uKr2 = phH.Nyy();
        assert (this.ZAb(uKr2 != null));
        assert (this.UB2(this.mBankTargetToUseForPosition == null));
        this.updateParentTrackProxiesTarget(phH);
        for (Object object2 : this.mCursorDevices) {
            ((ControlSurfaceProxy)object2).setTarget(uKr2);
        }
        this.updateTrackTypeString(phH);
        boolean bl2 = phH instanceof yWu;
        this.mIsGroupValue.setBoolValue(bl2);
        if (bl2) {
            object2 = (yWu)phH;
            this.mIsGroupExpandedValue.setTarget(object2.KHP().ZAb());
        } else {
            this.mIsGroupExpandedValue.clearTarget();
        }
        this.mArm.setTarget(uKr2.TBp());
        this.mMonitorModeProxy.setTarget(uKr2.u2V());
        this.mIsMonitoring.setTarget(uKr2.KHP());
        this.mIsPreFader.setTarget(uKr2.Omx());
        this.mCrossFadeMode.setTarget(uKr2.pzQ().UB2());
        this.mIsMatrixStopped.setTarget(phH.GJd());
        this.mIsMatrixQueuedForStop.setTarget(phH.Twz());
        this.mCanHoldNoteData.setTarget(uKr2.QPv());
        this.mCanHoldAudioData.setTarget(uKr2.QBO());
        this.mSourceSelector.setTarget(uKr2.cS2());
        if (this.mSlotBank != null) {
            this.mSlotBank.setTarget(phH);
        }
        this.addAllNoteSources();
        uKr2.tGb(this.mTrackTypeListener);
        for (ControlSurfaceObject controlSurfaceObject : this.getChildren()) {
            ControlSurfaceDocumentObjectProxy controlSurfaceDocumentObjectProxy;
            if (controlSurfaceObject instanceof SiblingTrackBankProxy) {
                SiblingTrackBankProxy siblingTrackBankProxy = (SiblingTrackBankProxy)controlSurfaceObject;
                siblingTrackBankProxy.setTrackOrGroup(phH);
                continue;
            }
            if (!bl2) continue;
            yWu yWu2 = (yWu)phH;
            if (controlSurfaceObject instanceof TrackProxy) {
                controlSurfaceDocumentObjectProxy = (TrackProxy)controlSurfaceObject;
                controlSurfaceDocumentObjectProxy.setTarget(yWu2.kQb());
                continue;
            }
            if (!(controlSurfaceObject instanceof AbstractTrackBankProxy)) continue;
            controlSurfaceDocumentObjectProxy = (AbstractTrackBankProxy)controlSurfaceObject;
            ((ChannelBankProxy)controlSurfaceDocumentObjectProxy).setTarget(yWu2);
        }
        if (!this.isInBank()) {
            object2 = phH.R3w();
            assert (this.UB2(this.mBankTargetToUseForPosition == null));
            if (object2 != null) {
                this.mBankTargetToUseForPosition = new TracksBankTarget((yWu)object2, true, true, true, false);
                this.mBankTargetToUseForPosition.setItemsChangedListener(this::scheduleUpdatePositionWhenNotInBank);
                this.updatePositionWhenNotInBank();
            } else {
                this.mPosition.setIntegerValue(-1);
            }
        }
        this.setRemoteControls(phH.Cud().onT());
    }

    private void updateParentTrackProxiesTarget(PhH phH) {
        yWu yWu2 = phH != null ? phH.R3w() : null;
        for (TrackProxy trackProxy : this.mParentTrackProxies) {
            trackProxy.setTarget(yWu2);
        }
    }

    public void disconnectFromTarget(PhH phH) {
        super.disconnectFromTarget(phH);
        this.removeAllNoteSources();
        this.updateParentTrackProxiesTarget(null);
        for (Object object : this.getChildren()) {
            if (!(object instanceof ControlSurfaceProxy)) continue;
            ((ControlSurfaceProxy)object).clearTarget();
        }
        this.mIsGroupValue.setBoolValue(false);
        this.mIsGroupExpandedValue.clearTarget();
        UKr uKr2 = phH.Nyy();
        assert (this.ZAb(uKr2 != null));
        uKr2.Fqp(this.mTrackTypeListener);
        this.mArm.clearTarget();
        this.mMonitorModeProxy.clearTarget();
        this.mIsMonitoring.clearTarget();
        this.mIsPreFader.clearTarget();
        this.mCrossFadeMode.clearTarget();
        this.mIsMatrixStopped.clearTarget();
        this.mIsMatrixQueuedForStop.clearTarget();
        this.mCanHoldNoteData.clearTarget();
        this.mCanHoldAudioData.clearTarget();
        this.mSourceSelector.clearTarget();
        for (CursorDeviceProxy cursorDeviceProxy : this.mCursorDevices) {
            cursorDeviceProxy.clearTarget();
        }
        if (this.mSlotBank != null) {
            this.mSlotBank.clearTarget();
        }
        this.updateTrackTypeString(null);
        if (this.mBankTargetToUseForPosition != null) {
            this.mBankTargetToUseForPosition.setItemsChangedListener(null);
            this.mBankTargetToUseForPosition = null;
        }
        this.mPosition.setIntegerValue(-1);
        this.setRemoteControls(null);
    }

    @Override
    protected void targetChanged() {
        super.targetChanged();
        PhH phH = (PhH)this.getTarget();
        for (ControlSurfaceObject controlSurfaceObject : this.getChildren()) {
            if (!(controlSurfaceObject instanceof SiblingTrackBankProxy)) continue;
            SiblingTrackBankProxy siblingTrackBankProxy = (SiblingTrackBankProxy)controlSurfaceObject;
            siblingTrackBankProxy.setTrackOrGroup(phH);
        }
    }

    @Override
    protected void connectObservers(Object object) {
        UKr uKr2;
        super.connectObservers(object);
        UKr uKr3 = uKr2 = object instanceof UKr ? (UKr)object : null;
        if (uKr2 != null) {
            for (cEP cEP2 : this.getObservers()) {
                if (!(cEP2 instanceof TrackProxy$PitchNamesObserver)) continue;
                uKr2.mTB().Ivg((TrackProxy$PitchNamesObserver)cEP2);
            }
        }
    }

    @Override
    protected void disconnectObservers(Object object) {
        UKr uKr2;
        super.disconnectObservers(object);
        UKr uKr3 = uKr2 = object instanceof UKr ? (UKr)object : null;
        if (uKr2 != null) {
            for (cEP cEP2 : this.getObservers()) {
                if (!(cEP2 instanceof TrackProxy$PitchNamesObserver)) continue;
                uKr2.mTB().OSp((TrackProxy$PitchNamesObserver)cEP2);
            }
        }
    }

    private void updateTrackTypeString(PhH phH) {
        if (phH instanceof yWu) {
            this.mTrackType.setValue("Group");
        } else if (phH instanceof UKr) {
            UKr uKr2 = (UKr)phH;
            if (uKr2.QnH()) {
                switch (uKr2.onT()) {
                    case Ivg: {
                        this.mTrackType.setValue("Instrument");
                        break;
                    }
                    case OSp: {
                        this.mTrackType.setValue("Audio");
                        break;
                    }
                    case oHp: {
                        this.mTrackType.setValue("Hybrid");
                    }
                }
            } else if (uKr2.VOD()) {
                this.mTrackType.setValue("Effect");
            } else if (uKr2.Car()) {
                this.mTrackType.setValue("Master");
            }
        } else {
            this.mTrackType.setValue("");
        }
    }

    @Override
    public void setName(String string) {
        this.exec(() -> {
            if (this.getTarget() instanceof UKr) {
                ((PhH)this.getTarget()).e_(string);
            }
        });
    }

    @Override
    public SettableBooleanValue getCanHoldNoteData() {
        this.deprecated(1, 5, "Use canHoldNoteData() instead");
        return this.mCanHoldNoteData;
    }

    @Override
    public SettableBooleanValue canHoldNoteData() {
        this.newSince(5);
        return this.mCanHoldNoteData;
    }

    @Override
    public SettableBooleanValue getCanHoldAudioData() {
        this.deprecated(1, 5, "Use canHoldAudioData() instead");
        return this.mCanHoldAudioData;
    }

    @Override
    public SettableBooleanValue canHoldAudioData() {
        this.newSince(5);
        return this.mCanHoldAudioData;
    }

    @Override
    public void addPitchNamesObserver(IndexedStringValueChangedCallback indexedStringValueChangedCallback) {
        this.addObserver(new TrackProxy$PitchNamesObserver(this.getControlSurface(), indexedStringValueChangedCallback));
    }

    @Override
    public StringValue trackType() {
        this.newSince(2);
        return this.mTrackType;
    }

    @Override
    public void addTrackTypeObserver(int n2, String string, StringValueChangedCallback stringValueChangedCallback) {
        this.deprecated(1, 2, "Use trackType() instead");
        this.mTrackType.addValueObserver(n2, string, stringValueChangedCallback);
    }

    @Override
    public BooleanValue isGroup() {
        this.newSince(2);
        return this.mIsGroupValue;
    }

    @Override
    public SettableBooleanValue isGroupExpanded() {
        this.newSince(15);
        return this.mIsGroupExpandedValue;
    }

    @Override
    public SettableBooleanValue getIsPreFader() {
        this.newSince(10);
        return this.mIsPreFader;
    }

    @Override
    public void addIsGroupObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use isGroup() instead");
        this.mIsGroupValue.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void addIsQueuedForStopObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use isQueuedForStop() instead");
        this.mIsMatrixQueuedForStop.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    protected PhH getChannel() {
        return (PhH)super.getChannel();
    }

    @Override
    public CursorDevice createCursorDevice(String string) {
        return this.createCursorDevice(string, this.getNumSends());
    }

    @Override
    public CursorDevice createCursorDevice(String string, int n2) {
        String string2 = string == null || string.isEmpty() ? DEFAULT_CURSOR_DEVICE_ID : string;
        assert (this.UB2(this.getKey() != null));
        assert (this.UB2(!this.getKey().isEmpty()));
        CursorDeviceProxy cursorDeviceProxy = CursorDeviceProxy.create(this, this.getKey() + "/" + string2, n2);
        this.mCursorDevices.add(cursorDeviceProxy);
        return cursorDeviceProxy;
    }

    @Deprecated
    public CursorDevice createDeviceSelection(String string, boolean bl2) {
        return this.createCursorDevice(string);
    }

    protected String getChannelSelectionName() {
        return null;
    }

    @Override
    @Deprecated
    public Device getPrimaryInstrument() {
        this.deprecated(1, 2);
        return this.getPrimaryDevice();
    }

    @Override
    public Device getPrimaryDevice() {
        this.deprecatedFail(1, 2, "Use createCursorDevice instead");
        this.checkIsInitializingDriver();
        if (this.mPrimaryDevice == null) {
            this.mPrimaryDevice = CursorDeviceProxy.create(this, this.getKey() + " / Primary Device", this.getNumSends());
            this.mCursorDevices.add(this.mPrimaryDevice);
        }
        assert (this.UB2(this.mPrimaryDevice != null));
        return this.mPrimaryDevice;
    }

    @Override
    public AbstractTrackBankProxy createTrackBank(int n2, int n3, int n4, boolean bl2) {
        TrackBankProxy trackBankProxy = new TrackBankProxy(this, "TrackBank", n2, n3, n4, bl2);
        this.addChild(trackBankProxy);
        return trackBankProxy;
    }

    @Override
    public AbstractTrackBankProxy createMainTrackBank(int n2, int n3, int n4, boolean bl2) {
        MainTrackBankProxy mainTrackBankProxy = new MainTrackBankProxy(this, "MainTrackBank", n2, n3, n4, bl2);
        this.addChild(mainTrackBankProxy);
        return mainTrackBankProxy;
    }

    @Override
    public AbstractTrackBankProxy createEffectTrackBank(int n2, int n3, boolean bl2) {
        EffectTrackBankProxy effectTrackBankProxy = new EffectTrackBankProxy(this, "EffectTrackBank", n2, n3, bl2);
        this.addChild(effectTrackBankProxy);
        return effectTrackBankProxy;
    }

    @Override
    public TrackBank createEffectTrackBank(int n2, int n3, int n4, boolean bl2) {
        EffectTrackBankProxy effectTrackBankProxy = new EffectTrackBankProxy(this, "EffectTrackBank", n2, n3, n4, bl2);
        this.addChild(effectTrackBankProxy);
        return effectTrackBankProxy;
    }

    @Override
    public MasterTrackProxy createMasterTrack(int n2) {
        MasterTrackProxy masterTrackProxy = new MasterTrackProxy((ControlSurfaceObject)this, n2);
        this.addChild(masterTrackProxy);
        return masterTrackProxy;
    }

    @Override
    public TrackBank createSiblingsTrackBank(int n2, int n3, int n4, boolean bl2, boolean bl3) {
        SiblingTrackBankProxy siblingTrackBankProxy = new SiblingTrackBankProxy(this, "SiblingTrackBank", n2, n3, n4, bl2, bl3);
        this.addChild(siblingTrackBankProxy);
        return siblingTrackBankProxy;
    }

    @Override
    public InsertionPoint afterTrackInsertionPoint() {
        return this.mAfterTrackInsertionPoint;
    }

    @Override
    public InsertionPoint beforeTrackInsertionPoint() {
        return this.mBeforeTrackInsertionPoint;
    }

    public cvF createNotificationWidget() {
        Object object;
        assert (this.Ivg(this.isDocumentThread()));
        cWD cWD2 = cWD.UB2(12);
        cuW cuW2 = cuW.ZAb(this.getName());
        cuW2.onT(0.5f);
        cuW2.Ivg((dkd)cuW2.gN_().fLU().BXy());
        cWD2.qGa(cuW2);
        if (this.mCursorDevices != null) {
            for (CursorDeviceProxy cursorDeviceProxy : this.mCursorDevices) {
                cvF cvF2 = cursorDeviceProxy.createNotificationWidget();
                cWD2.qGa(cvF2);
            }
        }
        if (this.mSendBankProxy != null) {
            object = this.mSendBankProxy.createNotificationWidget();
            cWD2.qGa((cvF)object);
        }
        if (this.mPan.shouldIndicate()) {
            object = this.mPan.createVisualizationWidget();
            cWD2.qGa((cvF)object);
        }
        if (this.mVolume.shouldIndicate()) {
            object = this.mVolume.createVisualizationWidget();
            cWD2.qGa((cvF)object);
        }
        return cWD2;
    }

    @Override
    public Track createParentTrack(int n2, int n3) {
        this.newSince(10);
        TrackProxy trackProxy = new TrackProxy(this, this.getKey() + "/parent", -1, n2, n3);
        this.addChild(trackProxy);
        this.mParentTrackProxies.add(trackProxy);
        return trackProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNoteSource(NoteInput noteInput) {
        this.newSince(10);
        this.notNull(noteInput, "noteInput");
        DirectNoteInput directNoteInput = (DirectNoteInput)noteInput;
        List list = this.mDirectNoteInputs;
        synchronized (list) {
            if (this.mDirectNoteInputs.contains(directNoteInput)) {
                return;
            }
            this.mDirectNoteInputs.add(directNoteInput);
        }
        this.exec(() -> this.doAddNoteSource(directNoteInput));
    }

    private void doAddNoteSource(DirectNoteInput directNoteInput) {
        assert (this.Ivg(this.isDocumentThread()));
        PhH phH = (PhH)this.getTarget();
        if (phH == null) {
            return;
        }
        UKr uKr2 = phH.Nyy();
        pq1 pq12 = uKr2.CsW();
        ovA ovA2 = directNoteInput.getNoteSource();
        assert (this.Ivg(ovA2 != null));
        if (ovA2 != null && !pq12.lXt().contains(ovA2)) {
            pq12.Ivg(ovA2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNoteSource(NoteInput noteInput) {
        this.newSince(10);
        this.notNull(noteInput, "noteInput");
        DirectNoteInput directNoteInput = (DirectNoteInput)noteInput;
        List list = this.mDirectNoteInputs;
        synchronized (list) {
            if (!this.mDirectNoteInputs.contains(directNoteInput)) {
                return;
            }
            this.mDirectNoteInputs.remove(directNoteInput);
        }
        this.exec(() -> this.doRemoveNoteSource(directNoteInput));
    }

    private void doRemoveNoteSource(DirectNoteInput directNoteInput) {
        assert (this.Ivg(this.isDocumentThread()));
        PhH phH = (PhH)this.getTarget();
        if (phH == null) {
            return;
        }
        UKr uKr2 = phH.Nyy();
        pq1 pq12 = uKr2.CsW();
        ovA ovA2 = directNoteInput.getNoteSource();
        assert (this.Ivg(ovA2 != null));
        if (ovA2 != null && pq12.lXt().contains(ovA2)) {
            pq12.OSp(ovA2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllNoteSources() {
        assert (this.Ivg(this.isDocumentThread()));
        List list = this.mDirectNoteInputs;
        synchronized (list) {
            for (DirectNoteInput directNoteInput : this.mDirectNoteInputs) {
                this.doRemoveNoteSource(directNoteInput);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAllNoteSources() {
        assert (this.Ivg(this.isDocumentThread()));
        List list = this.mDirectNoteInputs;
        synchronized (list) {
            for (DirectNoteInput directNoteInput : this.mDirectNoteInputs) {
                this.doAddNoteSource(directNoteInput);
            }
        }
    }

    @Override
    public void selectSlot(int n2) {
        this.newSince(10);
        this.greaterThan(n2, -1, "slotIndex");
        this.exec(() -> this.doSelectSlot(n2));
    }

    private void doSelectSlot(int n2) {
        assert (this.Ivg(this.isDocumentThread()));
        PhH phH = (PhH)this.getTarget();
        if (phH == null) {
            return;
        }
        if (n2 >= phH.UxT()) {
            return;
        }
        QZ qZ2 = this.getDocumentGUIWrapper();
        if (qZ2 == null) {
            return;
        }
        avY avY2 = qZ2.zoh();
        avY2.ZAb(phH.onT(n2));
        avY2.R3w();
    }

    @Override
    public void launchLastClipWithOptions(String string, String string2) {
        this.newSince(16);
        JmM jmM = (JmM)this.mLaunchQuantizationHelper.validateValueFromController(string);
        fkQ fkQ2 = (fkQ)this.mLaunchModeHelper.validateValueFromController(string2);
        this.exec(() -> this.doLaunchLastClipWithOptions(jmM, fkQ2));
    }

    @Override
    public HardwareActionBindable launchLastClipWithOptionsAction(String string, String string2) {
        this.newSince(16);
        JmM jmM = (JmM)this.mLaunchQuantizationHelper.validateValueFromController(string);
        fkQ fkQ2 = (fkQ)this.mLaunchModeHelper.validateValueFromController(string2);
        return new DocumentAction((ControlSurfaceObject)this, () -> this.doLaunchLastClipWithOptions(jmM, fkQ2));
    }

    @Override
    public CursorRemoteControlsPage createCursorRemoteControlsPage(int n2) {
        this.newSince(18);
        this.checkIsInitializingDriver();
        if (this.mMainRemoteControlsSection != null) {
            throw new QWx("Can only create one set of main remote controls that follow the selection");
        }
        assert (this.UB2(this.isControlSurfaceThread()));
        assert (this.UB2(this.isInitializingDriver()));
        this.mMainRemoteControlsSection = new MainDeviceCursorRemoteControlsPageProxy(this, this.getKey() + "/RemoteControls/Parameter", n2);
        return this.mMainRemoteControlsSection;
    }

    @Override
    public CursorRemoteControlsPage createCursorRemoteControlsPage(String string, int n2, String string2) {
        String string3;
        this.newSince(18);
        this.checkIsInitializingDriver();
        String string4 = string3 = string2 != null ? string2 : "";
        assert (this.UB2(this.isControlSurfaceThread()));
        assert (this.UB2(this.isInitializingDriver()));
        if (string == null || string.isEmpty()) {
            throw new QWx("Name must be provided");
        }
        if (n2 < 1) {
            throw new QWx("parameterCount must be >= 1");
        }
        int n3 = 0;
        if (this.mIndependentRemoteControlsSections == null) {
            this.mIndependentRemoteControlsSections = new ArrayList(2);
        } else {
            for (IndependentDeviceCursorRemoteControlsPageProxy independentDeviceCursorRemoteControlsPageProxy : this.mIndependentRemoteControlsSections) {
                if (!independentDeviceCursorRemoteControlsPageProxy.getFilter().equals(string3)) continue;
                ++n3;
            }
        }
        IndependentDeviceCursorRemoteControlsPageProxy independentDeviceCursorRemoteControlsPageProxy = new IndependentDeviceCursorRemoteControlsPageProxy(this, this.getKey() + "/RemoteControls/" + string + "/Parameter", n2, string3, n3);
        this.mIndependentRemoteControlsSections.add(independentDeviceCursorRemoteControlsPageProxy);
        return independentDeviceCursorRemoteControlsPageProxy;
    }

    private void doLaunchLastClipWithOptions(JmM jmM, fkQ fkQ2) {
        assert (this.Ivg(this.isDocumentThread()));
        PhH phH = (PhH)this.getTarget();
        if (phH == null) {
            return;
        }
        phH.Ivg(true, jmM, fkQ2);
    }

    @Override
    public void recordNewLauncherClip(int n2) {
        this.newSince(10);
        this.greaterThan(n2, -1, "slotIndex");
        this.exec(() -> this.doRecordNewLauncherClip(n2, true));
    }

    int doRecordNewLauncherClip(int n2, boolean bl2) {
        assert (this.Ivg(this.isDocumentThread()));
        PhH phH = (PhH)this.getTarget();
        if (phH == null) {
            return -1;
        }
        this.ensureSceneCount(n2);
        vkp vkp2 = this.findOrCreateFreeSlot(n2);
        if (!(vkp2 instanceof FhV)) {
            return -1;
        }
        phH.Nyy().OSp(true);
        FhV fhV = (FhV)vkp2;
        fhV.kyS();
        fhV.Ivg(true, false);
        if (bl2) {
            int n3 = fhV.qGa();
            this.doSelectSlot(n3);
        }
        return fhV.qGa();
    }

    @Override
    public void createNewLauncherClip(int n2, int n3) {
        this.newSince(10);
        this.greaterThan(n2, -1, "slotIndex");
        this.atLeast(n3, 1, "lengthInBeats");
        this.exec(() -> this.doCreateNewLauncherClip(n2, n3, true));
    }

    @Override
    public void createNewLauncherClip(int n2) {
        this.newSince(10);
        this.greaterThan(n2, -1, "slotIndex");
        this.exec(() -> this.doCreateNewLauncherClip(n2, -1, true));
    }

    FGC doCreateNewLauncherClip(int n2, int n3, boolean bl2) {
        assert (this.Ivg(this.isDocumentThread()));
        PhH phH = (PhH)this.getTarget();
        if (phH == null) {
            return null;
        }
        this.ensureSceneCount(n2);
        vkp vkp2 = this.findOrCreateFreeSlot(n2);
        if (!(vkp2 instanceof FhV)) {
            return null;
        }
        FhV fhV = (FhV)vkp2;
        if (n3 > 0) {
            fhV.Ivg(n3);
        } else {
            fhV.GC2();
        }
        if (bl2) {
            int n4 = fhV.qGa();
            this.doSelectSlot(n4);
        }
        return fhV.ZAb();
    }

    private vkp findOrCreateFreeSlot(int n2) {
        PhH phH = (PhH)this.getTarget();
        assert (this.Ivg(phH != null));
        int n3 = phH.UxT();
        for (int i2 = n2; i2 < n3; ++i2) {
            vkp vkp2 = phH.onT(i2);
            if (!vkp2.Vma()) continue;
            return vkp2;
        }
        yWu yWu2 = this.getDocument().ZYV();
        yWu2.oHp(n3, null);
        return phH.onT(n3);
    }

    private void ensureSceneCount(int n2) {
        PhH phH = (PhH)this.getTarget();
        assert (this.Ivg(phH != null));
        int n3 = phH.UxT();
        if (n3 < n2) {
            mgC mgC2 = this.getDocument();
            yWu yWu2 = mgC2.ZYV();
            for (int i2 = n3; i2 < n2; ++i2) {
                yWu2.oHp(i2, null);
            }
        }
    }

    public boolean isInBank() {
        return false;
    }

    private void scheduleUpdatePositionWhenNotInBank() {
        assert (this.UB2(this.isDocumentThread()));
        if (!this.mHasScheduledUpdateToPositionWhenNotInBank) {
            this.mHasScheduledUpdateToPositionWhenNotInBank = true;
            this.runAtEndOfEvent(this::updatePositionWhenNotInBank);
        }
    }

    private void updatePositionWhenNotInBank() {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(!this.isInBank()));
        this.mHasScheduledUpdateToPositionWhenNotInBank = false;
        int n2 = -1;
        if (this.mBankTargetToUseForPosition != null) {
            PhH phH = (PhH)this.getTarget();
            assert (this.UB2(phH != null));
            if (phH != null) {
                List list = this.mBankTargetToUseForPosition.listItems();
                n2 = list.indexOf(phH);
            }
        }
        this.mPosition.setIntegerValue(n2);
    }

    private void setRemoteControls(qvi qvi2) {
        if (this.mMainRemoteControlsSection != null) {
            this.mMainRemoteControlsSection.setTarget(qvi2);
        }
        if (this.mIndependentRemoteControlsSections != null) {
            for (DeviceCursorRemoteControlsPageProxy deviceCursorRemoteControlsPageProxy : this.mIndependentRemoteControlsSections) {
                deviceCursorRemoteControlsPageProxy.setTarget(qvi2);
            }
        }
    }
}

