/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.api.Color;
import com.bitwig.extension.controller.api.EnumDefinition;
import com.bitwig.extension.controller.api.EnumValueDefinition;
import com.bitwig.extension.controller.api.SettableBooleanValue;
import com.bitwig.extension.controller.api.SettableColorValue;
import com.bitwig.extension.controller.api.SettableEnumValue;
import com.bitwig.extension.controller.api.Setting;
import com.bitwig.extension.controller.api.Settings;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.BooleanSetting;
import com.bitwig.flt.control_surface.values.ColorSetting;
import com.bitwig.flt.control_surface.values.EnumSetting;
import com.bitwig.flt.control_surface.values.NumberSetting;
import com.bitwig.flt.control_surface.values.SignalSetting;
import com.bitwig.flt.control_surface.values.StringSetting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class SettingsProxy
extends ControlSurfaceDocumentProxy
implements Settings {
    protected final Map mSettings = new HashMap(32);
    protected final List mCategories = new ArrayList(4);
    private Map mInitialSettingValues;

    public SettingsProxy(ControlSurfaceObject controlSurfaceObject, String string, Map map) {
        super(controlSurfaceObject);
        this.setKey(string);
        this.mInitialSettingValues = map;
    }

    private void addSetting(Setting setting) {
        List<Setting> list;
        assert (this.UB2(setting != null));
        assert (this.UB2(this.isControlSurfaceThread()));
        this.checkCanAddSetting(setting.getLabel(), setting.getCategory());
        this.addChild((ControlSurfaceObject)((Object)setting));
        String string = setting.getCategory();
        if (!this.mCategories.contains(string)) {
            this.mCategories.add(string);
        }
        if (this.mSettings.containsKey(string)) {
            list = (List)this.mSettings.get(string);
        } else {
            list = new ArrayList(32);
            this.mSettings.put(string, list);
        }
        list.add(setting);
    }

    protected final int getSettingIndex(Setting setting) {
        return this.getSettings(setting.getCategory()).indexOf(setting);
    }

    public List getSettings(String string) {
        return (List)this.mSettings.get(string);
    }

    private void checkCanAddSetting(String string, String string2) {
        assert (this.UB2(this.isControlSurfaceThread()));
        if (string == null || string.isEmpty()) {
            throw new QWx("Label must be provided for a setting");
        }
        if (string2 == null || string2.isEmpty()) {
            throw new QWx("Category must be provided for a setting");
        }
        if (!this.getControlSurface().tGb()) {
            throw new QWx("Settings can only be added during script initialization");
        }
        List list = (List)this.mSettings.get(string2);
        if (list != null && list.stream().anyMatch(setting -> setting.getLabel().equals(string))) {
            throw new QWx("A setting with name " + string + " in category " + string2 + " has already been added");
        }
    }

    @Override
    public SignalSetting getSignalSetting(String string, String string2, String string3) {
        this.notEmpty(string, "label");
        SignalSetting signalSetting = new SignalSetting(this, string, string2, string3);
        this.addSetting(signalSetting);
        return signalSetting;
    }

    private Object getInitialValue(String string, String string2) {
        if (this.mInitialSettingValues == null) {
            return null;
        }
        Map map = (Map)this.mInitialSettingValues.get(string2);
        if (map == null) {
            return null;
        }
        return map.get(string);
    }

    public void finishedInitializing() {
        this.mInitialSettingValues = null;
    }

    @Override
    public NumberSetting getNumberSetting(String string, String string2, double d2, double d3, double d4, String string3, double d5) {
        double d6;
        this.notEmpty(string, "label");
        double d7 = d5;
        Object object = this.getInitialValue(string, string2);
        if (object instanceof Number && (d6 = ((Number)object).doubleValue()) >= d2 && d6 <= d3) {
            d7 = d6;
        }
        NumberSetting numberSetting = new NumberSetting(this, string, string2, d2, d3, d4, string3, d7);
        this.addSetting(numberSetting);
        return numberSetting;
    }

    @Override
    public EnumSetting getEnumSetting(String string, String string2, String[] stringArray, String string3) {
        this.notEmpty(string, "label");
        this.notNull(string3, "defaultValue");
        this.notNull(stringArray, "options");
        this.atLeast(stringArray.length, 1, "options.length");
        boolean bl2 = false;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.notNull(stringArray[i2], "options[" + i2 + "]");
            bl2 |= stringArray[i2].equals(string3);
        }
        if (!bl2) {
            throw new QWx("defaultValue " + string3 + " was not found amoung the options");
        }
        Object object = this.getInitialValue(string, string2);
        String string4 = string3;
        if (object instanceof String && Arrays.asList(stringArray).contains(object)) {
            string4 = (String)object;
        }
        EnumSetting enumSetting = new EnumSetting(this, string, string2, stringArray, string4);
        this.addSetting(enumSetting);
        return enumSetting;
    }

    @Override
    public SettableEnumValue getEnumSetting(String string, String string2, EnumValueDefinition enumValueDefinition) {
        this.newSince(11);
        this.notNull(enumValueDefinition, "enumDefinition");
        EnumDefinition enumDefinition = enumValueDefinition.enumDefinition();
        int n2 = enumDefinition.getValueCount();
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = enumDefinition.valueDefinitionAt(i2).getId();
        }
        return this.getEnumSetting(string, string2, stringArray, enumValueDefinition.getId());
    }

    @Override
    public SettableEnumValue getEnumSettingForValue(String string2, String string3, SettableEnumValue settableEnumValue) {
        this.newSince(11);
        this.notNull(settableEnumValue, "value");
        settableEnumValue.markInterested();
        settableEnumValue.subscribe();
        EnumDefinition enumDefinition = settableEnumValue.enumDefinition();
        SettableEnumValue settableEnumValue2 = this.getEnumSetting(string2, string3, enumDefinition.valueDefinitionFor(settableEnumValue.get()));
        settableEnumValue2.addValueObserver(string -> settableEnumValue.set((String)string));
        settableEnumValue.addValueObserver(string -> settableEnumValue2.set((String)string));
        return settableEnumValue2;
    }

    @Override
    public StringSetting getStringSetting(String string, String string2, int n2, String string3) {
        this.notEmpty(string, "label");
        Object object = this.getInitialValue(string, string2);
        String string4 = string3;
        if (object instanceof String) {
            string4 = (String)object;
        }
        StringSetting stringSetting = new StringSetting(this, string, string2, string4);
        this.addSetting(stringSetting);
        return stringSetting;
    }

    @Override
    public SettableColorValue getColorSetting(String string, String string2, Color color) {
        Object object;
        this.newSince(5);
        this.notEmpty(string, "label");
        this.validColor(color, "initialColor");
        Color color2 = color;
        Object object2 = this.getInitialValue(string, string2);
        if (object2 instanceof RjR) {
            object = (RjR)object2;
            color2 = Color.fromRGBA(((RjR)object).UB2(), ((RjR)object).ZAb(), ((RjR)object).lXt(), ((RjR)object).onT());
        }
        object = new ColorSetting((ControlSurfaceObject)this, string, string2, color2);
        this.addSetting((Setting)object);
        return object;
    }

    @Override
    public SettableColorValue getColorSettingForValue(String string, String string2, SettableColorValue settableColorValue) {
        this.newSince(11);
        this.notNull(settableColorValue, "value");
        settableColorValue.markInterested();
        settableColorValue.subscribe();
        SettableColorValue settableColorValue2 = this.getColorSetting(string, string2, settableColorValue.get());
        settableColorValue2.addValueObserver((f2, f3, f4) -> settableColorValue.set(settableColorValue2.get()));
        settableColorValue.addValueObserver((f2, f3, f4) -> settableColorValue2.set(settableColorValue.get()));
        return settableColorValue2;
    }

    @Override
    public SettableBooleanValue getBooleanSetting(String string, String string2, boolean bl2) {
        this.newSince(7);
        this.notEmpty(string, "label");
        Object object = this.getInitialValue(string, string2);
        boolean bl3 = bl2;
        if (object instanceof Boolean) {
            bl3 = (Boolean)object;
        }
        BooleanSetting booleanSetting = new BooleanSetting(this, string, string2, bl3);
        this.addSetting(booleanSetting);
        return booleanSetting;
    }

    @Override
    public SettableBooleanValue getBooleanSettingForValue(String string, String string2, SettableBooleanValue settableBooleanValue) {
        this.newSince(11);
        this.notNull(settableBooleanValue, "value");
        settableBooleanValue.markInterested();
        settableBooleanValue.subscribe();
        SettableBooleanValue settableBooleanValue2 = this.getBooleanSetting(string, string2, settableBooleanValue.get());
        settableBooleanValue2.addValueObserver(bl2 -> settableBooleanValue.set(bl2));
        settableBooleanValue.addValueObserver(bl2 -> settableBooleanValue2.set(bl2));
        return settableBooleanValue2;
    }
}

