/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.ShortMidiDataReceivedCallback;
import com.bitwig.extension.callback.SysexMidiDataReceivedCallback;
import com.bitwig.extension.controller.api.AbsoluteHardwareValueMatcher;
import com.bitwig.extension.controller.api.HardwareActionMatcher;
import com.bitwig.extension.controller.api.MidiExpressions;
import com.bitwig.extension.controller.api.MidiIn;
import com.bitwig.extension.controller.api.NoteInput;
import com.bitwig.extension.controller.api.RelativeHardwareValueMatcher;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject$AllowedCreationTime;
import com.bitwig.flt.control_surface.proxy.DirectNoteInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MidiInPort
extends ControlSurfaceObject
implements SV,
MidiIn {
    private final int mIndex;
    private final List mNoteInputsToSendTo = new ArrayList();

    public MidiInPort(ControlSurfaceObject controlSurfaceObject, int n2) {
        super(controlSurfaceObject, ControlSurfaceObject$AllowedCreationTime.DRIVER_SETUP);
        this.mIndex = n2;
    }

    @Override
    public void setMidiCallback(ShortMidiDataReceivedCallback shortMidiDataReceivedCallback) {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.getControlSurface().Ivg(this.mIndex, shortMidiDataReceivedCallback);
    }

    @Override
    public void setSysexCallback(SysexMidiDataReceivedCallback sysexMidiDataReceivedCallback) {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.getControlSurface().Ivg(this.mIndex, sysexMidiDataReceivedCallback);
    }

    @Override
    public NoteInput createNoteInput(String string, String ... stringArray) {
        this.notNull(string, "name");
        this.checkIsInitializingDriver();
        boolean bl2 = true;
        for (DirectNoteInput directNoteInput : this.mNoteInputsToSendTo) {
            if (!directNoteInput.isMatchAll()) continue;
            bl2 = false;
            break;
        }
        DirectNoteInput directNoteInput = this.getControlSurface().Ivg(this.getHost(), string, bl2, stringArray);
        this.sendToNoteInputImpl(directNoteInput);
        return directNoteInput;
    }

    private void sendToNoteInputImpl(DirectNoteInput directNoteInput) {
        assert (this.UB2(this.isControlSurfaceThread()));
        try {
            if (!this.mNoteInputsToSendTo.contains(directNoteInput)) {
                String string = ((DoJ)this.getControlSurface().rr().get(this.mIndex)).UB2().lXt();
                this.getControlSurface().Vma().OSp(string, directNoteInput.getEngineNoteInputId());
                this.mNoteInputsToSendTo.add(directNoteInput);
            }
        }
        catch (IOException iOException) {
            throw new t1i(this.getControlSurface(), "Could not connect MIDI input to note input", iOException);
        }
    }

    private void stopSendingToNoteInputImpl(DirectNoteInput directNoteInput) {
        assert (this.UB2(this.isControlSurfaceThread()));
        try {
            if (this.mNoteInputsToSendTo.contains(directNoteInput)) {
                String string = ((DoJ)this.getControlSurface().rr().get(this.mIndex)).UB2().lXt();
                this.getControlSurface().Vma().oHp(string, directNoteInput.getEngineNoteInputId());
                this.mNoteInputsToSendTo.remove(directNoteInput);
            }
        }
        catch (IOException iOException) {
            throw new t1i(this.getControlSurface(), "Could not disconnect MIDI input to note input", iOException);
        }
    }

    public boolean checkIfEventIsNoteInputOnDocumentThread(uPE uPE2) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(uPE2 != null));
        for (DirectNoteInput directNoteInput : this.mNoteInputsToSendTo) {
            if (!directNoteInput.checkIfEventIsNoteInputOnDocumentThread(uPE2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AbsoluteHardwareValueMatcher createAbsolutePitchBendValueMatcher(int n2) {
        return this.createAbsoluteValueMatcher(this.midiExpressions().createIsPitchBendExpression(n2), "data2 << 7 | data1", 14);
    }

    @Override
    public AbsoluteHardwareValueMatcher createSequencedValueMatcher(AbsoluteHardwareValueMatcher absoluteHardwareValueMatcher, AbsoluteHardwareValueMatcher absoluteHardwareValueMatcher2, boolean bl2) {
        this.checkMatcherIsForThisMidiIn("firstValueMatcher", absoluteHardwareValueMatcher);
        this.checkMatcherIsForThisMidiIn("secondValueMatcher", absoluteHardwareValueMatcher2);
        return new n2f((vu)((Object)absoluteHardwareValueMatcher), (vu)((Object)absoluteHardwareValueMatcher2), bl2);
    }

    @Override
    public Nnp createAbsoluteValueMatcher(String string, String string2, int n2) {
        return new Nnp(this.createActionMatcher(string), this.parseExpression(string2), n2);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeValueMatcher(String string, double d2) {
        return new B3(this, this.parseExpression(string), d2);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeSignedBitValueMatcher(String string, String string2, int n2, int n3) {
        return this.createRelativeSignedBitValueMatcher(this.createAbsoluteValueMatcher(string, string2, n2), n3);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeSignedBitValueMatcher(AbsoluteHardwareValueMatcher absoluteHardwareValueMatcher, int n2) {
        this.checkMatcherIsForThisMidiIn("valueMatcher", absoluteHardwareValueMatcher);
        return new mlL((sAP)absoluteHardwareValueMatcher, n2);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeSignedBit2ValueMatcher(String string, String string2, int n2, int n3) {
        return this.createRelativeSignedBit2ValueMatcher(this.createAbsoluteValueMatcher(string, string2, n2), n3);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeSignedBit2ValueMatcher(AbsoluteHardwareValueMatcher absoluteHardwareValueMatcher, int n2) {
        this.checkMatcherIsForThisMidiIn("valueMatcher", absoluteHardwareValueMatcher);
        return new qq3((sAP)absoluteHardwareValueMatcher, n2);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeBinOffsetValueMatcher(String string, String string2, int n2, int n3) {
        return this.createRelativeBinOffsetValueMatcher(this.createAbsoluteValueMatcher(string, string2, n2), n3);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeBinOffsetValueMatcher(AbsoluteHardwareValueMatcher absoluteHardwareValueMatcher, int n2) {
        this.checkMatcherIsForThisMidiIn("valueMatcher", absoluteHardwareValueMatcher);
        return new ClP((sAP)absoluteHardwareValueMatcher, n2);
    }

    @Override
    public RelativeHardwareValueMatcher createRelative2sComplementValueMatcher(String string, String string2, int n2, int n3) {
        return this.createRelative2sComplementValueMatcher(this.createAbsoluteValueMatcher(string, string2, n2), n3);
    }

    @Override
    public RelativeHardwareValueMatcher createRelative2sComplementValueMatcher(AbsoluteHardwareValueMatcher absoluteHardwareValueMatcher, int n2) {
        this.checkMatcherIsForThisMidiIn("valueMatcher", absoluteHardwareValueMatcher);
        return new rlc((sAP)absoluteHardwareValueMatcher, n2);
    }

    @Override
    public jUg createActionMatcher(String string) {
        return new jUg(this, this.parseExpression(string));
    }

    @Override
    public String hardwareAddress() {
        this.newSince(21);
        String string = this.getMidiReceiver().UB2().lXt();
        return this.getControlSurface().Vma().Ivg(string, true);
    }

    @Override
    public HardwareActionMatcher createCCActionMatcher(int n2, int n3, int n4) {
        return this.createActionMatcher(this.midiExpressions().createIsCCValueExpression(n2, n3, n4));
    }

    @Override
    public HardwareActionMatcher createCCActionMatcher(int n2, int n3) {
        return this.createActionMatcher(this.midiExpressions().createIsCCExpression(n2, n3));
    }

    @Override
    public HardwareActionMatcher createNoteOnActionMatcher(int n2, int n3) {
        return this.createActionMatcher(this.midiExpressions().createIsNoteOnExpression(n2, n3));
    }

    @Override
    public AbsoluteHardwareValueMatcher createNoteOnVelocityValueMatcher(int n2, int n3) {
        return this.createAbsoluteValueMatcher(this.midiExpressions().createIsNoteOnExpression(n2, n3), "data2", 7);
    }

    @Override
    public AbsoluteHardwareValueMatcher createNoteOffVelocityValueMatcher(int n2, int n3) {
        return this.createAbsoluteValueMatcher(this.midiExpressions().createIsNoteOffExpression(n2, n3), "data2", 7);
    }

    @Override
    public HardwareActionMatcher createNoteOffActionMatcher(int n2, int n3) {
        return this.createActionMatcher(this.midiExpressions().createIsNoteOffExpression(n2, n3));
    }

    @Override
    public AbsoluteHardwareValueMatcher createAbsoluteCCValueMatcher(int n2, int n3) {
        return this.createAbsoluteValueMatcher(this.midiExpressions().createIsCCExpression(n2, n3), "data2", 7);
    }

    @Override
    public AbsoluteHardwareValueMatcher createAbsoluteCCValueMatcher(int n2) {
        return this.createAbsoluteValueMatcher(this.midiExpressions().createIsCCExpression(n2), "data2", 7);
    }

    @Override
    public AbsoluteHardwareValueMatcher createPolyAftertouchValueMatcher(int n2, int n3) {
        return this.createAbsoluteValueMatcher(this.midiExpressions().createIsPolyAftertouch(n2, n3), "data2", 7);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeSignedBitCCValueMatcher(int n2, int n3, int n4) {
        return this.createRelativeSignedBitValueMatcher(this.midiExpressions().createIsCCExpression(n2, n3), "data2", 7, n4);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeSignedBit2CCValueMatcher(int n2, int n3, int n4) {
        return this.createRelativeSignedBit2ValueMatcher(this.midiExpressions().createIsCCExpression(n2, n3), "data2", 7, n4);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeBinOffsetCCValueMatcher(int n2, int n3, int n4) {
        return this.createRelativeBinOffsetValueMatcher(this.midiExpressions().createIsCCExpression(n2, n3), "data2", 7, n4);
    }

    @Override
    public RelativeHardwareValueMatcher createRelative2sComplementCCValueMatcher(int n2, int n3, int n4) {
        return this.createRelative2sComplementValueMatcher(this.midiExpressions().createIsCCExpression(n2, n3), "data2", 7, n4);
    }

    private is parseExpression(String string) {
        try {
            return is.OSp(string);
        }
        catch (iy iy2) {
            throw new QWx("Invalid MIDI event expression", iy2);
        }
    }

    public int getIndex() {
        return this.mIndex;
    }

    public DoJ getMidiReceiver() {
        return (DoJ)this.getControlSurface().rr().get(this.mIndex);
    }

    private MidiExpressions midiExpressions() {
        return this.getHost().midiExpressions();
    }

    private void checkMatcherIsForThisMidiIn(String string, AbsoluteHardwareValueMatcher absoluteHardwareValueMatcher) {
        if (!(absoluteHardwareValueMatcher instanceof sAP)) {
            throw new QWx(string + " is not a MIDI value matcher for this MidiIn");
        }
        if (((sAP)absoluteHardwareValueMatcher).UB2() != this) {
            throw new QWx(string + " is not a MIDI value matcher for this MidiIn");
        }
    }

    public List getNoteInputsToSendTo() {
        return this.mNoteInputsToSendTo;
    }

    public void close() {
        assert (this.UB2(this.isControlSurfaceThread()));
        for (DirectNoteInput directNoteInput : new ArrayList(this.mNoteInputsToSendTo)) {
            try {
                this.stopSendingToNoteInputImpl(directNoteInput);
            }
            catch (t1i t1i2) {
                bRL.ZAb.oHp("Error closing MIDI in", t1i2);
            }
        }
    }

    public int getHarwareInputSourceId() {
        return this.getControlSurface().QkE();
    }

    @Override
    public void sendRawMidiEvent(int n2, int n3, int n4) {
        DoJ doJ2 = this.getMidiReceiver();
        try {
            doJ2.Ivg(0L, n2, n3, n4);
        }
        catch (IOException iOException) {
            bRL.ZAb.OSp(iOException);
        }
    }
}

