/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.flt.app.jrf;
import com.bitwig.flt.control_surface.proxy.ListToFixedSizeWindowValue$ChangeListener;
import java.util.ArrayList;
import java.util.List;

public class ListToFixedSizeWindowValue
extends doc {
    private final ArrayList mSlaves;
    private final OIA mCanScrollUp;
    private final OIA mCanScrollDown;
    private final OIA mCanScrollPageUp;
    private final OIA mCanScrollPageDown;
    private final xby mWindowOffset;
    private final xby mListItemCount;
    private final int mWindowSize;
    private final tmO mList;
    private List mCurrentWindow;
    private final ListToFixedSizeWindowValue$ChangeListener mListener;
    private boolean mHasBeenDisposed;
    private int mPageAlignment;
    private boolean mHasInvalidatedWindow;

    public ListToFixedSizeWindowValue(int n2, tmO tmO2, ListToFixedSizeWindowValue$ChangeListener listToFixedSizeWindowValue$ChangeListener) {
        super(true);
        assert (bRL.oHp(n2 > 0));
        this.mWindowSize = n2;
        this.mList = tmO2;
        this.mListener = listToFixedSizeWindowValue$ChangeListener;
        this.mWindowOffset = new xby(0);
        this.mListItemCount = new xby(0);
        this.mSlaves = new ArrayList(3);
        this.mCanScrollUp = new OIA(false);
        this.mCanScrollDown = new OIA(false);
        this.mCanScrollPageUp = new OIA(false);
        this.mCanScrollPageDown = new OIA(false);
        this.addSource(this.mList);
    }

    public void addSlave(ListToFixedSizeWindowValue listToFixedSizeWindowValue) {
        this.mSlaves.add(listToFixedSizeWindowValue);
        listToFixedSizeWindowValue.scrollToOffset(this.mWindowOffset.getValue(), true, false);
    }

    public void removeSlave(ListToFixedSizeWindowValue listToFixedSizeWindowValue) {
        this.mSlaves.remove(listToFixedSizeWindowValue);
    }

    private void invalidateWindow() {
        if (!this.mHasInvalidatedWindow) {
            this.mHasInvalidatedWindow = true;
            jrf.NhN().runAtEndOfCurrentEvent(() -> {
                this.updateWindow();
                this.mHasInvalidatedWindow = false;
            });
        }
    }

    private void updateWindow() {
        int n2;
        int n3;
        if (this.mHasBeenDisposed || this.mWindowSize == 0) {
            return;
        }
        List list = this.mCurrentWindow;
        ArrayList<Object> arrayList = new ArrayList<Object>(this.mWindowSize);
        int n4 = this.mList.OSp();
        for (n3 = 0; n3 < this.mWindowSize; ++n3) {
            n2 = this.mWindowOffset.getValue() + n3;
            if (n2 < n4) {
                arrayList.add(this.mList.OSp(n2));
                continue;
            }
            arrayList.add(null);
        }
        n3 = this.mCurrentWindow == null ? 1 : 0;
        this.mCurrentWindow = arrayList;
        if (n3 != 0) {
            n2 = 0;
            for (Object e2 : arrayList) {
                this.mListener.onAssign(n2++, null, e2);
            }
        } else {
            for (n2 = 0; n2 < this.mWindowSize; ++n2) {
                if (arrayList.get(n2) == list.get(n2)) continue;
                this.mListener.onAssign(n2, list.get(n2), arrayList.get(n2));
            }
        }
        this.mListItemCount.setValue(n4);
        this.updateScrollableStatus();
    }

    public OIA getCanScrollDown() {
        return this.mCanScrollDown;
    }

    public OIA getCanScrollUp() {
        return this.mCanScrollUp;
    }

    public OIA getCanScrollPageDown() {
        return this.mCanScrollPageDown;
    }

    public OIA getCanScrollPageUp() {
        return this.mCanScrollPageUp;
    }

    private void updateScrollableStatus() {
        int n2 = this.mList.OSp();
        this.mCanScrollUp.Ivg(this.mWindowOffset.getValue() > 0);
        this.mCanScrollDown.Ivg(this.mWindowOffset.getValue() < n2 - this.mWindowSize);
        this.mCanScrollPageUp.Ivg(this.mWindowOffset.getValue() > 0);
        int n3 = (n2 - 1) / this.mWindowSize * this.mWindowSize;
        this.mCanScrollPageDown.Ivg(this.mWindowOffset.getValue() < n3);
    }

    public void dispose() {
        assert (bRL.onT(!this.mHasBeenDisposed));
        this.removeSource(this.mList);
        this.mHasBeenDisposed = true;
    }

    public void shiftWindow(int n2) {
        this.shiftWindow(n2, false);
    }

    public void shiftWindow(int n2, boolean bl2) {
        this.scrollToOffset(this.mWindowOffset.getValue() + n2, bl2, false);
    }

    public void shiftWindowPage(int n2) {
        int n3 = this.mWindowOffset.getValue() + n2 * this.mWindowSize;
        this.scrollToOffset(n3, true, true);
    }

    public void scrollTo(int n2) {
        this.scrollToOffset(n2, false, true);
    }

    public void scrollToOffset(int n2, boolean bl2, boolean bl3) {
        int n3;
        int n4 = bl3 ? this.quantizePosition(n2) : (n3 = Math.max(0, Math.min(n2, this.mList.OSp() - (bl2 ? 1 : this.mWindowSize))));
        if (this.mWindowOffset.getValue() != n3) {
            this.mWindowOffset.setValue(n3);
            this.updateWindow();
            for (ListToFixedSizeWindowValue listToFixedSizeWindowValue : this.mSlaves) {
                listToFixedSizeWindowValue.scrollToOffset(this.mWindowOffset.getValue(), bl2, false);
            }
        }
    }

    protected int quantizePosition(int n2) {
        int n3 = this.mPageAlignment % this.mWindowSize;
        int n4 = (n2 - n3) / this.mWindowSize * this.mWindowSize + n3;
        if (n4 < this.mWindowOffset.getValue() - this.mWindowSize) {
            n4 += this.mWindowSize;
        }
        int n5 = (this.mList.OSp() - 1) / this.mWindowSize * this.mWindowSize;
        return Syh.Ivg(n4, 0, n5);
    }

    @Override
    public void changedItems(tmO tmO2, int n2, int n3) {
        this.invalidateWindow();
    }

    @Override
    public void addedAsListenerTo(tmO tmO2) {
        this.invalidateWindow();
    }

    @Override
    public void aboutToRemoveAsListenerFrom(tmO tmO2) {
        for (int i2 = 0; i2 < this.mWindowSize; ++i2) {
            if (this.mCurrentWindow == null || this.mCurrentWindow.get(i2) == null) continue;
            this.mListener.onAssign(i2, this.mCurrentWindow.get(i2), null);
        }
        this.mListItemCount.setValue(0);
        this.updateScrollableStatus();
    }

    @Override
    public void insertedItems(tmO tmO2, int n2, int n3) {
        this.invalidateWindow();
    }

    @Override
    public void aboutToRemoveItems(tmO tmO2, int n2, int n3) {
        this.invalidateWindow();
    }

    @Override
    protected void insertedItem(tmO tmO2, Object object, int n2) {
        this.invalidateWindow();
    }

    @Override
    protected void aboutToRemoveItem(tmO tmO2, Object object, int n2) {
        this.invalidateWindow();
    }

    public tmO getList() {
        return this.mList;
    }

    public mks getPosition() {
        return this.mWindowOffset;
    }

    public mks getListItemCount() {
        return this.mListItemCount;
    }

    public int getPageAlignment() {
        return this.mPageAlignment;
    }

    public void setPageAlignment(int n2) {
        this.mPageAlignment = n2;
    }
}

