/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.DrumPadBank;
import com.bitwig.flt.control_surface.proxy.BankTarget;
import com.bitwig.flt.control_surface.proxy.ChannelBankProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceProxy;
import com.bitwig.flt.control_surface.proxy.DrumPadProxy;
import com.bitwig.flt.control_surface.values.BooleanValueProxy;
import com.bitwig.flt.document.core.iface.mgC;
import java.util.ArrayList;
import java.util.List;

public class DrumPadBankProxy
extends ChannelBankProxy
implements DrumPadBank {
    private final boolean mIsIndicating = true;
    private final int mNumLanes;
    private final List mPads;
    private final BooleanValueProxy mHasMutedPads;
    private final BooleanValueProxy mHasSoloedPads;

    public DrumPadBankProxy(ControlSurfaceObject controlSurfaceObject, int n2, int n3) {
        super(controlSurfaceObject, "DrumPadBank-" + n2, n2, n3);
        if (n2 < 1) {
            throw new QWx("At least 1 track is required.");
        }
        this.mNumLanes = n2;
        this.mPads = new ArrayList(n2);
        this.mChannelScrollStepSize = 4;
        this.mHasMutedPads = new BooleanValueProxy((ControlSurfaceObject)this, false);
        this.mHasSoloedPads = new BooleanValueProxy((ControlSurfaceObject)this, false);
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = this.getKey() + "/Pad" + i2;
            DrumPadProxy drumPadProxy = new DrumPadProxy(this, string, i2, n3, true);
            this.mPads.add(drumPadProxy);
            this.addChild(drumPadProxy);
        }
        this.initChannelProxies();
    }

    @Override
    public Class getTargetType() {
        return Yaq.class;
    }

    protected mgC getDocumentFromTarget(Yaq yaq) {
        return yaq.tNn();
    }

    @Override
    public void setIndication(boolean bl2) {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.exec(() -> this.doSetIndication(bl2));
    }

    private void doSetIndication(boolean bl2) {
        assert (this.UB2(this.isDocumentThread()));
        for (ControlSurfaceProxy controlSurfaceProxy : this.mChannels) {
            DrumPadProxy drumPadProxy = (DrumPadProxy)controlSurfaceProxy;
            drumPadProxy.setIndicating(bl2);
        }
    }

    @Override
    protected int getScrollPositionThatPageShouldAlignTo() {
        return 36;
    }

    @Override
    protected DrumPadProxy createChannelProxy(int n2, int n3, String string) {
        return new DrumPadProxy(this, string + n3, n3, n2, true);
    }

    protected BankTarget createBankTarget(Yaq yaq, boolean bl2) {
        return BankTarget.create(yaq.Ivg());
    }

    protected void connectToTarget(Yaq yaq) {
        int n2 = Integer.MAX_VALUE;
        boolean bl2 = yaq.x3R() > 0;
        int n3 = this.mChannelBankUpdater.getScrollPositionValue();
        boolean bl3 = false;
        for (Af2 af2 : yaq.Kyj()) {
            assert (this.UB2(bl2));
            int n4 = af2.onT().lXt();
            n2 = Math.min(n4, n2);
            if (n4 < n3 || n4 > n3 + this.getSizeOfBank() - 1) continue;
            bl3 = true;
        }
        if (bl2) {
            if (!bl3) {
                this.mChannelBankUpdater.doScrollIntoView(n2);
            }
        } else {
            this.mChannelBankUpdater.doScrollTo(this.getScrollPositionThatPageShouldAlignTo(), true);
        }
        this.mHasMutedPads.setTarget(yaq.zvj());
        this.mHasSoloedPads.setTarget(yaq.GNE());
    }

    protected void disconnectFromTarget(Yaq yaq) {
        this.mHasMutedPads.clearTarget();
        this.mHasSoloedPads.clearTarget();
    }

    @Override
    public void clearMutedPads() {
        assert (this.Ivg(this.isControlSurfaceThread()));
        this.newSince(10);
        this.exec(this::doClearMute);
    }

    private void doClearMute() {
        assert (this.Ivg(this.isDocumentThread()));
        Yaq yaq = (Yaq)this.getTarget();
        if (yaq == null) {
            return;
        }
        yaq.sRo();
    }

    @Override
    public void clearSoloedPads() {
        assert (this.Ivg(this.isControlSurfaceThread()));
        this.newSince(10);
        this.exec(this::doClearSolo);
    }

    private void doClearSolo() {
        assert (this.Ivg(this.isDocumentThread()));
        Yaq yaq = (Yaq)this.getTarget();
        if (yaq == null) {
            return;
        }
        yaq.R3w();
    }

    @Override
    public BooleanValue hasMutedPads() {
        this.newSince(10);
        return this.mHasMutedPads;
    }

    @Override
    public BooleanValue hasSoloedPads() {
        this.newSince(10);
        return this.mHasSoloedPads;
    }
}

