/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.api.Arpeggiator;
import com.bitwig.extension.controller.api.NoteInput;
import com.bitwig.extension.controller.api.NoteInput$NoteExpression;
import com.bitwig.extension.controller.api.NoteLatch;
import com.bitwig.extension.controller.api.SettableBooleanValue;
import com.bitwig.flt.control_surface.proxy.ArpeggiatorProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject$AllowedCreationTime;
import com.bitwig.flt.control_surface.proxy.DirectNoteInput$1;
import com.bitwig.flt.control_surface.proxy.MIDIEventFilter;
import com.bitwig.flt.control_surface.proxy.NoteLatchProxy;
import com.bitwig.flt.control_surface.values.SettableBooleanValueProxy;
import com.bitwig.flt.document.core.iface.mgC;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DirectNoteInput
extends ControlSurfaceObject
implements SV,
NoteInput {
    private int mEngineNoteInputId;
    private boolean mShouldConsumeEvents;
    private final List mFilters;
    private final String mName;
    private final ArpeggiatorProxy mArpeggiatorProxy;
    private final NoteLatchProxy mNoteLatchProxy;
    private ovA mNoteSource;
    private final SettableBooleanValueProxy mIncludeInAllInputsProxy;
    private boolean mShouldIncludeInAllInputs;
    private byte[] mKeyTranslationTable;
    private byte[] mKeyTranslationTableOnEventThread;
    private QVu mNoteInputSettings;
    private QIj mNoteSettingsNoteInputListener;

    public DirectNoteInput(ControlSurfaceObject controlSurfaceObject, String string, String[] stringArray, boolean bl2) {
        super(controlSurfaceObject, ControlSurfaceObject$AllowedCreationTime.INIT);
        this.mName = string;
        try {
            this.mEngineNoteInputId = this.getMidiProviderConnection().Ivg(this.getControlSurface(), bl2);
        }
        catch (IOException iOException) {
            throw new t1i(this.getControlSurface(), "Could not create note input", iOException);
        }
        this.mShouldIncludeInAllInputs = bl2;
        this.mIncludeInAllInputsProxy = new DirectNoteInput$1(this, this, bl2);
        this.mNoteLatchProxy = new NoteLatchProxy(this);
        this.mArpeggiatorProxy = new ArpeggiatorProxy(this);
        this.mFilters = new ArrayList(stringArray.length);
        for (String string2 : stringArray) {
            try {
                MIDIEventFilter mIDIEventFilter = new MIDIEventFilter(string2);
                this.mFilters.add(mIDIEventFilter);
            }
            catch (QWx qWx) {
                bRL.ZAb.oHp("Could not parse note input mask", qWx);
            }
        }
        try {
            this.sendNoteInputMasks();
        }
        catch (IOException iOException) {
            throw new t1i(this.getControlSurface(), "Could not send note input masks", iOException);
        }
    }

    public int getEngineNoteInputId() {
        return this.mEngineNoteInputId;
    }

    public void destroy() {
        assert (this.UB2(this.isControlSurfaceThread()));
        try {
            assert (this.oHp(this.mEngineNoteInputId >= 0));
            this.getMidiProviderConnection().Ivg(this.mEngineNoteInputId);
            this.mEngineNoteInputId = -1;
        }
        catch (IOException iOException) {
            bRL.ZAb.OSp(iOException);
        }
    }

    private void sendNoteInputMasks() {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        int n2 = this.mFilters.size();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int n3 = 0;
        for (MIDIEventFilter mIDIEventFilter : this.mFilters) {
            nArray[n3] = mIDIEventFilter.getCheckMask();
            nArray2[n3] = mIDIEventFilter.getMatchMask();
            ++n3;
        }
        this.getMidiProviderConnection().Ivg(this.mEngineNoteInputId, nArray, nArray2);
    }

    private void sendKeyMap(byte[] byArray) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        assert (this.UB2(byArray.length == 128));
        this.getMidiProviderConnection().Ivg(this.mEngineNoteInputId, byArray);
    }

    private void sendVelocityMap(byte[] byArray) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        assert (this.UB2(byArray.length == 128));
        this.getMidiProviderConnection().OSp(this.mEngineNoteInputId, byArray);
    }

    private efB getMidiProviderConnection() {
        return this.getControlSurface().Vma();
    }

    public boolean shouldConsumeEvents() {
        return this.mShouldConsumeEvents;
    }

    @Override
    public void setShouldConsumeEvents(boolean bl2) {
        this.mShouldConsumeEvents = bl2;
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        try {
            this.getMidiProviderConnection().Ivg(this.mEngineNoteInputId, bl2);
        }
        catch (IOException iOException) {
            throw new t1i(this.getControlSurface(), (Throwable)iOException);
        }
    }

    private byte[] convertJavaScriptArrayToByteArray(Object[] objectArray) {
        byte[] byArray = new byte[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (!(objectArray[i2] instanceof Number)) {
                throw new QWx("Object in array not instance of Number");
            }
            Number number = (Number)objectArray[i2];
            if (number.intValue() < -128 || number.intValue() > 127) {
                throw new QWx("Value out of range");
            }
            byArray[i2] = number.byteValue();
        }
        return byArray;
    }

    @Override
    public void setKeyTranslationTable(Object[] objectArray) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        if (objectArray == null || objectArray.length != 128) {
            throw new QWx("Map must have a length of 128");
        }
        byte[] byArray = this.convertJavaScriptArrayToByteArray(objectArray);
        if (Arrays.equals(byArray, this.mKeyTranslationTable)) {
            return;
        }
        this.mKeyTranslationTable = byArray;
        this.exec(() -> this.setKeyTranslationTableOnDocumentThread(byArray));
        try {
            this.sendKeyMap(this.mKeyTranslationTable);
        }
        catch (IOException iOException) {
            throw new t1i(this.getControlSurface(), (Throwable)iOException);
        }
    }

    private void setKeyTranslationTableOnDocumentThread(byte[] byArray) {
        assert (this.UB2(this.isDocumentThread()));
        this.mKeyTranslationTableOnEventThread = byArray;
        this.getHost().getHardwareControllerProxy().ZAb();
    }

    @Override
    public void setVelocityTranslationTable(Object[] objectArray) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        if (objectArray == null || objectArray.length != 128) {
            throw new QWx("Map must have a length of 128");
        }
        try {
            this.sendVelocityMap(this.convertJavaScriptArrayToByteArray(objectArray));
        }
        catch (IOException iOException) {
            throw new t1i(this.getControlSurface(), (Throwable)iOException);
        }
    }

    @Override
    public void assignPolyphonicAftertouchToExpression(int n2, NoteInput$NoteExpression noteInput$NoteExpression, int n3) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        try {
            this.getMidiProviderConnection().Ivg(this.mEngineNoteInputId, n2, noteInput$NoteExpression, n3);
        }
        catch (IOException iOException) {
            throw new t1i(this.getControlSurface(), (Throwable)iOException);
        }
    }

    @Override
    public void setUseExpressiveMidi(boolean bl2, int n2, int n3) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        if (n2 != 0 && n2 != 15) {
            throw new QWx("baseChannel must be either 0 or 15");
        }
        if (n3 < 0 || n3 > 96) {
            throw new QWx("pitchBendRange must be between 0 or 96");
        }
        try {
            this.getMidiProviderConnection().Ivg(this.mEngineNoteInputId, bl2, n2, n3);
        }
        catch (IOException iOException) {
            throw new t1i(this.getControlSurface(), (Throwable)iOException);
        }
    }

    @Override
    public void setUseMultidimensionalPolyphonicExpression(boolean bl2, int n2) {
        this.deprecated(1, 2);
        this.setUseExpressiveMidi(bl2, n2, 48);
    }

    @Override
    public void sendRawMidiEvent(int n2, int n3, int n4) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        if (n2 < 128 || n2 > 255) {
            throw new QWx("Status byte out of range");
        }
        if (n3 < 0 || n3 > 127) {
            throw new QWx("data0 byte out of range");
        }
        if (n4 < 0 || n4 > 127) {
            throw new QWx("data1 byte out of range");
        }
        try {
            this.getMidiProviderConnection().Ivg(this.mEngineNoteInputId, n2, n3, n4);
        }
        catch (IOException iOException) {
            throw new t1i(this.getControlSurface(), (Throwable)iOException);
        }
    }

    @Override
    public NoteLatch noteLatch() {
        this.newSince(10);
        return this.mNoteLatchProxy;
    }

    public boolean isMatchAll() {
        for (MIDIEventFilter mIDIEventFilter : this.mFilters) {
            if (!mIDIEventFilter.isMatchAll()) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.mName;
    }

    @Override
    public Arpeggiator arpeggiator() {
        this.newSince(10);
        return this.mArpeggiatorProxy;
    }

    public void connectToDocument(mgC mgC2) {
        assert (this.UB2(this.mNoteSource == null));
        assert (this.UB2(!mgC2.Kyj()));
        this.mNoteSource = mgC2.Ivg(this.mEngineNoteInputId);
        this.mNoteSource.Ivg(this.mShouldIncludeInAllInputs);
        this.mIncludeInAllInputsProxy.setTarget(this.mNoteSource.lXt());
        this.mNoteLatchProxy.setTarget(this.mNoteSource.UB2());
        this.mArpeggiatorProxy.setTarget(this.mNoteSource.ZAb());
    }

    public void disconnectFromDocument() {
        assert (this.UB2(this.mNoteSource != null));
        this.mNoteLatchProxy.clearTarget();
        this.mArpeggiatorProxy.clearTarget();
        this.mIncludeInAllInputsProxy.clearTarget();
        this.mNoteSource = null;
    }

    ovA getNoteSource() {
        return this.mNoteSource;
    }

    @Override
    public SettableBooleanValue includeInAllInputs() {
        this.newSince(10);
        return this.mIncludeInAllInputsProxy;
    }

    public boolean shouldProcessEvent(uPE uPE2) {
        for (MIDIEventFilter mIDIEventFilter : this.mFilters) {
            if (!mIDIEventFilter.matches(uPE2)) continue;
            return true;
        }
        return false;
    }

    public uPE getTransformedEvent(uPE uPE2) {
        assert (this.UB2(this.isControlSurfaceThread()));
        assert (this.UB2(this.shouldProcessEvent(uPE2)));
        return this.getTransformedEvent(uPE2, this.mKeyTranslationTable);
    }

    public boolean checkIfEventIsNoteInputOnDocumentThread(uPE uPE2) {
        assert (this.UB2(this.isDocumentThread()));
        if (!this.shouldProcessEvent(uPE2)) {
            return false;
        }
        return this.getTransformedEvent(uPE2, this.mKeyTranslationTableOnEventThread) != null;
    }

    public uPE getTransformedEvent(uPE uPE2, byte[] byArray) {
        assert (this.UB2(this.shouldProcessEvent(uPE2)));
        if (uPE2.oHp()) {
            int n2 = uPE2.ZAb();
            if (byArray != null) {
                if ((n2 = byArray[n2]) == -1) {
                    return null;
                }
                return new uPE(uPE2.fjZ(), n2, uPE2.GXr());
            }
        }
        return uPE2;
    }

    public void connectToNoteInputSettings(QVu qVu) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(this.mNoteInputSettings == null));
        this.mNoteInputSettings = qVu;
        this.mNoteSettingsNoteInputListener = tEA2 -> {
            int n2 = tEA2.oHp();
            int n3 = tEA2.UB2();
            int n4 = tEA2.ZAb();
            this.sendRawMidiEvent(n2, n3, n4);
        };
        qVu.oHp(this.mNoteSettingsNoteInputListener);
    }

    public void disconnectFromNoteInputSettings() {
        assert (this.UB2(this.isDocumentThread()));
        if (this.mNoteInputSettings != null) {
            this.mNoteInputSettings.UB2(this.mNoteSettingsNoteInputListener);
            this.mNoteInputSettings = null;
            this.mNoteSettingsNoteInputListener = null;
        }
    }
}

