/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.Device;
import com.bitwig.extension.controller.api.DeviceBank;
import com.bitwig.extension.controller.api.DeviceChain;
import com.bitwig.extension.controller.api.DeviceMatcher;
import com.bitwig.extension.controller.api.HardwareActionBindable;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.SettableIntegerValue;
import com.bitwig.flt.app.jrf;
import com.bitwig.flt.control_surface.proxy.AbstractDeviceMatcher;
import com.bitwig.flt.control_surface.proxy.ActiveDeviceMatcher;
import com.bitwig.flt.control_surface.proxy.AndDeviceMatcher;
import com.bitwig.flt.control_surface.proxy.BankItemTargetUpdater;
import com.bitwig.flt.control_surface.proxy.BankTarget;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentObjectProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.DeviceChainProxy;
import com.bitwig.flt.control_surface.proxy.DeviceProxy;
import com.bitwig.flt.control_surface.proxy.GUIFollowableBank;
import com.bitwig.flt.control_surface.proxy.MatchingPlaybackDevicesBankTarget;
import com.bitwig.flt.document.core.iface.mgC;
import java.util.Objects;

public class DeviceBankProxy
extends ControlSurfaceDocumentObjectProxy
implements DeviceBank,
GUIFollowableBank,
rOd {
    private final int mNumDevices;
    private final DeviceProxy[] mDeviceProxies;
    private final BankItemTargetUpdater mDeviceBankUpdater;
    private final DeviceChain mDeviceChainSection;
    private boolean mSkipDisabledItems = false;
    private AbstractDeviceMatcher mDeviceMatcher;

    protected DeviceBankProxy(DeviceChainProxy deviceChainProxy, int n2, int n3) {
        super(deviceChainProxy);
        this.setKey("Device Chain");
        if (n2 < 1) {
            throw new QWx("At least 1 device is required.");
        }
        this.mDeviceChainSection = deviceChainProxy;
        this.mNumDevices = n2;
        this.mDeviceProxies = new DeviceProxy[n2];
        for (int i2 = 0; i2 < this.mNumDevices; ++i2) {
            this.mDeviceProxies[i2] = new DeviceProxy(this, this.getKey() + " / Device " + i2, n3, deviceChainProxy);
        }
        this.mDeviceBankUpdater = new BankItemTargetUpdater((ControlSurfaceObject)this, this.mDeviceProxies);
    }

    @Override
    public DeviceChainProxy getParent() {
        return (DeviceChainProxy)super.getParent();
    }

    @Override
    public void followInGUI(boolean bl2) {
        assert (this.UB2(this.isDocumentThread()));
        Se se2 = jrf.NhN().Fy();
        assert (this.UB2(se2 != null));
        if (se2 == null) {
            return;
        }
        se2.oHp(this.mDeviceBankUpdater, bl2);
    }

    @Override
    public Class getTargetType() {
        return z.class;
    }

    protected mgC getDocumentFromTarget(z z2) {
        return z2.tNn();
    }

    @Override
    public DeviceChain getDeviceChain() {
        return this.mDeviceChainSection;
    }

    @Override
    public IntegerValue itemCount() {
        return this.mDeviceBankUpdater.getListItemCount();
    }

    @Override
    public SettableIntegerValue cursorIndex() {
        return this.mDeviceBankUpdater.getCursorIndex();
    }

    @Override
    public void setSkipDisabledItems(boolean bl2) {
        this.newSince(11);
        this.exec(() -> this.doSetSkipDisabledItems(bl2));
    }

    private void doSetSkipDisabledItems(boolean bl2) {
        assert (this.UB2(this.isDocumentThread()));
        if (this.mSkipDisabledItems != bl2) {
            this.mSkipDisabledItems = bl2;
            this.updateBankTarget();
        }
    }

    private void updateBankTarget() {
        assert (this.UB2(this.isDocumentThread()));
        z z2 = (z)this.getTarget();
        if (z2 != null) {
            this.mDeviceBankUpdater.setTarget(this.createBankTarget(z2));
        }
    }

    private BankTarget createBankTarget(z z2) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(z2 != null));
        AbstractDeviceMatcher abstractDeviceMatcher = this.getEffectiveDeviceMatcher();
        return abstractDeviceMatcher != null ? new MatchingPlaybackDevicesBankTarget(z2, abstractDeviceMatcher) : BankTarget.create(z2.zoh());
    }

    private AbstractDeviceMatcher getEffectiveDeviceMatcher() {
        assert (this.UB2(this.isDocumentThread()));
        if (this.mSkipDisabledItems) {
            if (this.mDeviceMatcher == null) {
                return new ActiveDeviceMatcher();
            }
            return new AndDeviceMatcher(new AbstractDeviceMatcher[]{new ActiveDeviceMatcher(), this.mDeviceMatcher});
        }
        return this.mDeviceMatcher;
    }

    @Override
    public BooleanValue canScrollBackwards() {
        return this.mDeviceBankUpdater.getCanScrollBackwards();
    }

    @Override
    public BooleanValue canScrollForwards() {
        return this.mDeviceBankUpdater.getCanScrollForwards();
    }

    @Override
    public int getSizeOfBank() {
        return this.mDeviceBankUpdater.getSizeOfBank();
    }

    @Override
    public void setSizeOfBank(int n2) {
        this.mDeviceBankUpdater.setSizeOfBank(n2);
    }

    @Override
    public int getCapacityOfBank() {
        return this.mDeviceBankUpdater.getCapacityOfBank();
    }

    @Override
    public Device getItemAt(int n2) {
        return (Device)((Object)this.mDeviceBankUpdater.getItemAt(n2));
    }

    @Override
    public SettableIntegerValue scrollPosition() {
        return this.mDeviceBankUpdater.getScrollPosition();
    }

    @Override
    public void scrollIntoView(int n2) {
        this.newSince(7);
        this.mDeviceBankUpdater.scrollIntoView(n2);
    }

    @Override
    public void scrollBy(int n2) {
        this.mDeviceBankUpdater.scrollBy(n2);
    }

    @Override
    public void doStepForwards() {
        this.mDeviceBankUpdater.doScrollForwards();
    }

    @Override
    public void doStepBackwards() {
        this.mDeviceBankUpdater.doScrollBackwards();
    }

    @Override
    public void scrollByPages(int n2) {
        this.mDeviceBankUpdater.scrollByPages(n2);
    }

    public void navigateToDeviceLayer(int n2, int n3) {
        this.validIndex(this.mDeviceProxies, n2);
        if (n3 < 0) {
            throw new QWx("layerIndex must be >= 0");
        }
        this.exec(() -> {
            FZw fZw;
            ERX eRX;
            BaM baM2;
            DeviceProxy deviceProxy = this.mDeviceProxies[n2];
            lMi lMi2 = deviceProxy.getDevice();
            if (lMi2 instanceof AyX && (baM2 = (eRX = (ERX)lMi2.dJJ()).onT()) instanceof FZw && n3 < (fZw = (FZw)baM2).x3R()) {
                Af2 af2 = fZw.OSp(n3);
                this.setTarget(af2.tGb());
            }
        });
    }

    public void navigateToKeyPad(int n2, int n3) {
        this.validIndex(this.mDeviceProxies, n2);
        if (n3 < 0 || n3 > 127) {
            throw new QWx("Invalid key");
        }
        this.exec(() -> {
            Yaq yaq;
            UFL uFL;
            Af2 af2;
            ERX eRX;
            BaM baM2;
            DeviceProxy deviceProxy = this.mDeviceProxies[n2];
            lMi lMi2 = deviceProxy.getDevice();
            if (lMi2 instanceof AyX && (baM2 = (eRX = (ERX)lMi2.dJJ()).onT()) instanceof Yaq && (af2 = (uFL = (yaq = (Yaq)baM2).Ivg(n3)).UB2()) != null) {
                this.setTarget(af2.tGb());
            }
        });
    }

    public void navigateToDeviceSlot(int n2, String string) {
        this.validIndex(this.mDeviceProxies, n2);
        this.notNull(string, "chain");
        this.exec(() -> {
            DeviceProxy deviceProxy = this.mDeviceProxies[n2];
            lMi lMi2 = deviceProxy.getDevice();
            if (lMi2 instanceof AyX) {
                ERX eRX = (ERX)lMi2.dJJ();
                for (ECV eCV : eRX.tGb()) {
                    Yax yax;
                    if (!(eCV instanceof Yax) || !(yax = (Yax)eCV).Ivg().equals(string)) continue;
                    this.setTarget(yax.onT().tGb());
                    return;
                }
            }
        });
    }

    @Override
    public void scrollPageUp() {
        this.mDeviceBankUpdater.scrollByPages(-1);
    }

    @Override
    public void scrollPageDown() {
        this.mDeviceBankUpdater.scrollByPages(1);
    }

    @Override
    public void scrollUp() {
        this.mDeviceBankUpdater.scrollBy(-1);
    }

    @Override
    public void scrollDown() {
        this.mDeviceBankUpdater.scrollBy(1);
    }

    @Override
    public void scrollTo(int n2) {
        this.mDeviceBankUpdater.scrollIntoView(n2);
    }

    @Override
    public Device getDevice(int n2) {
        return (Device)((Object)this.mDeviceBankUpdater.getItemAt(n2));
    }

    protected void connectToTarget(z z2) {
        assert (this.Ivg(this.isDocumentThread()));
        assert (this.ZAb(z2 != null));
        this.mDeviceBankUpdater.setTarget(this.createBankTarget(z2));
        this.connectObservers(z2);
    }

    protected void disconnectFromTarget(z z2) {
        assert (this.Ivg(this.isDocumentThread()));
        this.mDeviceBankUpdater.clearTarget();
    }

    @Override
    public void addScrollPositionObserver(IntegerValueChangedCallback integerValueChangedCallback, int n2) {
        this.deprecated(1, 2, "Use scrollPosition() instead");
        this.mDeviceBankUpdater.getScrollPosition().addValueObserver(integerValueChangedCallback, n2);
    }

    @Override
    public void addCanScrollUpObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollBackwards() instead");
        this.mDeviceBankUpdater.getCanScrollBackwards().addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void addCanScrollDownObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollForwards() instead");
        this.mDeviceBankUpdater.getCanScrollForwards().addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void addDeviceCountObserver(IntegerValueChangedCallback integerValueChangedCallback) {
        this.deprecated(1, 2, "Use itemCount().addValueObserver(callback)");
        this.mDeviceBankUpdater.getListItemCount().addValueObserver(integerValueChangedCallback);
    }

    @Override
    public HardwareActionBindable scrollBackwardsAction() {
        return this.mDeviceBankUpdater.scrollBackwardsAction();
    }

    @Override
    public HardwareActionBindable scrollForwardsAction() {
        return this.mDeviceBankUpdater.scrollForwardsAction();
    }

    @Override
    public HardwareActionBindable scrollPageBackwardsAction() {
        return this.mDeviceBankUpdater.scrollPageBackwardsAction();
    }

    @Override
    public HardwareActionBindable scrollPageForwardsAction() {
        return this.mDeviceBankUpdater.scrollPageForwardsAction();
    }

    @Override
    public void browseToInsertDevice(int n2) {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.inRange(n2, 0, this.getSizeOfBank(), "index");
        this.exec(() -> this.doBrowseToInsertDevice(n2));
    }

    private void doBrowseToInsertDevice(int n2) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(n2 >= 0 && n2 <= this.getSizeOfBank()));
        z z2 = (z)this.getTarget();
        if (z2 != null) {
            int n3 = Syh.Ivg(this.mDeviceBankUpdater.getScrollPositionValue() + n2, 0, z2.Sl());
            if (n3 > 0) {
                lMi lMi2 = z2.OSp(n3 - 1);
                ams.Ivg(null, new amn(lMi2));
            } else {
                ams.Ivg(null, new amp(z2));
            }
        }
    }

    @Override
    public void setDeviceMatcher(DeviceMatcher deviceMatcher) {
        this.newSince(12);
        AbstractDeviceMatcher abstractDeviceMatcher = AbstractDeviceMatcher.get(deviceMatcher);
        if (this.isInitializingDriver()) {
            this.mDeviceMatcher = abstractDeviceMatcher;
        } else {
            this.exec(() -> this.doSetDeviceMatcher(abstractDeviceMatcher));
        }
    }

    private void doSetDeviceMatcher(AbstractDeviceMatcher abstractDeviceMatcher) {
        assert (this.UB2(this.isDocumentThread()));
        if (!Objects.equals(abstractDeviceMatcher, this.mDeviceMatcher)) {
            this.mDeviceMatcher = abstractDeviceMatcher;
            this.updateBankTarget();
        }
    }
}

