/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.Channel;
import com.bitwig.extension.controller.api.CursorDeviceFollowMode;
import com.bitwig.extension.controller.api.CursorNavigationMode;
import com.bitwig.extension.controller.api.CursorRemoteControlsPage;
import com.bitwig.extension.controller.api.CursorTrack;
import com.bitwig.extension.controller.api.Device;
import com.bitwig.extension.controller.api.HardwareActionBindable;
import com.bitwig.extension.controller.api.PinnableCursorClip;
import com.bitwig.extension.controller.api.PinnableCursorDevice;
import com.bitwig.extension.controller.api.RelativeHardwareControl;
import com.bitwig.extension.controller.api.RelativeHardwareControlBinding;
import com.bitwig.extension.controller.api.SettableBooleanValue;
import com.bitwig.extension.controller.api.TrackBank;
import com.bitwig.flt.control_surface.proxy.ClipLauncherControllerFeedbackFrame;
import com.bitwig.flt.control_surface.proxy.ClipProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceRemoteControlsCursorProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceTrackCursorProxy;
import com.bitwig.flt.control_surface.proxy.CursorTrackCursorClipProxy;
import com.bitwig.flt.control_surface.proxy.CursorTrackCursorDeviceProxy;
import com.bitwig.flt.control_surface.proxy.CursorTrackProxy$RemoteControlProxiesEntry;
import com.bitwig.flt.control_surface.proxy.DelegatingControlSurfaceObjectProxy;
import com.bitwig.flt.control_surface.proxy.DelegatingTrackProxy;
import com.bitwig.flt.control_surface.proxy.MainDeviceCursorRemoteControlsPageProxy;
import com.bitwig.flt.control_surface.proxy.PinnableCursorImpl;
import com.bitwig.flt.control_surface.proxy.TrackProxy;
import com.bitwig.flt.document.core.iface.PhH;
import com.bitwig.flt.document.core.iface.mgC;
import java.util.ArrayList;
import java.util.List;

public class CursorTrackProxy
extends DelegatingTrackProxy
implements CursorTrack,
ClipLauncherControllerFeedbackFrame,
PinnableCursorImpl {
    private static final String DEFAULT_CURSOR_DEVICE_ID = "DeviceSelection";
    private static final String DEFAULT_CURSOR_DEVICE_NAME = "Main Device";
    private static final String DEFAULT_LAUNCHER_CURSOR_CLIP_ID = "LauncherClip";
    private static final String DEFAULT_LAUNCHER_CURSOR_CLIP_NAME = "Launcher Clip";
    private final String mCursorId;
    private final String mName;
    private final int mNumSends;
    private final int mNumScenes;
    private final boolean mShouldFollowSelection;
    private final ControlSurfaceTrackCursorProxy mCursorProxy;
    private final List mCursorDevices = new ArrayList(2);
    private final List mCursorClips = new ArrayList(2);
    private PinnableCursorDevice mPrimaryDevice;
    private int mShouldShowClipLauncherFeedbackLevel = 0;
    private List mRemoteControlsCursorProxies = new ArrayList();

    protected CursorTrackProxy(ControlSurfaceObject controlSurfaceObject, String string, String string2, int n2, int n3, boolean bl2) {
        super(controlSurfaceObject, new TrackProxy(controlSurfaceObject, string, -1, n2, n3));
        this.mCursorId = string;
        this.mName = string2;
        this.mNumSends = n2;
        this.mNumScenes = n3;
        this.mShouldFollowSelection = bl2;
        this.mCursorProxy = new ControlSurfaceTrackCursorProxy((ControlSurfaceObject)this, string, string2, this.getDelegateProxy());
        if (n3 > 0) {
            this.getControlSurface().oCu();
        }
    }

    @Override
    public String getCursorId() {
        return this.mCursorId;
    }

    public int getNumSends() {
        return this.mNumSends;
    }

    public int getNumScenes() {
        return this.mNumScenes;
    }

    @Override
    public TrackProxy getDelegateProxy() {
        return (TrackProxy)super.getDelegateProxy();
    }

    public ControlSurfaceTrackCursorProxy getCursorProxy() {
        return this.mCursorProxy;
    }

    @Override
    public Class getTargetType() {
        return mgC.class;
    }

    @Override
    public RelativeHardwareControlBinding addBindingWithSensitivity(RelativeHardwareControl relativeHardwareControl, double d2) {
        return this.mCursorProxy.addBindingWithSensitivity(relativeHardwareControl, d2);
    }

    @Override
    public HardwareActionBindable selectNextAction() {
        return this.mCursorProxy.selectNextAction();
    }

    @Override
    public HardwareActionBindable selectPreviousAction() {
        return this.mCursorProxy.selectPreviousAction();
    }

    @Override
    public SettableBooleanValue isPinned() {
        return this.mCursorProxy.isPinned();
    }

    @Override
    public void selectPrevious() {
        this.mCursorProxy.selectPrevious();
    }

    @Override
    public void selectNext() {
        this.mCursorProxy.selectNext();
    }

    @Override
    public void selectFirst() {
        this.mCursorProxy.selectFirst();
    }

    @Override
    public void selectLast() {
        this.mCursorProxy.selectLast();
    }

    @Override
    public BooleanValue hasNext() {
        return this.mCursorProxy.hasNext();
    }

    @Override
    public BooleanValue hasPrevious() {
        return this.mCursorProxy.hasPrevious();
    }

    @Override
    public void addCanSelectPreviousObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.mCursorProxy.addCanSelectPreviousObserver(booleanValueChangedCallback);
    }

    @Override
    public void addCanSelectNextObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.mCursorProxy.addCanSelectNextObserver(booleanValueChangedCallback);
    }

    @Override
    public void selectChannel(Channel channel) {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.notNull(channel, "channel");
        assert (this.UB2(channel instanceof ControlSurfaceProxy));
        this.exec(() -> this.doSelect(channel));
    }

    private void doSelect(Channel channel) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(channel != null));
        assert (this.UB2(channel instanceof ControlSurfaceProxy));
        PhH phH = (PhH)((ControlSurfaceProxy)((Object)channel)).getTargetOfType(PhH.class);
        if (phH != null) {
            this.mCursorProxy.doSelect(phH);
        }
    }

    @Override
    public void selectParent() {
        this.mCursorProxy.selectParent();
    }

    @Override
    public void selectFirstChild() {
        this.mCursorProxy.selectFirstChild();
    }

    @Override
    public void setCursorNavigationMode(CursorNavigationMode cursorNavigationMode) {
        this.deprecated(1, 2, "Make a TrackBank follow this cursor instead");
    }

    protected void connectToTarget(mgC mgC2) {
        zqp zqp2 = this.getControlSurfaceState();
        mjo mjo2 = zqp2.Ivg(this.mCursorId, this.mName, this.mShouldFollowSelection);
        assert (this.UB2(mjo2 != null));
        this.mCursorProxy.setTarget(mjo2);
        for (Object object : this.mRemoteControlsCursorProxies) {
            ControlSurfaceRemoteControlsCursorProxy controlSurfaceRemoteControlsCursorProxy = ((CursorTrackProxy$RemoteControlProxiesEntry)object).cursorProxy;
            Ith ith = ((CursorTrackProxy$RemoteControlProxiesEntry)object).followMode;
            String string = controlSurfaceRemoteControlsCursorProxy.getCursorId();
            String string2 = controlSurfaceRemoteControlsCursorProxy.getName();
            uys uys2 = mjo2.Ivg(string, string2, ith);
            assert (this.lXt(uys2 != null));
            controlSurfaceRemoteControlsCursorProxy.setTarget(uys2);
        }
        for (Object object : this.mCursorDevices) {
            ((ControlSurfaceProxy)object).setTarget(mjo2);
        }
        for (Object object : this.mCursorClips) {
            ((ControlSurfaceProxy)object).setTarget(mjo2);
        }
    }

    protected void disconnectFromTarget(mgC mgC2) {
        this.mCursorProxy.clearTarget();
        for (DelegatingControlSurfaceObjectProxy delegatingControlSurfaceObjectProxy : this.mCursorDevices) {
            delegatingControlSurfaceObjectProxy.clearTarget();
        }
        for (DelegatingControlSurfaceObjectProxy delegatingControlSurfaceObjectProxy : this.mCursorClips) {
            delegatingControlSurfaceObjectProxy.clearTarget();
        }
    }

    private void oldCursorDeviceAPIUsed() {
        this.checkIsInitializingDriver();
        this.deprecated(1, 2, "Use createCursorDevice and specify follow mode instead");
    }

    @Override
    public Device getPrimaryDevice() {
        if (this.mPrimaryDevice == null) {
            this.oldCursorDeviceAPIUsed();
            this.mPrimaryDevice = this.createCursorDevice(this.mCursorId + " / Primary Device", "Primary Device", this.getDelegateProxy().getNumSends(), CursorDeviceFollowMode.FIRST_INSTRUMENT_OR_DEVICE);
        }
        return this.mPrimaryDevice;
    }

    @Override
    public Device getPrimaryInstrument() {
        return this.getPrimaryDevice();
    }

    @Override
    public PinnableCursorDevice createCursorDevice() {
        return this.createCursorDevice(DEFAULT_CURSOR_DEVICE_ID, DEFAULT_CURSOR_DEVICE_NAME, this.getNumSends(), CursorDeviceFollowMode.FOLLOW_SELECTION);
    }

    @Override
    public PinnableCursorDevice createCursorDevice(String string) {
        return this.createCursorDevice(string, this.getNumSends());
    }

    @Override
    public PinnableCursorDevice createCursorDevice(String string, int n2) {
        this.oldCursorDeviceAPIUsed();
        String string2 = string;
        CursorDeviceFollowMode cursorDeviceFollowMode = CursorDeviceFollowMode.FIRST_INSTRUMENT_OR_DEVICE;
        if (string == null || string.isEmpty()) {
            string = DEFAULT_CURSOR_DEVICE_ID;
            string2 = DEFAULT_CURSOR_DEVICE_NAME;
            cursorDeviceFollowMode = CursorDeviceFollowMode.FOLLOW_SELECTION;
        }
        return this.createCursorDevice(string, string2, n2, cursorDeviceFollowMode);
    }

    @Override
    public PinnableCursorDevice createCursorDevice(String string, String string2, int n2, CursorDeviceFollowMode cursorDeviceFollowMode) {
        this.checkIsInitializingDriver();
        this.notEmpty(string, "id");
        this.notNull(string2, "name");
        this.atLeast(n2, 0, "numSends");
        this.notNull((Object)cursorDeviceFollowMode, "followMode");
        for (CursorTrackCursorDeviceProxy cursorTrackCursorDeviceProxy : this.mCursorDevices) {
            if (!cursorTrackCursorDeviceProxy.getCursorId().equals(string2)) continue;
            if (cursorTrackCursorDeviceProxy.getNumSends() == n2) {
                return cursorTrackCursorDeviceProxy;
            }
            this.deprecated(1, 2, "CursorDevice already created with id " + string + " but with " + cursorTrackCursorDeviceProxy.getNumSends() + " sends and now " + n2 + " sends were requested");
        }
        CursorTrackCursorDeviceProxy cursorTrackCursorDeviceProxy = CursorTrackCursorDeviceProxy.create(this, string, string2, n2, cursorDeviceFollowMode);
        this.mCursorDevices.add(cursorTrackCursorDeviceProxy);
        return cursorTrackCursorDeviceProxy;
    }

    @Override
    public PinnableCursorClip createLauncherCursorClip(int n2, int n3) {
        return this.createLauncherCursorClip(DEFAULT_LAUNCHER_CURSOR_CLIP_ID, DEFAULT_LAUNCHER_CURSOR_CLIP_NAME, n2, n3);
    }

    @Override
    public PinnableCursorClip createLauncherCursorClip(String string, String string2, int n2, int n3) {
        this.checkIsInitializingDriver();
        this.newSince(10);
        this.notEmpty(string, "id");
        this.notNull(string2, "name");
        for (CursorTrackCursorClipProxy cursorTrackCursorClipProxy : this.mCursorClips) {
            if (!cursorTrackCursorClipProxy.getCursorId().equals(string2)) continue;
            ClipProxy clipProxy = cursorTrackCursorClipProxy.getDelegateProxy();
            if (clipProxy.getGridWidth() != n2 || clipProxy.getGridHeight() != n3) {
                throw new QWx("Cursor clip already created with id " + string + " and different size");
            }
            return cursorTrackCursorClipProxy;
        }
        CursorTrackCursorClipProxy cursorTrackCursorClipProxy = new CursorTrackCursorClipProxy(this, string, string2, n2, n3);
        this.mCursorClips.add(cursorTrackCursorClipProxy);
        return cursorTrackCursorClipProxy;
    }

    public CursorRemoteControlsPage createCursorRemoteControlsPage(int n2, Ith ith) {
        this.checkIsInitializingDriver();
        assert (this.lXt(this.isControlSurfaceThread()));
        assert (this.lXt(this.isInitializingDriver()));
        if (this.mRemoteControlsCursorProxies.size() > 0) {
            throw new QWx("Can only create one set of main remote controls that follow the selection");
        }
        MainDeviceCursorRemoteControlsPageProxy mainDeviceCursorRemoteControlsPageProxy = new MainDeviceCursorRemoteControlsPageProxy(this, this.getKey() + "/RemoteControls/Parameter", n2);
        ControlSurfaceRemoteControlsCursorProxy controlSurfaceRemoteControlsCursorProxy = new ControlSurfaceRemoteControlsCursorProxy((ControlSurfaceObject)this, this.mCursorId, this.mName, mainDeviceCursorRemoteControlsPageProxy);
        this.mRemoteControlsCursorProxies.add(new CursorTrackProxy$RemoteControlProxiesEntry(controlSurfaceRemoteControlsCursorProxy, mainDeviceCursorRemoteControlsPageProxy, ith));
        return mainDeviceCursorRemoteControlsPageProxy;
    }

    @Override
    public CursorRemoteControlsPage createCursorRemoteControlsPage(int n2) {
        return this.createCursorRemoteControlsPage(n2, Ith.Ivg);
    }

    @Override
    public TrackBank createSiblingsTrackBank(int n2, int n3, int n4, boolean bl2, boolean bl3) {
        TrackBank trackBank = super.createSiblingsTrackBank(n2, n3, n4, bl2, bl3);
        trackBank.followCursorTrack(this);
        return trackBank;
    }

    @Override
    public int getTrackOrTrackGroupCount() {
        return 1;
    }

    @Override
    public TrackProxy getTrackProxyAt(int n2) {
        assert (this.UB2(n2 == 0));
        return this.getDelegateProxy();
    }

    @Override
    public PhH getTrackOrTrackGroupAt(int n2) {
        assert (this.UB2(n2 == 0));
        return (PhH)this.getDelegateProxy().getTarget();
    }

    @Override
    public int getSlotOrSceneCount() {
        return this.mNumScenes;
    }

    @Override
    public ControlSurfaceProxy getSlotProxy(int n2, int n3) {
        assert (this.UB2(n2 == 0));
        return (ControlSurfaceProxy)((Object)this.clipLauncherSlotBank().getItemAt(n3));
    }

    @Override
    public void beginShouldShowClipLauncherFeedback() {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(this.mShouldShowClipLauncherFeedbackLevel >= 0));
        ++this.mShouldShowClipLauncherFeedbackLevel;
        if (this.mShouldShowClipLauncherFeedbackLevel == 1) {
            this.getControlSurface().Ivg(this);
        }
    }

    @Override
    public void endShouldShowClipLauncherFeedback() {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(this.mShouldShowClipLauncherFeedbackLevel > 0));
        --this.mShouldShowClipLauncherFeedbackLevel;
        if (this.mShouldShowClipLauncherFeedbackLevel == 0) {
            this.getControlSurface().OSp(this);
        }
    }
}

