/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.base.sound.rAn;
import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.callback.Callback;
import com.bitwig.extension.callback.ColorValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.callback.NoteStepChangedCallback;
import com.bitwig.extension.callback.StepDataChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.Clip;
import com.bitwig.extension.controller.api.ClipLauncherSlot;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.NoteOccurrence;
import com.bitwig.extension.controller.api.SettableBeatTimeValue;
import com.bitwig.extension.controller.api.SettableBooleanValue;
import com.bitwig.extension.controller.api.SettableColorValue;
import com.bitwig.extension.controller.api.SettableEnumValue;
import com.bitwig.extension.controller.api.SettableRangedValue;
import com.bitwig.extension.controller.api.Track;
import com.bitwig.flt.app.jrf;
import com.bitwig.flt.control_surface.proxy.ClipLauncherSlotBankProxy;
import com.bitwig.flt.control_surface.proxy.ClipLauncherSlotProxy;
import com.bitwig.flt.control_surface.proxy.ClipProxy$1;
import com.bitwig.flt.control_surface.proxy.ClipProxy$InstrumentClipListener;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentObjectProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.NoteStep;
import com.bitwig.flt.control_surface.proxy.TrackProxy;
import com.bitwig.flt.control_surface.values.AbsBeatTimeProxy;
import com.bitwig.flt.control_surface.values.BeatTimeProxy;
import com.bitwig.flt.control_surface.values.ComputedBooleanValue;
import com.bitwig.flt.control_surface.values.ComputedIntegerValue;
import com.bitwig.flt.control_surface.values.RangedValueProxy;
import com.bitwig.flt.control_surface.values.RelativeBeatTimeProxy;
import com.bitwig.flt.control_surface.values.SettableBooleanValueProxy;
import com.bitwig.flt.control_surface.values.SettableColorValueProxy;
import com.bitwig.flt.control_surface.values.SettableEnumAttributeProxy;
import com.bitwig.flt.document.core.iface.mgC;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TimerTask;
import java.util.function.Consumer;

public class ClipProxy
extends ControlSurfaceDocumentObjectProxy
implements Clip {
    private static final boolean ENABLE_EARLY_LOCAL_CACHE_UPDATE = false;
    private ClipProxy$InstrumentClipListener mInstrumentClipListener;
    private final jeN mSelectionChangeListener = new ClipProxy$1(this);
    private Khc mStepGrid;
    private final int mGridHeight;
    private final int mGridWidth;
    private final HashMap mNoteStepsDocumentThread = new HashMap();
    private final HashMap mNoteStepsControllerThread = new HashMap();
    private int mBaseKey = 0;
    private int mBaseStep;
    private int mLastPlaybackStep = -1;
    private double mStepSize = 0.25;
    private final ComputedBooleanValue mCanScrollKeysUp;
    private final ComputedBooleanValue mCanScrollKeysDown;
    private final ComputedBooleanValue mCanScrollStepsBackwards;
    private final ComputedBooleanValue mCanScrollStepsForwards;
    private final SettableBooleanValueProxy mShuffle;
    private final RangedValueProxy mAccent;
    private final SettableBooleanValueProxy mIsLoopEnabled;
    private final BeatTimeProxy mPlayStart;
    private final BeatTimeProxy mPlayStop;
    private final BeatTimeProxy mLoopStart;
    private final BeatTimeProxy mLoopLength;
    private boolean mHasInvalidatedGrid = false;
    private final TrackProxy mTrackProxy;
    private final SettableColorValueProxy mColor;
    private final ComputedIntegerValue mPlayingStep;
    private final List mStepDataChangedCallbacks = new ArrayList();
    private final List mNoteDataChangedCallback = new ArrayList();
    private TimerTask mUpdateTimerTask = null;
    private final SettableEnumAttributeProxy mLaunchQuantization = new SettableEnumAttributeProxy((ControlSurfaceObject)this, JmM.Ivg);
    private final SettableBooleanValueProxy mUseLoopStartAsQuantizationReference = new SettableBooleanValueProxy(this);
    private final Runnable mClipEventsChanged = this::invalidateGrid;
    private final ClipLauncherSlotProxy mClipLauncherSlot;
    private final SettableEnumAttributeProxy mLaunchMode = new SettableEnumAttributeProxy((ControlSurfaceObject)this, fkQ.OSp);
    private final SettableBooleanValueProxy mLegatoMode;

    public ClipProxy(ControlSurfaceObject controlSurfaceObject, String string, int n2, int n3) {
        super(controlSurfaceObject);
        this.setKey(string);
        this.mGridHeight = n3;
        this.mGridWidth = n2;
        this.mStepGrid = new fEf(this.mStepSize);
        this.mShuffle = new SettableBooleanValueProxy(this);
        this.mAccent = new RangedValueProxy(this);
        this.mIsLoopEnabled = new SettableBooleanValueProxy(this);
        this.mPlayStart = new AbsBeatTimeProxy(this);
        this.mPlayStop = new AbsBeatTimeProxy(this);
        this.mLoopStart = new AbsBeatTimeProxy(this);
        this.mLoopLength = new RelativeBeatTimeProxy(this);
        this.mColor = new SettableColorValueProxy(this);
        this.mTrackProxy = new TrackProxy(this, "ClipParentTrack", -1, 0, 1);
        this.mCanScrollKeysDown = new ComputedBooleanValue((ControlSurfaceObject)this, false);
        this.mCanScrollKeysUp = new ComputedBooleanValue((ControlSurfaceObject)this, false);
        this.mCanScrollStepsBackwards = new ComputedBooleanValue((ControlSurfaceObject)this, false);
        this.mCanScrollStepsForwards = new ComputedBooleanValue((ControlSurfaceObject)this, false);
        this.mPlayingStep = new ComputedIntegerValue((ControlSurfaceObject)this, -1);
        this.mClipLauncherSlot = new ClipLauncherSlotProxy(this);
        this.mLegatoMode = new SettableBooleanValueProxy(this);
    }

    public int getGridWidth() {
        return this.mGridWidth;
    }

    public int getGridHeight() {
        return this.mGridHeight;
    }

    @Override
    public Class getTargetType() {
        return aAR.class;
    }

    protected mgC getDocumentFromTarget(aAR aAR2) {
        return aAR2.okW();
    }

    @Override
    public BooleanValue canScrollKeysUp() {
        this.newSince(2);
        return this.mCanScrollKeysUp;
    }

    @Override
    public void addCanScrollKeysUpObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollKeysUp() instead");
        this.mCanScrollKeysUp.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public BooleanValue canScrollKeysDown() {
        this.newSince(2);
        return this.mCanScrollKeysDown;
    }

    @Override
    public void addCanScrollKeysDownObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollKeysDown() instead");
        this.mCanScrollKeysDown.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public BooleanValue canScrollStepsBackwards() {
        this.newSince(2);
        return this.mCanScrollStepsBackwards;
    }

    @Override
    public void addCanScrollStepsBackwardsObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollStepsBackwards() instead");
        this.mCanScrollStepsBackwards.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public BooleanValue canScrollStepsForwards() {
        this.newSince(2);
        return this.mCanScrollStepsForwards;
    }

    @Override
    public void addCanScrollStepsForwardObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollStepsForwards() instead");
        this.mCanScrollStepsForwards.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void scrollKeysPageUp() {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.exec(() -> this.doScrollKeysBy(this.mGridHeight));
    }

    @Override
    public void scrollKeysPageDown() {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.exec(() -> this.doScrollKeysBy(-this.mGridHeight));
    }

    private void doScrollKeysBy(int n2) {
        assert (this.UB2(this.isDocumentThread()));
        int n3 = this.mBaseKey + n2;
        if (n3 >= 0 && n3 <= 127) {
            this.doScrollToKey(n3);
        }
    }

    @Override
    public void scrollKeysStepUp() {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.exec(() -> this.doScrollKeysBy(1));
    }

    @Override
    public void scrollKeysStepDown() {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.exec(() -> this.doScrollKeysBy(-1));
    }

    @Override
    public void scrollToKey(int n2) {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.validKey(n2);
        this.exec(() -> this.doScrollToKey(n2));
    }

    private void doScrollToKey(int n2) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(n2 >= 0 && n2 <= 127));
        if (n2 != this.mBaseKey) {
            this.mBaseKey = n2;
            aAR aAR2 = (aAR)this.getTarget();
            if (aAR2 != null) {
                this.updateGrid();
            }
        }
    }

    @Override
    public void scrollToStep(int n2) {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.exec(() -> this.doScrollToStep(n2));
    }

    private void doScrollToStep(int n2) {
        assert (this.UB2(this.isDocumentThread()));
        aAR aAR2 = (aAR)this.getTarget();
        if (aAR2 != null && this.mBaseStep != n2) {
            this.mBaseStep = n2;
            this.updateGrid();
        }
    }

    @Override
    public void setName(String string) {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.notNull(string, "name");
        this.exec(() -> this.doSetName(string));
    }

    private void doSetName(String string) {
        assert (this.UB2(this.isDocumentThread()));
        aAR aAR2 = (aAR)this.getTarget();
        if (aAR2 != null && aAR2.HZb() != null) {
            aAR2.HZb().Ivg(string);
        }
    }

    @Override
    public void scrollStepsPageForward() {
        this.exec(() -> this.doScrollStepsBy(this.mGridWidth));
    }

    @Override
    public void scrollStepsPageBackwards() {
        this.exec(() -> this.doScrollStepsBy(-this.mGridWidth));
    }

    @Override
    public void scrollStepsStepForward() {
        this.exec(() -> this.doScrollStepsBy(1));
    }

    @Override
    public void scrollStepsStepBackwards() {
        this.exec(() -> this.doScrollStepsBy(-1));
    }

    private void doScrollStepsBy(int n2) {
        assert (this.UB2(this.isDocumentThread()));
        this.doScrollToStep(this.mBaseStep + n2);
    }

    @Override
    public void toggleStep(int n2, int n3, int n4) {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.toggleStepCommon(0, n2, n3, n4);
    }

    @Override
    public void toggleStep(int n2, int n3, int n4, int n5) {
        this.newSince(10);
        this.toggleStepCommon(n2, n3, n4, n5);
    }

    private void toggleStepCommon(int n2, int n3, int n4, int n5) {
        this.validPosition(n3, n4);
        this.inRange(n5, 0, 127, "insertVelocity");
        this.exec(() -> this.doToggleStep(n2, n3, n4, n5));
    }

    private void doToggleStep(int n2, int n3, int n4, int n5) {
        assert (this.UB2(this.isDocumentThread()));
        wxZ wxZ2 = this.getInstrumentClip();
        if (wxZ2 == null) {
            return;
        }
        aAR aAR2 = (aAR)this.getTarget();
        assert (this.UB2(aAR2 != null));
        int n6 = this.getKeyForY(n4);
        double d2 = this.getTimeForCell(n3);
        double d3 = d2 + this.getStepSize() - 1.0E-4;
        if (rAn.onT(n6)) {
            l1y l1y2 = wxZ2.ZAb().Ivg(n2, n6, false);
            List list = l1y2 != null ? l1y2.oHp(d2, d3) : Collections.EMPTY_LIST;
            aAR2.zRD().OUx();
            if (list.isEmpty()) {
                wxZ2.Ivg(d2, this.mStepSize, n2, n6, (float)n5 * 0.007874016f, aAR2.zRD().oHp());
            } else {
                for (Glx glx : list) {
                    z2A z2A2 = (z2A)glx;
                    if (z2A2.zRD() != n2) continue;
                    l1y2.OSp(glx);
                }
            }
        }
    }

    @Override
    public void setStep(int n2, int n3, int n4, double d2) {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.setStepCommon(0, n2, n3, n4, d2);
    }

    @Override
    public void setStep(int n2, int n3, int n4, int n5, double d2) {
        this.newSince(10);
        this.setStepCommon(n2, n3, n4, n5, d2);
    }

    public void setStepCommon(int n2, int n3, int n4, int n5, double d2) {
        assert (this.Ivg(this.isControlSurfaceThread()));
        this.validPosition(n2, n3, n4);
        this.inRange(n5, 0, 127, "insertVelocity");
        this.greaterThan(d2, 0.0, "insertDuration");
        this.exec(() -> this.doSetStep(n2, n3, n4, n5, Bu.Ivg(d2)));
    }

    private void doSetStep(int n2, int n3, int n4, int n5, double d2) {
        assert (this.UB2(this.isDocumentThread()));
        wxZ wxZ2 = this.getInstrumentClip();
        if (wxZ2 == null) {
            return;
        }
        aAR aAR2 = (aAR)this.getTarget();
        assert (this.UB2(aAR2 != null));
        int n6 = n4 + this.mBaseKey;
        double d3 = this.getTimeForCell(n3);
        if (n6 >= 0 && n6 < 128) {
            wxZ2.Ivg(d3, d2, n2, n6, (float)n5 * 0.007874016f, aAR2.zRD().oHp());
        }
    }

    public void updateStepVelocity(NoteStep noteStep, double d2) {
        assert (this.Ivg(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(10);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.inRange(d2, 0.0, 1.0, "velocity");
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, rsT2 -> rsT2.Ivg(d2)));
    }

    public void updateStepReleaseVelocity(NoteStep noteStep, double d2) {
        assert (this.Ivg(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(10);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.inRange(d2, 0.0, 1.0, "velocity");
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, rsT2 -> rsT2.OSp(d2)));
    }

    public void updateStepChance(NoteStep noteStep, double d2) {
        assert (this.Ivg(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(14);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.inRange(d2, 0.0, 1.0, "chance");
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, rsT2 -> rsT2.QCa(d2)));
    }

    public void updateStepEnableChance(NoteStep noteStep, boolean bl2) {
        assert (this.Ivg(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(14);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, rsT2 -> rsT2.ZAb(bl2)));
    }

    public void updateStepVelocitySpread(NoteStep noteStep, double d2) {
        assert (this.Ivg(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(14);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.inRange(d2, 0.0, 1.0, "amount");
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, rsT2 -> rsT2.oHp(d2)));
    }

    public void updateStepEnableOccurrence(NoteStep noteStep, boolean bl2) {
        assert (this.Ivg(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(14);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, rsT2 -> rsT2.lXt(bl2)));
    }

    public void updateStepOccurrence(NoteStep noteStep, NoteOccurrence noteOccurrence) {
        assert (this.Ivg(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(14);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.exec(() -> this.lambda$updateStepOccurrence$26(n4, n2, n3, switch (noteOccurrence) {
            case NoteOccurrence.ALWAYS -> Cla.Ivg;
            case NoteOccurrence.FIRST -> Cla.OSp;
            case NoteOccurrence.NOT_FIRST -> Cla.oHp;
            case NoteOccurrence.PREV -> Cla.UB2;
            case NoteOccurrence.PREV_CHANNEL -> Cla.Nyy;
            case NoteOccurrence.NOT_PREV_CHANNEL -> Cla.tGb;
            case NoteOccurrence.NOT_PREV -> Cla.ZAb;
            case NoteOccurrence.PREV_KEY -> Cla.lXt;
            case NoteOccurrence.NOT_PREV_KEY -> Cla.onT;
            case NoteOccurrence.FILL -> Cla.Fqp;
            case NoteOccurrence.NOT_FILL -> Cla.QCa;
            default -> throw new QWx("Unknown occurrence: " + String.valueOf((Object)noteOccurrence));
        }));
    }

    public void updateStepEnableRecurrence(NoteStep noteStep, boolean bl2) {
        assert (this.Ivg(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(14);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, rsT2 -> rsT2.onT(bl2)));
    }

    public void updateStepRecurrence(NoteStep noteStep, int n2) {
        assert (this.Ivg(this.isControlSurfaceThread()));
        int n3 = noteStep.x();
        int n4 = noteStep.y();
        int n5 = noteStep.channel();
        this.newSince(14);
        this.validPosition(n3, n4);
        this.validChannel(n5);
        this.exec(() -> this.doUpdateNoteEvent(n5, n3, n4, rsT2 -> rsT2.kpx(n2)));
    }

    public void updateStepEnableRepeat(NoteStep noteStep, boolean bl2) {
        assert (this.Ivg(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(14);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, rsT2 -> rsT2.Nyy(bl2)));
    }

    public void updateStepRepeatCount(NoteStep noteStep, int n2) {
        assert (this.Ivg(this.isControlSurfaceThread()));
        int n3 = noteStep.x();
        int n4 = noteStep.y();
        int n5 = noteStep.channel();
        this.newSince(14);
        this.validPosition(n3, n4);
        this.validChannel(n5);
        this.exec(() -> this.doUpdateNoteEvent(n5, n3, n4, rsT2 -> rsT2.zEU(n2)));
    }

    public void updateStepRepeatCurve(NoteStep noteStep, double d2) {
        assert (this.Ivg(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(14);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, rsT2 -> rsT2.kpx(d2)));
    }

    public void updateStepRepeatVelocityEnd(NoteStep noteStep, double d2) {
        assert (this.Ivg(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(14);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, rsT2 -> rsT2.UB2(d2)));
    }

    public void updateStepRepeatVelocityCurve(NoteStep noteStep, double d2) {
        assert (this.Ivg(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(14);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, rsT2 -> rsT2.ZAb(d2)));
    }

    public void updateStepIsMuted(NoteStep noteStep, boolean bl2) {
        assert (this.Ivg(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(14);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, rsT2 -> rsT2.tGb(bl2)));
    }

    public void updateStepDuration(NoteStep noteStep, double d2) {
        assert (this.Ivg(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(10);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.inRange(d2, 0.0, 128.0, "duration");
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, rsT2 -> {
            l1y l1y2 = rsT2.kcX();
            double d3 = Bu.lXt(d2);
            l1y2.Ivg((c3T)rsT2, rsT2.dYG(), d3);
        }));
    }

    public void updateStepPan(NoteStep noteStep, double d2) {
        assert (this.Ivg(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(10);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.inRange(d2, -1.0, 1.0, "pan");
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, rsT2 -> l3E.Ivg(rsT2, "panning", 0.0, (d2 + 1.0) / 2.0)));
    }

    public void updateStepTranspose(NoteStep noteStep, double d2) {
        assert (this.Ivg(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(10);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.inRange(d2, -96.0, 96.0, "transpose");
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, rsT2 -> l3E.Ivg(rsT2, "transpose", 0.0, (d2 + 96.0) / 192.0)));
    }

    public void updateStepGain(NoteStep noteStep, double d2) {
        assert (this.Ivg(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(10);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.inRange(d2, 0.0, 1.0, "gain");
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, rsT2 -> l3E.Ivg(rsT2, "amplitude", 0.0, d2)));
    }

    public void updateStepTimbre(NoteStep noteStep, double d2) {
        assert (this.Ivg(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(10);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.inRange(d2, -1.0, 1.0, "timbre");
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, rsT2 -> l3E.Ivg(rsT2, "timbre", 0.0, (d2 + 1.0) / 2.0)));
    }

    public void updateStepPressure(NoteStep noteStep, double d2) {
        assert (this.Ivg(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(10);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.inRange(d2, 0.0, 1.0, "pressure");
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, rsT2 -> l3E.Ivg(rsT2, "pressure", 0.0, d2)));
    }

    private void doUpdateNoteEvent(int n2, int n3, int n4, Consumer consumer) {
        assert (this.Ivg(this.isDocumentThread()));
        wxZ wxZ2 = this.getInstrumentClip();
        if (wxZ2 == null) {
            return;
        }
        aAR aAR2 = (aAR)this.getTarget();
        assert (this.Ivg(aAR2 != null));
        int n5 = n4 + this.mBaseKey;
        double d2 = this.getTimeForCell(n3);
        if (n5 < 0 || 128 <= n5) {
            return;
        }
        l1y l1y2 = wxZ2.ZAb().Ivg(n2, n5, false);
        if (l1y2 == null) {
            return;
        }
        List list = l1y2.oHp(d2, d2 + this.mStepSize - 0.001);
        if (list == null) {
            return;
        }
        mgC mgC2 = this.getDocument();
        mgC2.Ivg("Update Note Data From Controller Extension", false);
        for (Glx glx : list) {
            if (!(glx instanceof rsT)) continue;
            rsT rsT2 = (rsT)glx;
            consumer.accept(rsT2);
        }
        mgC2.Ivg(false);
    }

    @Override
    public void clearStep(int n2, int n3) {
        this.clearStepCommon(0, n2, n3);
    }

    @Override
    public void clearStep(int n2, int n3, int n4) {
        this.newSince(10);
        this.clearStepCommon(n2, n3, n4);
    }

    public void clearStepCommon(int n2, int n3, int n4) {
        assert (this.Ivg(this.isControlSurfaceThread()));
        this.validPosition(n2, n3, n4);
        this.exec(() -> this.doClearStep(n2, n3, n4));
    }

    private void doClearStep(int n2, int n3, int n4) {
        assert (this.UB2(this.isDocumentThread()));
        int n5 = n4 + this.mBaseKey;
        if (n5 < 0 || n5 > 128) {
            return;
        }
        aAR aAR2 = (aAR)this.getTarget();
        if (aAR2 == null) {
            return;
        }
        wxZ wxZ2 = this.getInstrumentClip();
        if (wxZ2 == null) {
            return;
        }
        double d2 = this.getTimeForCell(n3);
        double d3 = d2 + this.getStepSize() - 1.0E-4;
        l1y l1y2 = wxZ2.ZAb().Ivg(n2, n5, false);
        if (l1y2 == null) {
            return;
        }
        List list = l1y2.oHp(d2, d3);
        for (rsT rsT2 : list) {
            l1y2.OSp(rsT2);
        }
        aAR2.zRD().OUx();
    }

    @Override
    public void clearStepsAtX(int n2, int n3) {
        assert (this.Ivg(this.isControlSurfaceThread()));
        this.newSince(10);
        this.validX(n3);
        this.validChannel(n2);
        this.exec(() -> this.doClearStepsAtX(n2, n3));
    }

    private void doClearStepsAtX(int n2, int n3) {
        assert (this.UB2(this.isDocumentThread()));
        aAR aAR2 = (aAR)this.getTarget();
        if (aAR2 == null) {
            return;
        }
        wxZ wxZ2 = this.getInstrumentClip();
        if (wxZ2 == null) {
            return;
        }
        double d2 = this.getTimeForCell(n3);
        double d3 = d2 + this.getStepSize() - 1.0E-4;
        for (int i2 = 0; i2 < 128; ++i2) {
            l1y l1y2 = wxZ2.ZAb().Ivg(n2, i2, false);
            if (l1y2 == null) continue;
            List list = l1y2.oHp(d2, d3);
            for (rsT rsT2 : list) {
                l1y2.OSp(rsT2);
            }
        }
        aAR2.zRD().OUx();
    }

    @Override
    public void clearSteps() {
        this.exec(this::doClearSteps);
    }

    private void doClearSteps() {
        aAR aAR2 = (aAR)this.getTarget();
        if (aAR2 != null) {
            wxZ wxZ2 = this.getInstrumentClip();
            if (wxZ2 == null) {
                return;
            }
            wxZ2.Ivg().UB2(-1.7976931348623157E308, Double.MAX_VALUE);
            aAR2.zRD().OUx();
        }
    }

    @Override
    public void clearSteps(int n2) {
        this.deprecated(1, 10, "Use clearStepsAtY(channel, y) instead.");
        this.validY(n2);
        this.exec(() -> this.doClearSteps(0, n2));
    }

    @Override
    public void clearStepsAtY(int n2, int n3) {
        this.validY(n3);
        this.validChannel(n2);
        this.exec(() -> this.doClearSteps(n2, n3));
    }

    private void doClearSteps(int n2, int n3) {
        assert (this.ZAb(this.isDocumentThread()));
        aAR aAR2 = (aAR)this.getTarget();
        if (aAR2 == null) {
            return;
        }
        wxZ wxZ2 = this.getInstrumentClip();
        if (wxZ2 == null) {
            return;
        }
        int n4 = n3 + this.mBaseKey;
        if (n4 < 0 || n4 >= 128) {
            return;
        }
        l1y l1y2 = wxZ2.ZAb().Ivg(n2, n4, false);
        if (l1y2 != null) {
            l1y2.Ldm();
        }
    }

    @Override
    public void moveStep(int n2, int n3, int n4, int n5) {
        this.newSince(16);
        this.moveStep(0, n2, n3, n4, n5);
    }

    @Override
    public void moveStep(int n2, int n3, int n4, int n5, int n6) {
        this.newSince(16);
        this.validPosition(n3, n4);
        this.validPosition(n3 + n5, n4 + n6);
        if (n5 == 0 && n6 == 0) {
            return;
        }
        this.exec(() -> this.doMoveStep(n2, n3, n4, n5, n6));
    }

    private void doMoveStep(int n2, int n3, int n4, int n5, int n6) {
        assert (this.isDocumentThread());
        wxZ wxZ2 = this.getInstrumentClip();
        if (wxZ2 == null) {
            return;
        }
        int n7 = this.getKeyForY(n4);
        int n8 = this.getKeyForY(n4 + n6);
        if (!rAn.onT(n7) || !rAn.onT(n8)) {
            return;
        }
        l1y l1y2 = wxZ2.ZAb().Ivg(n2, n7, false);
        if (l1y2 == null) {
            return;
        }
        double d2 = this.getTimeForCell(n3);
        double d3 = d2 + this.getStepSize() - 1.0E-4;
        double d4 = this.getTimeForCell(n3 + n5);
        double d5 = d4 - d2;
        List list = l1y2.oHp(d2, d3);
        assert (this.onT(list.stream().allMatch(z2A2 -> z2A2.zRD() == n2)));
        if (list.isEmpty()) {
            return;
        }
        wxZ2.ZAb().Ivg(list, n6, d5);
    }

    @Override
    public void selectStepContents(int n2, int n3, boolean bl2) {
        this.selectStepContentsCommon(0, n2, n3, bl2);
    }

    @Override
    public void selectStepContents(int n2, int n3, int n4, boolean bl2) {
        this.newSince(10);
        this.selectStepContentsCommon(n2, n3, n4, bl2);
    }

    void selectStepContentsCommon(int n2, int n3, int n4, boolean bl2) {
        this.validPosition(n2, n3, n4);
        this.exec(() -> this.doSelectStepContents(0, n3, n4, bl2));
    }

    private void doSelectStepContents(int n2, int n3, int n4, boolean bl2) {
        assert (this.UB2(this.isDocumentThread()));
        aAR aAR2 = (aAR)this.getTarget();
        if (aAR2 == null) {
            return;
        }
        wxZ wxZ2 = this.getInstrumentClip();
        if (wxZ2 == null) {
            return;
        }
        int n5 = n4 + this.mBaseKey;
        double d2 = this.getTimeForCell(n3);
        double d3 = d2 + this.getStepSize() - 1.0E-4;
        if (n5 < 0 || n5 >= 128) {
            return;
        }
        l1y l1y2 = wxZ2.ZAb().Ivg(n2, n5, false);
        List list = l1y2 != null ? l1y2.oHp(d2, d3) : Collections.EMPTY_LIST;
        avO avO2 = aAR2.zRD();
        if (bl2) {
            avO2.OUx();
        }
        for (z2A z2A2 : list) {
            avO2.lXt(z2A2.Ivg(0, false));
        }
    }

    @Override
    public void setStepSize(double d2) {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.greaterThan(d2, 0.0, "lengthInBeatTime");
        this.exec(() -> this.doSetStepSize(d2));
    }

    private void doSetStepSize(double d2) {
        assert (this.UB2(this.isDocumentThread()));
        aAR aAR2 = (aAR)this.getTarget();
        if (this.mStepSize != d2) {
            this.mStepSize = d2;
            this.mStepGrid = new fEf(this.mStepSize);
            if (!this.mHasInvalidatedGrid && aAR2 != null) {
                this.mHasInvalidatedGrid = true;
                if (this.mUpdateTimerTask != null) {
                    this.mUpdateTimerTask.cancel();
                }
                this.mUpdateTimerTask = this.scheduleTimerTaskOnDocumentThread(this::updateGridFromTimer, 100L);
            }
        }
    }

    private void updateGridFromTimer() {
        assert (this.Ivg(this.isDocumentThread()));
        assert (this.Ivg(this.mUpdateTimerTask != null));
        this.updateGrid();
        this.mHasInvalidatedGrid = false;
        this.mUpdateTimerTask = null;
    }

    private double getStepSize() {
        return this.mStepSize;
    }

    private double getTimeForCell(int n2) {
        double d2 = this.getTimeForCellUnsafe(n2);
        assert (this.onT(this.getCellForTimeUnsafe(d2) == n2));
        return d2;
    }

    private int getCellForTime(double d2) {
        int n2 = this.getCellForTimeUnsafe(d2);
        assert (this.onT(this.getTimeForCellUnsafe(n2) <= d2 && d2 < this.getTimeForCellUnsafe(n2 + 1)));
        return n2;
    }

    private double getTimeForCellUnsafe(int n2) {
        return Bu.Ivg((double)(this.mBaseStep + n2) * this.getStepSize());
    }

    private int getCellForTimeUnsafe(double d2) {
        double d3 = this.getTimeForCellUnsafe(0);
        int n2 = (int)Math.floor((d2 - d3) / this.getStepSize());
        if (this.isCorrectCellForTime(n2, d2)) {
            return n2;
        }
        int n3 = this.getTimeForCellUnsafe(n2) < d2 ? 1 : -1;
        for (int i2 = n2; i2 != n2 + 10 * n3; i2 += n3) {
            if (!this.isCorrectCellForTime(i2, d2)) continue;
            return i2;
        }
        assert (this.OSp(String.format("Could not determine step for time %f (base step: %d, step size: %f)", d2, this.mBaseStep, this.mStepSize)));
        return n2;
    }

    private boolean isCorrectCellForTime(int n2, double d2) {
        return this.getTimeForCellUnsafe(n2) <= d2 && d2 < this.getTimeForCellUnsafe(n2 + 1);
    }

    private int getKeyForY(int n2) {
        return this.mBaseKey + n2;
    }

    private QRZ getClipEvent() {
        aAR aAR2 = (aAR)this.getTarget();
        if (aAR2 == null) {
            return null;
        }
        FGC fGC = aAR2.HZb();
        if (fGC == null) {
            return null;
        }
        mgC mgC2 = (mgC)fGC.ZAb(mgC.class);
        assert (this.Ivg(mgC2 != null));
        if (mgC2 == null) {
            return null;
        }
        return fGC;
    }

    private wxZ getInstrumentClip() {
        QRZ qRZ = this.getClipEvent();
        return qRZ instanceof wxZ ? (wxZ)qRZ : null;
    }

    private void invalidateGrid() {
        assert (this.Ivg(this.isDocumentThread()));
        if (!this.mHasInvalidatedGrid) {
            this.mHasInvalidatedGrid = true;
            jrf.NhN().runAtEndOfCurrentEvent(() -> {
                this.updateGrid();
                this.mHasInvalidatedGrid = false;
            });
        }
    }

    private void updateGrid() {
        OqE oqE;
        assert (this.UB2(this.isDocumentThread()));
        wxZ wxZ2 = this.getInstrumentClip();
        aAR aAR2 = (aAR)this.getTarget();
        double d2 = this.getTimeForCell(0);
        double d3 = this.getTimeForCell(this.mGridWidth - 1) + this.getStepSize() - 1.0E-4;
        if (wxZ2 != null) {
            assert (this.ZAb(wxZ2.oTm().ZAb()));
            oqE = wxZ2.ZAb();
        } else {
            oqE = null;
        }
        ArrayList<NoteStep> arrayList = new ArrayList<NoteStep>();
        List list = oqE != null ? oqE.Ivg(d2, d3) : Collections.emptyList();
        HashMap hashMap = (HashMap)this.mNoteStepsDocumentThread.clone();
        for (Glx object : list) {
            rsT rsT2 = (rsT)object;
            boolean bl2 = aAR2.zRD().Ivg(rsT2);
            double d4 = rsT2.dYG();
            double d5 = rsT2.Omx();
            int n2 = this.getCellForTime(d4);
            if (n2 < 0 || this.mGridWidth <= n2) continue;
            int n3 = rsT2.Ivg();
            int n4 = n3 - this.mBaseKey;
            int n5 = rsT2.zRD();
            if (n4 < 0 || this.mGridHeight <= n4) continue;
            assert (this.Ivg(rAn.onT(n3)));
            assert (this.Ivg(rAn.lXt(n5)));
            assert (this.Ivg(n2 >= 0 && n2 < this.mGridWidth));
            assert (this.Ivg(n4 >= 0 && n4 < this.mGridHeight));
            int n6 = d4 < d2 ? 1 : 2;
            int n7 = this.computeStepInfoIndex(n5, n2, n4);
            NoteStep noteStep = (NoteStep)this.mNoteStepsDocumentThread.get(n7);
            if (noteStep != null) {
                hashMap.remove(n7);
            }
            if (noteStep == null || !noteStep.isSameAs(n2, n4, n5, rsT2, bl2, n6)) {
                NoteStep noteStep2 = NoteStep.createNoteStep(this, n2, n4, n5, rsT2, bl2, n6);
                arrayList.add(noteStep2);
            }
            for (int i2 = n2 + 1; i2 < this.mGridWidth && this.getTimeForCell(i2) < d5; ++i2) {
                assert (this.Ivg(0 <= i2 && i2 < this.mGridWidth));
                int n8 = this.computeStepInfoIndex(n5, i2, n4);
                NoteStep noteStep3 = (NoteStep)this.mNoteStepsDocumentThread.get(n8);
                if (noteStep3 != null) {
                    hashMap.remove(n8);
                }
                if (noteStep3 != null && noteStep3.isSameAs(i2, n4, n5, rsT2, bl2, 1)) continue;
                NoteStep noteStep4 = NoteStep.createNoteStep(this, i2, n4, n5, rsT2, bl2, 1);
                arrayList.add(noteStep4);
            }
        }
        for (NoteStep noteStep : arrayList) {
            this.mNoteStepsDocumentThread.put(this.computeStepInfoIndex(noteStep), noteStep);
        }
        for (Integer n9 : hashMap.keySet()) {
            this.mNoteStepsDocumentThread.remove(n9);
        }
        this.mCanScrollKeysDown.setBoolValue(this.mBaseKey > 0);
        this.mCanScrollKeysUp.setBoolValue(this.mBaseKey < 128 - this.mGridWidth * this.mGridHeight);
        if (!arrayList.isEmpty() || !hashMap.isEmpty()) {
            this.sendNoteStateToObservers(arrayList, hashMap.values());
        }
    }

    protected int computeStepInfoIndex(NoteStep noteStep) {
        return this.computeStepInfoIndex(noteStep.channel(), noteStep.x(), noteStep.y());
    }

    protected int computeStepInfoIndex(int n2, int n3, int n4) {
        return n2 + 16 * (n3 + n4 * this.mGridWidth);
    }

    @Override
    public void addStepDataObserver(StepDataChangedCallback stepDataChangedCallback) {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.checkIsInitializingDriver();
        this.notNull(stepDataChangedCallback, "callback");
        this.mStepDataChangedCallbacks.add(stepDataChangedCallback);
    }

    @Override
    public void addNoteStepObserver(NoteStepChangedCallback noteStepChangedCallback) {
        assert (this.Ivg(this.isControlSurfaceThread()));
        this.checkIsInitializingDriver();
        this.notNull(noteStepChangedCallback, "callback");
        this.mNoteDataChangedCallback.add(noteStepChangedCallback);
    }

    @Override
    public IntegerValue playingStep() {
        this.newSince(2);
        return this.mPlayingStep;
    }

    @Override
    public void addPlayingStepObserver(IntegerValueChangedCallback integerValueChangedCallback) {
        this.deprecated(1, 2, "Use playingStep() instead");
        this.mPlayingStep.addValueObserver(integerValueChangedCallback);
    }

    @Override
    public SettableBooleanValueProxy getShuffle() {
        return this.mShuffle;
    }

    @Override
    public SettableRangedValue getAccent() {
        return this.mAccent;
    }

    @Override
    public SettableBeatTimeValue getPlayStart() {
        return this.mPlayStart;
    }

    @Override
    public SettableBeatTimeValue getPlayStop() {
        return this.mPlayStop;
    }

    @Override
    public SettableBooleanValueProxy isLoopEnabled() {
        return this.mIsLoopEnabled;
    }

    @Override
    public SettableBeatTimeValue getLoopStart() {
        return this.mLoopStart;
    }

    @Override
    public SettableBeatTimeValue getLoopLength() {
        return this.mLoopLength;
    }

    @Override
    public void addColorObserver(ColorValueChangedCallback colorValueChangedCallback) {
        this.deprecated(1, 2, "Use color().addValueObserver(callback)");
        this.mColor.addValueObserver(colorValueChangedCallback);
    }

    @Override
    public SettableColorValue color() {
        this.newSince(2);
        return this.mColor;
    }

    @Override
    public void duplicate() {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.exec(this::doDuplicate);
    }

    private void doDuplicate() {
        assert (this.UB2(this.isDocumentThread()));
        mgC mgC2 = this.getDocument();
        aAR aAR2 = (aAR)this.getTarget();
        if (aAR2 != null && mgC2 != null) {
            FGC fGC = aAR2.HZb();
            FhV fhV = (FhV)fGC.ZAb(FhV.class);
            if (fhV != null) {
                FRf fRf = mgC2.uKS().onT();
                fRf.QCa(fhV);
                fRf.VDg();
                if (fRf.ZiK()) {
                    fRf.iXp();
                }
            }
            fGC.cS2();
        }
    }

    @Override
    public void duplicateContent() {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.exec(this::doDuplicateContent);
    }

    private void doDuplicateContent() {
        assert (this.UB2(this.isDocumentThread()));
        aAR aAR2 = (aAR)this.getTarget();
        if (aAR2 != null) {
            aAR2.HZb().cS2();
        }
    }

    @Override
    public void transpose(int n2) {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.exec(() -> this.doTranspose(n2));
    }

    private void doTranspose(int n2) {
        assert (this.UB2(this.isDocumentThread()));
        aAR aAR2 = (aAR)this.getTarget();
        if (aAR2 != null) {
            aAR2.HZb().Ivg(n2);
        }
    }

    @Override
    public void quantize(double d2) {
        assert (this.UB2(this.isControlSurfaceThread()));
        if (d2 <= 0.0 || d2 > 1.0) {
            throw new QWx("Clip.quantize: amount parameter value should be greater than zero and maximal one.");
        }
        this.exec(() -> this.doQuantize(d2));
    }

    private void doQuantize(double d2) {
        assert (this.UB2(this.isDocumentThread()));
        aAR aAR2 = (aAR)this.getTarget();
        if (aAR2 != null) {
            aAR2.Ivg(d2, this.mStepGrid);
        }
    }

    @Override
    public Track getTrack() {
        return this.mTrackProxy;
    }

    protected void connectToTarget(aAR aAR2) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(aAR2 != null));
        assert (this.UB2(this.mInstrumentClipListener == null));
        FGC fGC = aAR2.HZb();
        qUT qUT2 = fGC.qFU();
        wxZ wxZ2 = this.getInstrumentClip();
        this.mUseLoopStartAsQuantizationReference.setTarget(fGC.kcX());
        this.mLaunchMode.setTarget(fGC.kQP());
        this.mLegatoMode.setTarget(fGC.okW());
        if (wxZ2 != null) {
            this.mInstrumentClipListener = new ClipProxy$InstrumentClipListener(this, wxZ2);
        }
        aAR2.zRD().KxJ().Ivg(this.mSelectionChangeListener);
        qUT2.Ivg(this.mClipEventsChanged);
        this.mShuffle.setTarget(qUT2.Hsr());
        this.mAccent.setTarget(qUT2.oCu());
        DJl dJl2 = qUT2.eL_();
        this.mPlayStart.setTarget(dJl2.onT().nYD());
        this.mPlayStop.setTarget(dJl2.Nyy().nYD());
        this.mIsLoopEnabled.setTarget(dJl2.kyS());
        this.mLoopStart.setTarget(dJl2.qFU().nYD());
        this.mLoopLength.setTarget(dJl2.qFU().pzQ());
        this.mColor.setTarget(fGC.QTg(), fGC.Hsr());
        this.mLaunchQuantization.setTarget(fGC.jBI());
        if (this.mTrackProxy != null) {
            FhV fhV;
            ClipLauncherSlotBankProxy clipLauncherSlotBankProxy = this.mTrackProxy.getClipLauncherSlots();
            UKr uKr2 = fGC.MGv();
            this.mTrackProxy.setTarget(uKr2);
            if (clipLauncherSlotBankProxy != null && (fhV = (FhV)fGC.ZAb(FhV.class)) != null) {
                this.mClipLauncherSlot.setTarget(fhV);
                clipLauncherSlotBankProxy.scrollToScene(fhV);
            }
        }
        this.connectObservers(fGC);
    }

    protected void disconnectFromTarget(aAR aAR2) {
        assert (this.UB2(aAR2 != null));
        FGC fGC = aAR2.HZb();
        this.disconnectObservers(fGC);
        if (this.mTrackProxy != null) {
            this.mTrackProxy.clearTarget();
        }
        if (this.mInstrumentClipListener != null) {
            this.mInstrumentClipListener.dispose();
            this.mInstrumentClipListener = null;
        }
        qUT qUT2 = fGC.qFU();
        qUT2.OSp(this.mClipEventsChanged);
        this.mPlayStart.clearTarget();
        this.mPlayStop.clearTarget();
        this.mIsLoopEnabled.clearTarget();
        this.mLoopStart.clearTarget();
        this.mLoopLength.clearTarget();
        this.mColor.clearTarget();
        this.mShuffle.clearTarget();
        this.mAccent.clearTarget();
        this.mLaunchQuantization.clearTarget();
        this.mUseLoopStartAsQuantizationReference.clearTarget();
        this.mClipLauncherSlot.clearTarget();
        this.mLaunchMode.clearTarget();
        this.mLegatoMode.clearTarget();
        aAR2.zRD().KxJ().OSp(this.mSelectionChangeListener);
        this.setPlayingStep(-1);
    }

    @Override
    protected void targetChanged() {
        super.targetChanged();
        this.updateGrid();
    }

    private void sendNoteStateToObservers(Collection collection, Collection collection2) {
        assert (this.UB2(this.isDocumentThread()));
        this.queueCallback(() -> this.doSendNoteStateToObservers(collection, collection2));
    }

    private void doSendNoteStateToObservers(Collection collection, Collection collection2) {
        int n2;
        for (NoteStep noteStep : collection) {
            n2 = this.computeStepInfoIndex(noteStep);
            this.mNoteStepsControllerThread.put(n2, noteStep);
            this.notifyNoteStepToObservers(noteStep);
        }
        for (NoteStep noteStep : collection2) {
            noteStep.setCachedNoteState(0);
            n2 = this.computeStepInfoIndex(noteStep);
            this.mNoteStepsControllerThread.remove(n2);
            this.notifyNoteStepToObservers(noteStep);
        }
    }

    private void notifyNoteStepToObservers(NoteStep noteStep) {
        assert (this.UB2(this.isControlSurfaceThread()));
        assert (this.Ivg(noteStep.checkBounds(this.mGridWidth, this.mGridHeight)));
        for (Callback callback : this.mNoteDataChangedCallback) {
            callback.noteStepChanged(noteStep);
        }
        for (Callback callback : this.mStepDataChangedCallbacks) {
            callback.stepStateChanged(noteStep.x(), noteStep.y(), noteStep.noteState());
        }
    }

    private void setPlayingStep(int n2) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(n2 >= -1));
        if (n2 != this.mLastPlaybackStep) {
            this.mLastPlaybackStep = n2;
            this.mPlayingStep.setIntegerValue(n2);
        }
    }

    private void validPosition(int n2, int n3, int n4) {
        this.validChannel(n2);
        this.validPosition(n3, n4);
    }

    private void validPosition(int n2, int n3) {
        this.validX(n2);
        this.validY(n3);
    }

    private void validChannel(int n2) {
        this.inRange(n2, 0, 15, "channel");
    }

    private void validKey(int n2) {
        this.inRange(n2, 0, 127, "key");
    }

    private void validX(int n2) {
        this.inRange(n2, 0, this.mGridWidth - 1, "x");
    }

    private void validY(int n2) {
        this.inRange(n2, 0, this.mGridHeight - 1, "y");
    }

    @Override
    public SettableEnumValue launchQuantization() {
        this.newSince(8);
        return this.mLaunchQuantization;
    }

    @Override
    public SettableBooleanValue useLoopStartAsQuantizationReference() {
        this.newSince(8);
        return this.mUseLoopStartAsQuantizationReference;
    }

    @Override
    public SettableBooleanValue launchLegato() {
        this.deprecated(8, 9);
        return this.mLegatoMode;
    }

    @Override
    public SettableEnumValue launchMode() {
        this.newSince(9);
        return this.mLaunchMode;
    }

    @Override
    public ClipLauncherSlot clipLauncherSlot() {
        this.newSince(10);
        return this.mClipLauncherSlot;
    }

    @Override
    public void launch() {
        this.newSince(10);
        this.exec(this::doLaunch);
    }

    private void doLaunch() {
        assert (this.Ivg(this.isDocumentThread()));
        QRZ qRZ = this.getClipEvent();
        if (qRZ != null) {
            qRZ.Ivg(true, false);
        }
    }

    @Override
    public void launchWithOptions(String string, String string2) {
        this.newSince(16);
        JmM jmM = (JmM)this.mLaunchQuantization.validateValueFromController(string);
        fkQ fkQ2 = (fkQ)this.mLaunchMode.validateValueFromController(string2);
        this.exec(() -> this.doLaunchWithQuantization(jmM, fkQ2));
    }

    private void doLaunchWithQuantization(JmM jmM, fkQ fkQ2) {
        assert (this.Ivg(this.isDocumentThread()));
        QRZ qRZ = this.getClipEvent();
        if (qRZ == null) {
            return;
        }
        LNw lNw = qRZ.Kyj();
        lNw.OSp(true);
        lNw.Ivg(fkQ2);
        lNw.Ivg(true);
        lNw.Ivg(jmM);
        qRZ.Ivg(true, lNw);
    }

    @Override
    public com.bitwig.extension.controller.api.NoteStep getStep(int n2, int n3, int n4) {
        this.newSince(10);
        this.validPosition(n2, n3, n4);
        NoteStep noteStep = (NoteStep)this.mNoteStepsControllerThread.get(this.computeStepInfoIndex(n2, n3, n4));
        if (noteStep == null) {
            noteStep = new NoteStep(n3, n4, n2, this);
        }
        return noteStep;
    }

    @Override
    public void showInEditor() {
        QRZ qRZ;
        aog aog2 = this.getDocumentWidget().fLU();
        if (aog2 != null && (qRZ = this.getClipEvent()) instanceof FGC) {
            aog2.OSp((FGC)qRZ, true, true);
        }
    }

    private /* synthetic */ void lambda$updateStepOccurrence$26(int n2, int n3, int n4, Cla cla2) {
        this.doUpdateNoteEvent(n2, n3, n4, rsT2 -> rsT2.Ivg(cla2));
    }
}

