/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.controller.api.BrowserFilterColumnBank;
import com.bitwig.extension.controller.api.BrowserResultsColumn;
import com.bitwig.extension.controller.api.BrowserResultsItem;
import com.bitwig.extension.controller.api.BrowsingSession;
import com.bitwig.extension.controller.api.CursorBrowserFilterColumn;
import com.bitwig.extension.controller.api.CursorBrowserResultItem;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.flt.control_surface.proxy.BrowserFilterColumnBankProxy;
import com.bitwig.flt.control_surface.proxy.BrowserProxy;
import com.bitwig.flt.control_surface.proxy.BrowserResultsColumnProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObjectProxy;
import com.bitwig.flt.control_surface.proxy.CursorBrowserFilterColumnProxy;
import com.bitwig.flt.control_surface.proxy.CursorBrowserResultItemProxy;
import com.bitwig.flt.control_surface.proxy.SettledBrowserResultItemProxy;
import com.bitwig.flt.control_surface.values.IntegerValueProxy;

public abstract class BrowsingSessionProxy
extends ControlSurfaceObjectProxy
implements BrowsingSession {
    private final BrowserResultsColumnProxy mResultsColumn;
    private final CursorBrowserResultItemProxy mCursorResult;
    private final SettledBrowserResultItemProxy mSettledResult;
    private Lda mBrowsingSession;
    private final BrowserProxy mBrowser;
    private final dGI mFilterBankMap = new dGO();
    private final int mNumFilterColumnEntries;
    private final CursorBrowserFilterColumnProxy mFilterCursor;
    private final IntegerValueProxy mHitCount;

    public static String getSessionName(Lda lda) {
        assert (bRL.onT(lda != null));
        return null;
    }

    protected BrowsingSessionProxy(ControlSurfaceObject controlSurfaceObject, BrowserProxy browserProxy, int n2, int n3) {
        super(controlSurfaceObject);
        this.mBrowser = browserProxy;
        this.mNumFilterColumnEntries = n2;
        this.mResultsColumn = new BrowserResultsColumnProxy(this);
        this.mCursorResult = new CursorBrowserResultItemProxy(this.mResultsColumn);
        this.mSettledResult = new SettledBrowserResultItemProxy(this.mResultsColumn);
        this.mFilterCursor = new CursorBrowserFilterColumnProxy(this);
        this.mHitCount = new IntegerValueProxy(this);
    }

    @Override
    public void addIsAvailableObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use exists() instead");
        this.exists().addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void addIsActiveObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
    }

    @Override
    public void activate() {
        if (this.mBrowser != null) {
            this.mBrowser.activateSession(this);
        }
    }

    @Override
    public IntegerValue hitCount() {
        this.newSince(2);
        return this.mHitCount;
    }

    @Override
    public void addHitCountObserver(IntegerValueChangedCallback integerValueChangedCallback) {
        this.deprecated(1, 2, "Use hitCount() instead");
        this.mHitCount.addValueObserver(integerValueChangedCallback);
    }

    @Override
    public BrowserResultsColumn getResults() {
        return this.mResultsColumn;
    }

    @Override
    public CursorBrowserResultItem getCursorResult() {
        return this.mCursorResult;
    }

    @Override
    public BrowserResultsItem getSettledResult() {
        return this.mSettledResult;
    }

    @Override
    public CursorBrowserFilterColumn getCursorFilter() {
        return this.mFilterCursor;
    }

    @Override
    public BrowserFilterColumnBank createFilterBank(int n2) {
        if (this.mFilterBankMap.Ivg(n2)) {
            return (BrowserFilterColumnBank)this.mFilterBankMap.OSp(n2);
        }
        BrowserFilterColumnBankProxy browserFilterColumnBankProxy = new BrowserFilterColumnBankProxy(this, n2, this.mNumFilterColumnEntries);
        this.mFilterBankMap.Ivg(n2, (Object)browserFilterColumnBankProxy);
        return browserFilterColumnBankProxy;
    }

    protected void connectToTarget(Lda lda) {
        assert (this.ZAb(lda != null));
        assert (this.ZAb(this.mBrowsingSession == null));
        this.mBrowsingSession = this.mBrowser.getBrowsingSession();
        this.mResultsColumn.setTarget(lda);
        this.mCursorResult.connectToSearchSession(lda);
        this.mSettledResult.connectToSearchSession(lda);
        this.mFilterCursor.connectToSearchSession(lda);
        dTK dTK2 = this.mFilterBankMap.oHp().Ivg();
        while (dTK2.hasNext()) {
            BrowserFilterColumnBankProxy browserFilterColumnBankProxy = (BrowserFilterColumnBankProxy)dTK2.next();
            browserFilterColumnBankProxy.setTarget(lda);
        }
        this.mHitCount.setTarget(lda.QkE());
        this.connectObservers(lda);
    }

    protected void disconnectFromTarget(Lda lda) {
        assert (this.ZAb(lda != null));
        this.disconnectObservers(lda);
        dTK dTK2 = this.mFilterBankMap.oHp().Ivg();
        while (dTK2.hasNext()) {
            BrowserFilterColumnBankProxy browserFilterColumnBankProxy = (BrowserFilterColumnBankProxy)dTK2.next();
            browserFilterColumnBankProxy.clearTarget();
        }
        this.mFilterCursor.disconnectFromSearchSession(lda);
        this.mSettledResult.disconnectFromSearchSession(lda);
        this.mCursorResult.disconnectFromSearchSession(lda);
        this.mResultsColumn.clearTarget();
        this.mHitCount.clearTarget();
        this.mBrowsingSession = null;
    }
}

