/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.HardwareActionBindable;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.SettableIntegerValue;
import com.bitwig.flt.control_surface.proxy.BankCursorIndex;
import com.bitwig.flt.control_surface.proxy.BankItemWithPosition;
import com.bitwig.flt.control_surface.proxy.BankScrollPosition;
import com.bitwig.flt.control_surface.proxy.BankTarget;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceCursorProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceProxy;
import com.bitwig.flt.control_surface.proxy.DocumentAction;
import com.bitwig.flt.control_surface.proxy.SiblingTrackBankProxy;
import com.bitwig.flt.control_surface.values.ComputedBooleanValue;
import com.bitwig.flt.control_surface.values.ComputedIntegerValue;
import com.bitwig.flt.document.core.iface.mgC;
import com.bitwig.flt.document.core.master.R1k;
import com.bitwig.ramona.core.Oac;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BankItemTargetUpdater
extends ControlSurfaceProxy
implements EKT {
    private final ControlSurfaceProxy[] mItemProxies;
    private final ComputedBooleanValue mCanScrollBackwards;
    private final ComputedBooleanValue mCanScrollForwards;
    private final BankScrollPosition mScrollPosition;
    private final BankCursorIndex mCursorIndex;
    private ControlSurfaceCursorProxy mCursorProxyToFollow;
    private final ComputedIntegerValue mListItemCount;
    private final int mScrollPositionThatPageShouldAlignTo;
    private int mFirstPagePosition;
    private boolean mHasScheduledUpdate;
    private Oac mCursor;
    private List mScrollPositionSlaves;
    private BankItemTargetUpdater mMasterScrollPositionBankUpdater;
    private int mSizeOnControllerThread;
    private int mSize;

    public BankItemTargetUpdater(ControlSurfaceObject controlSurfaceObject, ControlSurfaceProxy[] controlSurfaceProxyArray, int n2) {
        super(controlSurfaceObject);
        assert (this.UB2(controlSurfaceProxyArray != null));
        assert (this.UB2(n2 >= 0));
        this.mItemProxies = controlSurfaceProxyArray;
        this.mSizeOnControllerThread = this.mSize = controlSurfaceProxyArray.length;
        this.mCanScrollBackwards = new ComputedBooleanValue(this);
        this.mCanScrollForwards = new ComputedBooleanValue(this);
        this.mScrollPosition = new BankScrollPosition(this);
        this.mCursorIndex = new BankCursorIndex(this);
        this.mListItemCount = new ComputedIntegerValue((ControlSurfaceObject)this, 0);
        this.mScrollPositionThatPageShouldAlignTo = n2;
        this.mFirstPagePosition = this.computeFirstPagePosition();
    }

    public BankItemTargetUpdater(ControlSurfaceObject controlSurfaceObject, ControlSurfaceProxy[] controlSurfaceProxyArray) {
        this(controlSurfaceObject, controlSurfaceProxyArray, 0);
    }

    private int computeFirstPagePosition() {
        if (this.mScrollPositionThatPageShouldAlignTo > 0 && this.mScrollPositionThatPageShouldAlignTo % this.mSize != 0) {
            int n2 = this.mScrollPositionThatPageShouldAlignTo - (this.mScrollPositionThatPageShouldAlignTo / this.mSize + 1) * this.mSize;
            assert (this.UB2(n2 < 0));
            assert (this.UB2(-n2 < this.mSize));
            return n2;
        }
        return 0;
    }

    @Override
    public Class getTargetType() {
        return BankTarget.class;
    }

    public void setSizeOfBank(int n2) {
        this.newSince(7);
        this.inRange(n2, 0, this.getCapacityOfBank(), "size");
        if (n2 == this.mSizeOnControllerThread) {
            return;
        }
        this.mSizeOnControllerThread = n2;
        this.exec(() -> this.doSetSizeOfBank(n2));
    }

    private void doSetSizeOfBank(int n2) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(n2 != this.mSize));
        this.mSize = n2;
        this.mFirstPagePosition = this.computeFirstPagePosition();
        this.updateItemTargets();
    }

    public int getSizeOfBank() {
        return this.isDocumentThread() ? this.mSize : this.mSizeOnControllerThread;
    }

    public int getCapacityOfBank() {
        this.newSince(7);
        return this.mItemProxies.length;
    }

    public HardwareActionBindable scrollBackwardsAction() {
        return new DocumentAction((ControlSurfaceObject)this, this::scrollBackwards);
    }

    public HardwareActionBindable scrollForwardsAction() {
        return new DocumentAction((ControlSurfaceObject)this, this::scrollForwards);
    }

    public HardwareActionBindable scrollPageBackwardsAction() {
        return new DocumentAction((ControlSurfaceObject)this, this::scrollPageBackwards);
    }

    public HardwareActionBindable scrollPageForwardsAction() {
        return new DocumentAction((ControlSurfaceObject)this, this::scrollPageForwards);
    }

    public ControlSurfaceProxy getItemAt(int n2) {
        this.inRange(n2, 0, this.getSizeOfBank(), "index");
        return (ControlSurfaceProxy)this.returnArrayItem(this.mItemProxies, n2);
    }

    public void scrollTo(int n2) {
        this.postEvent(nQn.Ivg(this, Math.max(0, n2)));
    }

    public void scrollIntoView(int n2) {
        this.postEvent(nQn.OSp(this, Math.max(0, n2)));
    }

    public void doScrollTo(int n2, boolean bl2) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(n2 >= 0));
        if (n2 >= this.mListItemCount.getValue()) {
            return;
        }
        if (this.mMasterScrollPositionBankUpdater != null) {
            this.mMasterScrollPositionBankUpdater.doScrollTo(n2, bl2);
        } else {
            this.doScrollToImpl(n2, bl2);
        }
    }

    protected int getQuantizedPagePositionThatIncludesItem(int n2, int n3) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(n2 >= 0 && n2 < n3));
        assert (this.UB2(n3 > 0));
        if (n3 == 0) {
            return 0;
        }
        int n4 = this.mSize;
        assert (this.UB2(n4 > 0));
        if (n4 == 0) {
            return 0;
        }
        int n5 = this.getPageIndexContainingIndex(n2);
        int n6 = this.getPageStartIndex(n5);
        int n7 = (n3 - 1) / n4 * n4;
        int n8 = Syh.Ivg(n6, 0, n7);
        assert (this.UB2(n8 >= 0));
        assert (this.UB2(n8 <= n2));
        assert (this.UB2(n8 + n4 >= n2));
        return n8;
    }

    private void doScrollToImpl(int n2, boolean bl2) {
        assert (this.UB2(this.isDocumentThread()));
        int n3 = bl2 ? this.mListItemCount.getValue() - 1 : this.mListItemCount.getValue() - this.mSize;
        int n4 = Syh.Ivg(n2, 0, Math.max(0, n3));
        List list = this.getPossibleTargets();
        int n5 = -1;
        for (int i2 = 0; i2 < this.mSize; ++i2) {
            Object object;
            ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[i2];
            int n6 = n4 + i2;
            if (n6 < list.size()) {
                object = (Oac)list.get(n6);
                controlSurfaceProxy.setTarget(object);
                if (this.mCursor != null && this.mCursor == object) {
                    n5 = i2;
                }
            } else {
                controlSurfaceProxy.clearTarget();
            }
            if (!(controlSurfaceProxy instanceof BankItemWithPosition)) continue;
            object = ((BankItemWithPosition)((Object)controlSurfaceProxy)).getBankItemPosition();
            ((ComputedIntegerValue)object).setIntegerValue(n6);
        }
        if (this.mScrollPositionSlaves != null) {
            for (ControlSurfaceProxy controlSurfaceProxy : this.mScrollPositionSlaves) {
                ((BankItemTargetUpdater)controlSurfaceProxy).doScrollToImpl(n4, bl2);
            }
        }
        this.mScrollPosition.setIntegerValue(n4);
        if (n5 >= 0) {
            this.mCursorIndex.setIntegerValue(n5);
        } else {
            this.mCursorIndex.unassigned();
        }
        this.mCanScrollForwards.setBoolValue(n4 + this.getSizeOfBank() < list.size());
        this.mCanScrollBackwards.setBoolValue(n4 > 0);
    }

    public void scrollForwards() {
        this.scrollBy(1);
    }

    public void scrollBackwards() {
        this.scrollBy(-1);
    }

    public void scrollBy(int n2) {
        if (n2 != 0) {
            this.postEvent(nQn.Ivg(this, n2, Math.abs(n2) > 1));
        }
    }

    public void doScrollForwards() {
        this.doScrollBy(1, false);
    }

    public void doScrollBackwards() {
        this.doScrollBy(-1, false);
    }

    public void doScrollPageForwards() {
        this.doScrollBy(this.mSize, true);
    }

    public void doScrollPageBackwards() {
        this.doScrollBy(-this.mSize, true);
    }

    public void doScrollBy(int n2, boolean bl2) {
        assert (this.UB2(this.isDocumentThread()));
        this.doScrollTo(Math.max(0, this.mScrollPosition.getValue() + n2), bl2);
    }

    public void doScrollByPages(int n2, boolean bl2) {
        assert (this.UB2(this.isDocumentThread()));
        int n3 = n2 < 0 && !this.isQuantizedToPageStart() ? n2 + 1 : n2;
        int n4 = this.getCurrentPageIndex();
        int n5 = Math.max(0, n4 + n3);
        int n6 = this.getPageStartIndex(n5);
        this.doScrollTo(n6, bl2);
    }

    public void scrollPageForwards() {
        this.scrollByPages(1);
    }

    public void scrollPageBackwards() {
        this.scrollByPages(-1);
    }

    public void scrollByPages(int n2) {
        assert (this.UB2(this.isControlSurfaceThread()));
        if (n2 != 0) {
            this.postEvent(nQn.OSp(this, n2, true));
        }
    }

    public ControlSurfaceProxy[] getItemProxies() {
        return this.mItemProxies;
    }

    public BooleanValue getCanScrollForwards() {
        return this.mCanScrollForwards;
    }

    public BooleanValue getCanScrollBackwards() {
        return this.mCanScrollBackwards;
    }

    public IntegerValue getListItemCount() {
        return this.mListItemCount;
    }

    public BankScrollPosition getScrollPosition() {
        return this.mScrollPosition;
    }

    public int getScrollPositionValue() {
        assert (this.UB2(this.isDocumentThread()));
        return this.mScrollPosition.getValue();
    }

    public final void possibleTargetsChanged() {
        assert (this.UB2(this.isDocumentThread()));
        if (!this.mHasScheduledUpdate) {
            this.mHasScheduledUpdate = true;
            this.runAtEndOfEvent(this::updateItemTargets);
        }
    }

    private void updateItemTargets() {
        assert (this.UB2(this.isDocumentThread()));
        List list = this.getPossibleTargets();
        this.updateItemTargets(list);
        this.mHasScheduledUpdate = false;
    }

    public void setTarget(tmO tmO2) {
        this.setTarget(BankTarget.create(tmO2));
    }

    public void setTarget(List list) {
        this.setTarget(BankTarget.create(list));
    }

    protected void connectToTarget(BankTarget bankTarget) {
        this.updateItemTargets();
        bankTarget.setItemsChangedListener(this::possibleTargetsChanged);
    }

    protected void disconnectFromTarget(BankTarget bankTarget) {
        bankTarget.setItemsChangedListener(null);
        for (ControlSurfaceProxy controlSurfaceProxy : this.mItemProxies) {
            controlSurfaceProxy.clearTarget();
        }
    }

    private List getPossibleTargets() {
        assert (this.UB2(this.isDocumentThread()));
        BankTarget bankTarget = (BankTarget)this.getTarget();
        if (bankTarget != null) {
            return bankTarget.listItems();
        }
        return Collections.EMPTY_LIST;
    }

    private void updateItemTargets(List list) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(list != null));
        int n2 = list.size() <= this.mSize ? 0 : this.determineNewOffset(list);
        assert (this.UB2(n2 >= 0));
        assert (this.UB2(list.isEmpty() ? n2 == 0 : n2 < list.size()));
        int n3 = -1;
        for (int i2 = 0; i2 < this.mItemProxies.length; ++i2) {
            Object object;
            ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[i2];
            int n4 = n2 + i2;
            if (n4 < list.size()) {
                object = (Oac)list.get(n4);
                if (object != controlSurfaceProxy.getTarget()) {
                    controlSurfaceProxy.setTarget(object);
                }
                if (this.mCursor != null && object == this.mCursor) {
                    n3 = i2;
                }
            } else if (controlSurfaceProxy.getTarget() != null) {
                controlSurfaceProxy.clearTarget();
            }
            if (!(controlSurfaceProxy instanceof BankItemWithPosition)) continue;
            object = (BankItemWithPosition)((Object)controlSurfaceProxy);
            ComputedIntegerValue computedIntegerValue = object.getBankItemPosition();
            computedIntegerValue.setIntegerValue(n4);
        }
        BankTarget bankTarget = (BankTarget)this.getTarget();
        if (bankTarget != null) {
            this.mScrollPosition.setIntegerValue(n2);
            this.mListItemCount.setIntegerValue(list.size());
            this.mCanScrollForwards.setBoolValue(n2 + this.getSizeOfBank() < list.size());
            this.mCanScrollBackwards.setBoolValue(n2 > 0);
        } else {
            this.mScrollPosition.unassigned();
            this.mListItemCount.unassigned();
            this.mCanScrollForwards.unassigned();
            this.mCanScrollBackwards.unassigned();
        }
        if (n3 >= 0) {
            this.mCursorIndex.setIntegerValue(n3);
        } else {
            this.mCursorIndex.unassigned();
        }
    }

    private int determineNewOffset(List list) {
        assert (this.UB2(list.size() >= this.mSize));
        assert (this.UB2(this.isDocumentThread()));
        for (ControlSurfaceProxy controlSurfaceProxy : this.mItemProxies) {
            int n2;
            Oac oac = (Oac)controlSurfaceProxy.getTarget();
            if (oac == null || (n2 = list.indexOf(oac)) < 0) continue;
            return this.getQuantizedPagePositionThatIncludesItem(n2, list.size());
        }
        return Syh.Ivg(this.mScrollPosition.getValue(), 0, list.size() - 1);
    }

    public void addScrollPositionSlave(BankItemTargetUpdater bankItemTargetUpdater) {
        assert (this.UB2(bankItemTargetUpdater != null));
        assert (this.UB2(this.isControlSurfaceThread()));
        assert (this.UB2(this.isInitializingDriver()));
        if (this.mScrollPositionSlaves == null) {
            this.mScrollPositionSlaves = new ArrayList(8);
        }
        this.mScrollPositionSlaves.add(bankItemTargetUpdater);
        assert (this.UB2(bankItemTargetUpdater.mMasterScrollPositionBankUpdater == null));
        bankItemTargetUpdater.mMasterScrollPositionBankUpdater = this;
    }

    public void removeScrollPositionSlave(BankItemTargetUpdater bankItemTargetUpdater) {
        assert (this.UB2(bankItemTargetUpdater != null));
        assert (this.UB2(this.isControlSurfaceThread()));
        assert (this.UB2(this.isInitializingDriver()));
        assert (this.UB2(this.mScrollPositionSlaves != null));
        if (this.mScrollPositionSlaves != null) {
            assert (this.UB2(this.mScrollPositionSlaves.contains(bankItemTargetUpdater)));
            this.mScrollPositionSlaves.remove(bankItemTargetUpdater);
            assert (this.UB2(bankItemTargetUpdater.mMasterScrollPositionBankUpdater == this));
            bankItemTargetUpdater.mMasterScrollPositionBankUpdater = null;
        }
    }

    @Override
    public Oac getFirstItem(Oac oac) {
        assert (this.UB2(this.isDocumentThread()));
        List list = this.getPossibleTargets();
        if (!list.isEmpty()) {
            return (Oac)list.get(0);
        }
        return null;
    }

    @Override
    public Oac getLastItem(Oac oac) {
        assert (this.UB2(this.isDocumentThread()));
        List list = this.getPossibleTargets();
        if (!list.isEmpty()) {
            return (Oac)list.get(list.size() - 1);
        }
        return null;
    }

    @Override
    public Oac getPreviousItem(Oac oac) {
        assert (this.UB2(this.isDocumentThread()));
        List list = this.getPossibleTargets();
        if (oac == null) {
            if (!list.isEmpty()) {
                return (Oac)list.get(0);
            }
            return null;
        }
        int n2 = list.indexOf(oac);
        if (n2 > 0) {
            return (Oac)list.get(n2 - 1);
        }
        return null;
    }

    @Override
    public Oac getNextItem(Oac oac) {
        assert (this.UB2(this.isDocumentThread()));
        List list = this.getPossibleTargets();
        if (oac == null) {
            if (!list.isEmpty()) {
                return (Oac)list.get(0);
            }
            return null;
        }
        int n2 = list.indexOf(oac);
        if (n2 + 1 < list.size()) {
            return (Oac)list.get(n2 + 1);
        }
        return null;
    }

    protected void cursorMovedToItem(Oac oac) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(this.mCursorProxyToFollow != null));
        this.mCursor = oac;
        if (oac != null) {
            Object object;
            Object object2 = this.getParent();
            if (object2 instanceof SiblingTrackBankProxy) {
                SiblingTrackBankProxy siblingTrackBankProxy = (SiblingTrackBankProxy)object2;
                object2 = this.mCursor.L_();
                if (object2 instanceof R1k) {
                    object = (R1k)object2;
                    siblingTrackBankProxy.setTarget((Oac)object);
                }
            }
            this.doScrollToItem(oac);
            int n2 = -1;
            for (int i2 = 0; i2 < this.mSize; ++i2) {
                object = this.mItemProxies[i2];
                Oac oac2 = (Oac)((ControlSurfaceProxy)object).getTarget();
                if (oac2 != oac) continue;
                n2 = i2;
                break;
            }
            if (n2 >= 0) {
                this.mCursorIndex.setIntegerValue(n2);
            } else {
                this.mCursorIndex.unassigned();
            }
        } else {
            this.mCursorIndex.unassigned();
        }
    }

    public void doScrollToItem(Oac oac) {
        assert (this.UB2(oac != null));
        assert (this.UB2(this.isDocumentThread()));
        List list = this.getPossibleTargets();
        int n2 = list.indexOf(oac);
        if (n2 >= 0) {
            this.doScrollIntoView(n2, list.size(), true);
        }
    }

    public void doScrollIntoView(int n2) {
        assert (this.UB2(n2 >= 0));
        assert (this.UB2(this.isDocumentThread()));
        this.doScrollIntoView(n2, true);
    }

    public void doScrollIntoView(int n2, boolean bl2) {
        assert (this.UB2(n2 >= 0));
        assert (this.UB2(this.isDocumentThread()));
        List list = this.getPossibleTargets();
        this.doScrollIntoView(n2, list.size(), bl2);
    }

    private void doScrollIntoView(int n2, int n3, boolean bl2) {
        assert (this.UB2(n2 >= 0));
        assert (this.UB2(this.isDocumentThread()));
        int n4 = this.mScrollPosition.getValue();
        if (n2 < n4 || n2 >= n4 + this.mSize) {
            int n5 = this.getQuantizedPagePositionThatIncludesItem(n2, n3);
            assert (this.UB2(n2 >= n5 && n2 < n5 + this.mSize));
            this.doScrollTo(n5, bl2);
        }
    }

    public void followCursorProxy(ControlSurfaceCursorProxy controlSurfaceCursorProxy) {
        this.notNull(controlSurfaceCursorProxy, "cursor");
        this.checkIsInitializingDriver();
        if (this.mCursorProxyToFollow != null) {
            throw new QWx("This bank is already following a cursor");
        }
        this.mCursorProxyToFollow = controlSurfaceCursorProxy;
        controlSurfaceCursorProxy.addBankFollowingCursor(this);
    }

    public SettableIntegerValue getCursorIndex() {
        assert (this.UB2(this.mCursorIndex != null));
        return this.mCursorIndex;
    }

    protected void moveCursorIndexTo(int n2) {
        assert (this.UB2(this.isControlSurfaceThread()));
        assert (this.UB2(n2 >= 0 && n2 < this.getSizeOfBank()));
        if (this.mCursorProxyToFollow == null) {
            throw new QWx("This bank is not following any cursor");
        }
        this.exec(() -> this.doMoveCursorToIndex(n2));
    }

    public void doMoveCursorToIndex(int n2) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(n2 >= 0 && n2 < this.getSizeOfBank()));
        assert (this.UB2(this.mCursorProxyToFollow != null));
        ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[n2];
        Oac oac = (Oac)controlSurfaceProxy.getTarget();
        if (oac != null) {
            this.mCursorProxyToFollow.doSelect(oac);
        }
    }

    protected void moveCursorIndexBy(int n2) {
        assert (this.UB2(this.isControlSurfaceThread()));
        if (this.mCursorProxyToFollow == null) {
            throw new QWx("This bank is not following any cursor");
        }
        if (n2 != 0) {
            this.exec(() -> this.doMoveCursorIndexBy(n2));
        }
    }

    private void doMoveCursorIndexBy(int n2) {
        int n3;
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(n2 != 0));
        assert (this.UB2(this.mCursorProxyToFollow != null));
        int n4 = this.mCursorIndex.getValue();
        assert (this.UB2(n4 >= 0 && n4 < this.getSizeOfBank() || n4 == -1));
        if (n4 >= 0 && n4 < this.getSizeOfBank() && (n3 = n4 + n2) >= 0 && n3 < this.getSizeOfBank()) {
            this.doMoveCursorToIndex(n3);
        }
    }

    public mgC getDocument() {
        for (ControlSurfaceProxy controlSurfaceProxy : this.getItemProxies()) {
            mgC mgC2;
            Oac oac = (Oac)controlSurfaceProxy.getTarget();
            if (oac == null || (mgC2 = (mgC)oac.ZAb(mgC.class)) == null) continue;
            return mgC2;
        }
        return null;
    }

    private int getPageStartIndex(int n2) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(n2 >= 0));
        int n3 = Math.max(0, this.mFirstPagePosition + n2 * this.mSize);
        return n3;
    }

    private int getPageIndexContainingIndex(int n2) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(n2 >= 0));
        assert (this.UB2(this.mSize > 0));
        if (this.mSize == 0) {
            return 0;
        }
        int n3 = (n2 - this.mFirstPagePosition) / this.mSize;
        assert (this.UB2(n2 >= this.getPageStartIndex(n3)));
        assert (this.UB2(n2 <= this.getPageStartIndex(n3) + this.mSize - 1));
        assert (this.UB2(n3 >= 0));
        return n3;
    }

    private int getCurrentPageIndex() {
        assert (this.UB2(this.isDocumentThread()));
        return this.getPageIndexContainingIndex(this.mScrollPosition.getValue());
    }

    private boolean isQuantizedToPageStart() {
        assert (this.UB2(this.isDocumentThread()));
        return this.mScrollPosition.getValue() == this.getPageStartIndex(this.getCurrentPageIndex());
    }
}

