/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.callback.ColorValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.callback.NotePlaybackCallback;
import com.bitwig.extension.callback.StringValueChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.Channel;
import com.bitwig.extension.controller.api.HardwareActionBindable;
import com.bitwig.extension.controller.api.HardwareControlType;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.Send;
import com.bitwig.extension.controller.api.SettableBooleanValue;
import com.bitwig.extension.controller.api.SettableColorValue;
import com.bitwig.extension.controller.api.SettableStringValue;
import com.bitwig.extension.controller.api.SoloValue;
import com.bitwig.extension.controller.api.StringValue;
import com.bitwig.flt.control_surface.proxy.AbstractChannelProxy$1;
import com.bitwig.flt.control_surface.proxy.AbstractChannelProxy$2;
import com.bitwig.flt.control_surface.proxy.AbstractChannelProxy$VuMeterObserver;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.DeviceChainProxy;
import com.bitwig.flt.control_surface.proxy.DocumentAction;
import com.bitwig.flt.control_surface.proxy.SendBankProxy;
import com.bitwig.flt.control_surface.values.BooleanValueAtomProxy;
import com.bitwig.flt.control_surface.values.BooleanValueProxy;
import com.bitwig.flt.control_surface.values.ComputedPlayingNoteArrayValue;
import com.bitwig.flt.control_surface.values.ComputedStringValue;
import com.bitwig.flt.control_surface.values.IntegerValueProxy;
import com.bitwig.flt.control_surface.values.PlayingNote;
import com.bitwig.flt.control_surface.values.RemappableParameterProxy;
import com.bitwig.flt.control_surface.values.SettableBooleanValueProxy;
import com.bitwig.flt.control_surface.values.SettableColorValueProxy;
import com.bitwig.flt.control_surface.values.SettableStringValueProxy;
import com.bitwig.flt.control_surface.values.SoloProxy;
import com.bitwig.flt.document.core.iface.PhH;
import com.bitwig.flt.document.core.iface.mgC;
import com.bitwig.flt.document.core.iface.mii;
import com.bitwig.ramona.core.Oac;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractChannelProxy
extends DeviceChainProxy
implements Channel {
    protected final SettableBooleanValueProxy mIsActivated;
    protected final BooleanValueAtomProxy mMute;
    protected final SoloProxy mSolo;
    protected final Map mPlayingNotes = new HashMap();
    protected final ComputedPlayingNoteArrayValue mPlayingNotesValue;
    protected final RemappableParameterProxy mVolume;
    protected final RemappableParameterProxy mPan;
    protected final SettableColorValueProxy mColor;
    private final SettableStringValueProxy mNameProxy;
    protected final SendBankProxy mSendBankProxy;
    private final List mNotePlaybackCallbacks = new ArrayList();
    private bnp mNoteObserverAtom;
    private final QIj mNotePlaybackListener = gkN2 -> this.notePlayed(gkN2.oHp(), gkN2.UB2(), gkN2.ZAb());
    private boolean mHasScheduledUpdatePlayingNotes = false;
    private final BooleanValueProxy mIsMutedBySolo;
    private final ComputedStringValue mChannelId;
    private IntegerValueProxy mChannelIndex;

    public AbstractChannelProxy(ControlSurfaceObject controlSurfaceObject, String string, int n2, int n3) {
        super(controlSurfaceObject, string);
        this.mNameProxy = new SettableStringValueProxy(this);
        this.mChannelId = new ComputedStringValue(this);
        this.mChannelIndex = new IntegerValueProxy(this);
        this.mIsActivated = new SettableBooleanValueProxy((ControlSurfaceObject)this, true);
        this.mMute = new BooleanValueAtomProxy(this);
        this.mPan = new RemappableParameterProxy((ControlSurfaceObject)this, string + "/Pan");
        this.mPan.setHardwareControlType(HardwareControlType.KNOB);
        this.mVolume = new RemappableParameterProxy((ControlSurfaceObject)this, string + "/Volume");
        this.mVolume.setHardwareControlType(HardwareControlType.SLIDER);
        this.mSolo = new SoloProxy(this);
        this.mColor = new SettableColorValueProxy(this);
        this.mPlayingNotesValue = new ComputedPlayingNoteArrayValue(this);
        this.mIsMutedBySolo = new BooleanValueProxy((ControlSurfaceObject)this, false);
        this.addChild(this.mIsActivated);
        this.addChild(this.mMute);
        this.addChild(this.mSolo);
        this.addChild(this.mVolume);
        this.addChild(this.mPan);
        this.addChild(this.mPlayingNotesValue);
        this.mVolume.setIndexInGroup(n2);
        this.mPan.setIndexInGroup(n2);
        this.mSendBankProxy = n3 > 0 ? new SendBankProxy(this, string + "/Send/", n3, n2) : null;
    }

    @Override
    protected int getNumSends() {
        return this.mSendBankProxy != null ? this.mSendBankProxy.getSizeOfBank() : 0;
    }

    @Override
    public void select() {
        this.selectInEditor();
    }

    @Override
    public void duplicate() {
        this.exec(() -> {
            qYw qYw2;
            if (this.getTarget() != null && (qYw2 = this.getEditorChannelSelection((mii)this.getTarget())) != null) {
                qYw2.QCa((Oac)this.getTarget());
                qYw2.VDg();
                if (qYw2.ZiK()) {
                    qYw2.iXp();
                }
            }
        });
    }

    @Override
    public StringValue channelId() {
        this.newSince(20);
        return this.mChannelId;
    }

    @Override
    public IntegerValue channelIndex() {
        this.newSince(22);
        return this.mChannelIndex;
    }

    @Override
    public SettableBooleanValue isActivated() {
        return this.mIsActivated;
    }

    @Override
    public RemappableParameterProxy getVolume() {
        this.deprecated(1, 5, "Use volume() instead");
        return this.mVolume;
    }

    @Override
    public RemappableParameterProxy volume() {
        this.newSince(5);
        return this.mVolume;
    }

    @Override
    public RemappableParameterProxy getPan() {
        this.deprecated(1, 5, "Use pan() instead");
        return this.mPan;
    }

    @Override
    public RemappableParameterProxy pan() {
        this.newSince(5);
        return this.mPan;
    }

    @Override
    public SettableBooleanValue getMute() {
        this.deprecated(1, 5, "Use mute() instead");
        return this.mMute;
    }

    @Override
    public SettableBooleanValue mute() {
        this.newSince(5);
        return this.mMute;
    }

    @Override
    public SoloProxy getSolo() {
        this.deprecated(1, 5, "Use solo() instead");
        return this.mSolo;
    }

    @Override
    public SoloValue solo() {
        this.newSince(5);
        return this.mSolo;
    }

    @Override
    public BooleanValue isMutedBySolo() {
        this.newSince(10);
        return this.mIsMutedBySolo;
    }

    @Override
    public SendBankProxy sendBank() {
        if (this.mSendBankProxy == null) {
            throw new QWx("No send bank exists: Requested a send bank size of 0");
        }
        return this.mSendBankProxy;
    }

    public SendBankProxy getSendBankOnDocumentThread() {
        assert (this.Ivg(this.isDocumentThread()));
        return this.mSendBankProxy;
    }

    @Override
    public Send getSend(int n2) {
        if (this.mSendBankProxy == null) {
            if (this.getRequiredApiVersion() == 1) {
                return null;
            }
            throw new QWx("No send bank exists: Requested a send bank size of 0");
        }
        return this.mSendBankProxy.getItemAt(n2);
    }

    @Override
    public SettableStringValue name() {
        this.newSince(2);
        return this.mNameProxy;
    }

    @Override
    public void addNameObserver(int n2, String string, StringValueChangedCallback stringValueChangedCallback) {
        this.deprecated(1, 2, "Use name() instead");
        this.mNameProxy.addValueObserver(n2, string, stringValueChangedCallback);
    }

    @Override
    public void addVuMeterObserver(int n2, int n3, boolean bl2, IntegerValueChangedCallback integerValueChangedCallback) {
        if (n3 < -1 || n3 > 1) {
            throw new QWx("No such channel.");
        }
        this.addObserver(new AbstractChannelProxy$VuMeterObserver(this.getControlSurface(), integerValueChangedCallback, n2, n3, bl2));
    }

    @Override
    public ComputedPlayingNoteArrayValue playingNotes() {
        return this.mPlayingNotesValue;
    }

    @Override
    public void addNoteObserver(NotePlaybackCallback notePlaybackCallback) {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.checkIsInitializingDriver();
        this.notNull(notePlaybackCallback, "callback");
        this.mNotePlaybackCallbacks.add(notePlaybackCallback);
    }

    private void notePlayed(boolean bl2, int n2, float f2) {
        assert (this.UB2(this.isDocumentThread()));
        if (!this.mNotePlaybackCallbacks.isEmpty()) {
            this.queueCallback(() -> this.notifyNotePlayed(bl2, n2, f2));
        }
        if (!this.mPlayingNotesValue.isInterested()) {
            return;
        }
        if (bl2) {
            this.mPlayingNotes.put(n2, new PlayingNote(n2, (int)(127.0f * f2)));
        } else {
            this.mPlayingNotes.remove(n2);
        }
        this.invalidatePlayingNotes();
    }

    private void invalidatePlayingNotes() {
        assert (this.Ivg(this.isDocumentThread()));
        if (!this.mHasScheduledUpdatePlayingNotes) {
            this.mHasScheduledUpdatePlayingNotes = true;
            this.runAtEndOfEvent(this::updatePlayingNotes);
        }
    }

    private void updatePlayingNotes() {
        assert (this.Ivg(this.isDocumentThread()));
        this.mHasScheduledUpdatePlayingNotes = false;
        PlayingNote[] playingNoteArray = this.mPlayingNotes.values().toArray(new PlayingNote[0]);
        this.mPlayingNotesValue.setValue(playingNoteArray);
    }

    private void notifyNotePlayed(boolean bl2, int n2, float f2) {
        assert (this.UB2(this.isControlSurfaceThread()));
        for (NotePlaybackCallback notePlaybackCallback : this.mNotePlaybackCallbacks) {
            notePlaybackCallback.notePlaybackEventOccurred(bl2, n2, f2);
        }
    }

    @Override
    public void addColorObserver(ColorValueChangedCallback colorValueChangedCallback) {
        this.deprecated(1, 2, "Use color().addValueObserver(callback)");
        this.mColor.addValueObserver(colorValueChangedCallback);
    }

    @Override
    public SettableColorValue color() {
        this.newSince(2);
        return this.mColor;
    }

    public RjR getColor() {
        qFC qFC2 = this.mColor.getEditableValue();
        if (qFC2 != null) {
            return (RjR)qFC2.getValue();
        }
        return null;
    }

    protected abstract qYw getEditorChannelSelection(mii var1);

    protected qYw getMixerChannelSelection() {
        mgC mgC2 = this.getDocument();
        if (mgC2 != null) {
            return mgC2.uKS().ZAb();
        }
        return null;
    }

    @Override
    public void addIsSelectedInEditorObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.addObserver(new AbstractChannelProxy$1(this, this.getControlSurface(), booleanValueChangedCallback));
    }

    @Override
    public void addIsSelectedInMixerObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.addObserver(new AbstractChannelProxy$2(this, this.getControlSurface(), booleanValueChangedCallback));
    }

    @Override
    public void selectInEditor() {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.exec(this::doSelectInEditor);
    }

    private void doSelectInEditor() {
        qYw qYw2;
        assert (this.UB2(this.isDocumentThread()));
        QZ qZ2 = this.getDocumentGUIWrapper();
        if (qZ2 != null && this.getTarget() != null && (qYw2 = this.getEditorChannelSelection((mii)this.getTarget())) != null) {
            qYw2.lXt((Oac)this.getTarget());
            this.showSelectionNotification();
        }
    }

    @Override
    public void selectInMixer() {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.exec(this::doSelectInMixer);
    }

    private void doSelectInMixer() {
        qYw qYw2;
        assert (this.UB2(this.isDocumentThread()));
        QZ qZ2 = this.getDocumentGUIWrapper();
        if (qZ2 != null && this.getTarget() != null && (qYw2 = this.getMixerChannelSelection()) != null) {
            qYw2.lXt((Oac)this.getTarget());
            this.showSelectionNotification();
        }
    }

    @Override
    public void makeVisibleInMixer() {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.exec(this::doMakeVisibleInMixer);
    }

    private void doMakeVisibleInMixer() {
        Rv rv2;
        assert (this.UB2(this.isDocumentThread()));
        if (this.getTarget() != null && (rv2 = this.getDocumentWidget()) != null) {
            List list = rv2.oHp(aIt.class, true);
            for (aIt aIt2 : list) {
                aIt2.Ivg((mii)this.getTarget());
            }
        }
    }

    @Override
    public void makeVisibleInArranger() {
        assert (this.UB2(this.isControlSurfaceThread()));
        this.exec(this::doMakeVisibleInArranger);
    }

    private void doMakeVisibleInArranger() {
        Rv rv2;
        assert (this.UB2(this.isDocumentThread()));
        if (this.getTarget() instanceof PhH && (rv2 = this.getDocumentWidget()) != null) {
            List list = rv2.oHp(Vj.class, true);
            for (Vj vj2 : list) {
                vj2.OSp((PhH)this.getTarget());
            }
        }
    }

    @Override
    protected String getName() {
        mii mii2 = (mii)this.getTarget();
        if (mii2 != null) {
            return mii2.dJJ();
        }
        return "(none)";
    }

    protected void connectToTarget(mii mii2) {
        assert (this.UB2(this.isDocumentThread()));
        assert (this.UB2(mii2 != null));
        assert (this.UB2(mii2.DOo()));
        this.mNameProxy.setTarget(mii2.Ldm(), mii2.QTg());
        this.mIsActivated.setTarget(mii2.KxJ());
        this.mColor.setTarget(mii2.Fy(), mii2.zRD());
        this.mChannelId.setValue(mii2.rr().toString());
        this.mChannelIndex.setTarget(mii2.bw_());
        TOm tOm = mii2.Fqp();
        if (tOm != null) {
            this.mMute.setTarget(tOm.Nyy());
            this.mSolo.setMixerModule(tOm);
            this.mVolume.setTargetAtom(tOm.lXt());
            this.mPan.setTargetAtom(tOm.onT());
            this.mIsMutedBySolo.setTarget(tOm.BXy());
        }
        this.mPlayingNotes.clear();
        this.invalidatePlayingNotes();
        if (this.mSendBankProxy != null) {
            this.mSendBankProxy.setTarget(mii2);
        }
        assert (this.UB2(this.mNoteObserverAtom == null));
        this.mNoteObserverAtom = mii2.Kyj();
        if (this.mNoteObserverAtom != null) {
            this.mNoteObserverAtom.oHp(this.mNotePlaybackListener);
            this.mNoteObserverAtom.EN().Ivg();
        }
        for (cEP cEP2 : this.getObservers()) {
            if (!(cEP2 instanceof AbstractChannelProxy$VuMeterObserver)) continue;
            AbstractChannelProxy$VuMeterObserver abstractChannelProxy$VuMeterObserver = (AbstractChannelProxy$VuMeterObserver)cEP2;
            int n2 = abstractChannelProxy$VuMeterObserver.mChannel;
            if (abstractChannelProxy$VuMeterObserver.mPeak) {
                abstractChannelProxy$VuMeterObserver.sendValue(((HZs)tOm.tGb().UB2().get(n2)).ZAb());
                ((HZs)tOm.tGb().UB2().get(n2)).oHp(abstractChannelProxy$VuMeterObserver);
                continue;
            }
            abstractChannelProxy$VuMeterObserver.sendValue(((HZs)tOm.tGb().UB2().get(n2)).Ivg());
            ((HZs)tOm.tGb().UB2().get(n2)).Ivg(abstractChannelProxy$VuMeterObserver);
        }
        this.setDeviceChain(mii2.tGb());
        this.connectObservers(mii2);
    }

    protected void disconnectFromTarget(mii mii2) {
        assert (this.UB2(this.getTarget() != null));
        if (this.mNoteObserverAtom != null) {
            this.mNoteObserverAtom.UB2(this.mNotePlaybackListener);
            this.mNoteObserverAtom.EN().UB2();
            this.mNoteObserverAtom = null;
        }
        this.mNameProxy.clearTarget();
        this.disconnectObservers(mii2);
        this.setDeviceChain(null);
        TOm tOm = ((mii)this.getTarget()).Fqp();
        if (this.mSendBankProxy != null) {
            this.mSendBankProxy.clearTarget();
        }
        for (cEP cEP2 : this.getObservers()) {
            if (!(cEP2 instanceof AbstractChannelProxy$VuMeterObserver)) continue;
            AbstractChannelProxy$VuMeterObserver abstractChannelProxy$VuMeterObserver = (AbstractChannelProxy$VuMeterObserver)cEP2;
            int n2 = abstractChannelProxy$VuMeterObserver.mChannel;
            HZs hZs = (HZs)tOm.tGb().UB2().get(n2);
            if (abstractChannelProxy$VuMeterObserver.mPeak) {
                hZs.UB2(abstractChannelProxy$VuMeterObserver);
            } else {
                hZs.OSp(abstractChannelProxy$VuMeterObserver);
            }
            abstractChannelProxy$VuMeterObserver.sendValue(0.0);
        }
        this.mChannelId.unassign();
        this.mChannelIndex.clearTarget();
        this.mIsActivated.clearTarget();
        this.mMute.clearTarget();
        this.mSolo.setMixerModule(null);
        this.mVolume.clearTarget();
        this.mPan.clearTarget();
        this.mColor.clearTarget();
        this.mIsMutedBySolo.clearTarget();
        this.mPlayingNotes.clear();
        this.invalidatePlayingNotes();
    }

    protected mii getChannel() {
        return (mii)this.getTarget();
    }

    @Override
    public void deleteObject() {
        assert (this.Ivg(this.isControlSurfaceThread()));
        this.newSince(10);
        this.getHost().deleteObjects("Delete Channel From Controller", this);
    }

    @Override
    public DocumentAction deleteObjectAction() {
        assert (this.onT(this.isControlSurfaceThread()));
        this.newSince(15);
        return this.getHost().deleteObjectsAction((ControlSurfaceObject)this, "Delete Channel From Controller", this);
    }

    @Override
    public void duplicateObject() {
        assert (this.Ivg(this.isControlSurfaceThread()));
        this.newSince(19);
        this.getHost().duplicateObjects("Duplicate Channel From Controller", this);
    }

    @Override
    public HardwareActionBindable duplicateObjectAction() {
        assert (this.Ivg(this.isControlSurfaceThread()));
        this.newSince(19);
        return this.getHost().duplicateObjectsAction((ControlSurfaceObject)this, "Duplicate Channel From Controller", this);
    }
}

