/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.opensoundcontrol;

import com.bitwig.extension.api.opensoundcontrol.OscBundle;
import com.bitwig.extension.api.opensoundcontrol.OscPacket;
import com.bitwig.flt.control_surface.opensoundcontrol.G3U;
import com.bitwig.flt.control_surface.opensoundcontrol.JqE;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

class mii {
    private ByteBuffer OSp = null;
    private byte[] oHp = null;

    mii() {
    }

    OscPacket Ivg(byte[] byArray, int n2, int n3) {
        try {
            this.oHp = byArray;
            this.OSp = ByteBuffer.wrap(byArray, n2, n3);
            this.OSp.order(ByteOrder.BIG_ENDIAN);
            return this.Ivg(null);
        }
        catch (IllegalArgumentException | BufferUnderflowException runtimeException) {
            return null;
        }
    }

    private OscPacket Ivg(OscBundle oscBundle) {
        String string = this.Ivg();
        if (string.equals("#bundle")) {
            return this.OSp(oscBundle);
        }
        return this.Ivg(oscBundle, string);
    }

    private String Ivg() {
        byte by2;
        int n2 = this.OSp.position();
        assert (bRL.Ivg(n2 % 4 == 0));
        while ((by2 = this.OSp.get()) != 0) {
        }
        String string = new String(this.oHp, n2, this.OSp.position() - n2 - 1);
        this.onT();
        return string;
    }

    private int OSp() {
        assert (bRL.Ivg(this.OSp.order() == ByteOrder.BIG_ENDIAN));
        return this.OSp.getInt();
    }

    private long oHp() {
        assert (bRL.Ivg(this.OSp.order() == ByteOrder.BIG_ENDIAN));
        return this.OSp.getLong();
    }

    private float UB2() {
        return this.OSp.getFloat();
    }

    private double ZAb() {
        return this.OSp.getDouble();
    }

    private byte[] lXt() {
        int n2 = this.OSp();
        if (n2 < 0) {
            throw new IOException("Invalid blob size: " + n2);
        }
        byte[] byArray = new byte[n2];
        this.OSp.get(byArray);
        this.onT();
        return byArray;
    }

    private void onT() {
        int n2 = this.OSp.position() % 4;
        if (n2 != 0) {
            int n3 = this.OSp.position() + 4 - n2;
            this.OSp.position(n3);
        }
        assert (bRL.Ivg(this.OSp.position() % 4 == 0));
    }

    private G3U Ivg(OscBundle oscBundle, String string) {
        String string2 = this.Ivg();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (!string2.isEmpty() && string2.charAt(0) == ',') {
            block11: for (int i2 = 1; i2 < string2.length(); ++i2) {
                char c2 = string2.charAt(i2);
                switch (c2) {
                    case 'F': {
                        arrayList.add(false);
                        continue block11;
                    }
                    case 'T': {
                        arrayList.add(true);
                        continue block11;
                    }
                    case 'N': {
                        arrayList.add(null);
                        continue block11;
                    }
                    case 'i': {
                        arrayList.add(this.OSp());
                        continue block11;
                    }
                    case 'h': {
                        arrayList.add(this.oHp());
                        continue block11;
                    }
                    case 'f': {
                        arrayList.add(Float.valueOf(this.UB2()));
                        continue block11;
                    }
                    case 'd': {
                        arrayList.add(this.ZAb());
                        continue block11;
                    }
                    case 'b': {
                        arrayList.add(this.lXt());
                        continue block11;
                    }
                    case 's': {
                        arrayList.add(this.Ivg());
                        continue block11;
                    }
                    default: {
                        i2 = string2.length();
                    }
                }
            }
        }
        return new G3U(oscBundle, string, string2, arrayList);
    }

    private JqE OSp(OscBundle oscBundle) {
        long l2 = this.oHp();
        JqE jqE = new JqE(oscBundle, l2);
        while (this.OSp.position() < this.OSp.limit()) {
            int n2 = this.OSp();
            if (this.OSp.limit() < this.OSp.position() + n2) {
                throw new IOException("OSC: Invalid Packet Size (" + n2 + ") which exceeds the packet by " + (this.OSp.position() + n2 - this.oHp.length) + " bytes.");
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.oHp, this.OSp.position(), n2);
            ByteBuffer byteBuffer2 = this.OSp;
            byteBuffer2.position(byteBuffer2.position() + n2);
            this.OSp = byteBuffer;
            OscPacket oscPacket = this.Ivg(jqE);
            jqE.Ivg(oscPacket);
            assert (bRL.Ivg(byteBuffer.position() <= byteBuffer2.position()));
            this.OSp = byteBuffer2;
        }
        return jqE;
    }
}

