/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.opensoundcontrol;

import com.bitwig.extension.api.opensoundcontrol.OscConnection;
import com.bitwig.extension.api.opensoundcontrol.OscPacket;
import com.bitwig.extension.api.opensoundcontrol.OscServer;
import com.bitwig.flt.control_surface.opensoundcontrol.AGq;
import com.bitwig.flt.control_surface.opensoundcontrol.JQ;
import com.bitwig.flt.control_surface.opensoundcontrol.mii;
import com.bitwig.flt.control_surface.opensoundcontrol.soX;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;

public class WPD
extends ControlSurfaceObject
implements OscServer {
    private final int OSp = 65536;
    private DatagramSocket oHp = null;
    private final AGq UB2;
    private Thread ZAb;
    private boolean lXt = false;
    private final byte[] onT = new byte[65536];
    private final mii Nyy = new mii();
    private final JQ tGb;

    WPD(ControlSurfaceObject controlSurfaceObject, AGq aGq2, JQ jQ2) {
        super(controlSurfaceObject);
        this.tGb = jQ2;
        this.UB2 = aGq2;
    }

    private void Ivg(int n2) {
        assert (this.Ivg(this.oHp == null));
        assert (this.Ivg(this.ZAb == null));
        this.lXt = false;
        this.oHp = new DatagramSocket(n2);
        this.ZAb = new Thread(this::OSp);
        this.ZAb.start();
    }

    private void OSp() {
        DatagramPacket datagramPacket = new DatagramPacket(this.onT, 65536);
        while (!this.lXt && !this.oHp.isClosed()) {
            try {
                this.oHp.receive(datagramPacket);
                OscPacket oscPacket = this.Nyy.Ivg(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength());
                if (oscPacket == null) continue;
                SocketAddress socketAddress = datagramPacket.getSocketAddress();
                vmU vmU2 = this.tGb.getHost().getControlSurface();
                vmU2.ZAb(() -> {
                    try {
                        soX soX2 = new soX(this, this, socketAddress);
                        this.UB2.Ivg((OscConnection)soX2, oscPacket);
                    }
                    catch (Throwable throwable) {
                        vmU2.Ivg(throwable);
                    }
                });
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (IOException iOException) {}
        }
    }

    public void Ivg() {
        this.lXt = true;
        byte[] byArray = new byte[]{0};
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.oHp.getLocalSocketAddress());
        try {
            this.oHp.send(datagramPacket);
        }
        catch (IOException iOException) {
            bRL.ZAb.OSp(iOException);
        }
        this.ZAb.interrupt();
        this.oHp.close();
        try {
            this.ZAb.join();
        }
        catch (InterruptedException interruptedException) {
            bRL.ZAb.OSp(interruptedException);
        }
        this.oHp = null;
        this.ZAb = null;
    }

    @Override
    public void start(int n2) {
        this.inRange(n2, 1024, 65535, "port");
        if (!this.isControlSurfaceThread()) {
            throw new QWx("OscServer.start() must be called from the control surface thread");
        }
        if (this.ZAb != null && this.oHp != null) {
            this.Ivg();
        }
        this.Ivg(n2);
    }
}

