/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.testing.WPD;
import com.bitwig.base.testing.rAn;
import com.bitwig.flt.app.testing.BitwigStudioTest;
import com.bitwig.flt.app.testing.TestItemSelection;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.TestTrack;
import com.bitwig.flt.app.testing.TestTrackGroup;
import com.bitwig.flt.document.core.master.ZZF;
import java.util.ArrayList;

@WPD(Ivg="Application")
public class TrackOperationTests
extends BitwigStudioTest {
    @Override
    public long getUndoCountLimit() {
        return 75L;
    }

    @rAn
    public void testTrackGrouping() {
        Object object;
        TestProject testProject = this.createTestProject(8, 0);
        ArrayList<TestTrack> arrayList = new ArrayList<TestTrack>();
        int n2 = 16;
        for (int i2 = 0; i2 < 16; ++i2) {
            object = testProject.Ivg(VSZ.OSp);
            arrayList.add((TestTrack)object);
        }
        TestItemSelection testItemSelection = testProject.kyS();
        testItemSelection.lXt();
        for (TestTrack testTrack : arrayList) {
            testItemSelection.Ivg(testTrack);
        }
        this.check("Created Tracks", testItemSelection.onT()).Ivg(16);
        testItemSelection.Nyy();
        object = (TestTrackGroup)this.cast(testProject.Nyy().OSp(0), TestTrackGroup.class);
        this.check("Tracks in TrackGroup", ((TestTrackGroup)object).Fqp()).Ivg(16);
    }

    @rAn
    public void testTrackGroupingAndUngrouping() {
        TestProject testProject = this.createTestProject(8, 0);
        ArrayList<TestTrack> arrayList = new ArrayList<TestTrack>();
        int n2 = 24;
        for (int i2 = 0; i2 < 24; ++i2) {
            TestTrack testTrack = testProject.Ivg(VSZ.OSp);
            arrayList.add(testTrack);
        }
        TestItemSelection testItemSelection = testProject.kyS();
        testItemSelection.lXt();
        for (TestTrack testTrackOrTrackGroup2 : arrayList) {
            testItemSelection.Ivg(testTrackOrTrackGroup2);
        }
        this.check("Created Tracks", testItemSelection.onT()).Ivg(24);
        int n3 = testProject.Nyy().Fqp();
        testItemSelection.Nyy();
        TestTrackGroup testTrackGroup = (TestTrackGroup)this.cast(testProject.Nyy().OSp(0), TestTrackGroup.class);
        testTrackGroup.V_();
        testItemSelection.tGb();
        int n4 = testProject.Nyy().Fqp();
        this.check("Tracks Before/After", n3).Ivg(n4);
    }

    @rAn
    public void testTrackRename() {
        this.testRenameTrack("Renamed");
    }

    @rAn
    public void testTrackRenameInvalid() {
        String string = new String(new char[]{'\ud800', 'H', 'E', 'L', 'L', 'O'});
        this.testRenameTrack(string);
    }

    @rAn
    public void testDuplicateTrackWithMidiAutomations() {
        TestProject testProject = this.createTestProject();
        TestTrack testTrack = testProject.Ivg(VSZ.Ivg);
        this.exec(() -> {
            int n2;
            QKi qKi = (QKi)testTrack.UB2();
            ZZF zZF = qKi.zny();
            zZF.Ivg("testDuplicateTrackWithMidiAutomations", false);
            for (int i2 = 0; i2 < 16; ++i2) {
                qKi.Ivg(i2, iDP.Ivg, 0);
                qKi.Ivg(i2, iDP.OSp, 0);
                for (n2 = 0; n2 < 128; ++n2) {
                    qKi.Ivg(i2, iDP.oHp, n2);
                }
            }
            YrE yrE = qKi.wWL();
            n2 = yrE.EN();
            for (int i3 = 0; i3 < n2; ++i3) {
                PIB pIB = yrE.ZAb(i3);
                lR lR2 = qKi.OSp((YqF)pIB);
                QKw qKw = lR2.HQa().glf();
                qKw.oHp(UsN.Ivg(0.0, 0.0));
                qKw.oHp(UsN.Ivg(16.0, 127.0));
            }
            zZF.Ivg(false);
        });
        testTrack.lXt();
        TestTrack testTrack2 = (TestTrack)testProject.Nyy().OSp(1);
        this.check("Duplicated Track Exists", testTrack2).zEU();
        this.check("Automation Lane Count", testTrack2.fjZ()).Ivg(testTrack.fjZ());
        this.exec(() -> {
            QKi qKi = (QKi)testTrack2.UB2();
            YrE yrE = qKi.wWL();
            for (int i2 = 0; i2 < 16; ++i2) {
                this.checkMidiParameterAutomation(qKi, yrE, i2, iDP.Ivg, 0);
                this.checkMidiParameterAutomation(qKi, yrE, i2, iDP.OSp, 0);
                for (int i3 = 0; i3 < 128; ++i3) {
                    this.checkMidiParameterAutomation(qKi, yrE, i2, iDP.oHp, i3);
                }
            }
        });
    }

    private void checkMidiParameterAutomation(QKi qKi, YrE yrE, int n2, iDP iDP2, int n3) {
        PIB pIB = yrE.OSp(n2, iDP2, n3);
        this.check("Has " + iDP2.OSp() + "/" + n3 + " Atom on channel " + n2, pIB).zEU();
        if (pIB == null) {
            return;
        }
        lR lR2 = qKi.OSp((YqF)pIB);
        this.check("Has " + iDP2.OSp() + "/" + n3 + " AutomationLane on channel " + n2, lR2).zEU();
    }

    private void testRenameTrack(String string) {
        TestProject testProject = this.createTestProject();
        TestTrack testTrack = testProject.Ivg(VSZ.Ivg);
        this.check(testTrack.onT()).onT();
        this.check(testTrack.Nyy()).Nyy();
        testTrack.OSp(string);
        this.check(testTrack.onT()).Ivg(string);
        this.check(testTrack.Nyy()).Ivg(string);
        this.check(testProject.x3R());
        this.check(!testProject.rr());
        testProject.Kyj();
        this.check(testTrack.onT()).onT();
        this.check(testTrack.Nyy()).Nyy();
        this.check(testProject.rr());
        testProject.EN();
        this.check(testTrack.onT()).Ivg(string);
        this.check(testTrack.Nyy()).Ivg(string);
    }
}

