/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.testing.rAn;
import com.bitwig.flt.app.testing.BitwigStudioIntegrationTest;
import com.bitwig.flt.app.testing.TestArrangementAutomationTimeline;
import com.bitwig.flt.app.testing.TestInstrumentNoteClipEvent;
import com.bitwig.flt.app.testing.TestInstrumentNoteEvent;
import com.bitwig.flt.app.testing.TestMatrixSlot;
import com.bitwig.flt.app.testing.TestNoteClipEvent;
import com.bitwig.flt.app.testing.TestNoteClipEventTimeline;
import com.bitwig.flt.app.testing.TestNoteEventTimeline;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.TestTimeSignatureEvent;
import com.bitwig.flt.app.testing.TestTimeSignatureTimeline;
import com.bitwig.flt.app.testing.TestTrack;
import com.bitwig.flt.app.testing.TestTransport;

public class SessionRecordingTests
extends BitwigStudioIntegrationTest {
    @Override
    public int getBlockSize() {
        return 1859;
    }

    @rAn(UB2=false)
    public void testRecordingEmptyInstrumentClipToArranger() {
        TestProject testProject = this.createTestProject(1, 0);
        testProject.kpx();
        TestTrack testTrack = testProject.Ivg(VSZ.Ivg);
        TestMatrixSlot testMatrixSlot = testTrack.oHp(0);
        TestInstrumentNoteClipEvent testInstrumentNoteClipEvent = (TestInstrumentNoteClipEvent)this.cast(testMatrixSlot.Nyy(), TestInstrumentNoteClipEvent.class);
        testInstrumentNoteClipEvent.Ivg(false, false);
        TestTransport testTransport = testProject.onT();
        double d2 = 150.0;
        testTransport.onT().Ivg(150.0);
        testTransport.OSp(0.0, 16.0);
        TestNoteClipEventTimeline testNoteClipEventTimeline = testTrack.QCa();
        this.check("clip count", testNoteClipEventTimeline.onT()).Ivg(1);
        TestInstrumentNoteClipEvent testInstrumentNoteClipEvent2 = (TestInstrumentNoteClipEvent)this.cast(testNoteClipEventTimeline.OSp(0), TestInstrumentNoteClipEvent.class);
        this.checkBeatTime("time", testInstrumentNoteClipEvent2.zEU()).Ivg(0.0);
        this.checkBeatTime("duration", testInstrumentNoteClipEvent2.tGb()).ZAb().OSp(16.0, this.getBlockBeatLength(150.0));
        testProject.Lea();
    }

    @rAn(UB2=false)
    public void testRecordingTimeSignatureChangesToArranger() {
        TestProject testProject = this.openTestProject("record-time-signature-changes-from-clip-launcher-to-arranger");
        testProject.kpx();
        TestTrack testTrack = testProject.Nyy().QCa();
        TestNoteClipEvent testNoteClipEvent = testTrack.oHp(0).onT();
        testNoteClipEvent.Ivg(false, false);
        TestTransport testTransport = testProject.onT();
        testTransport.OSp(0.0, 8.0);
        TestNoteClipEventTimeline testNoteClipEventTimeline = testTrack.QCa();
        this.check("clip count", testNoteClipEventTimeline.onT()).Ivg(2);
        TestInstrumentNoteClipEvent testInstrumentNoteClipEvent = (TestInstrumentNoteClipEvent)this.cast(testNoteClipEventTimeline.OSp(0), TestInstrumentNoteClipEvent.class);
        this.check("clip1 start time", testInstrumentNoteClipEvent.zEU()).Ivg(0.0);
        TestInstrumentNoteClipEvent testInstrumentNoteClipEvent2 = (TestInstrumentNoteClipEvent)this.cast(testNoteClipEventTimeline.OSp(1), TestInstrumentNoteClipEvent.class);
        this.checkBeatTime("clip2 start time", testInstrumentNoteClipEvent2.zEU()).Ivg(4.0);
        TestArrangementAutomationTimeline testArrangementAutomationTimeline = testTrack.OSp(testTransport.lXt());
        TestTimeSignatureTimeline testTimeSignatureTimeline = (TestTimeSignatureTimeline)this.cast(testArrangementAutomationTimeline.lXt(), TestTimeSignatureTimeline.class);
        this.check("event count", testTimeSignatureTimeline.onT()).Ivg(2);
        TestTimeSignatureEvent testTimeSignatureEvent = (TestTimeSignatureEvent)this.cast(testTimeSignatureTimeline.oHp(0), TestTimeSignatureEvent.class);
        this.checkBeatTime("time1", testTimeSignatureEvent.zEU()).Ivg(0.0);
        this.check("numerator1", testTimeSignatureEvent.onT()).Ivg(4);
        this.check("denominator1", testTimeSignatureEvent.Nyy()).Ivg(4);
        TestTimeSignatureEvent testTimeSignatureEvent2 = (TestTimeSignatureEvent)this.cast(testTimeSignatureTimeline.oHp(1), TestTimeSignatureEvent.class);
        this.check("time2", testTimeSignatureEvent2.zEU()).Ivg(4.0);
        this.check("numerator2", testTimeSignatureEvent2.onT()).Ivg(3);
        this.check("denominator2", testTimeSignatureEvent2.Nyy()).Ivg(4);
        testProject.Lea();
    }

    @rAn(UB2=false)
    public void testRecordingClipWithStartMarkerNotAtTimeZero() {
        TestProject testProject = this.createTestProject(1, 0);
        testProject.kpx();
        TestTrack testTrack = testProject.Ivg(VSZ.Ivg);
        TestMatrixSlot testMatrixSlot = testTrack.oHp(0);
        TestInstrumentNoteClipEvent testInstrumentNoteClipEvent = (TestInstrumentNoteClipEvent)this.cast(testMatrixSlot.Nyy(), TestInstrumentNoteClipEvent.class);
        double d2 = 2.75;
        int n2 = 40;
        double d3 = 1.0;
        testInstrumentNoteClipEvent.Ivg(2.75);
        testInstrumentNoteClipEvent.Ivg(xl.UB2(2.75, 1.0), 0, 40);
        testInstrumentNoteClipEvent.Ivg(false, false);
        TestTransport testTransport = testProject.onT();
        double d4 = 150.0;
        testTransport.onT().Ivg(150.0);
        testTransport.OSp(0.0, 16.0);
        TestNoteClipEventTimeline testNoteClipEventTimeline = testTrack.QCa();
        this.check("clip count", testNoteClipEventTimeline.onT()).Ivg(1);
        TestInstrumentNoteClipEvent testInstrumentNoteClipEvent2 = (TestInstrumentNoteClipEvent)this.cast(testNoteClipEventTimeline.OSp(0), TestInstrumentNoteClipEvent.class);
        this.checkBeatTime("time", testInstrumentNoteClipEvent2.zEU()).Ivg(0.0);
        this.checkBeatTime("duration", testInstrumentNoteClipEvent2.tGb()).ZAb().OSp(16.0, this.getBlockBeatLength(150.0));
        this.checkBeatTime("play start in recorded clip", testInstrumentNoteClipEvent2.Nyy()).Ivg(2.75);
        TestNoteEventTimeline testNoteEventTimeline = testInstrumentNoteClipEvent2.onT().Ivg(40, 0);
        int n3 = testNoteEventTimeline.onT();
        this.check("recorded note count", n3).Ivg(1);
        TestInstrumentNoteEvent testInstrumentNoteEvent = (TestInstrumentNoteEvent)this.cast(testNoteEventTimeline.OSp(0), TestInstrumentNoteEvent.class);
        this.check("recorded note start time", testInstrumentNoteEvent.zEU()).Ivg(2.75);
        this.check("recorded note duration", testInstrumentNoteEvent.tGb()).Ivg(1.0);
        testProject.Lea();
    }
}

