/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.io.soX;
import com.bitwig.base.testing.WPD;
import com.bitwig.flt.app.testing.BitwigStudioTest;
import com.bitwig.flt.app.testing.TestAnalyzedAudioFile;
import com.bitwig.flt.app.testing.tests.BitwigStudioTestDataFileTest;
import com.bitwig.samplefile.rAn;
import java.io.File;
import java.io.IOException;

@WPD(Ivg="Platform")
public class OnsetAnalysisTests
extends BitwigStudioTestDataFileTest {
    @Override
    protected String getTopLevelDirectoryPath() {
        return "audio-file-analysis";
    }

    @Override
    protected boolean shouldCreateTestForFileType(bDi bDi2) {
        return bDi2 instanceof D3e;
    }

    @com.bitwig.base.testing.rAn
    public void testBitwigVampPluginHostOnsetAnalyzer() {
        AG aG2 = this.getApplication().nmW();
        this.check(aG2).zEU();
        File file = aG2.onT();
        this.check(file).ZAb();
        File file2 = this.getFile().rr();
        File file3 = this.getOutputFile("detected.onsets");
        AU aU2 = new AU(file, file3);
        aU2.Ivg(new rAn(file2));
        this.check(file3).onT();
        File file4 = this.getExpectedFile("onsets").rr();
        Bq.Ivg(file4);
        this.checkOnsetsAreCorrect(file3, file4);
    }

    @com.bitwig.base.testing.rAn
    public void testOnsetAnalysisViaCache() {
        AG aG2 = this.getApplication().nmW();
        this.check(aG2).zEU();
        File file = this.getFile().rr();
        AE aE2 = aG2.Ivg(new soX(file));
        this.check(aE2).zEU();
        File file2 = aG2.onT();
        this.check(file2).ZAb();
        TestAnalyzedAudioFile testAnalyzedAudioFile = new TestAnalyzedAudioFile((BitwigStudioTest)this, aE2);
        Bf bf2 = testAnalyzedAudioFile.Ivg(file, file2);
        this.check(file2).ZAb();
        File file3 = aE2.OSp(file2);
        this.check(bf2).zEU();
        int n2 = bf2.Ivg();
        this.check(n2 > 0);
        double d2 = -1.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d3 = bf2.Ivg(i2);
            this.check(d3 >= 0.0);
            this.check(d3 > d2);
            double d4 = bf2.OSp(i2);
            this.check(d4).Ivg(0.0, 2.0);
            d2 = d3;
        }
        File file4 = this.getExpectedFile("onsets").rr();
        this.checkOnsetsAreCorrect(file3, file4);
    }

    private void checkOnsetsAreCorrect(File file, File file2) {
        this.check("onsets correct", file).Ivg(file2, () -> {
            Bf bf2 = this.loadOnsets(file);
            this.check(file2).onT();
            Bf bf3 = this.loadOnsets(file2);
            this.check("onset count", bf2.Ivg()).Ivg(bf3.Ivg());
            int n2 = bf2.Ivg();
            this.check(n2 > 0);
            for (int i2 = 0; i2 < n2; ++i2) {
                double d2;
                double d3 = bf2.Ivg(i2);
                double d4 = Math.abs(d3 - (d2 = bf3.Ivg(i2)));
                this.check(d4 < 1.0E-4);
            }
        });
    }

    private Bf loadOnsets(File file) {
        Bf bf2 = null;
        try {
            bf2 = Bq.Ivg(file);
        }
        catch (IOException iOException) {
            this.fail("load onsets file " + file.getAbsolutePath(), iOException);
        }
        this.check(bf2).zEU();
        int n2 = bf2.Ivg();
        this.check(n2 > 0);
        double d2 = -1.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d3 = bf2.Ivg(i2);
            this.check(d3 >= 0.0);
            this.check(d3 > d2);
            double d4 = bf2.OSp(i2);
            this.check(d4).Ivg(0.0, 2.0);
            d2 = d3;
        }
        return bf2;
    }
}

