/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.testing.WPD;
import com.bitwig.base.testing.rAn;
import com.bitwig.flt.app.testing.BitwigStudioIntegrationTest;
import com.bitwig.flt.app.testing.TestDecimalValueAtom;
import com.bitwig.flt.app.testing.TestDeviceChain;
import com.bitwig.flt.app.testing.TestModulationSourceAtom;
import com.bitwig.flt.app.testing.TestModule;
import com.bitwig.flt.app.testing.TestModuleGrid;
import com.bitwig.flt.app.testing.TestNativeDevice;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.TestTrack;
import com.bitwig.flt.app.testing.TestValueAtom;
import com.bitwig.flt.packaging.core.GSm;
import com.bitwig.flt.packaging.core.mii;
import java.util.UUID;

@WPD(Ivg="Devices")
public class ModuleGridTests
extends BitwigStudioIntegrationTest {
    @rAn
    public void addAndCopyPolyGrid() {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.Ivg(VSZ.Ivg);
        TestDeviceChain testDeviceChain = testTrack.tGb();
        TestNativeDevice testNativeDevice = testDeviceChain.Ivg(0, mii.DDx);
        testNativeDevice.GC2().Ivg(testNativeDevice, Tq.OSp.oHp());
        testProject.Kyj();
        testProject.EN();
        testProject.Ivg(new sAG[0]);
    }

    @rAn
    public void addFxGrid() {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.Ivg(VSZ.Ivg);
        TestDeviceChain testDeviceChain = testTrack.tGb();
        TestNativeDevice testNativeDevice = testDeviceChain.Ivg(0, mii.Sl);
        testNativeDevice.GC2().Ivg(testNativeDevice, Tq.OSp.oHp());
        testProject.Kyj();
        testProject.EN();
        testProject.Ivg(new sAG[0]);
    }

    @rAn
    public void addAllModulesToPolyGrid() {
        TestProject testProject = this.createTestProject(8, 0);
        testProject.BXy();
        TestTrack testTrack = testProject.Ivg(VSZ.Ivg);
        TestDeviceChain testDeviceChain = testTrack.tGb();
        TestNativeDevice testNativeDevice = testDeviceChain.Ivg(0, mii.DDx);
        TestModuleGrid testModuleGrid = testNativeDevice.EN();
        int n2 = 0;
        int n3 = 2;
        int n4 = 0;
        for (GSm gSm : mii.Ivg()) {
            if (gSm.oHp() != com.bitwig.flt.packaging.core.rAn.oHp) continue;
            TestModule testModule = testModuleGrid.Ivg(n2, n3, gSm.Ivg());
            n4 = Math.max(n4, testModule.zEU());
            if ((n2 += testModule.kpx()) <= 16) continue;
            n2 = 0;
            n3 += n4;
            n4 = 0;
        }
        testProject.zvj();
        testProject.Ivg(new sAG[0]);
        testProject.Ivg(300L);
    }

    @rAn
    public void convertFilters() {
        UUID[] uUIDArray = new UUID[]{mii.JTM, mii.biR, mii.X2o, mii.Ki, mii.qDv, mii.YMc, mii.PhT};
        UUID uUID = mii.YMc;
        for (UUID uUID2 : uUIDArray) {
            if (uUID == uUID2) continue;
            this.testConvertFilter(uUID, uUID2);
        }
    }

    private void testConvertFilter(UUID uUID, UUID uUID2) {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.Ivg(VSZ.Ivg);
        TestDeviceChain testDeviceChain = testTrack.tGb();
        TestNativeDevice testNativeDevice = testDeviceChain.Ivg(0, mii.DDx);
        TestModuleGrid testModuleGrid = testNativeDevice.EN();
        TestModule testModule = testModuleGrid.Ivg(0, 3, uUID);
        TestModule testModule2 = testModuleGrid.Ivg(0, 2, mii.lkO);
        TestModulationSourceAtom testModulationSourceAtom = (TestModulationSourceAtom)testModule2.Ivg("CONTENTS/LFO", TestModulationSourceAtom.class);
        TestDecimalValueAtom testDecimalValueAtom = (TestDecimalValueAtom)testModule.Ivg("CONTENTS/CUTOFF", TestDecimalValueAtom.class);
        testModulationSourceAtom.Ivg(testDecimalValueAtom, 0.5);
        this.check(testModulationSourceAtom.onT()).Ivg(1);
        testModule = testModule.Ivg(uUID2);
        this.check(testModulationSourceAtom.onT()).Ivg(1);
        testProject.Ivg(new sAG[0]);
    }

    @rAn
    public void convertOscillators() {
        UUID[] uUIDArray;
        UUID[] uUIDArray2 = uUIDArray = new UUID[]{mii.pCx, mii.SkJ, mii.hpX, mii.keX, mii.Zuq, mii.sca, mii.Ai};
        int n2 = uUIDArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            UUID uUID = mii.pCx;
            UUID uUID2 = uUIDArray2[i2];
            if (uUID == uUID2) continue;
            this.testConvertOscillator(uUID, uUID2);
        }
    }

    private void testConvertOscillator(UUID uUID, UUID uUID2) {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.Ivg(VSZ.Ivg);
        TestDeviceChain testDeviceChain = testTrack.tGb();
        TestNativeDevice testNativeDevice = testDeviceChain.Ivg(0, mii.DDx);
        TestModuleGrid testModuleGrid = testNativeDevice.EN();
        TestModule testModule = testModuleGrid.Ivg(-2, 3, mii.pCx);
        TestModule testModule2 = testModuleGrid.Ivg(0, 3, uUID);
        testModuleGrid.Ivg(testModule, "OUT", testModule2, "PHASE_IN");
        this.check("Is mapped (pre)", testModule2.OSp("PHASE_IN").lXt());
        testModule2 = testModule2.Ivg(uUID2);
        this.check("Is mapped (post)", testModule2.OSp("PHASE_IN").lXt());
        testProject.Ivg(new sAG[0]);
    }

    @rAn
    public void convertEnvelopes() {
        UUID[] uUIDArray;
        for (UUID uUID : uUIDArray = new UUID[]{mii.fBS, mii.y3q, mii.aMR, mii.jMf}) {
            for (UUID uUID2 : uUIDArray) {
                if (uUID == uUID2) continue;
                this.testConvertEnvelope(uUID, uUID2);
            }
        }
    }

    private void testConvertEnvelope(UUID uUID, UUID uUID2) {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.Ivg(VSZ.Ivg);
        TestDeviceChain testDeviceChain = testTrack.tGb();
        TestNativeDevice testNativeDevice = testDeviceChain.Ivg(0, mii.DDx);
        TestModuleGrid testModuleGrid = testNativeDevice.EN();
        TestModule testModule = testModuleGrid.Ivg(0, 3, mii.PhT);
        TestModule testModule2 = testModuleGrid.Ivg(0, 2, uUID);
        TestDecimalValueAtom testDecimalValueAtom = (TestDecimalValueAtom)testModule.Ivg("CONTENTS/CUTOFF", TestDecimalValueAtom.class);
        TestModulationSourceAtom testModulationSourceAtom = (TestModulationSourceAtom)testModule2.Ivg("CONTENTS/ENVELOPE", TestModulationSourceAtom.class);
        testModulationSourceAtom.Ivg(testDecimalValueAtom, 0.5);
        this.check("Pre count", testModulationSourceAtom.onT()).Ivg(1);
        testModule2 = testModule2.Ivg(uUID2);
        TestModulationSourceAtom testModulationSourceAtom2 = (TestModulationSourceAtom)testModule2.Ivg("CONTENTS/ENVELOPE", TestModulationSourceAtom.class);
        this.check("Post count", testModulationSourceAtom2.onT()).Ivg(1);
        testProject.Ivg(new sAG[0]);
    }

    @rAn
    public void convertLFOsWithAuxiliaryModulation() {
        UUID[] uUIDArray;
        for (UUID uUID : uUIDArray = new UUID[]{mii.lkO, mii.nNq}) {
            for (UUID uUID2 : uUIDArray) {
                for (UUID uUID3 : uUIDArray) {
                    for (UUID uUID4 : uUIDArray) {
                        if (uUID == uUID2 || uUID3 == uUID4) continue;
                        this.testConvertLFOsWithAuxiliaryModulation(uUID, uUID2, uUID3, uUID4);
                    }
                }
            }
        }
    }

    private void testConvertLFOsWithAuxiliaryModulation(UUID uUID, UUID uUID2, UUID uUID3, UUID uUID4) {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.Ivg(VSZ.Ivg);
        TestDeviceChain testDeviceChain = testTrack.tGb();
        TestNativeDevice testNativeDevice = testDeviceChain.Ivg(0, mii.DDx);
        TestModuleGrid testModuleGrid = testNativeDevice.EN();
        TestModule testModule = testModuleGrid.Ivg(0, 3, mii.PhT);
        TestModule testModule2 = testModuleGrid.Ivg(0, 2, uUID);
        TestModule testModule3 = testModuleGrid.Ivg(0, 5, uUID3);
        TestDecimalValueAtom testDecimalValueAtom = (TestDecimalValueAtom)testModule.Ivg("CONTENTS/CUTOFF", TestDecimalValueAtom.class);
        TestModulationSourceAtom testModulationSourceAtom = (TestModulationSourceAtom)testModule2.Ivg("CONTENTS/LFO", TestModulationSourceAtom.class);
        TestModulationSourceAtom testModulationSourceAtom2 = (TestModulationSourceAtom)testModule3.Ivg("CONTENTS/LFO", TestModulationSourceAtom.class);
        testModulationSourceAtom.Ivg((TestValueAtom)testDecimalValueAtom, 0.5, true, sPH.Ivg, testModulationSourceAtom2);
        this.check("Pre mod count", testModulationSourceAtom.onT()).Ivg(1);
        this.check("Pre aux count", testModulationSourceAtom2.Nyy()).Ivg(1);
        testModule2 = testModule2.Ivg(uUID2);
        testModule3 = testModule3.Ivg(uUID4);
        TestModulationSourceAtom testModulationSourceAtom3 = (TestModulationSourceAtom)testModule2.Ivg("CONTENTS/LFO", TestModulationSourceAtom.class);
        TestModulationSourceAtom testModulationSourceAtom4 = (TestModulationSourceAtom)testModule3.Ivg("CONTENTS/LFO", TestModulationSourceAtom.class);
        this.check("Post aux count", testModulationSourceAtom3.onT()).Ivg(1);
        this.check("Post mod count", testModulationSourceAtom4.Nyy()).Ivg(1);
        testProject.Ivg(new sAG[0]);
    }

    @rAn
    public void disableLongDelayFeedback() {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.Ivg(VSZ.Ivg);
        TestDeviceChain testDeviceChain = testTrack.tGb();
        TestNativeDevice testNativeDevice = testDeviceChain.Ivg(0, mii.DDx);
        TestModuleGrid testModuleGrid = testNativeDevice.EN();
        TestModule testModule = testModuleGrid.Ivg(0, 3, mii.hpX);
        TestModule testModule2 = testModuleGrid.Ivg(-2, 3, mii.DYP);
        testModuleGrid.Ivg(testModule2, "OUT", testModule, "PHASE_IN");
        testModuleGrid.Ivg(testModule, "OUT", testModule2, "IN");
        testProject.Ivg(new sAG[0]);
        testModule2.OSp(false);
        testModuleGrid.Ivg(testModule, "PHASE_IN");
        testProject.Kyj();
        testProject.EN();
    }

    @rAn
    public void deleteLongDelayFeedback() {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.Ivg(VSZ.Ivg);
        TestDeviceChain testDeviceChain = testTrack.tGb();
        TestNativeDevice testNativeDevice = testDeviceChain.Ivg(0, mii.DDx);
        TestModuleGrid testModuleGrid = testNativeDevice.EN();
        TestModule testModule = testModuleGrid.Ivg(0, 3, mii.hpX);
        TestModule testModule2 = testModuleGrid.Ivg(-2, 3, mii.DYP);
        testModuleGrid.Ivg(testModule2, "OUT", testModule, "PHASE_IN");
        testModuleGrid.Ivg(testModule, "OUT", testModule2, "IN");
        testProject.Ivg(new sAG[0]);
        testModule2.W_();
        testProject.Kyj();
        testProject.EN();
    }

    @rAn
    public void copyModuleWithModulationRoutingsToSameGrid() {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.Ivg(VSZ.Ivg);
        TestDeviceChain testDeviceChain = testTrack.tGb();
        TestNativeDevice testNativeDevice = testDeviceChain.Ivg(0, mii.DDx);
        TestModuleGrid testModuleGrid = testNativeDevice.EN();
        TestNativeDevice testNativeDevice2 = testNativeDevice.OSp("CONTENTS/POST_FX").lXt().tGb().Ivg(0, mii.GC2);
        TestModule testModule = testModuleGrid.Ivg(0, 2, mii.lkO);
        TestModulationSourceAtom testModulationSourceAtom = (TestModulationSourceAtom)testModule.Ivg("CONTENTS/LFO", TestModulationSourceAtom.class);
        TestDecimalValueAtom testDecimalValueAtom = (TestDecimalValueAtom)testNativeDevice2.Ivg("CONTENTS/FREQ", TestDecimalValueAtom.class);
        testModulationSourceAtom.Ivg(testDecimalValueAtom, 0.5);
        testProject.Ivg(new sAG[0]);
        testModuleGrid.Ivg(0, 4).Ivg(testModule, Tq.OSp.oHp());
        testProject.Ivg(new sAG[0]);
    }

    @rAn
    public void copyModuleWithModulationRoutingsToOtherGrid() {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.Ivg(VSZ.Ivg);
        TestTrack testTrack2 = testProject.Ivg(VSZ.Ivg);
        TestDeviceChain testDeviceChain = testTrack.tGb();
        TestDeviceChain testDeviceChain2 = testTrack2.tGb();
        testTrack.OSp("Source");
        testTrack2.OSp("Dest");
        TestNativeDevice testNativeDevice = testDeviceChain.Ivg(0, mii.DDx);
        TestNativeDevice testNativeDevice2 = testDeviceChain2.Ivg(0, mii.DDx);
        TestModuleGrid testModuleGrid = testNativeDevice.EN();
        TestModuleGrid testModuleGrid2 = testNativeDevice2.EN();
        TestNativeDevice testNativeDevice3 = testNativeDevice.OSp("CONTENTS/POST_FX").lXt().tGb().Ivg(0, mii.GC2);
        TestModule testModule = testModuleGrid.Ivg(0, 2, mii.lkO);
        TestModulationSourceAtom testModulationSourceAtom = (TestModulationSourceAtom)testModule.Ivg("CONTENTS/LFO", TestModulationSourceAtom.class);
        TestDecimalValueAtom testDecimalValueAtom = (TestDecimalValueAtom)testNativeDevice3.Ivg("CONTENTS/FREQ", TestDecimalValueAtom.class);
        testModulationSourceAtom.Ivg(testDecimalValueAtom, 0.5);
        testProject.Ivg(new sAG[0]);
        testModuleGrid2.Ivg(0, 3).Ivg(testModule, Tq.OSp.oHp());
        testProject.Ivg(new sAG[0]);
    }
}

