/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.testing.WPD;
import com.bitwig.base.testing.rAn;
import com.bitwig.flt.app.testing.BitwigStudioTest;
import com.bitwig.flt.app.testing.TestAudioClipTakeLane;
import com.bitwig.flt.app.testing.TestAudioNoteClipContentTimeline;
import com.bitwig.flt.app.testing.TestAudioNoteClipEvent;
import com.bitwig.flt.app.testing.TestAudioNoteEvent;
import com.bitwig.flt.app.testing.TestAudioNoteEventTimeline;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.TestTrack;

@WPD(Ivg="Application")
public class CompRegionTests
extends BitwigStudioTest {
    private TestAudioNoteClipEvent createProjectWithAudioClip(double d2) {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.Ivg(VSZ.OSp);
        TestAudioNoteClipEvent testAudioNoteClipEvent = this.createAudioNoteClipEvent(0.0, d2);
        testTrack.QCa().Ivg(testAudioNoteClipEvent);
        this.check("clip count", testTrack.QCa().onT()).Ivg(1);
        return testAudioNoteClipEvent;
    }

    private TestAudioClipTakeLane addTakeLane(TestAudioNoteClipEvent testAudioNoteClipEvent, double d2) {
        TestAudioNoteClipContentTimeline testAudioNoteClipContentTimeline = testAudioNoteClipEvent.onT();
        TestAudioNoteEvent testAudioNoteEvent = this.createDummyAudioNoteEvent(0.0, d2);
        TestAudioClipTakeLane testAudioClipTakeLane = testAudioNoteClipContentTimeline.Ivg(d2);
        testAudioClipTakeLane.QCa().Ivg(testAudioNoteEvent);
        return testAudioClipTakeLane;
    }

    @rAn
    public void testMultiplex() {
        TestAudioNoteClipEvent testAudioNoteClipEvent = this.createProjectWithAudioClip(8.0);
        TestAudioNoteClipContentTimeline testAudioNoteClipContentTimeline = testAudioNoteClipEvent.onT();
        this.check(testAudioNoteClipContentTimeline.tGb()).Ivg(0);
        this.check(testAudioNoteClipContentTimeline.Fqp()).Ivg(0);
        TestAudioClipTakeLane testAudioClipTakeLane = this.addTakeLane(testAudioNoteClipEvent, 32.0);
        this.check(testAudioNoteClipContentTimeline.tGb()).Ivg(1);
        this.check(testAudioNoteClipContentTimeline.Fqp()).Ivg(1);
        testAudioClipTakeLane.Ivg(8.0);
        this.check(testAudioNoteClipContentTimeline.tGb()).Ivg(4);
        this.check(testAudioNoteClipContentTimeline.Fqp()).Ivg(1);
        for (int i2 = 0; i2 < 4; ++i2) {
            TestAudioClipTakeLane testAudioClipTakeLane2 = testAudioNoteClipContentTimeline.OSp(i2);
            this.check(testAudioClipTakeLane2.Nyy()).Ivg(0.0, 6);
            this.check(testAudioClipTakeLane2.tGb()).Ivg((double)(8 * (3 - i2)), 6);
            this.check(testAudioClipTakeLane2.Fqp()).Ivg(8.0, 6);
        }
    }

    @rAn
    public void testStoreAsLane() {
        TestAudioNoteClipEvent testAudioNoteClipEvent = this.createProjectWithAudioClip(8.0);
        TestAudioNoteClipContentTimeline testAudioNoteClipContentTimeline = testAudioNoteClipEvent.onT();
        this.check(testAudioNoteClipContentTimeline.tGb()).Ivg(0);
        this.check(testAudioNoteClipContentTimeline.Fqp()).Ivg(0);
        TestAudioNoteEvent testAudioNoteEvent = this.createDummyAudioNoteEvent(8.0, 8.0);
        testAudioNoteClipContentTimeline.OSp(true).Ivg(testAudioNoteEvent);
        testAudioNoteClipContentTimeline.Nyy();
        this.check(testAudioNoteClipContentTimeline.tGb()).Ivg(1);
        this.check(testAudioNoteClipContentTimeline.Fqp()).Ivg(1);
    }

    @rAn
    public void testDeleteTake() {
        TestAudioNoteClipEvent testAudioNoteClipEvent = this.createProjectWithAudioClip(8.0);
        TestAudioNoteClipContentTimeline testAudioNoteClipContentTimeline = testAudioNoteClipEvent.onT();
        this.check(testAudioNoteClipContentTimeline.tGb()).Ivg(0);
        this.check(testAudioNoteClipContentTimeline.Fqp()).Ivg(0);
        TestAudioClipTakeLane testAudioClipTakeLane = this.addTakeLane(testAudioNoteClipEvent, 8.0);
        this.check(testAudioNoteClipContentTimeline.tGb()).Ivg(1);
        this.check(testAudioNoteClipContentTimeline.Fqp()).Ivg(1);
        testAudioClipTakeLane.lXt();
        this.check(testAudioNoteClipContentTimeline.tGb()).Ivg(0);
        this.check(testAudioNoteClipContentTimeline.Fqp()).Ivg(0);
    }

    @rAn
    public void testDeleteTake2() {
        TestAudioNoteClipEvent testAudioNoteClipEvent = this.createProjectWithAudioClip(8.0);
        TestAudioNoteClipContentTimeline testAudioNoteClipContentTimeline = testAudioNoteClipEvent.onT();
        this.check(testAudioNoteClipContentTimeline.tGb()).Ivg(0);
        this.check(testAudioNoteClipContentTimeline.Fqp()).Ivg(0);
        TestAudioClipTakeLane testAudioClipTakeLane = this.addTakeLane(testAudioNoteClipEvent, 8.0);
        TestAudioClipTakeLane testAudioClipTakeLane2 = this.addTakeLane(testAudioNoteClipEvent, 16.0);
        this.check(testAudioNoteClipContentTimeline.tGb()).Ivg(2);
        this.check(testAudioNoteClipContentTimeline.Fqp()).Ivg(2);
        testAudioClipTakeLane.lXt();
        this.check(testAudioNoteClipContentTimeline.tGb()).Ivg(1);
        this.check(testAudioNoteClipContentTimeline.Fqp()).Ivg(1);
    }

    @rAn
    public void testDeleteAll() {
        TestAudioNoteClipEvent testAudioNoteClipEvent = this.createProjectWithAudioClip(8.0);
        TestAudioNoteClipContentTimeline testAudioNoteClipContentTimeline = testAudioNoteClipEvent.onT();
        this.check(testAudioNoteClipContentTimeline.tGb()).Ivg(0);
        this.check(testAudioNoteClipContentTimeline.Fqp()).Ivg(0);
        TestAudioClipTakeLane testAudioClipTakeLane = this.addTakeLane(testAudioNoteClipEvent, 8.0);
        TestAudioClipTakeLane testAudioClipTakeLane2 = this.addTakeLane(testAudioNoteClipEvent, 16.0);
        this.check(testAudioNoteClipContentTimeline.tGb()).Ivg(2);
        this.check(testAudioNoteClipContentTimeline.Fqp()).Ivg(2);
        testAudioClipTakeLane.onT();
        this.check(testAudioNoteClipContentTimeline.tGb()).Ivg(0);
        this.check(testAudioNoteClipContentTimeline.Fqp()).Ivg(0);
    }

    @rAn
    public void testSelectTake() {
        TestAudioNoteClipEvent testAudioNoteClipEvent = this.createProjectWithAudioClip(8.0);
        TestAudioNoteClipContentTimeline testAudioNoteClipContentTimeline = testAudioNoteClipEvent.onT();
        this.check(testAudioNoteClipContentTimeline.tGb()).Ivg(0);
        this.check(testAudioNoteClipContentTimeline.Fqp()).Ivg(0);
        TestAudioClipTakeLane testAudioClipTakeLane = this.addTakeLane(testAudioNoteClipEvent, 8.0);
        testAudioNoteClipContentTimeline.Ivg(testAudioClipTakeLane, 2.0, 6.0);
        TestAudioNoteEventTimeline testAudioNoteEventTimeline = testAudioNoteClipContentTimeline.onT();
        this.check(testAudioNoteEventTimeline.Nyy()).Ivg(1);
        this.check(testAudioNoteEventTimeline.lXt()).Ivg(0);
        this.check(testAudioNoteClipContentTimeline.lXt().Nyy()).Ivg(1);
        this.check(testAudioNoteClipContentTimeline.lXt().lXt()).Ivg(0);
    }

    @rAn
    public void testSelectTakes() {
        TestAudioNoteClipEvent testAudioNoteClipEvent = this.createProjectWithAudioClip(8.0);
        TestAudioNoteClipContentTimeline testAudioNoteClipContentTimeline = testAudioNoteClipEvent.onT();
        this.check(testAudioNoteClipContentTimeline.tGb()).Ivg(0);
        this.check(testAudioNoteClipContentTimeline.Fqp()).Ivg(0);
        TestAudioClipTakeLane testAudioClipTakeLane = this.addTakeLane(testAudioNoteClipEvent, 8.0);
        TestAudioClipTakeLane testAudioClipTakeLane2 = this.addTakeLane(testAudioNoteClipEvent, 8.0);
        testAudioNoteClipContentTimeline.Ivg(testAudioClipTakeLane, 2.0, 6.0);
        testAudioNoteClipContentTimeline.Ivg(testAudioClipTakeLane2, 4.0, 5.0);
        TestAudioNoteEventTimeline testAudioNoteEventTimeline = testAudioNoteClipContentTimeline.onT();
        this.check(testAudioNoteEventTimeline.Nyy()).Ivg(3);
        this.check(testAudioNoteEventTimeline.lXt()).Ivg(0);
        this.check(testAudioNoteClipContentTimeline.lXt().Nyy()).Ivg(3);
        this.check(testAudioNoteClipContentTimeline.lXt().lXt()).Ivg(0);
    }

    @rAn
    public void testSelectTakes2() {
        TestAudioNoteClipEvent testAudioNoteClipEvent = this.createProjectWithAudioClip(8.0);
        TestAudioNoteClipContentTimeline testAudioNoteClipContentTimeline = testAudioNoteClipEvent.onT();
        this.check(testAudioNoteClipContentTimeline.tGb()).Ivg(0);
        this.check(testAudioNoteClipContentTimeline.Fqp()).Ivg(0);
        TestAudioClipTakeLane testAudioClipTakeLane = this.addTakeLane(testAudioNoteClipEvent, 8.0);
        TestAudioClipTakeLane testAudioClipTakeLane2 = this.addTakeLane(testAudioNoteClipEvent, 8.0);
        testAudioNoteClipContentTimeline.Ivg(testAudioClipTakeLane2, 4.0, 5.0);
        testAudioNoteClipContentTimeline.Ivg(testAudioClipTakeLane, 2.0, 6.0);
        TestAudioNoteEventTimeline testAudioNoteEventTimeline = testAudioNoteClipContentTimeline.onT();
        this.check(testAudioNoteEventTimeline.Nyy()).Ivg(1);
        this.check(testAudioNoteEventTimeline.lXt()).Ivg(0);
        this.check(testAudioNoteClipContentTimeline.lXt().Nyy()).Ivg(1);
        this.check(testAudioNoteClipContentTimeline.lXt().lXt()).Ivg(0);
    }
}

