/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.testing.rAn;
import com.bitwig.flt.app.testing.BitwigStudioIntegrationTest;
import com.bitwig.flt.app.testing.TestArrangementAutomationTimeline;
import com.bitwig.flt.app.testing.TestChainSelector;
import com.bitwig.flt.app.testing.TestChainSelectorIndexedValueAtom;
import com.bitwig.flt.app.testing.TestDeviceChain;
import com.bitwig.flt.app.testing.TestEnumAutomationEventTimeline;
import com.bitwig.flt.app.testing.TestIndexedValueAtom;
import com.bitwig.flt.app.testing.TestIndexedValueType;
import com.bitwig.flt.app.testing.TestNativeDevice;
import com.bitwig.flt.app.testing.TestNestedDeviceChain;
import com.bitwig.flt.app.testing.TestPermanentAutomationLane;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.TestTrack;
import com.bitwig.flt.app.testing.TestTrackGroup;
import com.bitwig.flt.app.testing.TestTrackOrTrackGroup;
import com.bitwig.flt.app.testing.plB;
import com.bitwig.flt.document.core.master.device.vbV;
import java.util.UUID;

public abstract class ChainSelectorTests
extends BitwigStudioIntegrationTest {
    @Override
    public long getUndoCountLimit() {
        return 75L;
    }

    protected abstract UUID getDeviceId();

    protected abstract VSZ getTrackType();

    private TestChainSelector createAndGetChainSelector() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.Ivg(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.tGb();
        TestNativeDevice testNativeDevice = testDeviceChain.Ivg(0, this.getDeviceId());
        return (TestChainSelector)this.cast(testNativeDevice.Ivg(vbV.class), TestChainSelector.class);
    }

    @rAn
    public void checkAddDeleteSimple() {
        TestChainSelector testChainSelector = this.createAndGetChainSelector();
        this.check("ChainSelectorEmpty", testChainSelector.Nyy()).Ivg(0);
        this.check("SelectedIndexWhileEmpty", testChainSelector.lXt().onT()).Ivg(0);
        testChainSelector.onT();
        this.check("ChainSelectorEmpty", testChainSelector.Nyy()).Ivg(1);
        this.check("SelectedIndexWhileEmpty", testChainSelector.lXt().onT()).Ivg(0);
        TestNestedDeviceChain testNestedDeviceChain = testChainSelector.oHp(0);
        testNestedDeviceChain.W_();
        this.check("ChainSelectorEmpty", testChainSelector.Nyy()).Ivg(0);
        this.check("SelectedIndexWhileEmpty", testChainSelector.lXt().onT()).Ivg(0);
    }

    @rAn
    public void checkAddDeleteComplex() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.Ivg(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.tGb();
        TestNativeDevice testNativeDevice = testDeviceChain.Ivg(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.Ivg(vbV.class), TestChainSelector.class);
        for (int i2 = 0; i2 < 5; ++i2) {
            testChainSelector.onT();
            this.check("chainCount", testChainSelector.Nyy()).Ivg(i2 + 1);
            String string = "Test Chain " + (i2 + 1);
            TestNestedDeviceChain testNestedDeviceChain = testChainSelector.oHp(i2);
            testNestedDeviceChain.OSp(string);
            this.check("title", testNestedDeviceChain.onT()).Ivg(string);
            this.check("displayedTitle", testNestedDeviceChain.Nyy()).Ivg(string);
        }
        TestChainSelectorIndexedValueAtom testChainSelectorIndexedValueAtom = testChainSelector.lXt();
        this.check("indexInit", testChainSelectorIndexedValueAtom.onT()).Ivg(0);
        testChainSelector.onT();
        this.check("indexAfterAddChain", testChainSelectorIndexedValueAtom.onT()).Ivg(0);
        this.check("chainCount", testChainSelector.Nyy()).Ivg(6);
        testChainSelector.oHp(0).W_();
        this.check("indexAfterRemoveChain", testChainSelectorIndexedValueAtom.onT()).Ivg(0);
        this.check("chainCount", testChainSelector.Nyy()).Ivg(5);
        testChainSelector.oHp(1).W_();
        this.check("index", testChainSelectorIndexedValueAtom.onT()).Ivg(0);
        this.check("chainCount", testChainSelector.Nyy()).Ivg(4);
        testChainSelectorIndexedValueAtom.OSp(2);
        testChainSelector.oHp(0).W_();
        this.check("index", testChainSelectorIndexedValueAtom.onT()).Ivg(1);
        this.check("chainCount", testChainSelector.Nyy()).Ivg(3);
        testChainSelectorIndexedValueAtom.OSp(2);
        this.check("index", testChainSelectorIndexedValueAtom.onT()).Ivg(2);
        testChainSelector.oHp(2).W_();
        this.check("index", testChainSelectorIndexedValueAtom.onT()).Ivg(1);
        this.check("chainCount", testChainSelector.Nyy()).Ivg(2);
    }

    @rAn
    public void checkMoveToFirst() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.Ivg(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.tGb();
        TestNativeDevice testNativeDevice = testDeviceChain.Ivg(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.Ivg(vbV.class), TestChainSelector.class);
        for (int i2 = 0; i2 < 5; ++i2) {
            testChainSelector.onT();
        }
        TestChainSelectorIndexedValueAtom testChainSelectorIndexedValueAtom = testChainSelector.lXt();
        testChainSelectorIndexedValueAtom.OSp(2);
        this.check("indexBeforeMove", testChainSelectorIndexedValueAtom.onT()).Ivg(2);
        TestNestedDeviceChain testNestedDeviceChain = testChainSelector.oHp(0);
        TestNestedDeviceChain testNestedDeviceChain2 = testChainSelector.oHp(2);
        testNestedDeviceChain.kpx().Ivg(testNestedDeviceChain2);
        this.check("chainsCount", testChainSelector.Nyy()).Ivg(5);
        this.check("chainMovedPosition", testNestedDeviceChain2).Ivg(testChainSelector.oHp(0));
        this.check("chainMovedBeforePosition", testNestedDeviceChain).Ivg(testChainSelector.oHp(1));
        this.check("indexAfterMove", testChainSelectorIndexedValueAtom.onT()).Ivg(0);
    }

    public void checkMoveToLast() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.Ivg(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.tGb();
        TestNativeDevice testNativeDevice = testDeviceChain.Ivg(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.Ivg(vbV.class), TestChainSelector.class);
        for (int i2 = 0; i2 < 5; ++i2) {
            testChainSelector.onT();
        }
        TestChainSelectorIndexedValueAtom testChainSelectorIndexedValueAtom = testChainSelector.lXt();
        testChainSelectorIndexedValueAtom.OSp(2);
        this.check("indexBeforeMove", testChainSelectorIndexedValueAtom.onT()).Ivg(2);
        TestNestedDeviceChain testNestedDeviceChain = testChainSelector.oHp(4);
        TestNestedDeviceChain testNestedDeviceChain2 = testChainSelector.oHp(2);
        testNestedDeviceChain.QCa().Ivg(testNestedDeviceChain2);
        this.check("chainsCount", testChainSelector.Nyy()).Ivg(5);
        this.check("chainMovedPosition", testNestedDeviceChain2).Ivg(testChainSelector.oHp(4));
        this.check("chainMovedBeforePosition", testNestedDeviceChain).Ivg(testChainSelector.oHp(3));
        this.check("indexAfterMove", testChainSelectorIndexedValueAtom.onT()).Ivg(4);
    }

    @rAn
    public void checkDuplicate() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.Ivg(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.tGb();
        TestNativeDevice testNativeDevice = testDeviceChain.Ivg(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.Ivg(vbV.class), TestChainSelector.class);
        for (int i2 = 0; i2 < 5; ++i2) {
            testChainSelector.onT();
        }
        testTrack.V_().Fqp();
        TestTrackGroup testTrackGroup = testProject.Nyy();
        TestTrackOrTrackGroup testTrackOrTrackGroup = testTrackGroup.OSp(1);
        TestNativeDevice testNativeDevice2 = testTrackOrTrackGroup.tGb().oHp(0);
        TestChainSelector testChainSelector2 = (TestChainSelector)this.cast(testNativeDevice2.Ivg(vbV.class), TestChainSelector.class);
        this.check("chainsCount", testChainSelector2.Nyy()).equals(5);
    }

    @rAn
    public void checkPrevNextArrows() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.Ivg(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.tGb();
        TestNativeDevice testNativeDevice = testDeviceChain.Ivg(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.Ivg(vbV.class), TestChainSelector.class);
        TestChainSelectorIndexedValueAtom testChainSelectorIndexedValueAtom = testChainSelector.lXt();
        this.check("index when empty", testChainSelectorIndexedValueAtom.onT()).Ivg(0);
        testChainSelectorIndexedValueAtom.Nyy();
        this.check("index when empty after selectNextValue()", testChainSelectorIndexedValueAtom.onT()).Ivg(0);
        testChainSelectorIndexedValueAtom.tGb();
        this.check("index when empty after selectPrevValue()", testChainSelectorIndexedValueAtom.onT()).Ivg(0);
        testChainSelectorIndexedValueAtom.Fqp();
        this.check("index when empty after cycleNextValue()", testChainSelectorIndexedValueAtom.onT()).Ivg(0);
        testChainSelectorIndexedValueAtom.QCa();
        this.check("index when empty after cyclePrevValue()", testChainSelectorIndexedValueAtom.onT()).Ivg(0);
        testChainSelector.onT();
        this.check("index with a single chain", testChainSelectorIndexedValueAtom.onT()).Ivg(0);
        testChainSelectorIndexedValueAtom.Nyy();
        this.check("index with a single chain after selectNextValue()", testChainSelectorIndexedValueAtom.onT()).Ivg(0);
        testChainSelectorIndexedValueAtom.tGb();
        this.check("index with a single chain after selectPrevValue()", testChainSelectorIndexedValueAtom.onT()).Ivg(0);
        testChainSelectorIndexedValueAtom.Fqp();
        this.check("index with a single chain after cycleNextValue()", testChainSelectorIndexedValueAtom.onT()).Ivg(0);
        testChainSelectorIndexedValueAtom.QCa();
        this.check("index with a single chain after cyclePrevValue()", testChainSelectorIndexedValueAtom.onT()).Ivg(0);
        testChainSelector.onT();
        this.check("index with two chains", testChainSelectorIndexedValueAtom.onT()).Ivg(0);
        testChainSelectorIndexedValueAtom.Nyy();
        this.check("index", testChainSelectorIndexedValueAtom.onT()).Ivg(1);
        testChainSelectorIndexedValueAtom.Nyy();
        this.check("index next at end", testChainSelectorIndexedValueAtom.onT()).Ivg(1);
        testChainSelectorIndexedValueAtom.tGb();
        this.check("index prev", testChainSelectorIndexedValueAtom.onT()).Ivg(0);
        testChainSelectorIndexedValueAtom.tGb();
        this.check("index prev at beginning", testChainSelectorIndexedValueAtom.onT()).Ivg(0);
        testChainSelectorIndexedValueAtom.Fqp();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.onT()).Ivg(1);
        testChainSelectorIndexedValueAtom.Fqp();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.onT()).Ivg(0);
        testChainSelectorIndexedValueAtom.QCa();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.onT()).Ivg(1);
        testChainSelectorIndexedValueAtom.QCa();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.onT()).Ivg(0);
        testChainSelector.onT();
        this.check("index with two chains", testChainSelectorIndexedValueAtom.onT()).Ivg(0);
        testChainSelectorIndexedValueAtom.Nyy();
        this.check("index", testChainSelectorIndexedValueAtom.onT()).Ivg(1);
        testChainSelectorIndexedValueAtom.Nyy();
        this.check("index", testChainSelectorIndexedValueAtom.onT()).Ivg(2);
        testChainSelectorIndexedValueAtom.Nyy();
        this.check("index next at end", testChainSelectorIndexedValueAtom.onT()).Ivg(2);
        testChainSelectorIndexedValueAtom.tGb();
        this.check("index prev", testChainSelectorIndexedValueAtom.onT()).Ivg(1);
        testChainSelectorIndexedValueAtom.tGb();
        this.check("index prev", testChainSelectorIndexedValueAtom.onT()).Ivg(0);
        testChainSelectorIndexedValueAtom.tGb();
        this.check("index prev at beginning", testChainSelectorIndexedValueAtom.onT()).Ivg(0);
        testChainSelectorIndexedValueAtom.Fqp();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.onT()).Ivg(1);
        testChainSelectorIndexedValueAtom.Fqp();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.onT()).Ivg(2);
        testChainSelectorIndexedValueAtom.Fqp();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.onT()).Ivg(0);
        testChainSelectorIndexedValueAtom.QCa();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.onT()).Ivg(2);
        testChainSelectorIndexedValueAtom.QCa();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.onT()).Ivg(1);
        testChainSelectorIndexedValueAtom.QCa();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.onT()).Ivg(0);
    }

    @rAn
    public void checkAutomation() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.Ivg(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.tGb();
        TestNativeDevice testNativeDevice = testDeviceChain.Ivg(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.Ivg(vbV.class), TestChainSelector.class);
        for (int i2 = 0; i2 < 5; ++i2) {
            testChainSelector.onT();
        }
        this.check("chainCount", testChainSelector.Nyy()).Ivg(5);
        TestChainSelectorIndexedValueAtom testChainSelectorIndexedValueAtom = testChainSelector.lXt();
        TestIndexedValueType testIndexedValueType = testChainSelectorIndexedValueAtom.lXt();
        this.check("indexValueTypeIsAutomatable", testIndexedValueType.lXt());
        this.check("indexValueTypeIsInterpolated", !testIndexedValueType.onT());
        testChainSelectorIndexedValueAtom.kpx();
        TestPermanentAutomationLane testPermanentAutomationLane = testTrack.Ivg(testChainSelectorIndexedValueAtom);
        TestArrangementAutomationTimeline testArrangementAutomationTimeline = testPermanentAutomationLane.lXt();
        TestEnumAutomationEventTimeline testEnumAutomationEventTimeline = testArrangementAutomationTimeline.onT();
        this.check("valueTypeEquals", testPermanentAutomationLane.Ivg(TestIndexedValueType.class)).Ivg(testIndexedValueType);
        for (int i3 = 0; i3 < 5; ++i3) {
            testEnumAutomationEventTimeline.Ivg(i3, i3);
        }
        this.check("automationHasEvents", testPermanentAutomationLane.onT());
        TestNestedDeviceChain testNestedDeviceChain = testChainSelector.oHp(4);
        TestNestedDeviceChain testNestedDeviceChain2 = testChainSelector.oHp(2);
        testNestedDeviceChain.QCa().Ivg(testNestedDeviceChain2);
        this.check("chainsCount", testChainSelector.Nyy()).Ivg(5);
        this.check("chainMovedPosition", testNestedDeviceChain2).Ivg(testChainSelector.oHp(4));
        this.check("chainMovedBeforePosition", testNestedDeviceChain).Ivg(testChainSelector.oHp(3));
        this.check("automationEventsCount", testEnumAutomationEventTimeline.onT()).Ivg(5);
        this.check("valueAt0", testEnumAutomationEventTimeline.Ivg(0.0).lXt()).equals(0);
        this.check("valueAt1", testEnumAutomationEventTimeline.Ivg(1.0).lXt()).equals(1);
        this.check("valueAt2", testEnumAutomationEventTimeline.Ivg(2.0).lXt()).equals(3);
        this.check("valueAt3", testEnumAutomationEventTimeline.Ivg(3.0).lXt()).equals(4);
        this.check("valueAt4", testEnumAutomationEventTimeline.Ivg(4.0).lXt()).equals(2);
    }

    @rAn
    public void checkMoveBetweenTwoDevices() {
        Object object;
        TestNestedDeviceChain testNestedDeviceChain;
        Object object2;
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.Ivg(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.tGb();
        TestNativeDevice testNativeDevice = testDeviceChain.Ivg(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.Ivg(vbV.class), TestChainSelector.class);
        TestNativeDevice testNativeDevice2 = testDeviceChain.Ivg(1, this.getDeviceId());
        TestChainSelector testChainSelector2 = (TestChainSelector)this.cast(testNativeDevice2.Ivg(vbV.class), TestChainSelector.class);
        for (int i2 = 0; i2 < 5; ++i2) {
            testChainSelector.onT();
            testChainSelector2.onT();
            this.check("chainCount1", testChainSelector.Nyy()).Ivg(i2 + 1);
            this.check("chainCount2", testChainSelector2.Nyy()).Ivg(i2 + 1);
            object2 = "Test Chain1 " + (i2 + 1);
            testNestedDeviceChain = testChainSelector.oHp(i2);
            testNestedDeviceChain.OSp((String)object2);
            this.check("title", testNestedDeviceChain.onT()).Ivg((String)object2);
            this.check("displayedTitle", testNestedDeviceChain.Nyy()).Ivg((String)object2);
            object = "Test Chain2 " + (i2 + 1);
            TestNestedDeviceChain testNestedDeviceChain2 = testChainSelector2.oHp(i2);
            testNestedDeviceChain2.OSp((String)object);
            this.check("title", testNestedDeviceChain2.onT()).Ivg((String)object);
            this.check("displayedTitle", testNestedDeviceChain2.Nyy()).Ivg((String)object);
        }
        TestChainSelectorIndexedValueAtom testChainSelectorIndexedValueAtom = testChainSelector.lXt();
        this.check("indexInit1", testChainSelectorIndexedValueAtom.onT()).Ivg(0);
        object2 = testChainSelector2.lXt();
        this.check("indexInit2", ((TestIndexedValueAtom)object2).onT()).Ivg(0);
        testChainSelectorIndexedValueAtom.OSp(2);
        ((TestIndexedValueAtom)object2).OSp(2);
        testNestedDeviceChain = testChainSelector.oHp(2);
        object = testChainSelector2.oHp(2);
        testNestedDeviceChain.QCa().Ivg((plB)object);
        this.check("index1", testChainSelector.lXt().onT()).Ivg(2);
        this.check("chainsCount1", testChainSelector.Nyy()).Ivg(6);
        this.check("index2", testChainSelector2.lXt().onT()).Ivg(2);
        this.check("chainsCount2", testChainSelector2.Nyy()).Ivg(4);
    }
}

