/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.io.soX;
import com.bitwig.base.testing.rAn;
import com.bitwig.flt.app.testing.BitwigStudioIntegrationTest;
import com.bitwig.flt.app.testing.TestAudioNoteClipEvent;
import com.bitwig.flt.app.testing.TestAudioNoteEvent;
import com.bitwig.flt.app.testing.TestAudioNoteEventTimeline;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.TestSampleReference;
import com.bitwig.flt.app.testing.TestTempoAutomationEventTimeline;
import com.bitwig.flt.app.testing.TestTrack;
import com.bitwig.flt.app.testing.TestTransport;
import com.bitwig.flt.app.testing.TestWarpEvent;
import com.bitwig.flt.app.testing.TestWarpEventTimeline;
import com.bitwig.flt.app.testing.tests.AGq;
import com.bitwig.samplefile.OpN;
import com.bitwig.samplefile.VLQ;
import com.bitwig.samplefile.Xpb;
import com.bitwig.samplefile.zuD;
import java.io.File;

public abstract class AudioRecordingOrBouncingTests
extends BitwigStudioIntegrationTest {
    @rAn(UB2=false)
    public void testRecordingAudio() {
        this.testRecordingAudio(0.0, 4.0, 120.0);
    }

    @rAn(UB2=false)
    public void testRecordingShortAudio() {
        double d2 = 120.0;
        this.testRecordingAudio(0.0, Bu.Ivg(this.getBlockBeatLength(120.0) * 2.0), 120.0);
    }

    private void testRecordingAudio(double d2, double d3, double d4) {
        this.checkBeatTime(d2).ZAb().ZAb(0.0);
        this.checkBeatTime("record duration", d3).ZAb().UB2(0.0);
        TestProject testProject = this.createTestProject(1, 0);
        testProject.kpx();
        TestTransport testTransport = testProject.onT();
        testTransport.onT().Ivg(d4);
        TestTrack testTrack = testProject.Ivg(VSZ.OSp);
        TestAudioNoteClipEvent testAudioNoteClipEvent = this.recordClip(testProject, testTrack, d2, d3, AGq.Ivg);
        this.checkAudioClipNoTempoAutomation(testAudioNoteClipEvent, d4, d3, this.getExpectedDurationInBeatsTolerance(d4), this.getExpectedRecordedFile(), AGq.Ivg);
        testProject.Lea();
    }

    protected File getExpectedRecordedFile() {
        return null;
    }

    @rAn(UB2=false)
    public void testRecordingAudioWithIOErrorOnOpen() {
        this.testRecordingAudioWithError(AGq.OSp);
    }

    @rAn(UB2=false)
    public void testRecordingAudioWithIOErrorOnWrite() {
        this.testRecordingAudioWithError(AGq.oHp);
    }

    @rAn(UB2=false)
    public void testRecordingAudioWithIOErrorOnClose() {
        this.testRecordingAudioWithError(AGq.UB2);
    }

    private void testRecordingAudioWithError(AGq aGq2) {
        double d2;
        double d3;
        this.check(aGq2 != AGq.Ivg);
        this.check("no error with recording audio so far", this.getFirstNotificationOfType(this.getErrorNotificationType())).kpx();
        TestProject testProject = this.createTestProject(1, 0);
        testProject.kpx();
        double d4 = testProject.onT().onT().lXt();
        TestTrack testTrack = testProject.Ivg(VSZ.OSp);
        TestAudioNoteClipEvent testAudioNoteClipEvent = this.recordClip(testProject, testTrack, 0.0, 4.0, aGq2);
        if (aGq2 == AGq.OSp || aGq2 == AGq.oHp) {
            d3 = 0.0;
            d2 = 0.0;
        } else {
            d3 = 0.0;
            d2 = 0.0;
        }
        this.checkAudioClipNoTempoAutomation(testAudioNoteClipEvent, d4, 4.0, this.getExpectedDurationInBeatsTolerance(d4), d3, d2, this.getExpectedRecordedFile(), aGq2);
        this.check("error notification was shown", this.getFirstNotificationOfType(this.getErrorNotificationType())).zEU();
        testProject.Lea();
    }

    @rAn(UB2=false)
    public void testRecordingAudioWithTempoAutomation() {
        TestProject testProject = this.createTestProject(1, 0);
        testProject.kpx();
        TestTransport testTransport = testProject.onT();
        testTransport.onT().kpx();
        TestTrack testTrack = testProject.Ivg(VSZ.OSp);
        TestTempoAutomationEventTimeline testTempoAutomationEventTimeline = (TestTempoAutomationEventTimeline)this.cast(testProject.Nyy().QCa().OSp(testTransport.onT()).lXt(), TestTempoAutomationEventTimeline.class);
        double d2 = 120.0;
        int n2 = 24;
        double d3 = 200.0;
        int n3 = 8;
        int n4 = 16;
        int n5 = 4;
        testTempoAutomationEventTimeline.Ivg(0.0, 120.0);
        testTempoAutomationEventTimeline.Ivg(8.0, 200.0);
        testTempoAutomationEventTimeline.Ivg(16.0, 200.0);
        testTempoAutomationEventTimeline.Ivg(24.0, 120.0);
        int n6 = 66;
        TestAudioNoteClipEvent testAudioNoteClipEvent = this.recordClip(testProject, testTrack, 0.0, 24.0, AGq.Ivg);
        this.check("recorded clip", testAudioNoteClipEvent).zEU();
        this.check("start time", testAudioNoteClipEvent.zEU()).Ivg(0.0);
        TestAudioNoteEventTimeline testAudioNoteEventTimeline = (TestAudioNoteEventTimeline)this.cast(testAudioNoteClipEvent.Ivg(0, 0), TestAudioNoteEventTimeline.class);
        this.check("event count", testAudioNoteEventTimeline.onT()).Ivg(1);
        TestAudioNoteEvent testAudioNoteEvent = (TestAudioNoteEvent)this.cast(testAudioNoteEventTimeline.OSp(0), TestAudioNoteEvent.class);
        this.check("event time", testAudioNoteEvent.zEU()).Ivg(0.0);
        this.check(!testAudioNoteEvent.kpx());
        TestWarpEventTimeline testWarpEventTimeline = testAudioNoteEvent.Nyy();
        TestSampleReference testSampleReference = testAudioNoteEvent.lXt();
        testSampleReference.Nyy();
        this.check("warp event count", testWarpEventTimeline.onT()).Ivg(66);
        double d4 = testSampleReference.tGb();
        double d5 = 24.0;
        this.check(!testSampleReference.onT());
        String string = testSampleReference.lXt().lXt().lXt();
        File file = new File(string);
        this.check("recorded file", file).onT().QCa().OSp(0L);
        zuD zuD2 = zuD.Ivg(Nni.oHp(file));
        double d6 = zuD2.GXr();
        this.check("file duration", d6).OSp(d4, 7.0);
        OpN opN = zuD2.Kyj();
        this.check("metadata chunk", opN).zEU();
        Xpb xpb = opN.Ivg();
        this.check("warp markers", xpb).zEU();
        int n7 = xpb.OSp();
        this.check("warp marker count", n7).Ivg(66);
        for (int i2 = 0; i2 < 32; ++i2) {
            double d7 = (double)i2 / 4.0;
            double d8 = testProject.Ivg(d7);
            this.checkWarpMarkerWithTempoAutomation(i2, xpb, testWarpEventTimeline, d7, d8);
        }
        this.checkWarpMarkerWithTempoAutomation(n7 - 1, xpb, testWarpEventTimeline, 24.0, d6);
        this.checkLoadingAudioNoteHasExpectedWarpMarkers(file, xpb);
        testProject.Lea();
    }

    private void checkWarpMarkerWithTempoAutomation(int n2, Xpb xpb, TestWarpEventTimeline testWarpEventTimeline, double d2, double d3) {
        VLQ vLQ = xpb.Ivg(n2);
        double d4 = vLQ.OSp();
        this.check("warp marker beat time " + n2, d4).Ivg(d2, 3);
        if (n2 > 0 && n2 < xpb.OSp() - 1) {
            this.checkBeatTime("warp marker " + n2 + " beat time", d4).lXt();
        }
        this.check("warp marker sample time " + n2, vLQ.Ivg()).Ivg(d3, 1);
        TestWarpEvent testWarpEvent = (TestWarpEvent)this.cast(testWarpEventTimeline.OSp(n2), TestWarpEvent.class);
        double d5 = testWarpEvent.zEU();
        this.checkBeatTime("warp event beat time " + n2, d5).ZAb();
        if (n2 > 0 && n2 < xpb.OSp() - 1) {
            this.checkBeatTime("warp event beat time " + n2, d4).lXt();
        }
        this.check("warp event sample time " + n2, testWarpEvent.lXt()).Ivg(vLQ.Ivg());
    }

    protected abstract TestAudioNoteClipEvent recordClip(TestProject var1, TestTrack var2, double var3, double var5, AGq var7);

    protected double getExpectedDurationInBeatsTolerance(double d2) {
        return 0.0;
    }

    private void checkAudioClipNoTempoAutomation(TestAudioNoteClipEvent testAudioNoteClipEvent, double d2, double d3, double d4, File file, AGq aGq2) {
        double d5 = d3 / d2 * 60.0;
        double d6 = d4 != 0.0 ? d4 / d2 * 60.0 : 1.0 / (double)this.getSampleRate();
        this.checkAudioClipNoTempoAutomation(testAudioNoteClipEvent, d2, d3, d4, d5, d6, file, aGq2);
    }

    private void checkAudioClipNoTempoAutomation(TestAudioNoteClipEvent testAudioNoteClipEvent, double d2, double d3, double d4, double d5, double d6, File file, AGq aGq2) {
        this.check("clip", testAudioNoteClipEvent).zEU();
        this.check("start time", testAudioNoteClipEvent.zEU()).Ivg(0.0);
        TestAudioNoteEventTimeline testAudioNoteEventTimeline = (TestAudioNoteEventTimeline)this.cast(testAudioNoteClipEvent.Ivg(0, 0), TestAudioNoteEventTimeline.class);
        this.check("event count", testAudioNoteEventTimeline.onT()).Ivg(1);
        TestAudioNoteEvent testAudioNoteEvent = (TestAudioNoteEvent)this.cast(testAudioNoteEventTimeline.OSp(0), TestAudioNoteEvent.class);
        this.check("event time", testAudioNoteEvent.zEU()).Ivg(0.0);
        this.check("!isBeingRecorded", !testAudioNoteEvent.kpx());
        TestWarpEventTimeline testWarpEventTimeline = testAudioNoteEvent.Nyy();
        int n2 = testWarpEventTimeline.onT();
        this.check("warp event count", n2).Ivg(2);
        TestSampleReference testSampleReference = testAudioNoteEvent.lXt();
        testSampleReference.Nyy();
        double d7 = testSampleReference.tGb();
        if (aGq2 == AGq.Ivg) {
            this.check("sample ref duration", d7).OSp(d5, d6);
        }
        double d8 = testAudioNoteClipEvent.tGb();
        this.checkBeatTime("clip duration", d8).ZAb().OSp(d3, d4);
        this.check("event duration", testAudioNoteEvent.tGb()).Ivg(d8);
        TestWarpEvent testWarpEvent = (TestWarpEvent)this.cast(testWarpEventTimeline.OSp(0), TestWarpEvent.class);
        this.check("first warp event time", testWarpEvent.zEU()).Ivg(0.0);
        this.check("first warp event sample time", testWarpEvent.lXt()).Ivg(0.0);
        TestWarpEvent testWarpEvent2 = (TestWarpEvent)this.cast(testWarpEventTimeline.OSp(n2 - 1), TestWarpEvent.class);
        this.check("last warp event time", testWarpEvent2.zEU()).Ivg(d8);
        if (aGq2 == AGq.Ivg) {
            this.check("last warp event sample time", testWarpEvent2.lXt()).Ivg(d7);
        }
        this.check(!testSampleReference.onT());
        String string = testSampleReference.lXt().lXt().lXt();
        File file2 = new File(string);
        if (file != null) {
            this.check(file.getPath()).Ivg(file2.getPath());
        }
        if (aGq2 == AGq.Ivg) {
            this.checkAudioFile(file2, d7, d8);
        }
    }

    protected void checkAudioFile(File file, double d2, double d3) {
        this.check("file", file).onT().QCa().OSp(0L);
        zuD zuD2 = zuD.Ivg(Nni.oHp(file));
        this.check("sample rate correct", zuD2.GC2()).Ivg(this.getSampleRate());
        this.check("channel count correct", zuD2.zEU()).Ivg(2);
        this.check("bit depth correct", zuD2.fjZ()).Ivg(this.getExpectedBitsPerSample());
        double d4 = zuD2.GXr();
        this.check("file duration", d4).OSp(d2, 7.0);
        OpN opN = zuD2.Kyj();
        this.check("metadata chunk", opN).zEU();
        Xpb xpb = opN.Ivg();
        this.check("warp markers", xpb).zEU();
        int n2 = xpb.OSp();
        this.check("warp marker count", n2).Ivg(2).UB2().ZAb(2);
        VLQ vLQ = xpb.Ivg(0);
        this.check("first warp marker beat time", vLQ.OSp()).Ivg(0.0);
        this.check("first warp marker sample time", vLQ.Ivg()).Ivg(0.0);
        VLQ vLQ2 = xpb.Ivg(n2 - 1);
        this.checkBeatTime("last warp marker beat time", vLQ2.OSp()).lXt(d3);
        this.check("last warp marker sample time", vLQ2.Ivg()).Ivg(d4);
        this.checkLoadingAudioNoteHasExpectedWarpMarkers(file, xpb);
    }

    private void checkLoadingAudioNoteHasExpectedWarpMarkers(File file, Xpb xpb) {
        oRo oRo2 = new oRo(new soX(file));
        tgS tgS2 = (tgS)this.get(() -> Yx.Ivg().Ivg(false, false, false));
        int n2 = 60;
        oRo2.Ivg(60.0, tgS2, false, true, true, true, 50.0f, 180.0f, 0.25);
        Xpb xpb2 = oRo2.UB2();
        this.check("loaded sample info has warp markers", xpb2).zEU();
        this.checkHasSameWarpMarkers(xpb, xpb2);
        ESF eSF = ESF.Ivg(oRo2, G.OSp, 60.0, true);
        axt axt2 = eSF.f2j().TBp();
        this.checkWarpEventsAreCorrectForWarpMarkers(axt2, xpb);
    }

    private void checkHasSameWarpMarkers(Xpb xpb, Xpb xpb2) {
        this.check(xpb.OSp()).UB2().Ivg(xpb2.OSp());
        for (int i2 = 0; i2 < xpb.OSp(); ++i2) {
            VLQ vLQ = xpb.Ivg(i2);
            VLQ vLQ2 = xpb2.Ivg(i2);
            this.check("Warp marker " + (i2 + 1) + " is the same", vLQ).Ivg(vLQ2);
        }
    }

    private void checkWarpEventsAreCorrectForWarpMarkers(axt axt2, Xpb xpb) {
        int n2 = axt2.rr();
        int n3 = xpb.OSp();
        this.check("warp event count is correct", n2).Ivg(n3);
        for (int i2 = 0; i2 < Math.min(n3, n2); ++i2) {
            VLQ vLQ = xpb.Ivg(i2);
            TCy tCy = axt2.OSp(i2);
            this.check("Warp event " + (i2 + 1) + " beat time is correct", tCy.dYG()).Ivg(Bu.Ivg(vLQ.OSp()));
            this.check("Warp event " + (i2 + 1) + " sample time is correct", tCy.UB2()).Ivg(vLQ.Ivg());
        }
    }

    protected abstract int getExpectedBitsPerSample();

    protected abstract Class getErrorNotificationType();
}

