/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing;

import com.bitwig.base.io.CouldNotDeleteDirectoryException;
import com.bitwig.base.io.tSK;
import com.bitwig.base.platform.AGq;
import com.bitwig.base.testing.AnnotationBasedTest;
import com.bitwig.base.testing.GSm;
import com.bitwig.flt.app.testing.TestAudioNoteClipEvent;
import com.bitwig.flt.app.testing.TestAudioNoteEvent;
import com.bitwig.flt.app.testing.TestInstrumentNoteClipEvent;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.WPD;
import com.bitwig.flt.app.testing.Xpb;
import com.bitwig.flt.app.testing.avs;
import com.bitwig.flt.app.testing.pJZ;
import com.bitwig.flt.app.testing.qxu;
import com.bitwig.flt.app.testing.vbV;
import com.bitwig.flt.document.core.iface.Dt;
import com.bitwig.flt.document.core.master.Fto;
import com.bitwig.flt.document.core.master.X2Z;
import com.bitwig.flt.document.core.master.ZZF;
import com.bitwig.flt.document.core.master.yh2;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public abstract class BitwigStudioTest
extends AnnotationBasedTest {
    private int mEngineRunCount = 0;

    public boolean shouldRunAsUnitTest() {
        return true;
    }

    @Override
    protected void beforeRun() {
        super.beforeRun();
        this.mEngineRunCount = 0;
    }

    @Override
    protected void afterRun() {
        super.afterRun();
        this.getApplication().ZdK();
        this.addCPPAssertions();
        this.addNitroAssertions();
    }

    @Override
    protected void tearDown() {
        super.tearDown();
    }

    public void addEngineCrashes() {
        int n2 = this.mEngineRunCount;
        for (int i2 = 1; i2 <= n2; ++i2) {
            File file = this.getEngineCrashFile(i2, false);
            if (file == null || !file.canRead()) continue;
            File file2 = this.getEngineCrashInfoFile(i2, false);
            LOG.UB2("about to make engine crash bundle for: " + file.getAbsolutePath());
            String string = "engine-crash-report-" + i2;
            File file3 = this.getOutputFile(string, false);
            try {
                file3.mkdirs();
                this.getApplication().OSp(Nni.OSp(file3), file, this.getEngineLogFile(), file2);
                File file4 = this.getOutputFile(string + ".zip");
                ujE ujE2 = new ujE();
                ujE2.Ivg(file3);
                ujE2.OSp(file4);
                try {
                    tSK.ZAb(file3);
                }
                catch (CouldNotDeleteDirectoryException couldNotDeleteDirectoryException) {
                    LOG.OSp(couldNotDeleteDirectoryException);
                }
                file.delete();
                continue;
            }
            catch (IOException iOException) {
                LOG.oHp("failed to make engine crash report", iOException);
            }
        }
    }

    private void addNitroAssertions() {
        int n2 = this.mEngineRunCount;
        if (n2 == 0) {
            return;
        }
        jzx jzx2 = new jzx();
        for (int i2 = 1; i2 <= n2; ++i2) {
            Object object = this.getNitroAssertsFile(i2, false);
            try {
                jzx2.Ivg((File)object);
                continue;
            }
            catch (IOException iOException) {
                LOG.oHp("Error parsing nitro assertions file " + String.valueOf(object), iOException);
            }
        }
        for (Object object : jzx2.Ivg()) {
            this.addCheck(new rsS(((Uji)object).Ivg(), ((Uji)object).OSp(), ((Uji)object).oHp(), ((Uji)object).UB2(), ((Uji)object).ZAb(), ((Uji)object).lXt(), ((Uji)object).onT()));
        }
    }

    private void addCPPAssertions() {
        czi czi2 = AGq.Ivg();
        if (czi2 != null) {
            this.addCPPAssertions(czi2);
        }
    }

    private void addCPPAssertions(czi czi2) {
        for (SGd sGd : czi2.Ivg()) {
            this.addCheck(new xd(sGd.Ivg(), sGd.OSp(), sGd.oHp(), sGd.UB2(), sGd.ZAb(), sGd.lXt()));
        }
    }

    protected pJZ getApplication() {
        return (pJZ)this.getEventProcessor();
    }

    @Override
    public WPD getTestRunner() {
        return (WPD)super.getTestRunner();
    }

    public qxu getTestRunnerService() {
        WPD wPD = this.getTestRunner();
        if (wPD == null) {
            return null;
        }
        return (qxu)wPD.OSp().Ivg();
    }

    public int getSampleRate() {
        return 44100;
    }

    public int getBlockSize() {
        return 512;
    }

    protected File getOutputFile(String string) {
        return this.getOutputFile(string, true);
    }

    protected File getOutputFile(String string, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("test-output");
        stringBuilder.append('/');
        BitwigStudioTest.appendTestPathAsFilePath(this, stringBuilder);
        stringBuilder.append('/');
        stringBuilder.append(string);
        File file = this.getTestDataFile(stringBuilder.toString(), false).Vma();
        if (bl2 && file.exists()) {
            file.delete();
        }
        file.getParentFile().mkdirs();
        return file;
    }

    private static void appendTestPathAsFilePath(GSm gSm, StringBuilder stringBuilder) {
        GSm gSm2 = gSm.getParent();
        if (gSm2 != null) {
            BitwigStudioTest.appendTestPathAsFilePath(gSm2, stringBuilder);
            stringBuilder.append('/');
        }
        stringBuilder.append(tSK.fjZ(gSm.getTestName()));
    }

    public File getEngineLogFile() {
        return this.getOutputFile("engine.log", false);
    }

    public void engineStarting() {
        assert (bRD.OSp(this.isEventDispatchThread()));
        ++this.mEngineRunCount;
    }

    public boolean shouldEnableNitroAssertions() {
        return true;
    }

    public String getErrorFilesPrefix() {
        return "";
    }

    public final File getNitroAssertsFile() {
        assert (bRD.OSp(this.isEventDispatchThread()));
        assert (bRD.OSp(this.mEngineRunCount > 0));
        return this.getNitroAssertsFile(this.mEngineRunCount, true);
    }

    protected File getNitroAssertsFile(int n2, boolean bl2) {
        assert (bRD.OSp(n2 > 0));
        return this.getOutputFile(this.getErrorFilesPrefix() + "nitro-asserts" + n2 + ".txt", bl2);
    }

    public final File getEngineCrashFile() {
        assert (bRD.Ivg(this.isEventDispatchThread()));
        assert (bRD.Ivg(this.mEngineRunCount > 0));
        return this.getEngineCrashFile(this.mEngineRunCount, true);
    }

    protected File getEngineCrashFile(int n2, boolean bl2) {
        assert (bRD.Ivg(n2 > 0));
        if (V3m.OSp()) {
            return null;
        }
        String string = "";
        if (V3m.Ivg()) {
            string = ".mdmp";
        }
        if (V3m.ZAb()) {
            string = ".txt";
        }
        return this.getOutputFile(this.getErrorFilesPrefix() + "engine-crash-" + n2 + string, bl2);
    }

    protected File getEngineCrashInfoFile(int n2, boolean bl2) {
        assert (bRD.Ivg(n2 > 0));
        return this.getOutputFile(this.getErrorFilesPrefix() + "engine-crash-" + n2 + ".info", bl2);
    }

    protected Xpb getTestObject(Supplier supplier) {
        Xpb xpb = this.getOptTestObject(supplier);
        this.check(xpb).zEU();
        return xpb;
    }

    protected Xpb getTestObject(Supplier supplier, Class clazz) {
        Xpb xpb = this.getTestObject(supplier);
        return (Xpb)this.cast(xpb, clazz);
    }

    protected Xpb getOptTestObject(Supplier supplier, Class clazz) {
        Xpb xpb = this.getOptTestObject(supplier);
        if (xpb == null) {
            return null;
        }
        return (Xpb)this.cast(xpb, clazz);
    }

    protected Xpb getOptTestObject(Supplier supplier) {
        Object object = this.getOpt(supplier);
        if (object == null) {
            return null;
        }
        return vbV.Ivg(this, object);
    }

    public Xpb createTestObject(Object object) {
        return vbV.Ivg(this, object);
    }

    public Xpb createTestObject(Object object, Class clazz) {
        Xpb xpb = vbV.Ivg(this, object);
        return (Xpb)this.cast(xpb, clazz);
    }

    protected TestProject createTestProject(int n2, int n3) {
        assert (bRD.OSp(!this.isEventDispatchThread()));
        com.bitwig.base.async.pJZ pJZ2 = new com.bitwig.base.async.pJZ();
        this.getApplication().asyncExec(() -> this.getApplication().Ivg(this.getTestName(), n2, n3, new avs(this), pJZ2));
        ZZF zZF = (ZZF)this.waitForAsyncTask("New document", pJZ2, 5L, TimeUnit.SECONDS);
        TestProject testProject = new TestProject(this, zZF);
        this.openedProject(testProject);
        return testProject;
    }

    protected TestProject createTestProject() {
        return this.createTestProject(0, 0);
    }

    protected TestAudioNoteClipEvent createAudioNoteClipEvent(double d2, double d3) {
        fhG fhG2 = fhG.Ivg(d2, d3);
        fhG2.bkV().OSp(true);
        return (TestAudioNoteClipEvent)this.createTestObject(fhG2, TestAudioNoteClipEvent.class);
    }

    protected TestInstrumentNoteClipEvent createInstrumentNoteClipEvent(double d2, double d3) {
        return (TestInstrumentNoteClipEvent)this.createTestObject(PF3.Ivg(d2, d3), TestInstrumentNoteClipEvent.class);
    }

    protected TestAudioNoteEvent createDummyAudioNoteEvent(double d2, double d3) {
        String string = "dummy";
        X2Z x2Z = X2Z.Ivg("dummy", "", 2.0, 44100, 2);
        yh2 yh22 = yh2.Ivg("dummy", x2Z, 0L);
        yh22.UB2("somewhere_on_my_disk");
        yh22.Ivg((Dt)Fto.Ivg("/mnt/a/dummy"));
        return (TestAudioNoteEvent)this.createTestObject(ESF.Ivg(d2, d3, x2Z), TestAudioNoteEvent.class);
    }

    protected void openedProject(TestProject testProject) {
        qxu qxu2 = this.getTestRunnerService();
        if (qxu2.kyS()) {
            testProject.kpx();
        }
    }

    @Override
    protected GSm createChild() {
        BitwigStudioTest bitwigStudioTest = (BitwigStudioTest)super.createChild();
        bitwigStudioTest.mEngineRunCount = 0;
        return bitwigStudioTest;
    }

    public long getUndoCountLimit() {
        return 25L;
    }
}

