/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.extensions.importer.als.elements.devices;

import com.bitwig.extension.api.project.component.Multisample;
import com.bitwig.extension.api.project.component.MultisampleZone;
import com.bitwig.extension.api.project.component.SamplerResourceComponent;
import com.bitwig.extension.api.project.component.SingleSampleResource;
import com.bitwig.extension.api.project.file.SampleReference;
import com.bitwig.extension.api.project.parameter.Unit;
import com.bitwig.extensions.importer.als.elements.MultiSampleMap;
import com.bitwig.extensions.importer.als.elements.MultiSamplePart;
import com.bitwig.extensions.importer.als.elements.NativeDevice;
import java.util.List;
import java.util.UUID;
import org.xml.sax.Attributes;

public abstract class SimplerOrSampler
extends NativeDevice {
    private MultiSampleMap oHp;
    private int UB2 = 1;

    public SimplerOrSampler(VOE vOE) {
        super(vOE, UUID.fromString("468bc14b-b2e7-45a1-9666-e83117fe404e"));
        this.Ivg("Pitch/TransposeKey", "TRANSPOSE", Unit.SEMITONES_RELATIVE);
        this.Ivg("Filter/Slot/Value/SimplerFilter/Freq", "FILT_FREQ", Unit.HERTZ);
        this.Ivg("Filter/Slot/Value/SimplerFilter/Res", "FILT_RESO", Unit.NONE);
        this.Ivg("Filter/Slot/Value/SimplerFilter/ModByPitch", "FILTER_KEYTRACK", Unit.NONE);
        this.Ivg("VolumeAndPan/Volume", "GAIN", Unit.DECIBEL);
        this.Ivg("VolumeAndPan/VolumeVelScale", "VELOCITY_SENSITIVETY", Unit.PERCENTAGE_OF_RANGE);
        this.Ivg("VolumeAndPan/Panorama", "PAN", Unit.NONE);
        this.Ivg("VolumeAndPan/Envelope/AttackTime", "AMP_ATTACK_TIME", Unit.MILLISECONDS);
        this.Ivg("VolumeAndPan/Envelope/DecayTime", "AMP_DECAY_TIME", Unit.MILLISECONDS);
        this.Ivg("VolumeAndPan/Envelope/SustainLevel", "AMP_SUSTAIN_LEVEL", Unit.NONE);
        this.Ivg("VolumeAndPan/Envelope/ReleaseTime", "AMP_RELEASE_TIME", Unit.MILLISECONDS);
        this.Ivg("VolumeAndPan/Envelope/AttackSlope", "AMP_ATTACK_SHAPE", Unit.MILLISECONDS);
        this.Ivg("VolumeAndPan/Envelope/DecaySlope", "AMP_DECAY_SHAPE", Unit.MILLISECONDS, d2 -> -d2);
        this.Ivg("VolumeAndPan/Envelope/ReleaseSlope", "AMP_RELEASE_SHAPE", Unit.MILLISECONDS, d2 -> -d2);
        this.Ivg("Player/SampleSelector", "SELECT", Unit.MIDI128);
        this.Ivg("Player/LoopModulators/SampleStart", "SAMPLE_START", Unit.NONE);
        this.Ivg("Player/LoopModulators/LoopLength", "LOOP_LENGTH", Unit.NONE);
        this.Ivg("Globals/PortamentoTime", "POLY/GLIDE_TIME", Unit.MILLISECONDS);
    }

    @Override
    public void Ivg(String string, Attributes attributes) {
        super.Ivg(string, attributes);
        if (string.equals("Player/MultiSampleMap")) {
            this.oHp = new MultiSampleMap(this.x3R());
            this.x3R().Ivg(this.oHp);
        }
        if (string.equals("Globals/NumVoices")) {
            this.UB2 = this.UB2(attributes, "Value");
        }
    }

    public SamplerResourceComponent oHp() {
        return (SamplerResourceComponent)((com.bitwig.extension.api.project.mixer.NativeDevice)this.OSp()).getComponent("SAMPLE", SamplerResourceComponent.class);
    }

    @Override
    public void Ivg() {
        super.Ivg();
        SamplerResourceComponent samplerResourceComponent = this.oHp();
        List list = this.oHp.oHp();
        if (list.size() == 1) {
            MultiSamplePart multiSamplePart = (MultiSamplePart)list.get(0);
            SingleSampleResource singleSampleResource = samplerResourceComponent.loadSample(multiSamplePart.qFU().lXt(), false);
            this.Ivg(multiSamplePart, singleSampleResource);
            if (this.x3R().Ivg("DrumBranch")) {
                singleSampleResource.setKeyTrack(0.0);
            }
        } else {
            Multisample multisample = samplerResourceComponent.createMultisample();
            for (MultiSamplePart multiSamplePart : list) {
                SampleReference sampleReference = multiSamplePart.qFU().lXt();
                if (sampleReference == null) continue;
                MultisampleZone multisampleZone = multisample.addZone(sampleReference);
                this.Ivg(multiSamplePart, multisampleZone);
            }
        }
        ((com.bitwig.extension.api.project.mixer.NativeDevice)this.Ivg).setNumVoices(1 + this.UB2 + Math.max(0, this.UB2 - 7));
    }

    private void Ivg(MultiSamplePart multiSamplePart, MultisampleZone multisampleZone) {
        multisampleZone.setLowKey(multiSamplePart.oHp());
        multisampleZone.setLowKeyCf(multiSamplePart.ZAb() - multiSamplePart.oHp());
        multisampleZone.setHighKey(multiSamplePart.UB2());
        multisampleZone.setHighKeyCf(multiSamplePart.UB2() - multiSamplePart.lXt());
        multisampleZone.setLowVelocity(multiSamplePart.onT());
        multisampleZone.setLowVelocityCf(multiSamplePart.tGb() - multiSamplePart.onT());
        multisampleZone.setHighVelocity(multiSamplePart.Nyy());
        multisampleZone.setHighVelocityCf(multiSamplePart.Nyy() - multiSamplePart.Fqp());
        multisampleZone.setLowSelect(multiSamplePart.QCa());
        multisampleZone.setLowSelectCf(multiSamplePart.zEU() - multiSamplePart.QCa());
        multisampleZone.setHighSelect(multiSamplePart.kpx());
        multisampleZone.setHighSelectCf(multiSamplePart.kpx() - multiSamplePart.fjZ());
        SingleSampleResource singleSampleResource = multisampleZone.getResource();
        this.Ivg(multiSamplePart, singleSampleResource);
    }

    protected void Ivg(MultiSamplePart multiSamplePart, SingleSampleResource singleSampleResource) {
        double d2 = multiSamplePart.qFU().ZAb();
        singleSampleResource.setRootKey(multiSamplePart.GC2());
        singleSampleResource.setDetune((double)multiSamplePart.GXr() * 0.01);
        singleSampleResource.setKeyTrack((double)multiSamplePart.oMe() * 0.01);
        singleSampleResource.setGain(Syh.ZAb(multiSamplePart.NhN()));
        singleSampleResource.setSampleStart((double)multiSamplePart.Lea() / d2);
        singleSampleResource.setSampleEnd((double)multiSamplePart.kyS() / d2);
        double d3 = multiSamplePart.zvj() - multiSamplePart.BXy();
        singleSampleResource.setLoopStart((double)multiSamplePart.BXy() / d2);
        singleSampleResource.setLoopEnd((double)multiSamplePart.zvj() / d2);
        singleSampleResource.setLoopCrossfade(multiSamplePart.Kyj() / d3);
        singleSampleResource.setLoopMode(this.Ivg(multiSamplePart.EN()));
    }

    private bPU Ivg(int n2) {
        switch (n2) {
            case 1: {
                return bPU.OSp;
            }
            case 2: {
                return bPU.oHp;
            }
        }
        return bPU.Ivg;
    }
}

