/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.extensions.importer.als.elements.devices;

import com.bitwig.extension.api.project.DocumentObject;
import com.bitwig.extension.api.project.component.DrumPad;
import com.bitwig.extension.api.project.component.DrumPads;
import com.bitwig.extension.api.project.file.SampleReference;
import com.bitwig.extension.api.project.mixer.Mixer;
import com.bitwig.extension.api.project.parameter.Unit;
import com.bitwig.extensions.importer.als.elements.FloatParameter;
import com.bitwig.extensions.importer.als.elements.NativeDevice;
import com.bitwig.extensions.importer.als.elements.SampleRef;
import java.util.UUID;
import org.xml.sax.Attributes;

public class InstrumentImpulse
extends NativeDevice {
    private static int oHp = 8;
    private static final int[] UB2 = new int[]{60, 62, 64, 65, 67, 69, 71, 72};
    private SampleRef[] ZAb = new SampleRef[oHp];
    private MOo[] lXt = new MOo[oHp];
    private boolean[] onT = new boolean[oHp];
    private int[] tGb = new int[oHp];

    public InstrumentImpulse(VOE vOE) {
        super(vOE, UUID.fromString("8ea97e45-0255-40fd-bc7e-94419741e9d1"));
        this.Ivg("GlobalVolume", "MASTER_VOLUME", Unit.DECIBEL);
        DrumPads drumPads = this.oHp();
        for (int i2 = 0; i2 < oHp; ++i2) {
            int n2 = UB2[i2];
            DrumPad drumPad = drumPads.getDrumPad(n2);
            Mixer mixer = drumPad.getMixer();
            this.lXt[i2] = new MOo(this.rr());
            com.bitwig.extension.api.project.mixer.NativeDevice nativeDevice = this.lXt[i2].Ivg();
            drumPad.getDeviceChain().addDevice(nativeDevice);
            String string = "VolumeVolume." + i2;
            this.OSp.put(string, new FloatParameter(this.x3R(), string, mixer.getVolume(), Unit.DECIBEL));
            String string2 = "VolumePan." + i2;
            this.OSp.put(string2, new FloatParameter(this.x3R(), string2, mixer.getPan(), Unit.NONE));
            String string3 = "StartTune." + i2;
            this.OSp.put(string3, new FloatParameter(this.x3R(), string3, nativeDevice.getDoubleParameter("TRANSPOSE"), Unit.SEMITONES_RELATIVE));
            String string4 = "FilterFreq." + i2;
            this.OSp.put(string4, new FloatParameter(this.x3R(), string4, nativeDevice.getDoubleParameter("FILT_FREQ"), Unit.HERTZ));
        }
    }

    @Override
    public void Ivg(String string, Attributes attributes) {
        super.Ivg(string, attributes);
        DrumPads drumPads = this.oHp();
        for (int i2 = 0; i2 < oHp; ++i2) {
            int n2 = UB2[i2];
            DrumPad drumPad = drumPads.getDrumPad(n2);
            if (string.equals("TabSample." + i2 + "/Value/SampleRef")) {
                this.ZAb[i2] = new SampleRef(this.x3R());
                this.x3R().Ivg(this.ZAb[i2]);
                continue;
            }
            if (string.equals("VolumeMute." + i2)) {
                drumPad.getMixer().getMute().setValue(this.oHp(attributes, "Value"));
                continue;
            }
            if (string.equals("VolumeSolo." + i2)) continue;
            if (string.equals("FilterOn." + i2)) {
                this.onT[i2] = this.oHp(attributes, "Value");
                continue;
            }
            if (!string.equals("FilterType." + i2 + "/Manual")) continue;
            this.tGb[i2] = this.UB2(attributes, "Value");
        }
    }

    @Override
    public void Ivg() {
        super.Ivg();
        for (int i2 = 0; i2 < oHp; ++i2) {
            DocumentObject documentObject;
            MOo mOo = this.lXt[i2];
            com.bitwig.extension.api.project.mixer.NativeDevice nativeDevice = mOo.Ivg();
            if (this.ZAb[i2] != null && (documentObject = this.ZAb[i2].lXt()) != null) {
                mOo.OSp().loadSample((SampleReference)documentObject, false);
            }
            if (!this.onT[i2]) continue;
            documentObject = nativeDevice.getEnumParameter("FILTER_TYPE");
            documentObject.setValue(this.Ivg(this.tGb[i2]));
        }
    }

    private int Ivg(int n2) {
        switch (n2) {
            case 0: {
                return 0;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 12;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 11;
            }
            case 6: {
                return 4;
            }
        }
        return 13;
    }

    public DrumPads oHp() {
        return (DrumPads)((com.bitwig.extension.api.project.mixer.NativeDevice)this.OSp()).getComponent("DRUM_PADS", DrumPads.class);
    }
}

