/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.extensions.importer.als.elements;

import com.bitwig.extension.api.project.parameter.AutomationEvents;
import com.bitwig.extension.api.project.parameter.Unit;
import com.bitwig.extension.api.project.timeline.NoteClip;
import com.bitwig.extension.api.project.timeline.NoteClipContent;
import com.bitwig.extensions.importer.als.elements.Clip;

public class ControllerTarget
implements dWA {
    private final Unit Ivg;
    private final int OSp;
    private final VOE oHp;

    @Override
    public void applyModulation(Clip clip, AutomationEvents automationEvents) {
        NoteClip noteClip = (NoteClip)clip.ZAb();
        NoteClipContent noteClipContent = (NoteClipContent)noteClip.getContent();
        if (this.OSp()) {
            noteClipContent.addMidiPitchBendEvents(0, automationEvents);
        } else if (this.oHp()) {
            noteClipContent.addMidiChannelPressureEvents(0, automationEvents);
        } else {
            noteClipContent.addMidiChannelControllerEvents(0, this.UB2(), automationEvents);
        }
    }

    @Override
    public Unit t_() {
        return this.Ivg;
    }

    public ControllerTarget(VOE vOE, int n2, Unit unit) {
        this.oHp = vOE;
        this.OSp = n2;
        this.Ivg = this.OSp() ? Unit.NONE : Unit.MIDI128;
    }

    private boolean OSp() {
        return this.OSp == 0;
    }

    private boolean oHp() {
        return this.OSp == 1;
    }

    private int UB2() {
        if (this.OSp < 2) {
            throw new IllegalStateException();
        }
        return this.OSp - 2;
    }
}

