/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.extensions.importer.als.elements;

import com.bitwig.extension.api.project.file.SampleReference;
import com.bitwig.extension.api.project.parameter.Unit;
import com.bitwig.extension.api.project.timeline.AudioClipContent;
import com.bitwig.extension.api.project.timeline.AudioNote;
import com.bitwig.extension.api.project.timeline.AudioNoteTimeline;
import com.bitwig.extension.api.project.timeline.TransientRate;
import com.bitwig.extension.api.project.timeline.WarpMarkers;
import com.bitwig.extension.api.project.timeline.WarpMode;
import com.bitwig.extension.api.project.timeline.WarpTailMode;
import com.bitwig.extensions.importer.als.elements.AGq;
import com.bitwig.extensions.importer.als.elements.Clip;
import com.bitwig.extensions.importer.als.elements.MainSequencer;
import com.bitwig.extensions.importer.als.elements.Modulation;
import com.bitwig.extensions.importer.als.elements.SampleRef;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;

public class AudioClip
extends Clip {
    private List Ivg = new ArrayList();
    private double OSp;
    private double oHp;
    private double UB2;
    private double ZAb;
    private double lXt;
    private boolean onT;
    private int tGb;
    private int Fqp;
    private int QCa;
    private double kpx;
    private double zEU;
    private double fjZ;
    private List GC2 = new ArrayList();
    private SampleRef GXr;
    private final MainSequencer Lea;
    private AudioNote kyS;
    private boolean qFU;
    private int oMe;

    public AudioClip(VOE vOE, com.bitwig.extension.api.project.timeline.AudioClip audioClip, MainSequencer mainSequencer) {
        super(vOE, audioClip);
        this.Lea = mainSequencer;
    }

    @Override
    public void Ivg(String string, Attributes attributes) {
        super.Ivg(string, attributes);
        if (string.equalsIgnoreCase("WarpMarkers/WarpMarker")) {
            double d2 = this.ZAb(attributes, "SecTime");
            double d3 = this.ZAb(attributes, "BeatTime");
            if (d2 >= 0.0) {
                this.Ivg.add(new AGq(this, d2, d3));
            } else {
                System.err.println("Skipping invalid warp marker found in als file with beat time " + d3 + " and sample time " + d2);
            }
        } else if (string.equalsIgnoreCase("SampleRef")) {
            this.GXr = new SampleRef(this.x3R());
            this.x3R().Ivg(this.GXr);
        } else if (string.equalsIgnoreCase("ModulationList/Modulations/Modulation")) {
            Modulation modulation = new Modulation(this.x3R(), this.Lea, this);
            this.GC2.add(modulation);
            this.x3R().Ivg(modulation);
        } else if (string.equalsIgnoreCase("PitchCoarse")) {
            this.OSp = this.UB2(attributes, "Value");
        } else if (string.equalsIgnoreCase("PitchFine")) {
            this.oHp = this.ZAb(attributes, "Value");
        } else if (string.equalsIgnoreCase("SampleVolume")) {
            this.UB2 = this.ZAb(attributes, "Value");
        } else if (string.equalsIgnoreCase("Fade")) {
            this.qFU = this.oHp(attributes, "Value");
        } else if (string.equalsIgnoreCase("Fades/FadeInLength")) {
            this.ZAb = this.lXt(attributes, "Value");
        } else if (string.equalsIgnoreCase("Fades/FadeOutLength")) {
            this.lXt = this.lXt(attributes, "Value");
        } else if (string.equalsIgnoreCase("Fades/CrossfadeInState")) {
            this.oMe = this.UB2(attributes, "Value");
        } else if (string.equalsIgnoreCase("IsWarped")) {
            this.onT = this.oHp(attributes, "Value");
        } else if (string.equalsIgnoreCase("WarpMode")) {
            this.tGb = this.UB2(attributes, "Value");
        } else if (string.equalsIgnoreCase("TransientResolution")) {
            this.Fqp = this.UB2(attributes, "Value");
        } else if (string.equalsIgnoreCase("TransientLoopMode")) {
            this.QCa = this.UB2(attributes, "Value");
        } else if (string.equalsIgnoreCase("TransientEnvelope")) {
            this.kpx = this.ZAb(attributes, "Value");
        } else if (string.equalsIgnoreCase("ComplexProFormants")) {
            this.zEU = this.ZAb(attributes, "Value");
        } else if (string.equalsIgnoreCase("ComplexProEnvelope")) {
            this.fjZ = this.ZAb(attributes, "Value");
        }
    }

    @Override
    public void Ivg(String string) {
        super.Ivg(string);
    }

    @Override
    public void Ivg() {
        double d2;
        double d3;
        super.Ivg();
        SampleReference sampleReference = this.GXr.lXt();
        if (sampleReference == null) {
            return;
        }
        WarpMarkers warpMarkers = this.rr().createWarpEvents();
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        double d4 = !this.Ivg.isEmpty() ? ((AGq)this.Ivg.getFirst()).oHp : 0.0;
        for (AGq aGq2 : this.Ivg) {
            double d5 = aGq2.oHp - d4;
            double d6 = aGq2.OSp;
            dArray2[0] = d6 - dArray[0];
            dArray2[1] = d5 - dArray[1];
            dArray[0] = d6;
            dArray[1] = d5;
            warpMarkers.addWarpEvent(d5, d6);
        }
        double d7 = 0.0;
        if (!this.Ivg.isEmpty()) {
            AGq aGq3 = (AGq)this.Ivg.getLast();
            if (this.GXr.oHp()) {
                double d8 = this.GXr.UB2();
                d3 = d8 - aGq3.OSp;
                d7 = aGq3.oHp + d3 * dArray2[1] / dArray2[0] - d4;
                if (d3 > 0.0) {
                    warpMarkers.addWarpEvent(d7, d8);
                }
            } else {
                d7 = aGq3.oHp - d4;
            }
        }
        this.kyS = this.rr().createAudioNote(d4, d7, sampleReference);
        this.kyS.setWarpEvents(warpMarkers);
        if (this.GXr.onT() != null) {
            this.kyS.analyzeOnsets(this.GXr.onT());
        }
        if ((d2 = this.OSp()) != 0.0) {
            this.kyS.getTranspose().setValue(d2, Unit.SEMITONES);
        }
        if (this.UB2 != 1.0) {
            this.kyS.getGain().setValue(this.UB2, Unit.NONE);
        }
        this.Ivg(this.kyS);
        AudioNoteTimeline audioNoteTimeline = (AudioNoteTimeline)((AudioClipContent)((com.bitwig.extension.api.project.timeline.AudioClip)this.ZAb()).getContent()).getNoteTimeline();
        this.Ivg(() -> audioNoteTimeline.addEvent(this.kyS), Sud.UB2);
        d3 = this.oMe == 1 ? -this.Lea.UB2() : this.ZAb;
        this.Ivg(() -> ((com.bitwig.extension.api.project.timeline.AudioClip)this.ZAb()).setFadeInTime(d3), Sud.ZAb);
        ((com.bitwig.extension.api.project.timeline.AudioClip)this.ZAb()).setFadeOutTime(this.lXt);
        this.Lea.Ivg(this.lXt);
    }

    private void Ivg(AudioNote audioNote) {
        if (!this.onT) {
            audioNote.setWarpMode(WarpMode.RAW);
        } else if (this.tGb == 0) {
            audioNote.setWarpMode(WarpMode.SLICE);
        } else if (this.tGb == 1) {
            audioNote.setWarpMode(WarpMode.STRETCH);
        } else if (this.tGb == 2) {
            audioNote.setWarpMode(WarpMode.CYCLIC);
        } else if (this.tGb == 3) {
            audioNote.setWarpMode(WarpMode.REPITCH);
        } else if (this.tGb == 4) {
            audioNote.setWarpMode(WarpMode.ELASTIQUE);
        } else if (this.tGb == 6) {
            audioNote.setWarpMode(WarpMode.ELASTIQUE_PRO);
        }
        audioNote.setPreserveFormants(this.zEU >= 50.0);
        audioNote.setFormantEnvelopeResolution((int)this.fjZ);
        if (this.Fqp == 6) {
            audioNote.setTransientRate(TransientRate.ONSETS);
        } else if (this.Fqp == 0) {
            audioNote.setTransientRate(TransientRate.EIGHT);
        } else if (this.Fqp == 1) {
            audioNote.setTransientRate(TransientRate.EIGHT);
        } else if (this.Fqp == 3) {
            audioNote.setTransientRate(TransientRate.EIGHT);
        } else if (this.Fqp == 4) {
            audioNote.setTransientRate(TransientRate.SIXTEENTH);
        } else if (this.Fqp == 5) {
            audioNote.setTransientRate(TransientRate.SIXTEENTH);
        }
        if (this.QCa == 2) {
            audioNote.setWarpTailMode(WarpTailMode.PINGPONG);
        } else if (this.QCa == 1) {
            audioNote.setWarpTailMode(WarpTailMode.GRAIN);
        } else if (this.QCa == 0) {
            audioNote.setWarpTailMode(WarpTailMode.NONE);
        }
    }

    public double OSp() {
        return this.OSp + this.oHp * 0.01;
    }

    public double oHp() {
        return this.UB2;
    }

    public AudioNote UB2() {
        return this.kyS;
    }
}

