/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.extension.api.util.midi;

public class ShortMidiMessage {
    public static final int NOTE_OFF = 128;
    public static final int NOTE_ON = 144;
    public static final int POLY_PRESSURE = 160;
    public static final int CONTROL_CHANGE = 176;
    public static final int PROGRAM_CHANGE = 192;
    public static final int CHANNEL_PRESSURE = 208;
    public static final int PITCH_BEND = 224;
    public static final int MIDI_TIME_CODE = 241;
    public static final int SONG_POSITION_POINTER = 242;
    public static final int SONG_SELECT = 243;
    public static final int TUNE_REQUEST = 246;
    public static final int TIMING_CLOCK = 248;
    public static final int START = 250;
    public static final int CONTINUE = 251;
    public static final int STOP = 252;
    public static final int ACTIVE_SENSING = 254;
    public static final int SYSTEM_RESET = 255;
    private int mData;

    public ShortMidiMessage(int n2, int n3, int n4) {
        this.mData = n2 | n3 << 8 | n4 << 16;
    }

    public int getStatusByte() {
        return this.mData & 0xFF;
    }

    public int getData1() {
        return this.mData >> 8 & 0xFF;
    }

    public int getData2() {
        return this.mData >> 16 & 0xFF;
    }

    public int getChannel() {
        return this.mData & 0xF;
    }

    private int getStatusMessage() {
        return this.mData & 0xF0;
    }

    public boolean isNoteOff() {
        return this.getStatusMessage() == 128;
    }

    public boolean isNoteOn() {
        return this.getStatusMessage() == 144;
    }

    public boolean isPitchBend() {
        return this.getStatusMessage() == 224;
    }

    public boolean isPolyPressure() {
        return this.getStatusMessage() == 160;
    }

    public boolean isControlChange() {
        return this.getStatusMessage() == 176;
    }

    public boolean isProgramChange() {
        return this.getStatusMessage() == 192;
    }

    public boolean isChannelPressure() {
        return this.getStatusMessage() == 208;
    }

    public String toString() {
        return "status: " + this.getStatusMessage() + ", channel: " + this.getChannel() + ", data1: " + this.getData1() + ", data2: " + this.getData2();
    }
}

