/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.base.file_notification.linux;

import com.bitwig.base.file_notification.FileSystemWatcher;
import com.bitwig.base.file_notification.JQ;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

final class LinuxFileSystemWatcher
extends FileSystemWatcher {
    private static final Executor Ivg = new ThreadPoolExecutor(0, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    private long OSp;
    private Semaphore oHp;

    LinuxFileSystemWatcher(long l2, File file, int n2, boolean bl2, JQ jQ2) {
        super(file, n2, bl2, jQ2);
        this.OSp = this.create(l2, file.getAbsolutePath(), n2, bl2);
        if (this.OSp == 0L) {
            throw new IOException("Could not register watch for directory " + String.valueOf(file));
        }
        if (bl2) {
            this.oHp = new Semaphore(0);
            Ivg.execute(() -> {
                LinuxFileSystemWatcher.addSubHierarchyWatchers(this.OSp);
                this.oHp.release();
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        LinuxFileSystemWatcher linuxFileSystemWatcher = this;
        synchronized (linuxFileSystemWatcher) {
            if (this.OSp != 0L) {
                if (this.isRecursive()) {
                    LinuxFileSystemWatcher.stopAddingSubHierarchyWatchers(this.OSp);
                    try {
                        this.oHp.acquire();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                LinuxFileSystemWatcher.destroy(this.OSp);
                this.OSp = 0L;
            }
        }
    }

    private native long create(long var1, String var3, int var4, boolean var5);

    private static native void addSubHierarchyWatchers(long var0);

    private static native void stopAddingSubHierarchyWatchers(long var0);

    private static native void destroy(long var0);

    private void fileCreated(String string) {
        this.mListener.Ivg(this, string);
    }

    private void fileModified(String string) {
        this.mListener.oHp(this, string);
    }

    private void fileDeleted(String string) {
        this.mListener.OSp(this, string);
    }
}

