/*
 * Decompiled with CFR 0.152.
 */
import com.bitwig.extension.api.opensoundcontrol.OscAddressSpace;
import com.bitwig.extension.api.opensoundcontrol.OscConnection;
import com.bitwig.extension.api.opensoundcontrol.OscMessage;
import com.bitwig.extension.api.opensoundcontrol.OscMethod;
import com.bitwig.extension.api.opensoundcontrol.OscModule;
import com.bitwig.extension.api.opensoundcontrol.OscServer;
import com.bitwig.extension.controller.ControllerExtension;
import com.bitwig.extension.controller.api.ChainSelector;
import com.bitwig.extension.controller.api.ControllerHost;
import com.bitwig.extension.controller.api.CursorDevice;
import com.bitwig.extension.controller.api.CursorTrack;
import com.bitwig.extension.controller.api.DeviceLayer;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.MasterTrack;
import com.bitwig.extension.controller.api.Preferences;
import com.bitwig.extension.controller.api.SettableIntegerValue;
import com.bitwig.extension.controller.api.SettableRangedValue;
import com.bitwig.extension.controller.api.Transport;
import java.io.IOException;

public class XGU
extends ControllerExtension {
    private Transport Ivg;
    private MasterTrack OSp;
    private CursorTrack oHp;
    private CursorDevice UB2;
    private ChainSelector ZAb;
    private DeviceLayer lXt;
    private SettableIntegerValue onT;
    private IntegerValue Nyy;
    private OscServer tGb;

    public XGU(ROT rOT, ControllerHost controllerHost) {
        super(rOT, controllerHost);
    }

    @Override
    public void init() {
        ControllerHost controllerHost = (ControllerHost)this.getHost();
        Preferences preferences = controllerHost.getPreferences();
        SettableRangedValue settableRangedValue = preferences.getNumberSetting("port", "Server", 1024.0, 32000.0, 1.0, "", 9001.0);
        settableRangedValue.addRawValueObserver(this::Ivg);
        this.Ivg = controllerHost.createTransport();
        this.OSp = controllerHost.createMasterTrack(1);
        this.oHp = controllerHost.createCursorTrack("osc-cursor-track", "OSC cursor track", 1, 1, true);
        this.UB2 = this.oHp.createCursorDevice();
        this.ZAb = this.UB2.createChainSelector();
        this.lXt = this.ZAb.activeChain();
        this.onT = this.ZAb.activeChainIndex();
        this.Nyy = this.ZAb.chainCount();
        this.lXt.name().markInterested();
        this.Nyy.markInterested();
        this.onT.markInterested();
        this.Ivg();
    }

    private void Ivg(double d2) {
        int n2 = (int)d2;
        try {
            this.tGb.start(n2);
        }
        catch (IOException iOException) {
            ((ControllerHost)this.getHost()).showPopupNotification("Could not set the OSC port to " + n2 + ": " + iOException.getMessage());
        }
    }

    @Override
    public void exit() {
    }

    @Override
    public void flush() {
    }

    private void Ivg() {
        OscModule oscModule = ((ControllerHost)this.getHost()).getOscModule();
        OscAddressSpace oscAddressSpace = oscModule.createAddressSpace();
        oscAddressSpace.setName("bitwig");
        oscAddressSpace.registerObjectMethods("/bitwig/transport", this.Ivg);
        oscAddressSpace.registerObjectMethods("/bitwig/cursorDevice", this.UB2);
        oscAddressSpace.registerObjectMethods("/bitwig/cursorTrack", this.oHp);
        oscAddressSpace.registerObjectMethods("/bitwig/masterTrack", this.OSp);
        oscAddressSpace.registerObjectMethods("/bitwig/", this);
        oscAddressSpace.registerDefaultMethod(this::Ivg);
        oscAddressSpace.setShouldLogMessages(true);
        this.tGb = oscModule.createUdpServer(oscAddressSpace);
    }

    private void Ivg(OscConnection oscConnection, OscMessage oscMessage) {
        ((ControllerHost)this.getHost()).println("OSC method not found for " + oscMessage.getAddressPattern() + "(" + oscMessage.getTypeTag() + ")");
    }

    @OscMethod(address="/test/int")
    public void handleTestInt(int n2) {
        ((ControllerHost)this.getHost()).println("int value: " + n2);
    }

    @OscMethod(address="/test/long")
    public void handleTestLong(long l2) {
        ((ControllerHost)this.getHost()).println("long value: " + l2);
    }

    @OscMethod(address="/test/float")
    public void handleTestFloat(float f2) {
        ((ControllerHost)this.getHost()).println("float value: " + f2);
    }

    @OscMethod(address="/test/double")
    public void handleTestDouble(double d2) {
        ((ControllerHost)this.getHost()).println("double value: " + d2);
    }

    @OscMethod(address="/test/bool")
    public void handleTestBool(boolean bl2) {
        ((ControllerHost)this.getHost()).println("boolean value: " + bl2);
    }

    @OscMethod(address="/test/string")
    public void handleTestString(String string) {
        ((ControllerHost)this.getHost()).println("string value: " + string);
    }

    @OscMethod(address="/test/ping")
    public void handleTestPing(OscConnection oscConnection) {
        oscConnection.sendMessage("/test/pong", new Object[0]);
    }

    @OscMethod(address="/test/chain-selector/select-next")
    public void handleChainSelectorNext() {
        this.ZAb.selectNext();
    }

    @OscMethod(address="/test/chain-selector/select-prev")
    public void handleChainSelectorPrev() {
        this.ZAb.selectPrevious();
    }

    @OscMethod(address="/test/chain-selector/select-first")
    public void handleChainSelectorFirst() {
        this.ZAb.selectFirst();
    }

    @OscMethod(address="/test/chain-selector/select-last")
    public void handleChainSelectorLast() {
        this.ZAb.selectLast();
    }

    @OscMethod(address="/test/chain-selector/cycle-next")
    public void handleChainSelectorCycleNext() {
        this.ZAb.cycleNext();
    }

    @OscMethod(address="/test/chain-selector/cycle-prev")
    public void handleChainSelectorCyclePrev() {
        this.ZAb.cyclePrevious();
    }

    @OscMethod(address="/test/chain-selector/test-active-chain")
    public void handleChainSelectorTestActiveChain() {
        ((ControllerHost)this.getHost()).println("ChainSelectorIndex: " + this.onT.get());
        ((ControllerHost)this.getHost()).println("ChainSelectorChainCount: " + this.Nyy.get());
        ((ControllerHost)this.getHost()).println("ChainSelectorActiveChainName: " + this.lXt.name().get());
    }
}

