/*
 * Decompiled with CFR 0.152.
 */
import com.bitwig.extension.api.Color;
import com.bitwig.extension.api.graphics.Bitmap;
import com.bitwig.extension.api.graphics.BitmapFormat;
import com.bitwig.extension.controller.ControllerExtension;
import com.bitwig.extension.controller.api.ControllerHost;
import com.bitwig.extension.controller.api.CursorRemoteControlsPage;
import com.bitwig.extension.controller.api.CursorTrack;
import com.bitwig.extension.controller.api.HardwareButton;
import com.bitwig.extension.controller.api.HardwarePixelDisplay;
import com.bitwig.extension.controller.api.HardwareSurface;
import com.bitwig.extension.controller.api.MidiIn;
import com.bitwig.extension.controller.api.MultiStateHardwareLight;
import com.bitwig.extension.controller.api.PinnableCursorDevice;
import com.bitwig.extension.controller.api.RelativeHardwareKnob;
import com.bitwig.extension.controller.api.RelativePosition;
import com.bitwig.extension.controller.api.RemoteControl;

public class MKF
extends ControllerExtension {
    private CursorTrack Ivg;
    private PinnableCursorDevice OSp;
    private HardwareSurface oHp;
    private RelativeHardwareKnob[] UB2 = new RelativeHardwareKnob[8];
    private RelativeHardwareKnob[] ZAb = new RelativeHardwareKnob[8];
    private CursorRemoteControlsPage lXt;
    private HardwarePixelDisplay[] onT = new HardwarePixelDisplay[8];
    private Bitmap[] Nyy = new Bitmap[8];
    private CursorRemoteControlsPage tGb;
    private CursorRemoteControlsPage Fqp;
    private RelativeHardwareKnob QCa;
    private HardwareButton[] kpx = new HardwareButton[4];
    private HardwareButton[] zEU = new HardwareButton[4];
    private HardwareButton[] fjZ = new HardwareButton[4];
    private HardwareButton[] GC2 = new HardwareButton[4];

    public MKF(WQB wQB, ControllerHost controllerHost) {
        super(wQB, controllerHost);
    }

    private HardwareButton Ivg(String string, int n2, int n3, int n4) {
        HardwareButton hardwareButton = this.oHp.createHardwareButton(string + n2);
        hardwareButton.setBounds(n3, n4, 20.0, 8.0);
        MultiStateHardwareLight multiStateHardwareLight = this.oHp.createMultiStateHardwareLight(string + n2 + "light");
        multiStateHardwareLight.setBounds(n3, n4 + 8, 20.0, 2.0);
        multiStateHardwareLight.setColorToStateFunction(PiC::Ivg);
        hardwareButton.setBackgroundLight(multiStateHardwareLight);
        return hardwareButton;
    }

    @Override
    public void init() {
        int n2;
        ControllerHost controllerHost = (ControllerHost)this.getHost();
        MidiIn midiIn = controllerHost.getMidiInPort(0);
        midiIn.setMidiCallback(this::Ivg);
        midiIn.createNoteInput("notes", new String[0]);
        this.Ivg = controllerHost.createCursorTrack(0, 8);
        this.OSp = this.Ivg.createCursorDevice();
        this.lXt = this.OSp.createCursorRemoteControlsPage(8);
        this.tGb = this.OSp.createCursorRemoteControlsPage("filter", 4, "filter");
        this.Fqp = this.OSp.createCursorRemoteControlsPage("envelope", 4, "envelope");
        this.tGb.pageCount().markInterested();
        this.tGb.selectedPageIndex().markInterested();
        this.Fqp.pageCount().markInterested();
        this.Fqp.selectedPageIndex().markInterested();
        this.oHp = controllerHost.createHardwareSurface();
        this.oHp.setPhysicalSize(503.0, 114.0);
        this.QCa = this.oHp.createRelativeHardwareKnob("bigencoder");
        this.QCa.setBounds(235.0, 55.0, 30.0, 30.0);
        this.QCa.setStepSize(0.1);
        for (n2 = 0; n2 < 8; ++n2) {
            int n3 = n2 / 4;
            int n4 = n2 % 4;
            this.UB2[n2] = this.oHp.createRelativeHardwareKnob("left" + n2);
            this.UB2[n2].setBounds(60 + 30 * n4, 25 + 40 * n3, 20.0, 20.0);
            this.UB2[n2].addBinding(this.lXt.getParameter(n2));
            this.UB2[n2].beginTouchAction().setActionMatcher(midiIn.createNoteOnActionMatcher(5, n2));
            this.UB2[n2].endTouchAction().setActionMatcher(midiIn.createNoteOffActionMatcher(5, n2));
            this.Nyy[n2] = controllerHost.createBitmap(128, 32, BitmapFormat.ARGB32);
            this.onT[n2] = this.oHp.createHardwarePixelDisplay("leftdisplay" + n2, this.Nyy[n2]);
            this.onT[n2].setBounds(59 + 30 * n4, 50 + 40 * n3, 22.0, 6.0);
            this.UB2[n2].isBeingTouched().markInterested();
            this.ZAb[n2] = this.oHp.createRelativeHardwareKnob("right" + n2);
            this.ZAb[n2].setBounds(330 + 30 * n4, 25 + 40 * n3, 20.0, 20.0);
            this.ZAb[n2].setLabelPosition(RelativePosition.BELOW);
            this.lXt.getParameter(n2).markInterested();
            this.lXt.getParameter(n2).name().markInterested();
            this.lXt.getParameter(n2).value().markInterested();
            this.lXt.getParameter(n2).displayedValue().markInterested();
        }
        for (n2 = 0; n2 < 4; ++n2) {
            this.ZAb[n2].addBinding(this.tGb.getParameter(n2));
            this.ZAb[n2 + 4].addBinding(this.Fqp.getParameter(n2));
            this.kpx[n2] = this.Ivg("leftmode", n2, 60 + 30 * n2, 10);
            this.zEU[n2] = this.Ivg("leftindex", n2, 60 + 30 * n2, 103);
            this.zEU[n2].setLabel(Integer.toString(n2 + 1));
            this.fjZ[n2] = this.Ivg("filtersel", n2, 330 + 30 * n2, 10);
            this.GC2[n2] = this.Ivg("envsel", n2, 330 + 30 * n2, 103);
        }
        this.ZAb[0].setLabel("Cutoff");
        this.ZAb[1].setLabel("Reso");
        this.ZAb[2].setLabel("Mod / KT");
        this.ZAb[3].setLabel("Drive");
        this.ZAb[4].setLabel("A");
        this.ZAb[5].setLabel("D");
        this.ZAb[6].setLabel("S");
        this.ZAb[7].setLabel("R");
        this.fjZ[0].setLabel("F1");
        this.fjZ[1].setLabel("F2");
        this.fjZ[2].setLabel("F3");
        this.fjZ[3].setLabel("EQ");
        this.fjZ[0].pressedAction().setBinding(controllerHost.createAction(() -> this.tGb.selectedPageIndex().set(0), () -> "F1"));
        this.fjZ[1].pressedAction().setBinding(controllerHost.createAction(() -> this.tGb.selectedPageIndex().set(1), () -> "F2"));
        this.fjZ[2].pressedAction().setBinding(controllerHost.createAction(() -> this.tGb.selectedPageIndex().set(2), () -> "F3"));
        this.GC2[0].pressedAction().setBinding(controllerHost.createAction(() -> this.Fqp.selectedPageIndex().set(0), () -> "AEG"));
        this.GC2[1].pressedAction().setBinding(controllerHost.createAction(() -> this.Fqp.selectedPageIndex().set(1), () -> "FEG"));
        this.GC2[2].pressedAction().setBinding(controllerHost.createAction(() -> this.Fqp.selectedPageIndex().set(2), () -> "EG3"));
        this.GC2[3].pressedAction().setBinding(controllerHost.createAction(() -> this.Fqp.selectedPageIndex().set(3), () -> "EG4"));
        this.GC2[0].setLabel("AEG");
        this.GC2[1].setLabel("FEG");
        this.GC2[2].setLabel("EG3");
        this.GC2[3].setLabel("EG4");
        this.kpx[0].setLabel("PERF");
        this.kpx[0].pressedAction().setBinding(controllerHost.createAction(() -> this.lXt.selectNextPageMatching("preset", true), () -> "Perform"));
        this.kpx[1].setLabel("OSC");
        this.kpx[1].pressedAction().setBinding(controllerHost.createAction(() -> this.lXt.selectNextPageMatching("oscillator", true), () -> "Oscillator"));
        this.kpx[2].setLabel("MIX");
        this.kpx[2].pressedAction().setBinding(controllerHost.createAction(() -> this.lXt.selectNextPageMatching("mix", true), () -> "Mix"));
        this.kpx[3].setLabel("FX");
    }

    private void Ivg(int n2, int n3, int n4) {
    }

    @Override
    public void flush() {
        int n2;
        int n3 = 0;
        while (n3 < 8) {
            int n4 = n3++;
            this.Nyy[n4].render(graphicsOutput -> {
                graphicsOutput.rectangle(0.0, 0.0, 128.0, 32.0);
                graphicsOutput.setColor(Color.blackColor());
                graphicsOutput.fill();
                graphicsOutput.setColor(Color.whiteColor());
                graphicsOutput.moveTo(0.0, 20.0);
                RemoteControl remoteControl = this.lXt.getParameter(n4);
                graphicsOutput.setFontSize(20.0);
                if (this.UB2[n4].isBeingTouched().get()) {
                    graphicsOutput.showText(remoteControl.displayedValue().getLimited(12));
                } else {
                    graphicsOutput.showText(remoteControl.name().getLimited(12));
                }
                graphicsOutput.rectangle(0.0, 30.0, remoteControl.value().get() * 128.0, 2.0);
                graphicsOutput.fill();
            });
        }
        Color color = Color.blackColor();
        Color color2 = Color.fromHex("404040");
        Color color3 = Color.whiteColor();
        int n5 = this.tGb.pageCount().get();
        int n6 = this.tGb.selectedPageIndex().get();
        for (n2 = 0; n2 < 3; ++n2) {
            Color color4 = n2 == n6 ? color3 : (n2 < n5 ? color2 : color);
            ((MultiStateHardwareLight)this.fjZ[n2].backgroundLight()).setColor(color4);
        }
        n2 = this.Fqp.pageCount().get();
        int n7 = this.Fqp.selectedPageIndex().get();
        for (int i2 = 0; i2 < 4; ++i2) {
            Color color5 = i2 == n7 ? color3 : (i2 < n2 ? color2 : color);
            ((MultiStateHardwareLight)this.GC2[i2].backgroundLight()).setColor(color5);
        }
    }

    @Override
    public void exit() {
    }
}

