/*
 * Decompiled with CFR 0.152.
 */
import com.bitwig.extension.api.project.Factory;
import com.bitwig.extension.api.project.Project;
import com.bitwig.extension.api.project.file.SampleReference;
import com.bitwig.extension.api.project.parameter.AutomationEvents;
import com.bitwig.extension.api.project.parameter.Unit;
import com.bitwig.extension.api.project.timeline.AudioClip;
import com.bitwig.extension.api.project.timeline.AudioClipContent;
import com.bitwig.extension.api.project.timeline.AudioNote;
import com.bitwig.extension.api.project.timeline.AudioNoteTimeline;
import com.bitwig.extension.api.project.timeline.NoteExpression;
import com.bitwig.extension.api.project.timeline.WarpMode;
import com.bitwig.extension.api.project.track.Track;
import com.bitwig.extension.importer.FileImporterExtensionDefinition;
import com.bitwig.extension.importer.ProjectFileImporter;
import com.bitwig.extension.settings.DoubleSetting;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import tv.amwa.maj.constant.ParameterConstant;
import tv.amwa.maj.extensions.avid.AvidFactory;
import tv.amwa.maj.industry.MediaEngine;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.io.aaf.AAFFactory;
import tv.amwa.maj.model.Component;
import tv.amwa.maj.model.CompositionPackage;
import tv.amwa.maj.model.ConstantValue;
import tv.amwa.maj.model.ControlPoint;
import tv.amwa.maj.model.EssenceDescriptor;
import tv.amwa.maj.model.Filler;
import tv.amwa.maj.model.Locator;
import tv.amwa.maj.model.MaterialPackage;
import tv.amwa.maj.model.OperationGroup;
import tv.amwa.maj.model.Package;
import tv.amwa.maj.model.Parameter;
import tv.amwa.maj.model.Preface;
import tv.amwa.maj.model.Segment;
import tv.amwa.maj.model.Sequence;
import tv.amwa.maj.model.SourceClip;
import tv.amwa.maj.model.SourcePackage;
import tv.amwa.maj.model.TimelineTrack;
import tv.amwa.maj.model.Transition;
import tv.amwa.maj.model.VaryingValue;
import tv.amwa.maj.model.WAVEDescriptor;
import tv.amwa.maj.record.Rational;
import tv.amwa.maj.union.SourceReferenceValue;

public class G2
extends FileImporterExtensionDefinition
implements ProjectFileImporter {
    private static final String[] Ivg = new String[]{"aaf"};
    private static final UUID OSp = UUID.fromString("d03c82b3-99a4-434c-8e7a-5d09641caa04");
    private static final G2 oHp = new G2();
    private lla UB2;
    private DoubleSetting ZAb = new DoubleSetting("tempo", 120.0, 20.0, 666.0, Unit.BPM);

    @Override
    public String[] getSupportedFileExtensions() {
        return Ivg;
    }

    @Override
    public void importProject(File file, Factory factory, Project project) {
        try {
            MediaEngine.initializeAAF();
            AvidFactory.registerAvidExtensions();
            Preface preface = AAFFactory.readPreface((String)file.getAbsolutePath());
            this.UB2 = new lla(this, factory, project, preface);
            project.getTransport().getTempo().setValue((Double)this.ZAb.getValue(), Unit.BPM);
            Set set = preface.getPackages();
            for (Package package_ : set) {
                if (!(package_ instanceof CompositionPackage)) continue;
                List list = package_.getPackageTracks();
                for (tv.amwa.maj.model.Track track : list) {
                    String string = track.getTrackName();
                    if (string.equals("Timecode") || !(track instanceof TimelineTrack)) continue;
                    TimelineTrack timelineTrack = (TimelineTrack)track;
                    Track track2 = factory.createAudioTrack();
                    track2.setTitle(string);
                    track2.mixer().getVolume().setValue(0.0, Unit.DECIBEL);
                    project.getTrackGroup().addMainTrack(track2);
                    Segment segment = track.getTrackSegment();
                    Sequence sequence = segment.generateSequence();
                    this.UB2.Ivg = timelineTrack.getEditRate();
                    long l2 = this.Ivg(track2, sequence, timelineTrack.getOrigin());
                }
            }
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
        finally {
            this.UB2 = null;
        }
    }

    @Override
    public List getSettings() {
        return Collections.singletonList(this.ZAb);
    }

    private long Ivg(Track track, Sequence sequence, long l2) {
        long l4 = l2;
        List list = sequence.getComponentObjects();
        for (Component component : list) {
            if (component instanceof Segment) {
                this.Ivg(track, (Segment)component, l4);
                if (component.getLengthPresent()) {
                    l4 += component.getComponentLength();
                }
                this.UB2.oHp = 0L;
                continue;
            }
            if (!(component instanceof Transition)) continue;
            this.UB2.oHp = component.getComponentLength();
            l4 -= this.UB2.oHp;
        }
        return l4;
    }

    private AudioNote Ivg(Track track, Segment segment, long l2) {
        double d2 = this.UB2.Ivg(l2);
        if (segment instanceof OperationGroup) {
            OperationGroup operationGroup = (OperationGroup)segment;
            AudioNote audioNote = null;
            for (Segment segment2 : operationGroup.getInputSegments()) {
                audioNote = this.Ivg(track, segment2, l2);
            }
            for (Segment segment2 : operationGroup.getParameters()) {
                if (audioNote == null) continue;
                this.Ivg(audioNote, (Parameter)segment2);
            }
        } else if (segment instanceof Sequence) {
            this.Ivg(track, (Sequence)segment, l2);
        } else if (segment instanceof Filler) {
            double d3 = this.UB2.Ivg(this.UB2.oHp);
            if (d3 > 0.0 && this.UB2.OSp != null) {
                this.UB2.OSp.setFadeOutTime(d3);
            }
            this.UB2.OSp = null;
        } else if (segment instanceof SourceClip) {
            boolean bl2;
            SourceClip sourceClip = (SourceClip)segment;
            double d4 = this.UB2.Ivg(this.UB2.oHp);
            AudioClip audioClip = this.UB2.ZAb.createAudioClip();
            audioClip.setTime(d2);
            audioClip.setDuration(this.UB2.Ivg(sourceClip.getComponentLength()));
            Package package_ = this.Ivg(sourceClip.getSourceReference());
            AudioNote audioNote = null;
            if (package_ != null) {
                audioClip.setTitle(package_.getPackageName());
                if (package_ instanceof MaterialPackage) {
                    audioNote = this.Ivg(audioClip, (MaterialPackage)package_);
                }
            }
            track.clipTimeline().addEvent(audioClip);
            boolean bl3 = bl2 = this.UB2.OSp != null;
            if (bl2) {
                audioClip.setFadeInTime(-d4);
                this.UB2.OSp.setFadeOutTime(d4);
            } else {
                audioClip.setFadeInTime(d4);
            }
            this.UB2.OSp = audioClip;
            return audioNote;
        }
        return null;
    }

    private void Ivg(AudioNote audioNote, Parameter parameter) {
        NoteExpression noteExpression = null;
        if (parameter.getParameterDefinitionReference().equals((Object)ParameterConstant.Amplitude)) {
            noteExpression = audioNote.getGain();
        } else if (parameter.getParameterDefinitionReference().equals((Object)ParameterConstant.Pan)) {
            noteExpression = audioNote.getPan();
        }
        if (noteExpression == null) {
            return;
        }
        if (parameter instanceof ConstantValue) {
            ConstantValue constantValue = (ConstantValue)parameter;
            noteExpression.setValue(this.Ivg(constantValue.getValue()), Unit.NONE);
        } else if (parameter instanceof VaryingValue) {
            VaryingValue varyingValue = (VaryingValue)parameter;
            AutomationEvents automationEvents = this.UB2.ZAb.createDoubleAutomationEvents(Unit.NONE);
            for (ControlPoint controlPoint : varyingValue.getControlPoints()) {
                double d2 = this.UB2.Ivg(controlPoint.getTime().getNumerator());
                double d3 = this.Ivg(controlPoint.getControlPointValue());
                automationEvents.addPoint(d2, d3);
            }
            noteExpression.setEvents(automationEvents, Unit.NONE);
        }
    }

    private double Ivg(PropertyValue propertyValue) {
        Object object = propertyValue.getValue();
        if (object instanceof Rational) {
            Rational rational = (Rational)object;
            return rational.doubleValue();
        }
        throw new IOException("Unexpected class " + object.getClass().getName() + " in extractValue");
    }

    private AudioNote Ivg(AudioClip audioClip, MaterialPackage materialPackage) {
        List list = materialPackage.getPackageTracks();
        if (!list.isEmpty()) {
            tv.amwa.maj.model.Track track = (tv.amwa.maj.model.Track)list.get(0);
            Segment segment = track.getTrackSegment();
            Sequence sequence = segment.generateSequence();
            return this.Ivg(audioClip, sequence);
        }
        return null;
    }

    private AudioNote Ivg(AudioClip audioClip, Sequence sequence) {
        for (Component component : sequence.getComponentObjects()) {
            SourceClip sourceClip;
            if (component instanceof SourceClip) {
                sourceClip = (SourceClip)component;
                Package package_ = this.Ivg(sourceClip.getSourceReference());
                if (!(package_ instanceof SourcePackage)) continue;
                SourcePackage sourcePackage = (SourcePackage)package_;
                return this.Ivg(audioClip, sourcePackage);
            }
            if (!(component instanceof Sequence)) continue;
            sourceClip = (Sequence)component;
            return this.Ivg(audioClip, (Sequence)sourceClip);
        }
        return null;
    }

    private AudioNote Ivg(AudioClip audioClip, SourcePackage sourcePackage) {
        EssenceDescriptor essenceDescriptor = sourcePackage.getEssenceDescription();
        if (essenceDescriptor instanceof WAVEDescriptor) {
            WAVEDescriptor wAVEDescriptor = (WAVEDescriptor)essenceDescriptor;
            long l2 = wAVEDescriptor.getEssenceLength();
            if (wAVEDescriptor.countLocators() > 0) {
                File file = null;
                for (Locator locator : wAVEDescriptor.getLocators()) {
                    try {
                        file = new File(new URI(locator.getPath()).getPath());
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        throw new IOException(uRISyntaxException);
                    }
                    if (!file.exists()) continue;
                    break;
                }
                if (file != null) {
                    int n2 = (int)wAVEDescriptor.getSampleRate().doubleValue();
                    int n3 = 1;
                    SampleReference sampleReference = file.exists() ? this.UB2.ZAb.createSampleReferenceForLocalFile(file) : this.UB2.ZAb.createSampleReferenceForAbsolutePath(file, (int)l2, n2, n3);
                    AudioNote audioNote = this.UB2.ZAb.createAudioNote(0.0, this.UB2.Ivg(l2), sampleReference);
                    audioNote.setWarpMode(WarpMode.RAW);
                    ((AudioNoteTimeline)((AudioClipContent)audioClip.getContent()).getNoteTimeline()).addEvent(audioNote);
                    return audioNote;
                }
            }
            throw new IOException("AAF files with embedded samples not supported.");
        }
        return null;
    }

    private Package Ivg(SourceReferenceValue sourceReferenceValue) {
        for (Package package_ : this.UB2.onT.getPackages()) {
            if (!package_.getPackageID().equals((Object)sourceReferenceValue.getSourcePackageID())) continue;
            return package_;
        }
        return null;
    }

    @Override
    public String getName() {
        return "Advanced Authoring Format";
    }

    @Override
    public String getAuthor() {
        return "Bitwig";
    }

    @Override
    public String getVersion() {
        return "1.0";
    }

    @Override
    public UUID getId() {
        return OSp;
    }

    @Override
    public int getRequiredAPIVersion() {
        return 11;
    }

    public static G2 Ivg() {
        return oHp;
    }
}

