/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public final class Utilities {
    private static Hashtable<Integer, Byte> timezoneTable;
    private static transient int timeStampCounter;
    private static final char[] hexChars;
    private static final byte[] charToByte;

    private Utilities() {
    }

    public static final int hoursAndMinsToMilliseconds(int sign, int hours, int minutes) throws IllegalArgumentException {
        sign = sign >= 0 ? 1 : -1;
        hours = hours >= 0 ? hours : -hours;
        int n = minutes = minutes >= 0 ? minutes : -minutes;
        if (hours > 30 || minutes > 1800) {
            throw new IllegalArgumentException("The magnitude of one or both of the hours or minutes value is outside the acceptable range.");
        }
        return sign * (hours * 3600000 + minutes * 60000);
    }

    public static final byte[] checkBytes(byte[] data, int requiredLength) throws NegativeArraySizeException {
        if (data == null) {
            data = new byte[]{};
        }
        if (data.length != requiredLength) {
            int u;
            byte[] replacement = new byte[requiredLength];
            for (u = 0; u < requiredLength; ++u) {
                replacement[u] = 0;
            }
            if (data.length < requiredLength) {
                for (u = 0; u < data.length; ++u) {
                    replacement[u] = data[u];
                }
            } else {
                for (u = 0; u < requiredLength; ++u) {
                    replacement[u] = data[u];
                }
            }
            return replacement;
        }
        return (byte[])data.clone();
    }

    public static final synchronized SecureRandom seedRandomMaker() {
        SecureRandom randomMaker = null;
        String username = System.getProperty("user.name");
        long dateTime = new Date().getTime();
        byte[] hostAddress = null;
        String hostname = null;
        try {
            InetAddress hostInetAddress = InetAddress.getLocalHost();
            hostAddress = hostInetAddress.getAddress();
            hostname = hostInetAddress.getCanonicalHostName();
        }
        catch (UnknownHostException uhe) {
            hostAddress = new byte[]{System.getProperty("os.version").getBytes()[0], System.getProperty("os.arch").getBytes()[0], System.getProperty("os.name").getBytes()[0], System.getProperty("java.vm.name").getBytes()[0]};
            hostname = System.getProperty("user.dir");
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException nsae) {
            try {
                randomMaker = SecureRandom.getInstance("SHA1PRNG");
                randomMaker.setSeed(username.getBytes());
                return randomMaker;
            }
            catch (NoSuchAlgorithmException nsae2) {
                randomMaker = new SecureRandom(username.getBytes());
                return randomMaker;
            }
        }
        md.update(username.getBytes());
        for (int u = 0; u < 8; ++u) {
            md.update((byte)(dateTime & 0xFFL));
            dateTime >>>= 8;
        }
        md.update(hostAddress);
        md.update(hostname.getBytes());
        byte[] seed = md.digest();
        try {
            randomMaker = SecureRandom.getInstance("SHA1PRNG");
            randomMaker.setSeed(seed);
        }
        catch (NoSuchAlgorithmException nsae3) {
            randomMaker = new SecureRandom(seed);
        }
        return randomMaker;
    }

    public static final int dmyToModifiedJulianDate(int day, int month, int year) throws IllegalArgumentException {
        if (day < 1 || day > 31) {
            throw new IllegalArgumentException("Day is outside the acceptable range of 1 to 31.");
        }
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("Month is outside the acceptable range of 1 to 12.");
        }
        if (year < 1754) {
            throw new IllegalArgumentException("Year must be later than 1754 A.D..");
        }
        int a = (int)Math.floor((14 - month) / 12);
        long y = (long)year + 4800L - (long)a;
        long m = month + 12 * a - 3;
        long julian = (long)day + (153L * m + 2L) / 5L + 365L * y + y / 4L - y / 100L + y / 400L - 32045L;
        int mjd = (int)((double)julian - 2400000.5);
        return mjd;
    }

    public static final byte timezoneCode(int timezoneOffset) {
        if (!timezoneTable.containsKey(timezoneOffset)) {
            return 57;
        }
        return timezoneTable.get(timezoneOffset);
    }

    public static final byte[] createLocalHostID(int size) throws NegativeArraySizeException {
        if (size < 0) {
            throw new NegativeArraySizeException("Cannot create a unique host ID value with a negative array size.");
        }
        byte[] hostAddress = null;
        String hostname = null;
        try {
            InetAddress hostInetAddress = InetAddress.getLocalHost();
            hostAddress = hostInetAddress.getAddress();
            hostname = hostInetAddress.getCanonicalHostName();
        }
        catch (UnknownHostException uhe) {
            hostAddress = new byte[]{System.getProperty("os.version").getBytes()[0], System.getProperty("os.arch").getBytes()[0], System.getProperty("os.name").getBytes()[0], System.getProperty("java.vm.name").getBytes()[0]};
            hostname = System.getProperty("user.dir");
        }
        byte[] hostID = new byte[8];
        int firstDot = hostname.indexOf(46);
        if (firstDot == -1 || firstDot >= hostname.length() - 4) {
            hostID[0] = 120;
            hostID[1] = 120;
            hostID[2] = 120;
            hostID[4] = 120;
        } else {
            byte[] endOfTheDomain = hostname.substring(firstDot + 1, firstDot + 5).getBytes();
            System.arraycopy(endOfTheDomain, 0, hostID, 0, 4);
        }
        System.arraycopy(hostAddress, hostAddress.length - 4, hostID, 4, 4);
        hostID[0] = (byte)(hostID[0] & 0xFC | 2);
        switch (size) {
            case 6: {
                byte[] shorter = new byte[6];
                shorter[0] = hostID[0];
                System.arraycopy(hostID, 3, shorter, 1, 5);
                return shorter;
            }
            case 8: {
                return hostID;
            }
        }
        return Utilities.checkBytes(hostID, size);
    }

    public static final byte[] getLocalHostID() {
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            byte[] candidateAddress = null;
            while (netInterfaces.hasMoreElements() && Utilities.suspiciousHardwareAddress(candidateAddress = netInterfaces.nextElement().getHardwareAddress())) {
                candidateAddress = null;
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return Utilities.createLocalHostID(6);
    }

    private static final boolean suspiciousHardwareAddress(byte[] hardwareAddress) {
        if (hardwareAddress == null) {
            return true;
        }
        int zeros = 0;
        for (byte b : hardwareAddress) {
            if (b != 0) continue;
            ++zeros;
        }
        return zeros > 2;
    }

    public static final synchronized byte[] compute7ByteTimeStamp(Calendar timeStamp) throws NullPointerException {
        if (timeStamp == null) {
            throw new NullPointerException("Cannot create a 7-byte timestamp with a null calendar value.");
        }
        byte[] timeStampBits = new byte[7];
        if (++timeStampCounter == Integer.MAX_VALUE) {
            timeStampCounter = 0;
        }
        int todaysCount = timeStamp.get(11) * 86400000 + timeStamp.get(12) * 1440000 + timeStamp.get(13) * 24000 + timeStamp.get(14) * 24 + timeStampCounter % 24;
        timeStampBits[0] = (byte)(todaysCount >>> 24 & 0xFF);
        timeStampBits[1] = (byte)(todaysCount >>> 16 & 0xFF);
        timeStampBits[2] = (byte)(todaysCount >>> 8 & 0xFF);
        timeStampBits[3] = (byte)(todaysCount & 0xFF);
        int year = timeStamp.get(1);
        int month = timeStamp.get(2);
        int day = timeStamp.get(5);
        int mjd = Utilities.dmyToModifiedJulianDate(day, month + 1, year);
        timeStampBits[4] = (byte)(mjd % 10 << 4 | mjd / 10 % 10);
        timeStampBits[5] = (byte)(mjd / 100 % 10 << 4 | mjd / 1000 % 10);
        timeStampBits[6] = (byte)(mjd / 10000 % 10 << 4 | mjd / 100000 % 10);
        return timeStampBits;
    }

    public static final char[] bytesToHexChars(byte[] bytes) throws NullPointerException {
        if (bytes == null) {
            throw new NullPointerException("Cannot convert a null byte array to hex string.");
        }
        char[] chars = new char[bytes.length * 2];
        int charCounter = 0;
        for (int x = 0; x < bytes.length; ++x) {
            chars[charCounter++] = hexChars[bytes[x] >>> 4 & 0xF];
            chars[charCounter++] = hexChars[bytes[x] & 0xF];
        }
        return chars;
    }

    public static final byte[] hexStringToBytes(String hexCharacters) throws NullPointerException, IndexOutOfBoundsException {
        if (hexCharacters == null) {
            throw new NullPointerException("The given string of hex digits is null.");
        }
        char[] chars = new char[hexCharacters.length()];
        hexCharacters.getChars(0, chars.length, chars, 0);
        byte[] bytes = new byte[chars.length / 2];
        int charCounter = 0;
        for (int x = 0; x < bytes.length; ++x) {
            bytes[x] = (byte)(charToByte[chars[charCounter++]] << 4 | charToByte[chars[charCounter++]]);
        }
        return bytes;
    }

    public static final String lowerFirstLetter(String camelString) {
        if (camelString.length() == 0) {
            return camelString;
        }
        StringBuffer workingBuffer = new StringBuffer(camelString);
        workingBuffer.setCharAt(0, Character.toLowerCase(camelString.charAt(0)));
        return workingBuffer.toString();
    }

    public static final byte twoCharsToByte(char mostSignficantCharacter, char leastSignficantCharacter) throws NumberFormatException {
        return (byte)(Utilities.byteFromCharacter(mostSignficantCharacter) << 4 | Utilities.byteFromCharacter(leastSignficantCharacter));
    }

    public static final byte byteFromCharacter(char c) throws NumberFormatException {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new NumberFormatException("Unexpected character " + c + " when parsing an AUID.");
    }

    public static final void hexDump(ByteBuffer buffer) throws NullPointerException {
        if (buffer == null) {
            throw new NullPointerException("Cannot create a hex dump of a null buffer.");
        }
        int positionCache = buffer.position();
        buffer.rewind();
        int count = 0;
        while (buffer.hasRemaining()) {
            int x;
            StringBuffer nextLine = new StringBuffer(80);
            byte[] lineBytes = new byte[buffer.remaining() > 16 ? 16 : buffer.remaining()];
            buffer.get(lineBytes);
            nextLine.append(Integer.toHexString(count));
            for (x = nextLine.length(); x <= 8; ++x) {
                nextLine.insert(0, '0');
            }
            nextLine.append("  ");
            for (x = 0; x < lineBytes.length; ++x) {
                nextLine.append(hexChars[lineBytes[x] >>> 4 & 0xF]);
                nextLine.append(hexChars[lineBytes[x] & 0xF]);
                nextLine.append(' ');
            }
            nextLine.append("  ");
            for (x = 0; x < lineBytes.length; ++x) {
                if (lineBytes[x] > 32 && lineBytes[x] < 128) {
                    nextLine.append((char)lineBytes[x]);
                    continue;
                }
                nextLine.append('.');
            }
            System.out.println(nextLine.toString());
            count += 16;
        }
        buffer.position(positionCache);
    }

    public static final String makeSymbol(String name) throws NullPointerException, IllegalArgumentException {
        if (name == null) {
            throw new NullPointerException("Cannot convert a null name into a safe symbol value.");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Cannot convert an empty string into a safe symbol value.");
        }
        char[] symbolChars = new char[name.length()];
        symbolChars[0] = Character.isJavaIdentifierStart(name.charAt(0)) ? (int)name.charAt(0) : 95;
        for (int x = 1; x < symbolChars.length; ++x) {
            symbolChars[x] = Character.isJavaIdentifierPart(name.charAt(x)) ? (int)name.charAt(x) : 95;
        }
        return new String(symbolChars);
    }

    static {
        int x;
        timezoneTable = new Hashtable();
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(1, 0, 0), (byte)0);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(-1, 1, 0), (byte)1);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(-1, 2, 0), (byte)2);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(-1, 3, 0), (byte)3);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(-1, 4, 0), (byte)4);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(-1, 5, 0), (byte)5);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(-1, 6, 0), (byte)6);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(-1, 7, 0), (byte)7);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(-1, 8, 0), (byte)8);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(-1, 9, 0), (byte)9);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(-1, 10, 0), (byte)16);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(-1, 11, 0), (byte)17);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(-1, 12, 0), (byte)18);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(1, 13, 0), (byte)19);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(1, 12, 0), (byte)20);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(1, 11, 0), (byte)21);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(1, 10, 0), (byte)22);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(1, 9, 0), (byte)23);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(1, 8, 0), (byte)24);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(1, 7, 0), (byte)25);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(1, 6, 0), (byte)32);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(1, 5, 0), (byte)33);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(1, 4, 0), (byte)34);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(1, 3, 0), (byte)35);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(1, 2, 0), (byte)36);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(1, 1, 0), (byte)37);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(-1, 0, 30), (byte)10);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(-1, 1, 30), (byte)11);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(-1, 2, 30), (byte)12);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(-1, 3, 30), (byte)13);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(-1, 4, 30), (byte)14);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(-1, 5, 30), (byte)15);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(-1, 6, 30), (byte)26);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(-1, 7, 30), (byte)27);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(-1, 8, 30), (byte)28);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(-1, 9, 30), (byte)29);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(-1, 10, 30), (byte)30);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(-1, 11, 30), (byte)31);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(1, 11, 30), (byte)42);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(1, 10, 30), (byte)43);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(1, 9, 30), (byte)44);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(1, 8, 30), (byte)45);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(1, 7, 30), (byte)46);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(1, 6, 30), (byte)47);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(1, 5, 30), (byte)58);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(1, 4, 30), (byte)59);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(1, 3, 30), (byte)60);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(1, 2, 30), (byte)61);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(1, 1, 30), (byte)62);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(1, 0, 30), (byte)63);
        timezoneTable.put(Utilities.hoursAndMinsToMilliseconds(1, 12, 45), (byte)50);
        timeStampCounter = 0;
        hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        charToByte = new byte[127];
        for (x = 0; x < charToByte.length; ++x) {
            Utilities.charToByte[x] = 0;
        }
        for (x = 0; x < hexChars.length; ++x) {
            Utilities.charToByte[Utilities.hexChars[x]] = (byte)x;
        }
        Utilities.charToByte[97] = 10;
        Utilities.charToByte[98] = 11;
        Utilities.charToByte[99] = 12;
        Utilities.charToByte[100] = 13;
        Utilities.charToByte[101] = 14;
        Utilities.charToByte[102] = 15;
    }
}

