/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.record.impl;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import tv.amwa.maj.constant.CommonConstants;
import tv.amwa.maj.enumeration.ProductReleaseType;
import tv.amwa.maj.exception.EndOfDataException;
import tv.amwa.maj.exception.InsufficientSpaceException;
import tv.amwa.maj.industry.TypeDefinitions;
import tv.amwa.maj.integer.UInt16;
import tv.amwa.maj.io.xml.LocalHandler;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.io.xml.XMLSerializable;
import tv.amwa.maj.record.ProductVersion;

public final class ProductVersionImpl
implements ProductVersion,
Serializable,
XMLSerializable,
Cloneable,
CommonConstants {
    private static final long serialVersionUID = -7836591873835174007L;
    @UInt16
    private short major;
    @UInt16
    private short minor;
    @UInt16
    private short tertiary;
    @UInt16
    private short patchLevel;
    private ProductReleaseType buildType;
    private static final Pattern majorPattern = Pattern.compile("<\\w*\\:?Major\\>([\\d]{1,5})\\<\\/\\w*\\:?Major\\>");
    private static final Pattern minorPattern = Pattern.compile("<\\w*\\:?Minor\\>([\\d]{1,5})\\<\\/\\w*\\:?Minor\\>");
    private static final Pattern tertiaryPattern = Pattern.compile("<\\w*\\:?Tertiary\\>([\\d]{1,5})\\<\\/\\w*\\:?Tertiary\\>");
    private static final Pattern patchLevelPattern = Pattern.compile("<\\w*\\:?PatchLevel\\>([\\d]{1,5})\\<\\/\\w*\\:?PatchLevel\\>");
    private static final Pattern buildTypePattern = Pattern.compile("<\\w*\\:?BuildType\\>(\\w*)\\<\\/\\w*\\:?BuildType\\>");
    public static final String PRODUCTVERSION_TAG = "ProductVersion";

    ProductVersionImpl() {
    }

    public ProductVersionImpl(@UInt16 short major, @UInt16 short minor, @UInt16 short tertiary, @UInt16 short patchLevel, ProductReleaseType type) throws NullPointerException, IllegalArgumentException {
        if (major == -1 && minor == -1 && tertiary == -1 && patchLevel == -1 && type == null) {
            this.buildType = null;
            return;
        }
        this.setMajor(major);
        this.setMinor(minor);
        this.setTertiary(tertiary);
        this.setPatchLevel(patchLevel);
        this.setBuildType(type);
    }

    @Override
    @UInt16
    public final short getMajor() {
        return this.major;
    }

    @Override
    public final void setMajor(@UInt16 short major) throws IllegalArgumentException {
        if (major < 0) {
            throw new IllegalArgumentException("Cannot set the major part for this product version to a negative value.");
        }
        this.major = major;
    }

    @Override
    @UInt16
    public final short getMinor() {
        return this.minor;
    }

    @Override
    public final void setMinor(@UInt16 short minor) throws IllegalArgumentException {
        if (minor < 0) {
            throw new IllegalArgumentException("Cannot set the minor part for this product version to a negative value.");
        }
        this.minor = minor;
    }

    @Override
    @UInt16
    public final short getPatchLevel() {
        return this.patchLevel;
    }

    @Override
    public final void setPatchLevel(@UInt16 short patchLevel) throws IllegalArgumentException {
        this.patchLevel = patchLevel;
    }

    @Override
    @UInt16
    public final short getTertiary() {
        return this.tertiary;
    }

    @Override
    public final void setTertiary(@UInt16 short tertiary) throws IllegalArgumentException {
        if (tertiary < 0) {
            throw new IllegalArgumentException("Cannot set the tertiary part of this product version to a negative number.");
        }
        this.tertiary = tertiary;
    }

    @Override
    public final ProductReleaseType getBuildType() {
        return this.buildType;
    }

    @Override
    public final void setBuildType(ProductReleaseType buildType) throws NullPointerException {
        if (buildType == null) {
            throw new NullPointerException("Cannot set the product release type of this product version with a null value.");
        }
        this.buildType = buildType;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof ProductVersion)) {
            return false;
        }
        ProductVersion testVersion = (ProductVersion)o;
        if (testVersion.getMajor() != this.major) {
            return false;
        }
        if (testVersion.getMinor() != this.minor) {
            return false;
        }
        if (testVersion.getTertiary() != this.tertiary) {
            return false;
        }
        if (testVersion.getPatchLevel() != this.patchLevel) {
            return false;
        }
        return testVersion.getBuildType() == this.buildType;
    }

    @Override
    public final String toString() {
        return XMLBuilder.toXMLNonMetadata(this);
    }

    public static final ProductVersionImpl parseFactory(String versionString) throws NullPointerException, ParseException {
        if (versionString == null) {
            throw new NullPointerException("Cannot create a product version instance from a null string value.");
        }
        Matcher matcher = majorPattern.matcher(versionString);
        short major = 0;
        short minor = 0;
        short tertiary = 0;
        short patchLevel = 0;
        try {
            if (matcher.find()) {
                major = Short.parseShort(matcher.group(1));
            }
            if ((matcher = minorPattern.matcher(versionString)).find()) {
                minor = Short.parseShort(matcher.group(1));
            }
            if ((matcher = tertiaryPattern.matcher(versionString)).find()) {
                tertiary = Short.parseShort(matcher.group(1));
            }
            if ((matcher = patchLevelPattern.matcher(versionString)).find()) {
                patchLevel = (short)Integer.parseInt(matcher.group(1));
            }
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("A given numeric value for one of major, minor, tertiary or patch level values could not be parsed.", 0);
        }
        matcher = buildTypePattern.matcher(versionString);
        ProductReleaseType releaseType = ProductReleaseType.Unknown;
        try {
            if (matcher.find()) {
                String enumToken = matcher.group(1);
                if (enumToken.startsWith("Version")) {
                    enumToken = enumToken.substring(7);
                }
                releaseType = ProductReleaseType.valueOf(enumToken);
            }
        }
        catch (IllegalArgumentException iae) {
            throw new ParseException("Could not parse the given value patch level to a known enumeration value.", 0);
        }
        return new ProductVersionImpl(major, minor, tertiary, patchLevel, releaseType);
    }

    @Override
    public final ProductVersion clone() {
        try {
            return (ProductVersion)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
            return null;
        }
    }

    public final int hashCode() {
        return this.major ^ this.minor << 16 ^ this.tertiary << 8 ^ this.patchLevel << 24 ^ this.buildType.hashCode();
    }

    @Override
    public final void appendXMLChildren(Node parent) {
        this.appendXMLChildren(parent, PRODUCTVERSION_TAG);
    }

    public final void appendXMLChildren(Node parent, String alternativeTag) {
        Node productVersionElement = parent instanceof DocumentFragment ? XMLBuilder.createChild(parent, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", alternativeTag) : parent;
        XMLBuilder.appendElement(productVersionElement, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", "Major", this.major);
        XMLBuilder.appendElement(productVersionElement, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", "Minor", this.minor);
        XMLBuilder.appendElement(productVersionElement, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", "Tertiary", this.tertiary);
        XMLBuilder.appendElement(productVersionElement, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", "PatchLevel", this.patchLevel >= 0 ? this.patchLevel : 65536 + this.patchLevel);
        XMLBuilder.appendElement(productVersionElement, "http://www.smpte-ra.org/schemas/2001-2/2007/aaf", "aaf", "BuildType", "Version" + this.buildType.name());
    }

    @Override
    public String getComment() {
        return null;
    }

    public static final ProductVersion createFromBuffer(ByteBuffer buffer) throws NullPointerException, EndOfDataException {
        if (buffer == null) {
            throw new NullPointerException("Cannot create a product version from a null value rather than a buffer.");
        }
        if (buffer.remaining() < 9 || buffer.remaining() > 10) {
            throw new EndOfDataException("Cannot create a product version from a buffer with less than 9 bytes or more than 10 bytes remaining.");
        }
        ProductVersionImpl createdVersion = new ProductVersionImpl();
        createdVersion.setMajor(buffer.getShort());
        createdVersion.setMinor(buffer.getShort());
        createdVersion.setTertiary(buffer.getShort());
        createdVersion.setPatchLevel(buffer.getShort());
        if (buffer.remaining() == 2) {
            buffer.get();
        }
        try {
            createdVersion.setBuildType((ProductReleaseType)TypeDefinitions.ProductReleaseType.createFromBytes(buffer).getValue());
        }
        catch (EndOfDataException eode) {
            throw new IllegalArgumentException("Unexpectedly short product version value in binary data.");
        }
        return createdVersion;
    }

    public static final long lengthAsBuffer(ProductVersion value) {
        return 10L;
    }

    public static final void writeToBuffer(ProductVersion version, ByteBuffer buffer) throws NullPointerException, InsufficientSpaceException {
        if (version == null) {
            throw new NullPointerException("Cannot write a null product version to a buffer.");
        }
        if (buffer == null) {
            throw new NullPointerException("Cannot write a product version to a null buffer.");
        }
        if (buffer.remaining() < 10) {
            throw new InsufficientSpaceException("Insufficient space in the given buffer to write a product version value.");
        }
        buffer.putShort(version.getMajor());
        buffer.putShort(version.getMinor());
        buffer.putShort(version.getTertiary());
        buffer.putShort(version.getPatchLevel());
        buffer.put((byte)0);
        buffer.put((byte)version.getBuildType().value());
    }

    public static final String toPersistentForm(ProductVersion productVersion) {
        if (productVersion == null) {
            return null;
        }
        return productVersion.toString();
    }

    public static final ProductVersion fromPersistentForm(String productVersion) {
        if (productVersion == null) {
            return null;
        }
        try {
            return ProductVersionImpl.parseFactory(productVersion);
        }
        catch (ParseException pe) {
            return null;
        }
    }

    public static class XMLHandler
    extends LocalHandler
    implements ContentHandler {
        public static final String elementName = "ProductVersion";
        public static final String[] dataElementNames = new String[]{"major", "minor", "tertiary", "patchLevel", "type"};

        @Override
        public Object createResult() throws Exception {
            String releaseTypeValue = this.getElementData("type");
            if (releaseTypeValue.startsWith("Version")) {
                releaseTypeValue = releaseTypeValue.substring(7);
            }
            return new ProductVersionImpl(Short.parseShort(this.getElementData("major")), Short.parseShort(this.getElementData("minor")), Short.parseShort(this.getElementData("tertiary")), Short.parseShort(this.getElementData("patchLevel")), ProductReleaseType.valueOf(releaseTypeValue));
        }
    }
}

