/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.record.impl;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import tv.amwa.maj.enumeration.MaterialType;
import tv.amwa.maj.exception.EndOfDataException;
import tv.amwa.maj.exception.GenerationMethodNotSupportedException;
import tv.amwa.maj.exception.InstanceOverflowException;
import tv.amwa.maj.exception.InsufficientSpaceException;
import tv.amwa.maj.integer.UInt32;
import tv.amwa.maj.integer.UInt8;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.io.xml.XMLSerializable;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.InstanceNumberGeneration;
import tv.amwa.maj.record.MaterialNumberGeneration;
import tv.amwa.maj.record.PackageID;
import tv.amwa.maj.record.impl.AUIDImpl;
import tv.amwa.maj.util.Utilities;

public final class PackageIDImpl
implements PackageID,
Serializable,
XMLSerializable,
Cloneable {
    private static final long serialVersionUID = 8871509282509864625L;
    private static final PackageIDImpl zeroPackageID = new PackageIDImpl(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    private static final char[] umidTemplate = new char[]{'u', 'r', 'n', ':', 's', 'm', 'p', 't', 'e', ':', 'u', 'm', 'i', 'd', ':', '*', '*', '*', '*', '*', '*', '*', '*', '.', '*', '*', '*', '*', '*', '*', '*', '*', '.', '*', '*', '*', '*', '*', '*', '*', '*', '.', '*', '*', '*', '*', '*', '*', '*', '*', '.', '*', '*', '*', '*', '*', '*', '*', '*', '.', '*', '*', '*', '*', '*', '*', '*', '*', '.', '*', '*', '*', '*', '*', '*', '*', '*', '.', '*', '*', '*', '*', '*', '*', '*', '*'};
    private static final char[] hexCharMap = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] bigHexCharMap = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final char[] persistTemplate = new char[]{'*', '*', '*', '*', '*', '*', '*', '*', '-', '*', '*', '*', '*', '-', '*', '*', '*', '*', '-', '*', '*', '*', '*', '-', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '-', '*', '*', '*', '*', '*', '*', '-', '*', '*', '-', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*'};
    private static SecureRandom randomMaker = null;
    private byte[] packageIDValue;
    private static final byte[] localMaskingData = new byte[]{77, 65, 74, 65, 80, 73, 42, 42, 108, 111, 99, 97, 108, 42, 42, 42, 114, 101, 102, 101, 114, 101, 110, 99, 101, 42, 42, 42, 42, 42, 42, 42, 109, 97, 115, 107, 105, 110, 103, 42, 100, 97, 116, 97, 42, 42, 42, 42, 116, 104, 97, 116, 42, 42, 42, 42, 105, 115, 42, 42, 42, 42, 42, 42, 98, 101, 116, 116, 101, 114, 42, 42, 116, 104, 97, 110, 42, 42, 42, 42, 117, 115, 105, 110, 103, 42, 42, 42, 106, 117, 115, 116, 42, 42, 42, 42, 97, 42, 42, 42, 42, 42, 42, 42, 108, 111, 97, 100, 42, 42, 42, 42, 111, 102, 42, 42, 42, 42, 42, 42, 122, 101, 114, 111, 115, 42, 42, 42};
    public static final String MYSQL_COLUMN_DEFINITION = "CHAR(71) CHARACTER SET ascii COLLATE ascii_general_ci";

    public static final byte[] getBaseUniversalLabel() {
        return (byte[])BaseUniversalLabel.clone();
    }

    public static final PackageID getZeroPackageID() {
        return zeroPackageID.clone();
    }

    public static final PackageIDImpl umidFactory(MaterialType materialType, MaterialNumberGeneration materialNumberGeneration, InstanceNumberGeneration instanceNumberGeneration, byte[] extraData) throws GenerationMethodNotSupportedException, NullPointerException {
        if (materialType == null) {
            throw new NullPointerException("Cannot create a package id from a null material type.");
        }
        if (materialNumberGeneration == null) {
            throw new NullPointerException("Cannot create a package id from a null material number generation method.");
        }
        if (instanceNumberGeneration == null) {
            throw new NullPointerException("Cannot create a package id from a null instance number generation method.");
        }
        if (randomMaker == null) {
            randomMaker = Utilities.seedRandomMaker();
        }
        PackageIDImpl packageID = new PackageIDImpl(BaseUniversalLabel, 19, 0, 0, 0, new AUIDImpl(new byte[16]));
        byte[] label = packageID.getUniversalLabel();
        label[10] = materialType.getMaterialTypeCode();
        label[11] = (byte)(materialNumberGeneration.getMethodCode() << 4 | instanceNumberGeneration.getMethodCode());
        packageID.setUniversalLabel(label);
        AUIDImpl material = null;
        switch (materialNumberGeneration) {
            case SMPTE: {
                material = PackageIDImpl.materialGenerationSMPTE(extraData);
                packageID.setMaterial(material);
                break;
            }
            case UUID_UL: {
                material = PackageIDImpl.materialGenerationUUID_UL(extraData);
                packageID.setMaterial(material);
                break;
            }
            case Masked: {
                material = PackageIDImpl.materialGenerationMasked(extraData);
                packageID.setMaterial(material);
                break;
            }
            case IEEE1394: {
                material = PackageIDImpl.materialGenerationIEEE1394(extraData);
                packageID.setMaterial(material);
                break;
            }
            case NotDefined: {
                material = PackageIDImpl.materialGenerationRandom();
                packageID.setMaterial(material);
                break;
            }
        }
        switch (instanceNumberGeneration) {
            case CopyAndPseudoRandom16Bit: {
                byte[] twoRandomBytes = new byte[2];
                randomMaker.nextBytes(twoRandomBytes);
                packageID.setInstanceMid(twoRandomBytes[0]);
                packageID.setInstanceLow(twoRandomBytes[1]);
                break;
            }
            case LiveStream: {
                throw new GenerationMethodNotSupportedException("Generation of instance numbers using live stream data is not supported by this method.");
            }
            case PseudoRandom24Bit: {
                byte[] threeRandomBytes = new byte[3];
                randomMaker.nextBytes(threeRandomBytes);
                packageID.setInstanceHigh(threeRandomBytes[0]);
                packageID.setInstanceMid(threeRandomBytes[1]);
                packageID.setInstanceLow(threeRandomBytes[2]);
            }
        }
        return packageID;
    }

    static final AUIDImpl materialGenerationRandom() {
        byte[] randombytes = new byte[16];
        randomMaker.nextBytes(randombytes);
        return new AUIDImpl(randombytes);
    }

    static final AUIDImpl materialGenerationIEEE1394(byte[] extraData) {
        byte[] materialNumber = new byte[16];
        Calendar rightNow = Calendar.getInstance();
        byte[] timeStampBits = Utilities.compute7ByteTimeStamp(rightNow);
        System.arraycopy(timeStampBits, 0, materialNumber, 0, 7);
        byte[] oneRandomByte = new byte[1];
        randomMaker.nextBytes(oneRandomByte);
        materialNumber[7] = (byte)((oneRandomByte[0] & 0x3F) << 2 | 3);
        extraData = Utilities.checkBytes(extraData, 8);
        System.arraycopy(extraData, 0, materialNumber, 8, 8);
        return new AUIDImpl(materialNumber);
    }

    static final AUIDImpl materialGenerationMasked(byte[] extraData) {
        byte[] unmasked = PackageIDImpl.materialGenerationSMPTE(extraData).getAUIDValue();
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsae) {
            System.err.println("Unexpected: MD5 algorithm not available in method tv.amwa.maj.entity.packageID.materialGenerationMasked(). Please investigate.");
            return new AUIDImpl(unmasked);
        }
        md.update(unmasked);
        md.update(localMaskingData);
        byte[] md5digest = md.digest();
        md5digest[7] = (byte)(md5digest[7] & 0xF | 0x40);
        md5digest[8] = (byte)(md5digest[8] & 0x3F | 0x80);
        return new AUIDImpl(md5digest);
    }

    static final AUIDImpl materialGenerationUUID_UL(byte[] extraData) {
        return new AUIDImpl(extraData);
    }

    static final AUIDImpl materialGenerationSMPTE(byte[] extraData) {
        byte[] materialNumber = new byte[16];
        Calendar rightNow = Calendar.getInstance();
        byte[] timeStampBits = Utilities.compute7ByteTimeStamp(rightNow);
        System.arraycopy(timeStampBits, 0, materialNumber, 0, 7);
        int timezoneOffsetInMillis = rightNow.get(15) + rightNow.get(16);
        byte timezoneCode = Utilities.timezoneCode(timezoneOffsetInMillis);
        materialNumber[7] = timezoneCode = (byte)(timezoneCode << 2 | 1);
        byte[] twoRandomBytes = new byte[2];
        randomMaker.nextBytes(twoRandomBytes);
        materialNumber[8] = twoRandomBytes[0];
        materialNumber[9] = twoRandomBytes[1];
        extraData = Utilities.checkBytes(extraData, 6);
        System.arraycopy(extraData, 0, materialNumber, 10, 6);
        return new AUIDImpl(materialNumber);
    }

    public PackageIDImpl(byte[] label, @UInt8 byte length, @UInt8 byte instanceHigh, @UInt8 byte instanceMid, @UInt8 byte instanceLow, AUID material) throws NullPointerException {
        this.packageIDValue = new byte[32];
        this.setUniversalLabel(label);
        this.setLength(length);
        this.setInstanceLow(instanceLow);
        this.setInstanceMid(instanceMid);
        this.setInstanceHigh(instanceHigh);
        this.setMaterial(material);
    }

    public PackageIDImpl(byte[] packageID) throws NullPointerException {
        this.setPackageIDValue(packageID);
    }

    public PackageIDImpl() {
        this.packageIDValue = new byte[32];
        if (randomMaker == null) {
            randomMaker = Utilities.seedRandomMaker();
        }
        byte[] randomInstanceLabel = (byte[])BaseUniversalLabel.clone();
        randomInstanceLabel[11] = (byte)(MaterialNumberGeneration.NotDefined.getMethodCode() << 4 | InstanceNumberGeneration.PseudoRandom24Bit.getMethodCode());
        this.setUniversalLabel(randomInstanceLabel);
        this.setLength((byte)19);
        byte[] dumbNumber = new byte[19];
        randomMaker.nextBytes(dumbNumber);
        System.arraycopy(dumbNumber, 0, this.packageIDValue, 13, 19);
    }

    public final byte[] getPackageIDValue() {
        return (byte[])this.packageIDValue.clone();
    }

    public final void setPackageIDValue(byte[] packageID) throws NullPointerException {
        if (packageID == null) {
            throw new NullPointerException("Cannot set the value of a PackageID using a null value.");
        }
        this.packageIDValue = Utilities.checkBytes(packageID, 32);
    }

    @Override
    public final byte[] getUniversalLabel() {
        byte[] label = new byte[12];
        System.arraycopy(this.packageIDValue, 0, label, 0, 12);
        return label;
    }

    @Override
    public final void setUniversalLabel(byte[] label) throws NullPointerException {
        if (label == null) {
            throw new NullPointerException("Cannot set the universal label of a package id from a null value.");
        }
        label = Utilities.checkBytes(label, 12);
        System.arraycopy(label, 0, this.packageIDValue, 0, 12);
    }

    @Override
    @UInt8
    public final byte getLength() {
        return this.packageIDValue[12];
    }

    @Override
    public final void setLength(@UInt8 byte length) {
        this.packageIDValue[12] = length;
    }

    @Override
    @UInt32
    public final int getInstanceNumber() {
        return (this.packageIDValue[13] & 0xFF) << 16 & (this.packageIDValue[14] & 0xFF) << 8 & (this.packageIDValue[15] & 0xFF);
    }

    @Override
    @UInt8
    public final byte getInstanceHigh() {
        return this.packageIDValue[13];
    }

    @Override
    public final void setInstanceHigh(@UInt8 byte instanceHigh) {
        this.packageIDValue[13] = instanceHigh;
    }

    @Override
    @UInt8
    public final byte getInstanceMid() {
        return this.packageIDValue[14];
    }

    @Override
    public final void setInstanceMid(@UInt8 byte instanceMid) {
        this.packageIDValue[14] = instanceMid;
    }

    @Override
    @UInt8
    public final byte getInstanceLow() {
        return this.packageIDValue[15];
    }

    @Override
    public final void setInstanceLow(@UInt8 byte instanceLow) {
        this.packageIDValue[15] = instanceLow;
    }

    @Override
    public final AUID getMaterial() {
        byte[] material = new byte[16];
        System.arraycopy(this.packageIDValue, 16, material, 0, 16);
        return new AUIDImpl(material);
    }

    @Override
    public final void setMaterial(AUID material) throws NullPointerException {
        if (material == null) {
            throw new NullPointerException("Cannot set the material number from a null AUID.");
        }
        System.arraycopy(material.getAUIDValue(), 0, this.packageIDValue, 16, 16);
    }

    @Override
    public final boolean isZero() {
        for (byte element : this.packageIDValue) {
            if (element == 0) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        int orrdCode = 0;
        for (int x = 0; x < 32; x += 8) {
            orrdCode <<= 8;
            orrdCode ^= this.packageIDValue[x] ^ this.packageIDValue[x + 1] ^ this.packageIDValue[x + 2] ^ this.packageIDValue[x + 3] ^ this.packageIDValue[x + 4] ^ this.packageIDValue[x + 5] ^ this.packageIDValue[x + 6] ^ this.packageIDValue[x + 7];
        }
        return orrdCode;
    }

    @Override
    public final String toString() {
        char[] umid = (char[])umidTemplate.clone();
        int umidCount = 15;
        for (int x = 0; x < 32; ++x) {
            umid[umidCount++] = hexCharMap[this.packageIDValue[x] >>> 4 & 0xF];
            umid[umidCount++] = hexCharMap[this.packageIDValue[x] & 0xF];
            if (x % 4 != 3) continue;
            ++umidCount;
        }
        return new String(umid);
    }

    public static final PackageIDImpl parseFactory(String packageIdURN) throws NullPointerException, ParseException {
        if (packageIdURN == null) {
            throw new NullPointerException("Cannot create a package ID value from a null string.");
        }
        if ((packageIdURN = packageIdURN.trim()).startsWith("urn:x-umid")) {
            return PackageIDImpl.parseOldStyleURN(packageIdURN);
        }
        if (packageIdURN.length() != umidTemplate.length) {
            throw new ParseException("The given string representation contains a different number of characters to that requried for a package id URN.", 0);
        }
        if (!packageIdURN.startsWith("urn:smpte:umid:")) {
            throw new ParseException("The given value does not appear to be a URN representing a package identifier.", 0);
        }
        char[] urn = packageIdURN.toCharArray();
        byte[] packageId = new byte[32];
        try {
            int urnCount = 15;
            for (int x = 0; x < 32; ++x) {
                packageId[x] = Utilities.twoCharsToByte(urn[urnCount++], urn[urnCount++]);
                if (x % 4 != 3) continue;
                ++urnCount;
            }
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Unexpected character when parsing a package ID URN.", 0);
        }
        return new PackageIDImpl(packageId);
    }

    private static final PackageIDImpl parseOldStyleURN(String packageIdURN) throws ParseException {
        if (packageIdURN.length() != 78) {
            throw new ParseException("An old style package ID URN is not of the correct length (78 characters).", 0);
        }
        char[] urn = packageIdURN.toCharArray();
        byte[] packageId = new byte[32];
        try {
            int x;
            int urnCount = 11;
            for (x = 0; x < 12; ++x) {
                packageId[x] = Utilities.twoCharsToByte(urn[urnCount++], urn[urnCount++]);
            }
            packageId[12] = Utilities.twoCharsToByte(urn[36], urn[37]);
            packageId[13] = Utilities.twoCharsToByte(urn[39], urn[40]);
            packageId[14] = Utilities.twoCharsToByte(urn[41], urn[42]);
            packageId[15] = Utilities.twoCharsToByte(urn[43], urn[44]);
            urnCount = 46;
            for (x = 16; x < 32; ++x) {
                packageId[x] = Utilities.twoCharsToByte(urn[urnCount++], urn[urnCount++]);
            }
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Error parsing part of a value for an old-style package identifier.", 0);
        }
        return new PackageIDImpl(packageId);
    }

    @Override
    public final PackageID clone() {
        try {
            PackageIDImpl cloned = (PackageIDImpl)super.clone();
            cloned.setPackageIDValue(this.packageIDValue);
            return cloned;
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
            return null;
        }
    }

    public final boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof PackageID)) {
            return false;
        }
        PackageID testPackageID = (PackageID)o;
        if (testPackageID.getLength() != this.getLength()) {
            return false;
        }
        if (testPackageID.getInstanceHigh() != this.getInstanceHigh()) {
            return false;
        }
        if (testPackageID.getInstanceMid() != this.getInstanceMid()) {
            return false;
        }
        if (testPackageID.getInstanceLow() != this.getInstanceLow()) {
            return false;
        }
        if (!Arrays.equals(testPackageID.getUniversalLabel(), this.getUniversalLabel())) {
            return false;
        }
        return this.getMaterial().equals(testPackageID.getMaterial());
    }

    @Override
    public final MaterialNumberGeneration getMaterialNumberGenerator() {
        return MaterialNumberGeneration.generationMethodFromCode((byte)((this.packageIDValue[11] & 0xFF) >>> 4));
    }

    @Override
    public final InstanceNumberGeneration getInstanceGenerator() {
        return InstanceNumberGeneration.generationMethodFromCode((byte)(this.packageIDValue[11] & 0xF));
    }

    public final MaterialType getMaterialType() {
        return MaterialType.materialTypeFromCode(this.packageIDValue[10]);
    }

    @Override
    public final synchronized PackageID nextInstance() throws InstanceOverflowException, GenerationMethodNotSupportedException {
        PackageID next = this.clone();
        switch (this.getInstanceGenerator()) {
            case LocalRegistration: {
                int currentPlus = ((this.packageIDValue[13] & 0xFF) << 16 | (this.packageIDValue[14] & 0xFF) << 8 | this.packageIDValue[15] & 0xFF) + 1;
                if (currentPlus > 0xFFFFFF) {
                    throw new InstanceOverflowException("Creating a new instance number using the local registration method causes the 24-bit instance number to overflow.", InstanceNumberGeneration.LocalRegistration);
                }
                next.setInstanceHigh((byte)(currentPlus >>> 16 & 0xFF));
                next.setInstanceMid((byte)((currentPlus >>> 8) * 255));
                next.setInstanceLow((byte)(currentPlus & 0xFF));
                return next;
            }
            case CopyAndPseudoRandom16Bit: {
                int currentPlusOne = (this.packageIDValue[13] & 0xFF) + 1;
                if (currentPlusOne > 255) {
                    throw new InstanceOverflowException("Creating a new instance number using a one byte counter causes an instance number overflow. Consider resetting the counter with setInstanceHigh((byte) 0).", InstanceNumberGeneration.CopyAndPseudoRandom16Bit);
                }
                next.setInstanceHigh((byte)(currentPlusOne & 0xFF));
                byte[] twoRandomBytes = new byte[2];
                while (next.getInstanceMid() == this.packageIDValue[14] && next.getInstanceLow() == this.packageIDValue[15]) {
                    randomMaker.nextBytes(twoRandomBytes);
                    next.setInstanceMid(twoRandomBytes[0]);
                    next.setInstanceLow(twoRandomBytes[1]);
                }
                return next;
            }
            case LiveStream: {
                throw new GenerationMethodNotSupportedException("Generation of instance numbers using live stream data is not supported by this method.");
            }
        }
        byte[] threeRandomBytes = new byte[3];
        while (next.getInstanceHigh() == this.packageIDValue[13] && next.getInstanceMid() == this.packageIDValue[14] && next.getInstanceLow() == this.packageIDValue[15]) {
            randomMaker.nextBytes(threeRandomBytes);
            next.setInstanceHigh(threeRandomBytes[0]);
            next.setInstanceMid(threeRandomBytes[1]);
            next.setInstanceLow(threeRandomBytes[2]);
        }
        return next;
    }

    @Override
    public final void appendXMLChildren(Node parent) {
        Document document = parent.getOwnerDocument();
        Text textPackageID = document.createTextNode(this.toString());
        parent.appendChild(textPackageID);
    }

    @Override
    public String getComment() {
        return null;
    }

    public static final PackageID createFromBuffer(ByteBuffer buffer) throws NullPointerException, EndOfDataException {
        if (buffer == null) {
            throw new NullPointerException("Cannot create a package id value from a null buffer.");
        }
        if (buffer.remaining() < 32) {
            throw new EndOfDataException("Not enough bytes remaining in the given buffer to read a package id value.");
        }
        if (buffer.order() == ByteOrder.LITTLE_ENDIAN) {
            byte[] packageIDBytes = new byte[32];
            buffer.get(packageIDBytes, 0, 16);
            buffer.get(packageIDBytes, 19, 1);
            buffer.get(packageIDBytes, 18, 1);
            buffer.get(packageIDBytes, 17, 1);
            buffer.get(packageIDBytes, 16, 1);
            buffer.get(packageIDBytes, 21, 1);
            buffer.get(packageIDBytes, 20, 1);
            buffer.get(packageIDBytes, 23, 1);
            buffer.get(packageIDBytes, 22, 1);
            buffer.get(packageIDBytes, 24, 8);
            if (packageIDBytes[24] == 6 && packageIDBytes[25] == 14 && packageIDBytes[26] == 43 && packageIDBytes[27] == 52 && (packageIDBytes[16] & 0x80) == 0) {
                byte[] swapBytes = new byte[8];
                System.arraycopy(packageIDBytes, 24, swapBytes, 0, 8);
                System.arraycopy(packageIDBytes, 16, packageIDBytes, 24, 8);
                System.arraycopy(swapBytes, 0, packageIDBytes, 16, 8);
            }
            return new PackageIDImpl(packageIDBytes);
        }
        byte[] packageIdBytes = new byte[buffer.remaining()];
        buffer.get(packageIdBytes);
        return new PackageIDImpl(packageIdBytes);
    }

    public static final long lengthAsBuffer(PackageID packageID) throws NullPointerException {
        return 32L;
    }

    public static final void writeToBuffer(PackageID packageID, ByteBuffer buffer) throws NullPointerException, InsufficientSpaceException {
        if (packageID == null) {
            throw new NullPointerException("Cannot write a null package id to a buffer.");
        }
        if (buffer == null) {
            throw new NullPointerException("Cannot write a package id to a null buffer.");
        }
        if (buffer.remaining() < 32) {
            throw new InsufficientSpaceException("Insufficient space in the given buffer to write a 32-byte identifier.");
        }
        if (buffer.order() == ByteOrder.BIG_ENDIAN) {
            if (packageID instanceof PackageIDImpl) {
                buffer.put(((PackageIDImpl)packageID).getPackageIDValue());
            } else {
                buffer.put(packageID.getUniversalLabel());
                buffer.put(packageID.getLength());
                buffer.put(packageID.getInstanceHigh());
                buffer.put(packageID.getInstanceMid());
                buffer.put(packageID.getInstanceLow());
                buffer.put(packageID.getMaterial().getAUIDValue());
            }
        } else {
            byte[] packageIDBytes = ((PackageIDImpl)packageID).getPackageIDValue();
            buffer.put(packageIDBytes, 0, 16);
            int y = 16;
            if (packageIDBytes[16] == 6 && packageIDBytes[17] == 14 && packageIDBytes[18] == 43 && packageIDBytes[19] == 52 && (packageIDBytes[24] & 0x80) == 0) {
                y = 24;
            }
            buffer.put(packageIDBytes[y + 3]);
            buffer.put(packageIDBytes[y + 2]);
            buffer.put(packageIDBytes[y + 1]);
            buffer.put(packageIDBytes[y]);
            buffer.put(packageIDBytes[y + 5]);
            buffer.put(packageIDBytes[y + 4]);
            buffer.put(packageIDBytes[y + 7]);
            buffer.put(packageIDBytes[y + 6]);
            y = y == 24 ? 16 : 24;
            buffer.put(packageIDBytes, y, 8);
        }
    }

    public static final void generateEmbeddableORM(Node parent, String namespace, String prefix) {
        Element embeddable = XMLBuilder.createChild(parent, namespace, prefix, "embeddable");
        XMLBuilder.setAttribute(embeddable, namespace, prefix, "class", PackageIDImpl.class.getCanonicalName());
        XMLBuilder.setAttribute(embeddable, namespace, prefix, "access", "FIELD");
        Element embeddableAttributes = XMLBuilder.createChild(embeddable, namespace, prefix, "attributes");
        Element basic = XMLBuilder.createChild(embeddableAttributes, namespace, prefix, "basic");
        XMLBuilder.setAttribute(basic, namespace, prefix, "name", "packageIDValue");
    }

    public static final void generateEmbeddedORM(Node parent, String ownerName, String namespace, String prefix) {
        Element embedded = XMLBuilder.createChild(parent, namespace, prefix, "embedded");
        XMLBuilder.setAttribute(embedded, namespace, prefix, "name", Utilities.lowerFirstLetter(ownerName));
        Element attributeOverride = XMLBuilder.createChild(embedded, namespace, prefix, "attribute-override");
        XMLBuilder.setAttribute(attributeOverride, namespace, prefix, "name", "packageIDValue");
        Element column = XMLBuilder.createChild(attributeOverride, namespace, prefix, "column");
        XMLBuilder.setAttribute(column, namespace, prefix, "name", ownerName);
    }

    public static final String toPersistentForm(PackageID packageID) {
        if (packageID == null) {
            return null;
        }
        char[] packageChars = (char[])persistTemplate.clone();
        byte[] materialBytes = null;
        materialBytes = packageID.getMaterial().getAUIDValue();
        packageChars[0] = bigHexCharMap[materialBytes[0] >>> 4 & 0xF];
        packageChars[1] = bigHexCharMap[materialBytes[0] & 0xF];
        packageChars[2] = bigHexCharMap[materialBytes[1] >>> 4 & 0xF];
        packageChars[3] = bigHexCharMap[materialBytes[1] & 0xF];
        packageChars[4] = bigHexCharMap[materialBytes[2] >>> 4 & 0xF];
        packageChars[5] = bigHexCharMap[materialBytes[2] & 0xF];
        packageChars[6] = bigHexCharMap[materialBytes[3] >>> 4 & 0xF];
        packageChars[7] = bigHexCharMap[materialBytes[3] & 0xF];
        packageChars[9] = bigHexCharMap[materialBytes[4] >>> 4 & 0xF];
        packageChars[10] = bigHexCharMap[materialBytes[4] & 0xF];
        packageChars[11] = bigHexCharMap[materialBytes[5] >>> 4 & 0xF];
        packageChars[12] = bigHexCharMap[materialBytes[5] & 0xF];
        packageChars[14] = bigHexCharMap[materialBytes[6] >>> 4 & 0xF];
        packageChars[15] = bigHexCharMap[materialBytes[6] & 0xF];
        packageChars[16] = bigHexCharMap[materialBytes[7] >>> 4 & 0xF];
        packageChars[17] = bigHexCharMap[materialBytes[7] & 0xF];
        packageChars[19] = bigHexCharMap[materialBytes[8] >>> 4 & 0xF];
        packageChars[20] = bigHexCharMap[materialBytes[8] & 0xF];
        packageChars[21] = bigHexCharMap[materialBytes[9] >>> 4 & 0xF];
        packageChars[22] = bigHexCharMap[materialBytes[9] & 0xF];
        packageChars[24] = bigHexCharMap[materialBytes[10] >>> 4 & 0xF];
        packageChars[25] = bigHexCharMap[materialBytes[10] & 0xF];
        packageChars[26] = bigHexCharMap[materialBytes[11] >>> 4 & 0xF];
        packageChars[27] = bigHexCharMap[materialBytes[11] & 0xF];
        packageChars[28] = bigHexCharMap[materialBytes[12] >>> 4 & 0xF];
        packageChars[29] = bigHexCharMap[materialBytes[12] & 0xF];
        packageChars[30] = bigHexCharMap[materialBytes[13] >>> 4 & 0xF];
        packageChars[31] = bigHexCharMap[materialBytes[13] & 0xF];
        packageChars[32] = bigHexCharMap[materialBytes[14] >>> 4 & 0xF];
        packageChars[33] = bigHexCharMap[materialBytes[14] & 0xF];
        packageChars[34] = bigHexCharMap[materialBytes[15] >>> 4 & 0xF];
        packageChars[35] = bigHexCharMap[materialBytes[15] & 0xF];
        byte instanceHigh = packageID.getInstanceHigh();
        packageChars[37] = bigHexCharMap[instanceHigh >>> 4 & 0xF];
        packageChars[38] = bigHexCharMap[instanceHigh & 0xF];
        byte instanceMid = packageID.getInstanceMid();
        packageChars[39] = bigHexCharMap[instanceMid >>> 4 & 0xF];
        packageChars[40] = bigHexCharMap[instanceMid & 0xF];
        byte instanceLow = packageID.getInstanceLow();
        packageChars[41] = bigHexCharMap[instanceLow >>> 4 & 0xF];
        packageChars[42] = bigHexCharMap[instanceLow & 0xF];
        byte length = packageID.getLength();
        packageChars[44] = bigHexCharMap[length >>> 4 & 0xF];
        packageChars[45] = bigHexCharMap[length & 0xF];
        byte[] ul = packageID.getUniversalLabel();
        int y = 47;
        for (int x = 0; x < ul.length; ++x) {
            packageChars[y++] = bigHexCharMap[ul[x] >>> 4 & 0xF];
            packageChars[y++] = bigHexCharMap[ul[x] & 0xF];
        }
        return new String(packageChars);
    }

    public static final PackageID fromPersistentForm(String packageID) {
        if (packageID == null) {
            return null;
        }
        byte[] packageBytes = new byte[32];
        char[] packageChars = packageID.toCharArray();
        int y = 16;
        packageBytes[y++] = Utilities.twoCharsToByte(packageChars[0], packageChars[1]);
        packageBytes[y++] = Utilities.twoCharsToByte(packageChars[2], packageChars[3]);
        packageBytes[y++] = Utilities.twoCharsToByte(packageChars[4], packageChars[5]);
        packageBytes[y++] = Utilities.twoCharsToByte(packageChars[6], packageChars[7]);
        packageBytes[y++] = Utilities.twoCharsToByte(packageChars[9], packageChars[10]);
        packageBytes[y++] = Utilities.twoCharsToByte(packageChars[11], packageChars[12]);
        packageBytes[y++] = Utilities.twoCharsToByte(packageChars[14], packageChars[15]);
        packageBytes[y++] = Utilities.twoCharsToByte(packageChars[16], packageChars[17]);
        y = 24;
        packageBytes[y++] = Utilities.twoCharsToByte(packageChars[19], packageChars[20]);
        packageBytes[y++] = Utilities.twoCharsToByte(packageChars[21], packageChars[22]);
        packageBytes[y++] = Utilities.twoCharsToByte(packageChars[24], packageChars[25]);
        packageBytes[y++] = Utilities.twoCharsToByte(packageChars[26], packageChars[27]);
        packageBytes[y++] = Utilities.twoCharsToByte(packageChars[28], packageChars[29]);
        packageBytes[y++] = Utilities.twoCharsToByte(packageChars[30], packageChars[31]);
        packageBytes[y++] = Utilities.twoCharsToByte(packageChars[32], packageChars[33]);
        packageBytes[y++] = Utilities.twoCharsToByte(packageChars[34], packageChars[35]);
        packageBytes[13] = Utilities.twoCharsToByte(packageChars[37], packageChars[38]);
        packageBytes[14] = Utilities.twoCharsToByte(packageChars[39], packageChars[40]);
        packageBytes[15] = Utilities.twoCharsToByte(packageChars[41], packageChars[42]);
        packageBytes[12] = Utilities.twoCharsToByte(packageChars[44], packageChars[45]);
        y = 47;
        for (int x = 0; x < 12; ++x) {
            packageBytes[x] = Utilities.twoCharsToByte(packageChars[y++], packageChars[y++]);
        }
        return new PackageIDImpl(packageBytes);
    }
}

