/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.record.impl;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tv.amwa.maj.integer.Int16;
import tv.amwa.maj.integer.UInt8;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.record.DateStruct;
import tv.amwa.maj.util.Utilities;

public final class DateStructImpl
implements DateStruct,
Serializable,
Cloneable {
    private static final long serialVersionUID = -20078426390114363L;
    private Calendar dateValue;
    private boolean dayHasBeenSet = false;
    private boolean monthHasBeenSet = false;
    private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");

    public DateStructImpl(@UInt8 byte day, @UInt8 byte month, @Int16 short year) throws IllegalArgumentException {
        this.dateValue = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        this.dateValue.setLenient(false);
        this.setDate(day, month, year);
    }

    @Override
    public void setDate(@UInt8 byte day, @UInt8 byte month, @Int16 short year) throws IllegalArgumentException {
        this.dateValue.clear();
        this.dateValue.set(year, month - 1, day);
        this.dayHasBeenSet = true;
        this.monthHasBeenSet = true;
        this.dateValue.getTime();
    }

    public DateStructImpl(Calendar dateItem) throws NullPointerException, IllegalArgumentException {
        this.setDateValue(dateItem);
    }

    public DateStructImpl() {
        this.dateValue = new GregorianCalendar();
        this.dateValue.setLenient(false);
    }

    @Override
    @UInt8
    public final byte getDay() {
        return (byte)this.dateValue.get(5);
    }

    @Override
    public final void setDay(@UInt8 byte day) throws IllegalArgumentException {
        if (day == 0) {
            this.dayHasBeenSet = false;
            return;
        }
        if (day < 1 || day > 31) {
            throw new IllegalArgumentException("The day of the month must be in the range 1 to 31.");
        }
        this.dateValue.clear(5);
        this.dateValue.set(5, day);
        this.dayHasBeenSet = true;
        if (this.monthHasBeenSet) {
            this.dateValue.getTime();
        }
    }

    @Override
    @UInt8
    public final byte getMonth() {
        return (byte)(this.dateValue.get(2) + 1);
    }

    @Override
    public final void setMonth(@UInt8 byte month) throws IllegalArgumentException {
        if (month == 0) {
            this.monthHasBeenSet = false;
            return;
        }
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("The month must lie in the range 1 to 12.");
        }
        this.dateValue.clear(2);
        this.dateValue.set(2, month - 1);
        this.monthHasBeenSet = true;
        if (this.dayHasBeenSet) {
            this.dateValue.getTime();
        }
    }

    @Override
    @Int16
    public final short getYear() {
        int year = this.dateValue.get(1);
        if (this.dateValue.get(0) == 0) {
            year = 1 - year;
        }
        return (short)year;
    }

    @Override
    public final void setYear(@Int16 short year) throws IllegalArgumentException {
        if (year == 0) {
            return;
        }
        int dayOfMonth = this.dateValue.get(5);
        int month = this.dateValue.get(2);
        this.dateValue.clear(1);
        if (year <= 0) {
            year = (short)(1 - year);
            this.dateValue.set(0, 0);
        }
        this.dateValue.set(1, year);
        this.dateValue.getTime();
    }

    @Override
    public final Calendar getDateValue() {
        return (Calendar)this.dateValue.clone();
    }

    public final void setDateValue(Calendar dateItem) throws NullPointerException, IllegalArgumentException {
        if (dateItem == null) {
            throw new NullPointerException("Cannot create a date structure from a null value.");
        }
        dateItem.setLenient(false);
        dateItem.getTime();
        this.dateValue = (Calendar)dateItem.clone();
    }

    @Override
    public final String toString() {
        StringBuffer sb = new StringBuffer();
        String value = Short.toString(this.getYear());
        if (value.charAt(0) == '-') {
            sb.append('-');
            value = value.substring(1);
        }
        for (int u = value.length(); u < 4; ++u) {
            sb.append('0');
        }
        sb.append(value);
        sb.append('-');
        value = Byte.toString(this.getMonth());
        if (value.length() == 1) {
            sb.append('0');
        }
        sb.append(value);
        sb.append('-');
        value = Byte.toString(this.getDay());
        if (value.length() == 1) {
            sb.append('0');
        }
        sb.append(value);
        int offset = this.dateValue.get(15) / 60000;
        int hourOffset = offset / 60;
        int minuteOffset = offset % 60;
        value = Integer.toString(hourOffset);
        if (value.charAt(0) == '-') {
            sb.append('-');
            value = value.substring(1);
        } else {
            sb.append('+');
        }
        if (value.length() == 1) {
            sb.append('0');
        }
        sb.append(value);
        value = Integer.toString(minuteOffset);
        if (value.length() == 1) {
            sb.append('0');
        }
        sb.append(value);
        return sb.toString();
    }

    public static final DateStructImpl parseFactory(String date) throws ParseException, NullPointerException, IllegalArgumentException {
        if (date == null) {
            throw new NullPointerException("Cannot create a date value from a null value.");
        }
        formatter.setLenient(false);
        Date parsedDate = formatter.parse(date);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.clear();
        calendar.setTime(parsedDate);
        if (calendar.get(1) <= Short.MIN_VALUE) {
            throw new IllegalArgumentException("Year cannot be less than the minimum value for a Java short.");
        }
        if (calendar.get(1) > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Year cannot be greater than the maximum value for a Java short.");
        }
        return new DateStructImpl(calendar);
    }

    public final boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof DateStruct)) {
            return false;
        }
        DateStruct testDate = (DateStruct)o;
        if (this.getDay() != testDate.getDay()) {
            return false;
        }
        if (this.getMonth() != testDate.getMonth()) {
            return false;
        }
        return this.getYear() == testDate.getYear();
    }

    public final int hashCode() {
        return this.getYear() + 10000 * this.getMonth() + 1000000 * this.getDay();
    }

    @Override
    public final DateStruct clone() {
        try {
            DateStructImpl cloned = (DateStructImpl)super.clone();
            cloned.setDateValue(this.dateValue);
            return cloned;
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
            return null;
        }
    }

    public static final void generateEmbeddableORM(Node parent, String namespace, String prefix) {
        Element embeddable = XMLBuilder.createChild(parent, namespace, prefix, "embeddable");
        XMLBuilder.setAttribute(embeddable, namespace, prefix, "class", DateStructImpl.class.getCanonicalName());
        XMLBuilder.setAttribute(embeddable, namespace, prefix, "access", "FIELD");
        Element embeddableAttributes = XMLBuilder.createChild(embeddable, namespace, prefix, "attributes");
        Element basic = XMLBuilder.createChild(embeddableAttributes, namespace, prefix, "basic");
        XMLBuilder.setAttribute(basic, namespace, prefix, "name", "dateValue");
        XMLBuilder.appendElement((Node)basic, namespace, prefix, "temporal", "DATE");
    }

    public static final void generateEmbeddedORM(Node parent, String ownerName, String namespace, String prefix) {
        Element embedded = XMLBuilder.createChild(parent, namespace, prefix, "embedded");
        XMLBuilder.setAttribute(embedded, namespace, prefix, "name", Utilities.lowerFirstLetter(ownerName));
        Element attributeOverride = XMLBuilder.createChild(embedded, namespace, prefix, "attribute-override");
        XMLBuilder.setAttribute(attributeOverride, namespace, prefix, "name", "dateValue");
        Element column = XMLBuilder.createChild(attributeOverride, namespace, prefix, "column");
        XMLBuilder.setAttribute(column, namespace, prefix, "name", ownerName);
    }
}

