/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.record.impl;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.SecureRandom;
import java.util.Date;
import java.util.UUID;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import tv.amwa.maj.exception.EndOfDataException;
import tv.amwa.maj.exception.InsufficientSpaceException;
import tv.amwa.maj.integer.UInt16;
import tv.amwa.maj.integer.UInt32;
import tv.amwa.maj.integer.UInt8;
import tv.amwa.maj.io.mxf.UL;
import tv.amwa.maj.io.xml.XMLBuilder;
import tv.amwa.maj.io.xml.XMLSerializable;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.impl.AUIDGeneration;
import tv.amwa.maj.util.Utilities;

public final class AUIDImpl
implements AUID,
UL,
Serializable,
XMLSerializable,
Cloneable,
Comparable<AUID> {
    private static final long serialVersionUID = 5546784434464118885L;
    private static final char[] uuidTemplate = new char[]{'u', 'r', 'n', ':', 'u', 'u', 'i', 'd', ':', '*', '*', '*', '*', '*', '*', '*', '*', '-', '*', '*', '*', '*', '-', '*', '*', '*', '*', '-', '*', '*', '*', '*', '-', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*'};
    private static final char[] hexCharMap = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] bigHexCharMap = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] ulTemplate = new char[]{'u', 'r', 'n', ':', 's', 'm', 'p', 't', 'e', ':', 'u', 'l', ':', '*', '*', '*', '*', '*', '*', '*', '*', '.', '*', '*', '*', '*', '*', '*', '*', '*', '.', '*', '*', '*', '*', '*', '*', '*', '*', '.', '*', '*', '*', '*', '*', '*', '*', '*'};
    private static final char[] persistTemplate = new char[]{'*', '*', '*', '*', '*', '*', '*', '*', '-', '*', '*', '*', '*', '-', '*', '*', '*', '*', '-', '*', '*', '*', '*', '-', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*'};
    static final long gregorianToJavaOffset = 12219292800000L;
    private byte[] auidValue;
    private static SecureRandom randomMaker = null;
    private static byte[] localNodeID = Utilities.createLocalHostID(6);
    private static Long type1Counter = 0L;
    public static final String MYSQL_COLUMN_DEFINITION = "CHAR(36) CHARACTER SET ascii COLLATE ascii_general_ci";

    public AUIDImpl(@UInt32 int data1, @UInt16 short data2, @UInt16 short data3, @UInt8 byte[] data4) throws NullPointerException {
        if (data4 == null) {
            throw new NullPointerException("Cannot create AUID value with null value for data4, the last 8 bytes.");
        }
        this.auidValue = new byte[16];
        this.setData1(data1);
        this.setData2(data2);
        this.setData3(data3);
        this.setData4(data4);
    }

    public AUIDImpl(byte[] auidValue) throws NullPointerException {
        this.setAUIDValue(auidValue);
    }

    public AUIDImpl() {
        this.setAUIDValue(AUIDImpl.randomAUID().getAUIDValue());
    }

    public static final void setLocalNodeID(byte[] localNodeIDBytes) {
        localNodeID = Utilities.checkBytes(localNodeIDBytes, 6);
    }

    public static final AUIDImpl timebasedAUID() {
        return AUIDImpl.timebasedAUID(localNodeID);
    }

    public static final AUIDImpl randomAUID() {
        if (randomMaker == null) {
            randomMaker = Utilities.seedRandomMaker();
        }
        int data1 = randomMaker.nextInt();
        short data2 = (short)randomMaker.nextInt();
        short data3 = (short)(0x4000 | randomMaker.nextInt() & 0xFFF);
        byte[] data4 = new byte[8];
        randomMaker.nextBytes(data4);
        data4[0] = (byte)(0x80 | data4[0] & 0x3F);
        return new AUIDImpl(data1, data2, data3, data4);
    }

    public static final AUIDImpl namebasedAUID(byte[] nameData) {
        if (nameData == null) {
            throw new NullPointerException("Cannot create a new name based UUID using null name data.");
        }
        UUID uuid = UUID.nameUUIDFromBytes(nameData);
        byte[] auidValue = new byte[16];
        long msbs = uuid.getMostSignificantBits();
        for (int x = 7; x > -1; --x) {
            auidValue[x] = (byte)(msbs & 0xFFL);
            msbs >>>= 8;
        }
        long lsbs = uuid.getLeastSignificantBits();
        for (int x = 15; x > 7; --x) {
            auidValue[x] = (byte)(lsbs & 0xFFL);
            lsbs >>>= 8;
        }
        return new AUIDImpl(auidValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final AUIDImpl timebasedAUID(byte[] nodeId) throws NullPointerException, IllegalArgumentException {
        long timeValue;
        if (nodeId == null) {
            throw new NullPointerException("Cannot create a new time-based AUID from a null node ID.");
        }
        if (nodeId.length < 6) {
            throw new IllegalArgumentException("Cannot create a new time-based AUID from a node id with less than 6 bytes.");
        }
        if (randomMaker == null) {
            randomMaker = Utilities.seedRandomMaker();
        }
        Long l = type1Counter;
        synchronized (l) {
            timeValue = new Date().getTime();
            timeValue += 12219292800000L;
            timeValue = timeValue * 10000L + (type1Counter & 0x1FFFL);
            Long l2 = type1Counter;
            type1Counter = type1Counter + 1L;
        }
        short clockSequence = (short)(0x8000 | randomMaker.nextInt() & 0x1FFF);
        int data1 = (int)(timeValue & 0xFFFFFFFFFFFFFFFFL);
        short data2 = (short)(timeValue >>> 32 & 0xFFFFL);
        short data3 = (short)(0x1000L | timeValue >>> 48 & 0xFFFL);
        byte[] data4 = new byte[8];
        data4[0] = (byte)(clockSequence >>> 8 & 0xFF);
        data4[1] = (byte)(clockSequence & 0xFF);
        System.arraycopy(nodeId, 0, data4, 2, 6);
        return new AUIDImpl(data1, data2, data3, data4);
    }

    public static final AUIDImpl auidFactory(AUIDGeneration type, byte[] extraData) throws NullPointerException {
        if (type == null) {
            throw new NullPointerException("Cannot create a new UUID as an AUID using a null generation type.");
        }
        switch (type) {
            case IETF_Type1: 
            case Timebased: {
                if (extraData == null) {
                    return AUIDImpl.timebasedAUID();
                }
                return AUIDImpl.timebasedAUID(extraData);
            }
            case IETF_Type3: 
            case Namebased: {
                if (extraData != null) {
                    return AUIDImpl.namebasedAUID(extraData);
                }
                throw new NullPointerException("Cannot create a new name based AUID without name data.");
            }
            case IETF_Type4: 
            case Random: {
                return AUIDImpl.randomAUID();
            }
        }
        throw new NullPointerException("Cannot create a new AUID for an unknown or null generation type.");
    }

    @Override
    public final int getData1() {
        return (this.auidValue[0] & 0xFF) << 24 | (this.auidValue[1] & 0xFF) << 16 | (this.auidValue[2] & 0xFF) << 8 | this.auidValue[3] & 0xFF;
    }

    @Override
    public final void setData1(int data1) {
        this.auidValue[0] = (byte)(data1 >>> 24);
        this.auidValue[1] = (byte)(data1 >>> 16 & 0xFF);
        this.auidValue[2] = (byte)(data1 >>> 8 & 0xFF);
        this.auidValue[3] = (byte)(data1 & 0xFF);
    }

    @Override
    public final short getData2() {
        return (short)((this.auidValue[4] & 0xFF) << 8 | this.auidValue[5] & 0xFF);
    }

    @Override
    public final void setData2(short data2) {
        this.auidValue[4] = (byte)(data2 >>> 8);
        this.auidValue[5] = (byte)(data2 & 0xFF);
    }

    @Override
    public final short getData3() {
        return (short)((this.auidValue[6] & 0xFF) << 8 | this.auidValue[7] & 0xFF);
    }

    @Override
    public final void setData3(short data3) {
        this.auidValue[6] = (byte)(data3 >>> 8);
        this.auidValue[7] = (byte)(data3 & 0xFF);
    }

    @Override
    public final byte[] getData4() {
        byte[] data4 = new byte[8];
        System.arraycopy(this.auidValue, 8, data4, 0, 8);
        return data4;
    }

    @Override
    public final void setData4(byte[] data4) {
        data4 = Utilities.checkBytes(data4, 8);
        System.arraycopy(data4, 0, this.auidValue, 8, 8);
    }

    @Override
    public final byte[] getAUIDValue() {
        return (byte[])this.auidValue.clone();
    }

    public final void setAUIDValue(byte[] auidValue) throws NullPointerException {
        if (auidValue == null) {
            throw new NullPointerException("Cannot create AUID from a null byte array.");
        }
        this.auidValue = (auidValue = Utilities.checkBytes(auidValue, 16))[0] == 6 && auidValue[1] == 14 && auidValue[2] == 43 && auidValue[3] == 52 && (auidValue[8] & 0x80) == 0 ? AUIDImpl.swapIDBytes(auidValue) : auidValue;
    }

    private static final byte[] swapIDBytes(byte[] idBytes) {
        for (int u = 0; u < 8; ++u) {
            byte swapByte = idBytes[u];
            idBytes[u] = idBytes[u + 8];
            idBytes[u + 8] = swapByte;
        }
        return idBytes;
    }

    @Override
    public final boolean isNil() {
        for (byte element : this.auidValue) {
            if (element == 0) continue;
            return false;
        }
        return true;
    }

    public final boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof AUID)) {
            return false;
        }
        return AUIDImpl.auidsEqual(this, (AUID)o);
    }

    public static final boolean auidsEqual(AUID auid1, AUID auid2) throws NullPointerException {
        if (auid1 == null || auid2 == null) {
            throw new NullPointerException("Cannot check for AUID value equality with null objects.");
        }
        if (auid1 == auid2) {
            return true;
        }
        if (auid1.getData1() != auid2.getData1()) {
            return false;
        }
        if (auid1.getData2() != auid2.getData2()) {
            return false;
        }
        if (auid1.getData3() != auid2.getData3()) {
            return false;
        }
        for (int u = 0; u < auid1.getData4().length; ++u) {
            if (auid1.getData4()[u] == auid2.getData4()[u]) continue;
            return false;
        }
        return true;
    }

    final String toUUIDString() {
        char[] uuid = (char[])uuidTemplate.clone();
        uuid[9] = hexCharMap[this.auidValue[0] >>> 4 & 0xF];
        uuid[10] = hexCharMap[this.auidValue[0] & 0xF];
        uuid[11] = hexCharMap[this.auidValue[1] >>> 4 & 0xF];
        uuid[12] = hexCharMap[this.auidValue[1] & 0xF];
        uuid[13] = hexCharMap[this.auidValue[2] >>> 4 & 0xF];
        uuid[14] = hexCharMap[this.auidValue[2] & 0xF];
        uuid[15] = hexCharMap[this.auidValue[3] >>> 4 & 0xF];
        uuid[16] = hexCharMap[this.auidValue[3] & 0xF];
        uuid[18] = hexCharMap[this.auidValue[4] >>> 4 & 0xF];
        uuid[19] = hexCharMap[this.auidValue[4] & 0xF];
        uuid[20] = hexCharMap[this.auidValue[5] >>> 4 & 0xF];
        uuid[21] = hexCharMap[this.auidValue[5] & 0xF];
        uuid[23] = hexCharMap[this.auidValue[6] >>> 4 & 0xF];
        uuid[24] = hexCharMap[this.auidValue[6] & 0xF];
        uuid[25] = hexCharMap[this.auidValue[7] >>> 4 & 0xF];
        uuid[26] = hexCharMap[this.auidValue[7] & 0xF];
        uuid[28] = hexCharMap[this.auidValue[8] >>> 4 & 0xF];
        uuid[29] = hexCharMap[this.auidValue[8] & 0xF];
        uuid[30] = hexCharMap[this.auidValue[9] >>> 4 & 0xF];
        uuid[31] = hexCharMap[this.auidValue[9] & 0xF];
        uuid[33] = hexCharMap[this.auidValue[10] >>> 4 & 0xF];
        uuid[34] = hexCharMap[this.auidValue[10] & 0xF];
        uuid[35] = hexCharMap[this.auidValue[11] >>> 4 & 0xF];
        uuid[36] = hexCharMap[this.auidValue[11] & 0xF];
        uuid[37] = hexCharMap[this.auidValue[12] >>> 4 & 0xF];
        uuid[38] = hexCharMap[this.auidValue[12] & 0xF];
        uuid[39] = hexCharMap[this.auidValue[13] >>> 4 & 0xF];
        uuid[40] = hexCharMap[this.auidValue[13] & 0xF];
        uuid[41] = hexCharMap[this.auidValue[14] >>> 4 & 0xF];
        uuid[42] = hexCharMap[this.auidValue[14] & 0xF];
        uuid[43] = hexCharMap[this.auidValue[15] >>> 4 & 0xF];
        uuid[44] = hexCharMap[this.auidValue[15] & 0xF];
        return new String(uuid);
    }

    final String toULString() {
        char[] ul = (char[])ulTemplate.clone();
        ul[13] = hexCharMap[this.auidValue[8] >>> 4 & 0xF];
        ul[14] = hexCharMap[this.auidValue[8] & 0xF];
        ul[15] = hexCharMap[this.auidValue[9] >>> 4 & 0xF];
        ul[16] = hexCharMap[this.auidValue[9] & 0xF];
        ul[17] = hexCharMap[this.auidValue[10] >>> 4 & 0xF];
        ul[18] = hexCharMap[this.auidValue[10] & 0xF];
        ul[19] = hexCharMap[this.auidValue[11] >>> 4 & 0xF];
        ul[20] = hexCharMap[this.auidValue[11] & 0xF];
        ul[22] = hexCharMap[this.auidValue[12] >>> 4 & 0xF];
        ul[23] = hexCharMap[this.auidValue[12] & 0xF];
        ul[24] = hexCharMap[this.auidValue[13] >>> 4 & 0xF];
        ul[25] = hexCharMap[this.auidValue[13] & 0xF];
        ul[26] = hexCharMap[this.auidValue[14] >>> 4 & 0xF];
        ul[27] = hexCharMap[this.auidValue[14] & 0xF];
        ul[28] = hexCharMap[this.auidValue[15] >>> 4 & 0xF];
        ul[29] = hexCharMap[this.auidValue[15] & 0xF];
        ul[31] = hexCharMap[this.auidValue[0] >>> 4 & 0xF];
        ul[32] = hexCharMap[this.auidValue[0] & 0xF];
        ul[33] = hexCharMap[this.auidValue[1] >>> 4 & 0xF];
        ul[34] = hexCharMap[this.auidValue[1] & 0xF];
        ul[35] = hexCharMap[this.auidValue[2] >>> 4 & 0xF];
        ul[36] = hexCharMap[this.auidValue[2] & 0xF];
        ul[37] = hexCharMap[this.auidValue[3] >>> 4 & 0xF];
        ul[38] = hexCharMap[this.auidValue[3] & 0xF];
        ul[40] = hexCharMap[this.auidValue[4] >>> 4 & 0xF];
        ul[41] = hexCharMap[this.auidValue[4] & 0xF];
        ul[42] = hexCharMap[this.auidValue[5] >>> 4 & 0xF];
        ul[43] = hexCharMap[this.auidValue[5] & 0xF];
        ul[44] = hexCharMap[this.auidValue[6] >>> 4 & 0xF];
        ul[45] = hexCharMap[this.auidValue[6] & 0xF];
        ul[46] = hexCharMap[this.auidValue[7] >>> 4 & 0xF];
        ul[47] = hexCharMap[this.auidValue[7] & 0xF];
        return new String(ul);
    }

    @Override
    public final boolean isUniversalLabel() {
        if (this.isNil()) {
            return false;
        }
        return (this.auidValue[8] & 0x80) == 0;
    }

    @Override
    public final String toString() {
        if (this.isNil()) {
            return "urn:uuid:00000000-0000-0000-0000-000000000000";
        }
        if (this.isUniversalLabel()) {
            return this.toULString();
        }
        return this.toUUIDString();
    }

    public static final AUIDImpl parseFactory(String auidValue) throws NullPointerException, NumberFormatException {
        if (auidValue == null) {
            throw new NullPointerException("Cannot create an AUID from a null string.");
        }
        if ((auidValue = auidValue.trim()).startsWith("urn:smpte:ul:")) {
            return AUIDImpl.parseUL(auidValue);
        }
        if (auidValue.startsWith("urn:uuid:")) {
            return AUIDImpl.parseUUID(auidValue);
        }
        if (auidValue.startsWith("urn:x-ul:")) {
            return AUIDImpl.parseULOld(auidValue);
        }
        throw new NumberFormatException("The given string does not appear to be a Universal Label or an UUID.");
    }

    static final AUIDImpl parseUUID(String auidValue) throws NumberFormatException {
        if (auidValue.length() != 45) {
            throw new NumberFormatException("The given string is the wrong length for a complete AUID value, UL or UUID.");
        }
        byte[] auid = new byte[16];
        char[] urn = auidValue.toCharArray();
        auid[0] = Utilities.twoCharsToByte(urn[9], urn[10]);
        auid[1] = Utilities.twoCharsToByte(urn[11], urn[12]);
        auid[2] = Utilities.twoCharsToByte(urn[13], urn[14]);
        auid[3] = Utilities.twoCharsToByte(urn[15], urn[16]);
        auid[4] = Utilities.twoCharsToByte(urn[18], urn[19]);
        auid[5] = Utilities.twoCharsToByte(urn[20], urn[21]);
        auid[6] = Utilities.twoCharsToByte(urn[23], urn[24]);
        auid[7] = Utilities.twoCharsToByte(urn[25], urn[26]);
        auid[8] = Utilities.twoCharsToByte(urn[28], urn[29]);
        auid[9] = Utilities.twoCharsToByte(urn[30], urn[31]);
        auid[10] = Utilities.twoCharsToByte(urn[33], urn[34]);
        auid[11] = Utilities.twoCharsToByte(urn[35], urn[36]);
        auid[12] = Utilities.twoCharsToByte(urn[37], urn[38]);
        auid[13] = Utilities.twoCharsToByte(urn[39], urn[40]);
        auid[14] = Utilities.twoCharsToByte(urn[41], urn[42]);
        auid[15] = Utilities.twoCharsToByte(urn[43], urn[44]);
        return new AUIDImpl(auid);
    }

    static final AUIDImpl parseULOld(String auidValue) throws NumberFormatException {
        if (auidValue.length() != 45) {
            throw new NumberFormatException("The given string is the wrong length for a complete AUID value, UL or UUID.");
        }
        byte[] auid = new byte[16];
        char[] urn = auidValue.toCharArray();
        auid[0] = Utilities.twoCharsToByte(urn[28], urn[29]);
        auid[1] = Utilities.twoCharsToByte(urn[30], urn[31]);
        auid[2] = Utilities.twoCharsToByte(urn[32], urn[33]);
        auid[3] = Utilities.twoCharsToByte(urn[34], urn[35]);
        auid[4] = Utilities.twoCharsToByte(urn[37], urn[38]);
        auid[5] = Utilities.twoCharsToByte(urn[39], urn[40]);
        auid[6] = Utilities.twoCharsToByte(urn[41], urn[42]);
        auid[7] = Utilities.twoCharsToByte(urn[43], urn[44]);
        auid[8] = Utilities.twoCharsToByte(urn[9], urn[10]);
        auid[9] = Utilities.twoCharsToByte(urn[11], urn[12]);
        auid[10] = Utilities.twoCharsToByte(urn[13], urn[14]);
        auid[11] = Utilities.twoCharsToByte(urn[15], urn[16]);
        auid[12] = Utilities.twoCharsToByte(urn[18], urn[19]);
        auid[13] = Utilities.twoCharsToByte(urn[20], urn[21]);
        auid[14] = Utilities.twoCharsToByte(urn[23], urn[24]);
        auid[15] = Utilities.twoCharsToByte(urn[25], urn[26]);
        return new AUIDImpl(auid);
    }

    static final AUIDImpl parseUL(String auidValue) throws NumberFormatException {
        if (auidValue.length() != 48) {
            throw new NumberFormatException("The given string is the wrong length for a complete universal label.");
        }
        byte[] auid = new byte[16];
        char[] urn = auidValue.toCharArray();
        auid[0] = Utilities.twoCharsToByte(urn[31], urn[32]);
        auid[1] = Utilities.twoCharsToByte(urn[33], urn[34]);
        auid[2] = Utilities.twoCharsToByte(urn[35], urn[36]);
        auid[3] = Utilities.twoCharsToByte(urn[37], urn[38]);
        auid[4] = Utilities.twoCharsToByte(urn[40], urn[41]);
        auid[5] = Utilities.twoCharsToByte(urn[42], urn[43]);
        auid[6] = Utilities.twoCharsToByte(urn[44], urn[45]);
        auid[7] = Utilities.twoCharsToByte(urn[46], urn[47]);
        auid[8] = Utilities.twoCharsToByte(urn[13], urn[14]);
        auid[9] = Utilities.twoCharsToByte(urn[15], urn[16]);
        auid[10] = Utilities.twoCharsToByte(urn[17], urn[18]);
        auid[11] = Utilities.twoCharsToByte(urn[19], urn[20]);
        auid[12] = Utilities.twoCharsToByte(urn[22], urn[23]);
        auid[13] = Utilities.twoCharsToByte(urn[24], urn[25]);
        auid[14] = Utilities.twoCharsToByte(urn[26], urn[27]);
        auid[15] = Utilities.twoCharsToByte(urn[28], urn[29]);
        if (auid[0] != 6 || auid[1] != 14 || auid[2] != 43 || auid[3] != 52 || (auid[8] & 0x80) != 0) {
            auid = AUIDImpl.swapIDBytes(auid);
        }
        return new AUIDImpl(auid);
    }

    public final int hashCode() {
        return (this.auidValue[0] ^ this.auidValue[4] ^ this.auidValue[8] ^ this.auidValue[12]) << 24 ^ (this.auidValue[1] ^ this.auidValue[5] ^ this.auidValue[9] ^ this.auidValue[13]) << 16 ^ (this.auidValue[2] ^ this.auidValue[6] ^ this.auidValue[10] ^ this.auidValue[14]) << 8 ^ (this.auidValue[3] ^ this.auidValue[7] ^ this.auidValue[11] ^ this.auidValue[15]);
    }

    @Override
    public final UL clone() {
        try {
            AUIDImpl cloned = (AUIDImpl)super.clone();
            cloned.setAUIDValue(this.auidValue);
            return cloned;
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
            return null;
        }
    }

    @Override
    public final void appendXMLChildren(Node parent) {
        Document document = parent.getOwnerDocument();
        Text idText = document.createTextNode(this.toString());
        parent.appendChild(idText);
    }

    @Override
    public byte[] getUniversalLabel() {
        return AUIDImpl.swapIDBytes((byte[])this.auidValue.clone());
    }

    @Override
    public String getComment() {
        return null;
    }

    @Override
    public int compareTo(AUID o) {
        if (this.getData1() < o.getData1()) {
            return -1;
        }
        if (this.getData1() > o.getData1()) {
            return 1;
        }
        if (this.getData2() < o.getData2()) {
            return -1;
        }
        if (this.getData2() > o.getData2()) {
            return 1;
        }
        if (this.getData3() < o.getData3()) {
            return -1;
        }
        if (this.getData3() > o.getData3()) {
            return 1;
        }
        byte[] localBytes = this.getData4();
        byte[] comparisonBytes = o.getData4();
        for (int u = 0; u < 8; ++u) {
            if (localBytes[u] < comparisonBytes[u]) {
                return -1;
            }
            if (localBytes[u] <= comparisonBytes[u]) continue;
            return 1;
        }
        return 0;
    }

    public static final AUID createFromBuffer(ByteBuffer buffer) throws NullPointerException, EndOfDataException {
        if (buffer == null) {
            throw new NullPointerException("Cannot read an AUID value from a null buffer.");
        }
        if (buffer.remaining() < 16) {
            throw new EndOfDataException("Not enough bytes remaining in the given buffer to read an AUID value.");
        }
        if (buffer.order() == ByteOrder.LITTLE_ENDIAN) {
            int data1 = buffer.getInt();
            short data2 = buffer.getShort();
            short data3 = buffer.getShort();
            byte[] data4 = new byte[8];
            buffer.get(data4);
            return new AUIDImpl(data1, data2, data3, data4);
        }
        byte[] keyBytes = new byte[16];
        buffer.get(keyBytes);
        return new AUIDImpl(keyBytes);
    }

    public static final long lengthAsBuffer(AUID value) {
        return 16L;
    }

    public static final void writeToBuffer(AUID value, ByteBuffer buffer) throws NullPointerException, InsufficientSpaceException {
        if (value == null) {
            throw new NullPointerException("Cannot write a null AUID value to a buffer.");
        }
        if (buffer == null) {
            throw new NullPointerException("Cannot write an AUID value to a null buffer.");
        }
        if (buffer.remaining() < 16) {
            throw new InsufficientSpaceException("Insufficient space is available to write a 16 byte value to the given buffer.");
        }
        if (value.isUniversalLabel()) {
            buffer.put(((UL)value).getUniversalLabel());
        } else {
            buffer.put(value.getAUIDValue());
        }
    }

    public static final void writeToStructuredStorageBuffer(AUID value, ByteBuffer buffer) throws NullPointerException, InsufficientSpaceException {
        if (value == null) {
            throw new NullPointerException("Cannot write a null AUID value to a buffer.");
        }
        if (buffer == null) {
            throw new NullPointerException("Cannot write an AUID value to a null buffer.");
        }
        if (buffer.remaining() < 16) {
            throw new InsufficientSpaceException("Insufficient space is available to write a 16 byte value to the given buffer.");
        }
        buffer.put(value.getAUIDValue());
    }

    public static final void generateEmbeddableORM(Node parent, String namespace, String prefix) {
        Element embeddable = XMLBuilder.createChild(parent, namespace, prefix, "embeddable");
        XMLBuilder.setAttribute(embeddable, namespace, prefix, "class", AUIDImpl.class.getCanonicalName());
        XMLBuilder.setAttribute(embeddable, namespace, prefix, "access", "FIELD");
        Element embeddableAttributes = XMLBuilder.createChild(embeddable, namespace, prefix, "attributes");
        Element basic = XMLBuilder.createChild(embeddableAttributes, namespace, prefix, "basic");
        XMLBuilder.setAttribute(basic, namespace, prefix, "name", "auidValue");
    }

    public static final void generateEmbeddedORM(Node parent, String ownerName, String namespace, String prefix) {
        Element embedded = XMLBuilder.createChild(parent, namespace, prefix, "embedded");
        XMLBuilder.setAttribute(embedded, namespace, prefix, "name", Utilities.lowerFirstLetter(ownerName));
        Element attributeOverride = XMLBuilder.createChild(embedded, namespace, prefix, "attribute-override");
        XMLBuilder.setAttribute(attributeOverride, namespace, prefix, "name", "auidValue");
        Element column = XMLBuilder.createChild(attributeOverride, namespace, prefix, "column");
        XMLBuilder.setAttribute(column, namespace, prefix, "name", ownerName);
    }

    public static final String toPersistentForm(AUID auid) {
        if (auid == null) {
            return null;
        }
        byte[] auidValue = auid.getAUIDValue();
        char[] persistUUID = (char[])persistTemplate.clone();
        persistUUID[0] = bigHexCharMap[auidValue[0] >>> 4 & 0xF];
        persistUUID[1] = bigHexCharMap[auidValue[0] & 0xF];
        persistUUID[2] = bigHexCharMap[auidValue[1] >>> 4 & 0xF];
        persistUUID[3] = bigHexCharMap[auidValue[1] & 0xF];
        persistUUID[4] = bigHexCharMap[auidValue[2] >>> 4 & 0xF];
        persistUUID[5] = bigHexCharMap[auidValue[2] & 0xF];
        persistUUID[6] = bigHexCharMap[auidValue[3] >>> 4 & 0xF];
        persistUUID[7] = bigHexCharMap[auidValue[3] & 0xF];
        persistUUID[9] = bigHexCharMap[auidValue[4] >>> 4 & 0xF];
        persistUUID[10] = bigHexCharMap[auidValue[4] & 0xF];
        persistUUID[11] = bigHexCharMap[auidValue[5] >>> 4 & 0xF];
        persistUUID[12] = bigHexCharMap[auidValue[5] & 0xF];
        persistUUID[14] = bigHexCharMap[auidValue[6] >>> 4 & 0xF];
        persistUUID[15] = bigHexCharMap[auidValue[6] & 0xF];
        persistUUID[16] = bigHexCharMap[auidValue[7] >>> 4 & 0xF];
        persistUUID[17] = bigHexCharMap[auidValue[7] & 0xF];
        persistUUID[19] = bigHexCharMap[auidValue[8] >>> 4 & 0xF];
        persistUUID[20] = bigHexCharMap[auidValue[8] & 0xF];
        persistUUID[21] = bigHexCharMap[auidValue[9] >>> 4 & 0xF];
        persistUUID[22] = bigHexCharMap[auidValue[9] & 0xF];
        persistUUID[24] = bigHexCharMap[auidValue[10] >>> 4 & 0xF];
        persistUUID[25] = bigHexCharMap[auidValue[10] & 0xF];
        persistUUID[26] = bigHexCharMap[auidValue[11] >>> 4 & 0xF];
        persistUUID[27] = bigHexCharMap[auidValue[11] & 0xF];
        persistUUID[28] = bigHexCharMap[auidValue[12] >>> 4 & 0xF];
        persistUUID[29] = bigHexCharMap[auidValue[12] & 0xF];
        persistUUID[30] = bigHexCharMap[auidValue[13] >>> 4 & 0xF];
        persistUUID[31] = bigHexCharMap[auidValue[13] & 0xF];
        persistUUID[32] = bigHexCharMap[auidValue[14] >>> 4 & 0xF];
        persistUUID[33] = bigHexCharMap[auidValue[14] & 0xF];
        persistUUID[34] = bigHexCharMap[auidValue[15] >>> 4 & 0xF];
        persistUUID[35] = bigHexCharMap[auidValue[15] & 0xF];
        return new String(persistUUID);
    }

    public static final AUID fromPersistentForm(String persistentForm) {
        if (persistentForm == null) {
            return null;
        }
        byte[] auid = new byte[16];
        char[] urn = persistentForm.toCharArray();
        auid[0] = Utilities.twoCharsToByte(urn[0], urn[1]);
        auid[1] = Utilities.twoCharsToByte(urn[2], urn[3]);
        auid[2] = Utilities.twoCharsToByte(urn[4], urn[5]);
        auid[3] = Utilities.twoCharsToByte(urn[6], urn[7]);
        auid[4] = Utilities.twoCharsToByte(urn[9], urn[10]);
        auid[5] = Utilities.twoCharsToByte(urn[11], urn[12]);
        auid[6] = Utilities.twoCharsToByte(urn[14], urn[15]);
        auid[7] = Utilities.twoCharsToByte(urn[16], urn[17]);
        auid[8] = Utilities.twoCharsToByte(urn[19], urn[20]);
        auid[9] = Utilities.twoCharsToByte(urn[21], urn[22]);
        auid[10] = Utilities.twoCharsToByte(urn[24], urn[25]);
        auid[11] = Utilities.twoCharsToByte(urn[26], urn[27]);
        auid[12] = Utilities.twoCharsToByte(urn[28], urn[29]);
        auid[13] = Utilities.twoCharsToByte(urn[30], urn[31]);
        auid[14] = Utilities.twoCharsToByte(urn[32], urn[33]);
        auid[15] = Utilities.twoCharsToByte(urn[34], urn[35]);
        return new AUIDImpl(auid);
    }
}

