/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import tv.amwa.maj.exception.EndOfDataException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.Stream;
import tv.amwa.maj.integer.Int32;
import tv.amwa.maj.integer.UInt16;
import tv.amwa.maj.integer.UInt32;
import tv.amwa.maj.model.ContainerDefinition;
import tv.amwa.maj.model.WAVEPCMDescriptor;
import tv.amwa.maj.model.impl.SoundDescriptorImpl;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.Rational;
import tv.amwa.maj.record.TimeStamp;
import tv.amwa.maj.record.impl.AUIDImpl;
import tv.amwa.maj.record.impl.TimeStampImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=18432, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="WAVEPCMDescriptor", aliases={"PCMDescritpor"}, description="The WAVEPCMDescriptor class specifies that a File SourcePackage is associated with audio essence formatted according to the BWF File Format.", symbol="WAVEPCMDescriptor")
public class WAVEPCMDescriptorImpl
extends SoundDescriptorImpl
implements WAVEPCMDescriptor,
tv.amwa.maj.extensions.avid.WAVEPCMDescriptor,
Serializable,
Cloneable {
    private static final long serialVersionUID = -7505177867499530833L;
    private short blockAlign;
    private Byte sequenceOffset = null;
    private int averageBytesPerSecond;
    private AUID channelAssignment = null;
    private Integer peakEnvelopeVersion = null;
    private Integer peakEnvelopeFormat = null;
    private Integer pointsPerPeakValue = null;
    private Integer peakEnvelopeBlockSize = null;
    private Integer peakChannels = null;
    private Integer peakFrames = null;
    private Long peakOfPeaksPosition = null;
    private TimeStamp peakEnvelopeTimestamp = null;
    private Stream peakEnvelopeData = null;
    @Int32
    private Integer dataOffset = null;

    public WAVEPCMDescriptorImpl() {
    }

    public WAVEPCMDescriptorImpl(ContainerDefinition containerFormat, Rational audioSamplingRate, @UInt32 int channels, @UInt32 int quantizationBits, @UInt16 short blockAlign, @UInt32 int averageBPS) throws NullPointerException, IllegalArgumentException {
        super(containerFormat, audioSamplingRate, channels, quantizationBits);
        if (blockAlign < 0) {
            throw new IllegalArgumentException("Cannot create a new PCM descriptor with a negative block align value.");
        }
        if (averageBPS < 0) {
            throw new IllegalArgumentException("Cannot create a new PCM descriptor with a negative average bits per second value.");
        }
        this.setBlockAlign(blockAlign);
        this.setAverageBytesPerSecond(averageBPS);
    }

    @Override
    public boolean areAllPeakEnvelopePropertiesPresent() {
        return this.peakEnvelopeVersion != null && this.peakEnvelopeFormat != null && this.pointsPerPeakValue != null && this.peakEnvelopeBlockSize != null && this.peakChannels != null && this.peakFrames != null && this.peakOfPeaksPosition != null && this.peakEnvelopeTimestamp != null && this.peakEnvelopeData != null;
    }

    @Override
    @MediaProperty(uuid1=67240707, uuid2=1280, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="AverageBytesPerSecond", aliases={"AverageBPS"}, typeName="UInt32", optional=false, uniqueIdentifier=false, pid=15625, symbol="AverageBytesPerSecond")
    public int getAverageBytesPerSecond() {
        return this.averageBytesPerSecond;
    }

    @Override
    @MediaPropertySetter(value="AverageBytesPerSecond")
    public void setAverageBytesPerSecond(int bps) throws IllegalArgumentException {
        if (bps < 0) {
            throw new IllegalArgumentException("Cannot set the average bits per second value to a negative value for this PCM descriptor.");
        }
        this.averageBytesPerSecond = bps;
    }

    public static final int initializeAverageBytesPerSecond() {
        return 1;
    }

    @Override
    @MediaProperty(uuid1=67240706, uuid2=256, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="BlockAlign", typeName="UInt16", optional=false, uniqueIdentifier=false, pid=15626, symbol="BlockAlign")
    public short getBlockAlign() {
        return this.blockAlign;
    }

    @Override
    @MediaPropertySetter(value="BlockAlign")
    public void setBlockAlign(short blockAlign) throws IllegalArgumentException {
        if (blockAlign < 0) {
            throw new IllegalArgumentException("Cannot set the block alignment for this PCM descriptor to a negative value.");
        }
        this.blockAlign = blockAlign;
    }

    public static final short initializeBlockAlign() {
        return 0;
    }

    @Override
    @MediaProperty(uuid1=67240193, uuid2=1280, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 7}, definedName="ChannelAssignment", typeName="AUID", optional=true, uniqueIdentifier=false, pid=15666, symbol="ChannelAssignment")
    public AUID getChannelAssignment() throws PropertyNotPresentException {
        if (this.channelAssignment == null) {
            throw new PropertyNotPresentException("The optional channel assignment property is not present in this PCM descriptor.");
        }
        return this.channelAssignment.clone();
    }

    @Override
    @MediaPropertySetter(value="ChannelAssignment")
    public void setChannelAssignment(AUID channelAssignment) {
        if (channelAssignment == null) {
            this.channelAssignment = null;
            return;
        }
        this.channelAssignment = channelAssignment.clone();
    }

    @Override
    @MediaProperty(uuid1=67240705, uuid2=2560, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 8}, definedName="PeakChannels", typeName="UInt32", optional=true, uniqueIdentifier=false, pid=15661, symbol="PeakChannels")
    public int getPeakChannelCount() throws PropertyNotPresentException {
        if (this.peakChannels == null) {
            throw new PropertyNotPresentException("The optional peak channel count property is not present in this PCM descriptor.");
        }
        return this.peakChannels;
    }

    @Override
    @MediaPropertySetter(value="PeakChannels")
    public void setPeakChannelCount(Integer channelCount) throws IllegalArgumentException {
        if (channelCount == null) {
            this.peakChannels = null;
            return;
        }
        if (channelCount < 0) {
            throw new IllegalArgumentException("Cannot set the peak channels property of a PCM descriptor to a negative value.");
        }
        this.peakChannels = channelCount;
    }

    @Override
    @MediaProperty(uuid1=67240705, uuid2=2304, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 8}, definedName="PeakEnvelopeBlockSize", typeName="UInt32", optional=true, uniqueIdentifier=false, pid=15660, symbol="PeakEnvelopeBlockSize")
    public int getPeakEnvelopeBlockSize() throws PropertyNotPresentException {
        if (this.peakEnvelopeBlockSize == null) {
            throw new PropertyNotPresentException("The optional peak envelope block size property is not present in this PCM descriptor.");
        }
        return this.peakEnvelopeBlockSize;
    }

    @Override
    @MediaPropertySetter(value="PeakEnvelopeBlockSize")
    public void setPeakEnvelopeBlockSize(Integer blockSize) throws IllegalArgumentException {
        if (blockSize == null) {
            this.peakEnvelopeBlockSize = null;
            return;
        }
        if (blockSize < 0) {
            throw new IllegalArgumentException("Cannot set the peak envelope box size of this PCM descriptor to a negative value.");
        }
        this.peakEnvelopeBlockSize = blockSize;
    }

    @Override
    public long getPeakEnvelopeDataPosition() throws PropertyNotPresentException, IOException {
        if (this.peakEnvelopeData == null) {
            throw new PropertyNotPresentException("The optional peak envelope data property is not present for this WAVE PCM descriptor.");
        }
        return this.peakEnvelopeData.getPosition();
    }

    @Override
    public void setPeakEnvelopeDataPosition(long position) throws PropertyNotPresentException, IllegalArgumentException, IOException {
        if (this.peakEnvelopeData == null) {
            throw new PropertyNotPresentException("The optional peak envelope data property is not present for this WAVE PCM descriptor.");
        }
        this.peakEnvelopeData.setPosition(position);
    }

    @Override
    public long getPeakEnvelopeDataSize() throws PropertyNotPresentException, IOException {
        if (this.peakEnvelopeData == null) {
            throw new PropertyNotPresentException("The optional peak envelope data property is not present in this PCM descriptor.");
        }
        return this.peakEnvelopeData.getLength();
    }

    @Override
    @MediaProperty(uuid1=67240705, uuid2=1792, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 8}, definedName="PeakEnvelopeFormat", typeName="UInt32", optional=true, uniqueIdentifier=false, pid=15658, symbol="PeakEnvelopeFormat")
    public int getPeakEnvelopeFormat() throws PropertyNotPresentException {
        if (this.peakEnvelopeFormat == null) {
            throw new PropertyNotPresentException("The optional peak envelope format is not present in this PCM descriptor.");
        }
        return this.peakEnvelopeFormat;
    }

    @Override
    @MediaPropertySetter(value="PeakEnvelopeFormat")
    public void setPeakEnvelopeFormat(Integer format) throws IllegalArgumentException {
        if (format == null) {
            this.peakEnvelopeFormat = null;
            return;
        }
        if (format < 0) {
            throw new IllegalArgumentException("Cannot set the peak envelope format property of this PCM descriptor to a negative value.");
        }
        this.peakEnvelopeFormat = format;
    }

    @Override
    @MediaProperty(uuid1=67240705, uuid2=3328, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 8}, definedName="PeakEnvelopeTimestamp", typeName="TimeStamp", optional=true, uniqueIdentifier=false, pid=15664, symbol="PeakEnvelopeTimestamp")
    public TimeStamp getPeakEnvelopeTimestamp() throws PropertyNotPresentException {
        if (this.peakEnvelopeTimestamp == null) {
            throw new PropertyNotPresentException("The optional peak envelope timestamp property is not present in this PCM descritpor.");
        }
        return this.peakEnvelopeTimestamp.clone();
    }

    @Override
    @MediaPropertySetter(value="PeakEnvelopeTimestamp")
    public void setPeakEnvelopeTimestamp(TimeStamp timeStamp) {
        if (timeStamp == null) {
            this.peakEnvelopeTimestamp = null;
            return;
        }
        this.peakEnvelopeTimestamp = timeStamp.clone();
    }

    @Override
    @MediaProperty(uuid1=67240705, uuid2=1536, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 8}, definedName="PeakEnvelopeVersion", typeName="UInt32", optional=true, uniqueIdentifier=false, pid=15657, symbol="PeakEnvelopeVersion")
    public int getPeakEnvelopeVersion() throws PropertyNotPresentException {
        if (this.peakEnvelopeVersion == null) {
            throw new PropertyNotPresentException("The optional peak envelope version property is not present in this PCM descriptor.");
        }
        return this.peakEnvelopeVersion;
    }

    @Override
    @MediaPropertySetter(value="PeakEnvelopeVersion")
    public void setPeakEnvelopeVersion(Integer version) throws IllegalArgumentException {
        if (version == null) {
            this.peakEnvelopeVersion = null;
            return;
        }
        if (version < 0) {
            throw new IllegalArgumentException("Cannot set the peak envelope version property of this PCM descriptor to a negative value.");
        }
        this.peakEnvelopeVersion = version;
    }

    @Override
    @MediaProperty(uuid1=67240705, uuid2=2816, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 8}, definedName="PeakFrames", typeName="UInt32", optional=true, uniqueIdentifier=false, pid=15662, symbol="PeakFrames")
    public int getPeakFrameCount() throws PropertyNotPresentException {
        if (this.peakFrames == null) {
            throw new PropertyNotPresentException("The optional peak frames property is not present in this PCM descriptor.");
        }
        return this.peakFrames;
    }

    @Override
    @MediaPropertySetter(value="PeakFrames")
    public void setPeakFrameCount(Integer frameCount) throws IllegalArgumentException {
        if (frameCount == null) {
            this.peakFrames = null;
            return;
        }
        if (frameCount < 0) {
            throw new IllegalArgumentException("Cannot set the peak frames count property of this PCM descriptor to a negative value.");
        }
        this.peakFrames = frameCount;
    }

    @Override
    @MediaProperty(uuid1=67240705, uuid2=3072, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 8}, definedName="PeakOfPeaksPosition", typeName="PositionType", optional=true, uniqueIdentifier=false, pid=15663, symbol="PeakOfPeaksPosition")
    public long getPeakOfPeaksPosition() throws PropertyNotPresentException {
        if (this.peakOfPeaksPosition == null) {
            throw new PropertyNotPresentException("The optional peak of peaks position property is not present in this PCM descriptor.");
        }
        return this.peakOfPeaksPosition;
    }

    @Override
    @MediaPropertySetter(value="PeakOfPeaksPosition")
    public void setPeakOfPeaksPosition(Long position) {
        this.peakOfPeaksPosition = position;
    }

    @Override
    @MediaProperty(uuid1=67240705, uuid2=2048, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 8}, definedName="PointsPerPeakValue", typeName="UInt32", optional=true, uniqueIdentifier=false, pid=15659, symbol="PointsPerPeakValue")
    public int getPointsPerPeakValue() throws PropertyNotPresentException {
        if (this.pointsPerPeakValue == null) {
            throw new PropertyNotPresentException("The optional points per peak property is not present in this PCM descriptor.");
        }
        return this.pointsPerPeakValue;
    }

    @Override
    @MediaPropertySetter(value="PointsPerPeakValue")
    public void setPointsPerPeakValue(Integer pointCount) throws IllegalArgumentException {
        if (pointCount == null) {
            this.pointsPerPeakValue = null;
            return;
        }
        if (pointCount < 0) {
            throw new IllegalArgumentException("Cannot set the points per peak property of this PCM descriptor to a negative value.");
        }
        this.pointsPerPeakValue = pointCount;
    }

    @Override
    @MediaProperty(uuid1=67240706, uuid2=512, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 5}, definedName="SequenceOffset", typeName="UInt8", optional=true, uniqueIdentifier=false, pid=15627, symbol="SequenceOffset")
    public byte getSequenceOffset() throws PropertyNotPresentException {
        if (this.sequenceOffset == null) {
            throw new PropertyNotPresentException("The optional sequence offset property is not present in this PCM descritpor.");
        }
        return this.sequenceOffset;
    }

    @Override
    @MediaPropertySetter(value="SequenceOffset")
    public void setSequenceOffset(Byte offset) throws IllegalArgumentException {
        if (offset == null) {
            this.sequenceOffset = null;
            return;
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Cannot set the sequence offset of this PCM descriptor to a negative value.");
        }
        this.sequenceOffset = offset;
    }

    @Override
    @MediaProperty(uuid1=67240705, uuid2=3584, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 8}, definedName="PeakEnvelopeData", typeName="Stream", optional=true, uniqueIdentifier=false, pid=15665, symbol="PeakEnvelopeData")
    public Stream getPeakEnvelopeData() throws PropertyNotPresentException {
        if (this.peakEnvelopeData == null) {
            throw new PropertyNotPresentException("The optional peak envelope data property is not present in this PCM descriptor.");
        }
        return this.peakEnvelopeData.clone();
    }

    @Override
    @MediaPropertySetter(value="PeakEnvelopeData")
    public void setPeakEnvelopeData(Stream peakEnvelopeData) {
        this.peakEnvelopeData = peakEnvelopeData == null ? null : peakEnvelopeData.clone();
    }

    @Override
    public ByteBuffer readPeakEnvelopeData(int bytes) throws EndOfDataException, PropertyNotPresentException, IOException {
        if (this.peakEnvelopeData == null) {
            throw new PropertyNotPresentException("The optional peak envelope data property is not present for this WAVE PCM descriptor.");
        }
        return this.peakEnvelopeData.read(bytes);
    }

    @Override
    public int writePeakEnvelopeData(ByteBuffer bytes) throws PropertyNotPresentException, EndOfDataException, IOException {
        if (this.peakEnvelopeData == null) {
            throw new PropertyNotPresentException("The optional peak envelope data property is not present for this WAVE PCM descriptor.");
        }
        return this.peakEnvelopeData.write(bytes);
    }

    @Override
    public WAVEPCMDescriptor clone() {
        return (WAVEPCMDescriptor)super.clone();
    }

    @Override
    @MediaProperty(uuid1=-1153455139, uuid2=-832, uuid3=17320, uuid4={-105, 89, -57, 39, 119, 31, -52, 74}, definedName="DataOffset", typeName="Int32", optional=true, uniqueIdentifier=false, pid=0, symbol="DataOffset2", namespace="http://www.amwa.tv/is03/extensions/avid", prefix="avid")
    @Int32
    public int getDataOffset() throws PropertyNotPresentException {
        if (this.dataOffset == null) {
            throw new NullPointerException("The optional data offset property is not present for this WAVE PCM descriptor.");
        }
        return this.dataOffset;
    }

    @Override
    @MediaPropertySetter(value="DataOffset")
    public void setDataOffset(@Int32 Integer dataOffset) {
        this.dataOffset = dataOffset;
    }

    public String getChannelAssignmentString() {
        return AUIDImpl.toPersistentForm(this.channelAssignment);
    }

    public void setChannelAssignmentString(String channelAssignment) {
        this.channelAssignment = AUIDImpl.fromPersistentForm(channelAssignment);
    }

    public String getPeakEnvelopeTimestampString() {
        return TimeStampImpl.toPersistentForm(this.peakEnvelopeTimestamp);
    }

    public void setPeakEnvelopeTimestampString(String peakEnvelopeTimestampString) {
        this.peakEnvelopeTimestamp = TimeStampImpl.fromPersistentForm(peakEnvelopeTimestampString);
    }
}

