/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.Serializable;
import java.nio.ByteBuffer;
import tv.amwa.maj.enumeration.TCSource;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.Stream;
import tv.amwa.maj.misctype.DataBuffer;
import tv.amwa.maj.model.TimecodeStream12M;
import tv.amwa.maj.model.impl.DataDefinitionImpl;
import tv.amwa.maj.model.impl.TimecodeStreamImpl;
import tv.amwa.maj.record.Rational;
import tv.amwa.maj.record.TimecodeValue;
import tv.amwa.maj.record.impl.TimecodeValueImpl;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=5632, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="TimecodeStream12M", description="The TimecodeStream12M class specifies a stream of timecode data in the SMPTE 12M format.", symbol="TimecodeStream12M")
public class TimecodeStream12MImpl
extends TimecodeStreamImpl
implements TimecodeStream12M,
Serializable,
Cloneable {
    private static final long serialVersionUID = 3370849531070799041L;
    private static final int streamSampleSize = 10;
    private static final int userDataSize = 4;
    private static final int bits0_7 = 0;
    private static final int bits8_15 = 1;
    private static final int bits16_23 = 2;
    private static final int bits24_31 = 3;
    private static final int bits32_39 = 4;
    private static final int bits40_47 = 5;
    private static final int bits48_55 = 6;
    private static final int bits56_63 = 7;
    private static final int bits64_71 = 8;
    private static final int bits72_79 = 9;
    private Boolean includeSync = null;

    public TimecodeStream12MImpl() {
    }

    public TimecodeStream12MImpl(Rational sampleRate, @DataBuffer Stream source, TCSource sourceType) throws NullPointerException, IllegalArgumentException {
        this.setComponentDataDefinition(DataDefinitionImpl.forIdentification(DataDefinitionImpl.Timecode));
        if (sampleRate == null) {
            throw new NullPointerException("Cannot set the sample rate for the 12M-compliant timecode stream using a null value.");
        }
        if (source == null) {
            throw new NullPointerException("Cannot set the source for this 12M-compliant timecode stream using a null value.");
        }
        if (sourceType == null) {
            throw new NullPointerException("Cannot set the source type for this 12M-compliant timecode stream using a null value.");
        }
        this.setTimecodeStreamSampleRate(sampleRate);
        this.setTimecodeStreamData(source);
        this.setTimecodeSource(sourceType);
    }

    @Override
    @MediaProperty(uuid1=0x4040101, uuid2=1024, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 1}, definedName="IncludeSync", typeName="Boolean", optional=false, uniqueIdentifier=false, pid=5889, symbol="IncludeSync")
    public boolean getIncludeSync() {
        if (!this.includeSync.booleanValue()) {
            return false;
        }
        return this.includeSync;
    }

    @Override
    @MediaPropertySetter(value="IncludeSync")
    public void setIncludeSync(Boolean includeSync) {
        this.includeSync = includeSync;
    }

    public static final boolean initializeIncludeSync() {
        return false;
    }

    @Override
    public int getSampleSize() {
        return 10;
    }

    @Override
    public int getUserDataLength() {
        return 4;
    }

    @Override
    public ByteBuffer packTimecode(TimecodeValue timecode, ByteBuffer packedBuffer) throws NullPointerException, IllegalArgumentException {
        if (timecode == null) {
            throw new NullPointerException("Cannot pack a null timecode value into a 12M-compliant timecode sample.");
        }
        if (packedBuffer == null) {
            throw new NullPointerException("Cannot pack a timecode value into a null timecode sample.");
        }
        byte[] packedBytes = packedBuffer.array();
        if (packedBytes.length != 10) {
            throw new IllegalArgumentException("The given timecode sample buffer is the wrong length (10) for a 12M-compliant timecode stream.");
        }
        byte[] withAddedBits = (byte[])packedBytes.clone();
        TimecodeValueImpl.TimeComponents timeComponents = new TimecodeValueImpl(timecode.getDropFrame(), timecode.getStartTimecode(), timecode.getFramesPerSecond()).convertToActualTimeValues();
        withAddedBits[0] = (byte)(packedBytes[0] & 0xF0 | timeComponents.frameInSecond % 10 << 4 & 0xF0);
        withAddedBits[1] = (byte)(packedBytes[1] & 0x3F | timeComponents.frameInSecond / 10 << 6 & 0xC0);
        withAddedBits[2] = (byte)(packedBytes[2] & 0xF | timeComponents.seconds % 10 << 4 & 0xF0);
        withAddedBits[3] = (byte)(packedBytes[3] & 0x1F | timeComponents.seconds / 10 << 5 & 0xE0);
        withAddedBits[4] = (byte)(packedBytes[4] & 0xF | timeComponents.minutes % 10 << 4 & 0xF0);
        withAddedBits[5] = (byte)(packedBytes[5] & 0x1F | timeComponents.minutes / 10 << 5 & 0xE0);
        withAddedBits[6] = (byte)((long)(packedBytes[6] & 0xF) | timeComponents.hours % 10L << 4 & 0xF0L);
        withAddedBits[7] = (byte)((long)(packedBytes[7] & 0x3F) | timeComponents.hours / 10L << 6 & 0xC0L);
        withAddedBits[1] = (byte)(packedBytes[1] & 0xDF | (timecode.getDropFrame() ? 32 : 0));
        withAddedBits[8] = 63;
        withAddedBits[9] = -3;
        return ByteBuffer.wrap(withAddedBits);
    }

    @Override
    public ByteBuffer packUserBits(ByteBuffer userBitsBuffer, ByteBuffer packedBuffer) throws NullPointerException, IllegalArgumentException {
        if (userBitsBuffer == null) {
            throw new NullPointerException("Cannot pack user bits into a timecode sample using a null userbits value.");
        }
        if (packedBuffer == null) {
            throw new NullPointerException("Cannot pack user bits into a null timecode sample.");
        }
        byte[] userBits = userBitsBuffer.array();
        byte[] packedBytes = packedBuffer.array();
        if (userBits.length != 4) {
            throw new IllegalArgumentException("The given array of user bits is not of the required length (4) for this 12M-compliant timecode stream.");
        }
        if (packedBytes.length != 10) {
            throw new IllegalArgumentException("The given array of packed bytes is not of the required length (10) for this 12M-compliant timecode stream.");
        }
        byte[] withAddedBits = (byte[])packedBytes.clone();
        withAddedBits[0] = (byte)(packedBytes[0] & 0xF0 | userBits[0] >>> 4 & 0xF);
        withAddedBits[1] = (byte)(packedBytes[1] & 0xF0 | userBits[0] & 0xF);
        withAddedBits[2] = (byte)(packedBytes[2] & 0xF0 | userBits[1] >>> 4 & 0xF);
        withAddedBits[3] = (byte)(packedBytes[3] & 0xF0 | userBits[1] & 0xF);
        withAddedBits[4] = (byte)(packedBytes[4] & 0xF0 | userBits[2] >>> 4 & 0xF);
        withAddedBits[5] = (byte)(packedBytes[5] & 0xF0 | userBits[2] & 0xF);
        withAddedBits[6] = (byte)(packedBytes[6] & 0xF0 | userBits[3] >>> 4 & 0xF);
        withAddedBits[7] = (byte)(packedBytes[7] & 0xF0 | userBits[3] & 0xF);
        withAddedBits[8] = 63;
        withAddedBits[9] = -3;
        return ByteBuffer.wrap(withAddedBits);
    }

    @Override
    public TimecodeValue unpackTimecode(ByteBuffer timecodeBuffer, short fps) throws NullPointerException, IllegalArgumentException {
        if (timecodeBuffer == null) {
            throw new NullPointerException("The given buffer cannot be coverted to a timecode value because it is null.");
        }
        byte[] buffer = timecodeBuffer.array();
        if (buffer.length < 10) {
            throw new IllegalArgumentException("The given buffer cannot be converted to a timecode value because is is too short.");
        }
        if (fps <= 0) {
            throw new IllegalArgumentException("The given timecode value is not a postive number.");
        }
        short hours = (short)((buffer[7] >>> 6 & 3) * 10 + (buffer[6] >>> 4 & 0xF));
        short minutes = (short)((buffer[5] >>> 5 & 7) * 10 + (buffer[4] >>> 4 & 0xF));
        short seconds = (short)((buffer[3] >>> 5 & 7) * 10 + (buffer[2] >>> 4 & 0xF));
        short frames = (short)((buffer[1] >>> 6 & 3) * 10 + (buffer[0] >>> 4 & 0xF));
        boolean drop = (buffer[1] >>> 5 & 1) == 1;
        return new TimecodeValueImpl(fps, hours, minutes, seconds, frames, drop);
    }

    @Override
    public ByteBuffer unpackUserBits(ByteBuffer buffer) throws NullPointerException, IllegalArgumentException {
        if (buffer == null) {
            throw new NullPointerException("Cannot unpack user bits from a null buffer.");
        }
        byte[] localBuffer = buffer.array();
        if (localBuffer.length < 10) {
            throw new IllegalArgumentException("The given buffer is too short to allow user bits to be unpacked.");
        }
        byte[] userBits = new byte[]{(byte)((localBuffer[0] & 0xF) << 4 | localBuffer[1] & 0xF), (byte)((localBuffer[2] & 0xF) << 4 | localBuffer[3] & 0xF), (byte)((localBuffer[4] & 0xF) << 4 | localBuffer[5] & 0xF), (byte)((localBuffer[6] & 0xF) << 4 | localBuffer[7] & 0xF)};
        return ByteBuffer.wrap(userBits);
    }

    @Override
    public TimecodeStream12M clone() {
        return (TimecodeStream12M)super.clone();
    }
}

