/*
 * Decompiled with CFR 0.152.
 */
package tv.amwa.maj.model.impl;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import tv.amwa.maj.exception.IllegalPropertyValueException;
import tv.amwa.maj.exception.InsufficientSpaceException;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.industry.MediaClass;
import tv.amwa.maj.industry.MediaListAppend;
import tv.amwa.maj.industry.MediaListGetAt;
import tv.amwa.maj.industry.MediaListInsertAt;
import tv.amwa.maj.industry.MediaListPrepend;
import tv.amwa.maj.industry.MediaListRemoveAt;
import tv.amwa.maj.industry.MediaProperty;
import tv.amwa.maj.industry.MediaPropertyClear;
import tv.amwa.maj.industry.MediaPropertyCount;
import tv.amwa.maj.industry.MediaPropertySetter;
import tv.amwa.maj.industry.PropertyValue;
import tv.amwa.maj.industry.StrongReferenceVector;
import tv.amwa.maj.industry.TypeDefinitions;
import tv.amwa.maj.industry.Warehouse;
import tv.amwa.maj.integer.UInt32;
import tv.amwa.maj.meta.TypeDefinition;
import tv.amwa.maj.misctype.AAFString;
import tv.amwa.maj.model.InterchangeObject;
import tv.amwa.maj.model.TaggedValue;
import tv.amwa.maj.model.impl.InterchangeObjectImpl;
import tv.amwa.maj.record.AUID;

@MediaClass(uuid1=0xD010101, uuid2=257, uuid3=16128, uuid4={6, 14, 43, 52, 2, 6, 1, 1}, definedName="TaggedValue", description="The TaggedValue class specifies a user-defined tag and value.", symbol="TaggedValue")
public class TaggedValueImpl
extends InterchangeObjectImpl
implements TaggedValue,
tv.amwa.maj.extensions.avid.TaggedValue,
Serializable,
Cloneable {
    private static final long serialVersionUID = -3605581441449580470L;
    private String tag;
    private AUID typeDefinition;
    private Serializable value;
    private List<TaggedValue> taggedValueAttributeList = Collections.synchronizedList(new Vector());
    @UInt32
    private Integer portableObjectClassID = null;
    private InterchangeObject portableObject = null;

    public TaggedValueImpl() {
    }

    public TaggedValueImpl(@AAFString String name, TypeDefinition typeDefinition, Serializable value) throws NullPointerException, ClassCastException {
        if (name == null) {
            throw new NullPointerException("Cannot create a new tagged value with a null name.");
        }
        if (typeDefinition == null) {
            throw new NullPointerException("Cannot create a new tagged value with a null type definition.");
        }
        if (value == null) {
            throw new NullPointerException("Cannot create a new tagged value with a null value instead of a byte array.");
        }
        this.setTag(name);
        this.setTypeDefinition(typeDefinition);
        typeDefinition.createValue(value);
        this.value = value;
    }

    public TaggedValueImpl(@AAFString String tag, PropertyValue indirectValue) throws NullPointerException {
        if (tag == null) {
            throw new NullPointerException("Cannot create a new tagged value with a null tag name.");
        }
        if (indirectValue == null) {
            throw new NullPointerException("Cannot create a new tagged value with a null indirect value.");
        }
        if (indirectValue.getType() == null) {
            throw new NullPointerException("Cannot create a new tagged value with a property value of null type.");
        }
        this.setTag(tag);
        this.setIndirectValue(indirectValue);
    }

    @Override
    public TypeDefinition getIndirectTypeDefinition() {
        return Warehouse.lookForType(this.typeDefinition);
    }

    void setTypeDefinition(TypeDefinition indirectType) throws NullPointerException {
        if (indirectType == null) {
            throw new NullPointerException("Cannot set the type definition for an indirect type value to null.");
        }
        this.typeDefinition = indirectType.getAUID().clone();
    }

    @Override
    @MediaProperty(uuid1=50462978, uuid2=2305, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="Tag", aliases={"Name", "TaggedValueName"}, typeName="UTF16String", optional=false, uniqueIdentifier=false, pid=20481, symbol="Tag")
    public String getTag() {
        return this.tag;
    }

    @MediaPropertySetter(value="Tag")
    public void setTag(String tag) throws NullPointerException {
        if (tag == null) {
            throw new NullPointerException("Cannot set the tag name of a tagged value with a null value.");
        }
        this.tag = tag;
    }

    public static final String initializeTag() {
        return "DeafaultTag";
    }

    @Override
    @MediaProperty(uuid1=50462978, uuid2=2561, uuid3=0, uuid4={6, 14, 43, 52, 1, 1, 1, 2}, definedName="IndirectValue", aliases={"Value", "TaggedValueValue"}, typeName="Indirect", optional=false, uniqueIdentifier=false, pid=20483, symbol="IndirectValue")
    public PropertyValue getIndirectValue() {
        return Warehouse.lookForType(this.typeDefinition).createValue(this.value);
    }

    @Override
    @MediaPropertySetter(value="IndirectValue")
    public void setIndirectValue(PropertyValue indirectValue) throws NullPointerException {
        if (indirectValue == null) {
            throw new NullPointerException("Cannot set the value of this tagged value with a null indirect value.");
        }
        if (indirectValue.getType().equals(TypeDefinitions.Indirect)) {
            indirectValue = (PropertyValue)indirectValue.getValue();
        }
        this.typeDefinition = indirectValue.getType().getAUID();
        this.value = (Serializable)indirectValue.getValue();
    }

    public static final PropertyValue initializeIndirectValue() {
        return TypeDefinitions.Int32.createValue(0);
    }

    @Override
    public TaggedValue clone() {
        return (TaggedValue)super.clone();
    }

    @MediaProperty(uuid1=1620410757, uuid2=18353, uuid3=4564, uuid4={-96, 28, 0, 4, -84, -106, -97, 80}, definedName="TaggedValueAttributeList", typeName="TaggedValueStrongReferenceVector", optional=true, uniqueIdentifier=false, pid=0, symbol="TaggedValueAttributeList", namespace="http://www.amwa.tv/is03/extensions/avid", prefix="avid")
    public List<TaggedValue> getTaggedValueAttributeList() throws PropertyNotPresentException {
        if (this.taggedValueAttributeList.size() == 0) {
            throw new PropertyNotPresentException("The optional tagged value attribute list is not present for this tagged value.");
        }
        return StrongReferenceVector.getOptionalList(this.taggedValueAttributeList);
    }

    @Override
    @MediaListAppend(value="TaggedValueAttributeList")
    public void appendTaggedValueAttributeItem(TaggedValue taggedValueAttributeItem) throws NullPointerException {
        if (taggedValueAttributeItem == null) {
            throw new NullPointerException("Cannot append to the mob attribute list of this package using a null value.");
        }
        StrongReferenceVector.append(this.taggedValueAttributeList, taggedValueAttributeItem);
    }

    @Override
    @MediaListPrepend(value="TaggedValueAttributeList")
    public void prependTaggedValueAttributeItem(TaggedValue taggedValueAttributeItem) throws NullPointerException {
        if (taggedValueAttributeItem == null) {
            throw new NullPointerException("Cannot prepend to the mob attribute list of this package using a null value.");
        }
        StrongReferenceVector.prepend(this.taggedValueAttributeList, taggedValueAttributeItem);
    }

    @Override
    @MediaListInsertAt(value="TaggedValueAttributeList")
    public void insertTaggedValueAttributeItem(int index, TaggedValue taggedValueAttributeItem) throws NullPointerException, IndexOutOfBoundsException {
        if (taggedValueAttributeItem == null) {
            throw new NullPointerException("Cannot insert into the mob attribute list of this package using a null value.");
        }
        StrongReferenceVector.insert(this.taggedValueAttributeList, index, taggedValueAttributeItem);
    }

    @Override
    @MediaPropertyCount(value="TaggedValueAttributeList")
    public int countTaggedValueAttributeList() {
        return this.taggedValueAttributeList.size();
    }

    @Override
    @MediaPropertyClear(value="TaggedValueAttributeList")
    public void clearTaggedValueAttributeList() {
        this.taggedValueAttributeList.clear();
    }

    @Override
    @MediaListGetAt(value="TaggedValueAttributeList")
    public TaggedValue getTaggedValueAttributeItemAt(int index) throws IndexOutOfBoundsException {
        return StrongReferenceVector.getAt(this.taggedValueAttributeList, index);
    }

    @Override
    @MediaListRemoveAt(value="TaggedValueAttributeList")
    public void removeTaggedValueAttributeItemAt(int index) throws IndexOutOfBoundsException {
        StrongReferenceVector.remove(this.taggedValueAttributeList, index);
    }

    @Override
    @UInt32
    public int getPortableObjectClassID() throws PropertyNotPresentException {
        if (this.portableObjectClassID == null) {
            throw new PropertyNotPresentException("The optional portable object class ID property is not present for this tagged value.");
        }
        return this.portableObjectClassID;
    }

    @Override
    public void setPortableObjectClassID(@UInt32 Integer portableObjectClassID) throws IllegalArgumentException {
        if (portableObjectClassID == null) {
            this.portableObjectClassID = null;
            return;
        }
        if (portableObjectClassID < 0) {
            throw new IllegalArgumentException("Cannot set the portable object class ID of this tagged value to a negative value.");
        }
        this.portableObjectClassID = portableObjectClassID;
    }

    @Override
    public InterchangeObject getPortableObject() throws PropertyNotPresentException {
        if (this.portableObject == null) {
            throw new PropertyNotPresentException("The optional portable object is not present for this tagged value.");
        }
        return this.portableObject;
    }

    @Override
    public void setPortableObject(InterchangeObject portableObject) {
        this.portableObject = portableObject;
    }

    public byte[] getIndirectValuePersist() throws NotSerializableException, NullPointerException, IllegalPropertyValueException, InsufficientSpaceException {
        if (this.value == null || this.typeDefinition == null) {
            return null;
        }
        PropertyValue typedValue = this.getIndirectValue();
        PropertyValue indirectValue = TypeDefinitions.Indirect.createValueFromActualValue(typedValue);
        ByteBuffer buffer = ByteBuffer.allocate((int)TypeDefinitions.Indirect.lengthAsBytes(indirectValue));
        TypeDefinitions.Indirect.writeAsBytes(indirectValue, buffer);
        buffer.rewind();
        return buffer.array();
    }

    public void setIndirectValuePersist(byte[] indirectBytes) {
        if (indirectBytes == null) {
            this.value = null;
            this.typeDefinition = null;
            return;
        }
        PropertyValue indirectValue = TypeDefinitions.Indirect.createFromBytes(ByteBuffer.wrap(indirectBytes));
        PropertyValue typedValue = (PropertyValue)indirectValue.getValue();
        this.value = (Serializable)typedValue.getValue();
        this.typeDefinition = typedValue.getType().getAUID();
    }
}

